/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.goods.service.impl;

import com.qianjiang.goods.bean.GoodsReleParam;
import com.qianjiang.goods.dao.CascDelMapper;
import com.qianjiang.goods.dao.GoodsReleParamMapper;
import com.qianjiang.goods.service.GoodsReleParamService;
import com.qianjiang.goods.vo.GoodsReleParamVo;
import com.qianjiang.util.MyLogger;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="GoodsReleParamService")
public class GoodsReleParamServiceImpl
implements GoodsReleParamService {
    private GoodsReleParamMapper goodsReleParamMapper;
    private CascDelMapper cascDelMapper;
    private static final MyLogger LOGGER = new MyLogger(GoodsReleParamServiceImpl.class);

    public CascDelMapper getCascDelMapper() {
        return this.cascDelMapper;
    }

    @Resource(name="CascDelMapper")
    public void setCascDelMapper(CascDelMapper cascDelMapper) {
        this.cascDelMapper = cascDelMapper;
    }

    public GoodsReleParamMapper getGoodsReleParamMapper() {
        return this.goodsReleParamMapper;
    }

    @Resource(name="GoodsReleParamMapper")
    public void setGoodsReleParamMapper(GoodsReleParamMapper goodsReleParamMapper) {
        this.goodsReleParamMapper = goodsReleParamMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public int saveGoodsReleParam(Long goodsId, Long paramId, String paramValue, String usernames) {
        GoodsReleParam goodsReleParam = new GoodsReleParam();
        try {
            goodsReleParam.setParamCreateName(usernames);
            goodsReleParam.setParamDelflag("0");
            goodsReleParam.setParamId(paramId);
            goodsReleParam.setParamValue(paramValue);
            goodsReleParam.setGoodsId(goodsId);
            int n = this.goodsReleParamMapper.insertSelective(goodsReleParam);
            return n;
        }
        finally {
            LOGGER.info((Object)("\u4fdd\u5b58\u5546\u54c1\u5173\u8054\u7c7b\u578b\u5c5e\u6027SUCC" + usernames));
            goodsReleParam = null;
        }
    }

    @Override
    @Transactional
    public int updateReleParam(GoodsReleParam goodsReleParam, String username) {
        goodsReleParam.setParamModifiedName(username);
        LOGGER.info((Object)("\u66f4\u65b0\u5546\u54c1\u5173\u8054\u7c7b\u578b\u5c5e\u6027SUCC" + username));
        return this.goodsReleParamMapper.updateByPrimaryKeySelective(goodsReleParam);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GoodsReleParam queryReleParamByGoodsIdAndParamId(Long goodsId, Long paramId) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        try {
            map.put("goodsId", goodsId);
            map.put("paramId", paramId);
            GoodsReleParam goodsReleParam = this.goodsReleParamMapper.queryByGoodsIdAndParamId(map);
            return goodsReleParam;
        }
        finally {
            map = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public int delAllReleParamByGoodsId(Long goodsId, String username) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            map.put("delName", username);
            map.put("goodsId", goodsId.toString());
            int n = this.goodsReleParamMapper.delAllReleParamByGoodsId(map);
            return n;
        }
        finally {
            LOGGER.info((Object)("\u5220\u9664\u5546\u54c1\u5173\u8054\u7c7b\u578b\u5c5e\u6027SUCC" + username));
            this.cascDelMapper.cascDel(username);
            map = null;
        }
    }

    @Override
    public List<GoodsReleParam> queryAllReleParamByGoodId(Long goodsId) {
        return this.goodsReleParamMapper.queryAllGoodsReleParamByGoodsId(goodsId);
    }

    @Override
    public int deleReleParamByReleParamId(Long releParamId) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("releParamId", String.valueOf(releParamId));
        return this.goodsReleParamMapper.deleteByPrimaryKey(paramMap);
    }

    @Override
    public List<GoodsReleParamVo> queryAllByGoodsId(Long goodsId) {
        return this.goodsReleParamMapper.queryAllByGoodsId(goodsId);
    }
}

