/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.goods.service.impl;

import com.qianjiang.goods.bean.GoodsSpec;
import com.qianjiang.goods.bean.GoodsTypeSpec;
import com.qianjiang.goods.dao.CascDelMapper;
import com.qianjiang.goods.dao.GoodsTypeSpecMapper;
import com.qianjiang.goods.service.GoodsSpecService;
import com.qianjiang.goods.service.GoodsTypeSpecService;
import com.qianjiang.goods.vo.GoodsTypeSpecVo;
import com.qianjiang.util.MyLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="GoodsTypeSpecService")
public class GoodsTypeSpecServiceImpl
implements GoodsTypeSpecService {
    private GoodsTypeSpecMapper goodsTypeSpecMapper;
    private GoodsSpecService goodsSpecService;
    private CascDelMapper cascDelMapper;
    private static final MyLogger LOGGER = new MyLogger(GoodsTypeSpecServiceImpl.class);

    public CascDelMapper getCascDelMapper() {
        return this.cascDelMapper;
    }

    @Resource(name="CascDelMapper")
    public void setCascDelMapper(CascDelMapper cascDelMapper) {
        this.cascDelMapper = cascDelMapper;
    }

    public GoodsSpecService getGoodsSpecService() {
        return this.goodsSpecService;
    }

    @Resource(name="GoodsSpecService")
    public void setGoodsSpecService(GoodsSpecService goodsSpecService) {
        this.goodsSpecService = goodsSpecService;
    }

    public GoodsTypeSpecMapper getGoodsTypeSpecMapper() {
        return this.goodsTypeSpecMapper;
    }

    @Resource(name="GoodsTypeSpecMapper")
    public void setGoodsTypeSpecMapper(GoodsTypeSpecMapper goodsTypeSpecMapper) {
        this.goodsTypeSpecMapper = goodsTypeSpecMapper;
    }

    @Override
    @Transactional
    public int saveTypeSpec(GoodsTypeSpec goodsTypeSpec, String username) {
        goodsTypeSpec.setTypeSpecCreateName(username);
        LOGGER.info((Object)("\u4fdd\u5b58\u7c7b\u578b\u5173\u8054\u89c4\u683cSUCC" + username));
        return this.goodsTypeSpecMapper.insertSelective(goodsTypeSpec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public int delTypeSpec(Long typeSpecId, String username) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            map.put("delName", username);
            map.put("typeSpecId", typeSpecId.toString());
            int n = this.goodsTypeSpecMapper.deleteByPrimaryKey(map);
            return n;
        }
        finally {
            LOGGER.info((Object)("\u5220\u9664\u7c7b\u578b\u5173\u8054\u89c4\u683cSUCC" + username));
            this.cascDelMapper.cascDel(username);
            map = null;
        }
    }

    @Override
    @Transactional
    public int updateTypeSpec(GoodsTypeSpec goodsTypeSpec, String username) {
        goodsTypeSpec.setTypeSpecModifiedName(username);
        LOGGER.info((Object)("\u66f4\u65b0\u7c7b\u578b\u5173\u8054\u89c4\u683cSUCC" + username));
        return this.goodsTypeSpecMapper.updateByPrimaryKeySelective(goodsTypeSpec);
    }

    @Override
    public List<GoodsTypeSpecVo> queryTypeSpecByTypeId(Long typeId) {
        return this.goodsTypeSpecMapper.queryTypeSpecBytypeId(typeId);
    }

    @Override
    @Transactional
    public int batchUpdate(Long typeId, String username, String[] specIds) {
        int i;
        GoodsTypeSpec typeSpec = null;
        HashMap<String, Long> map = new HashMap<String, Long>();
        List<GoodsSpec> specList = this.goodsSpecService.queryAllSpecIncludeDel();
        ArrayList<Long> allspecsIds = new ArrayList<Long>();
        if (specList != null && !specList.isEmpty()) {
            for (i = 0; i < specList.size(); ++i) {
                allspecsIds.add(specList.get(i).getSpecId());
            }
        }
        if (null != specIds && specIds.length > 0) {
            for (i = 0; i < specIds.length; ++i) {
                map.put("typeId", typeId);
                map.put("specId", Long.parseLong(specIds[i]));
                typeSpec = this.goodsTypeSpecMapper.queryTypeSpecByTypeIdAndSpecId(map);
                if (null == typeSpec) {
                    typeSpec = new GoodsTypeSpec();
                    typeSpec.setSpecId(Long.parseLong(specIds[i]));
                    typeSpec.setTypeSpecDelflag("0");
                    typeSpec.setTypeId(typeId);
                    this.saveTypeSpec(typeSpec, username);
                    continue;
                }
                if (!"1".equals(typeSpec.getTypeSpecDelflag())) continue;
                typeSpec.setTypeSpecDelflag("0");
                this.updateTypeSpec(typeSpec, username);
            }
            for (i = 0; i < allspecsIds.size(); ++i) {
                for (int k = 0; k < specIds.length; ++k) {
                    if ((Long)allspecsIds.get(i) != Long.parseLong(specIds[k])) continue;
                    allspecsIds.remove(i);
                }
            }
        }
        LOGGER.info((Object)("\u6279\u91cf\u66f4\u65b0\u7c7b\u578b\u5173\u8054\u89c4\u683cSUCC" + username));
        this.delAllreleSpec(typeId, username, map, allspecsIds);
        return 0;
    }

    @Transactional
    private void delAllreleSpec(Long typeId, String username, Map<String, Long> map, List<Long> allspecsIds) {
        for (int i = 0; i < allspecsIds.size(); ++i) {
            map.put("typeId", typeId);
            map.put("specId", allspecsIds.get(i));
            GoodsTypeSpec typeSpec = this.goodsTypeSpecMapper.queryTypeSpecByTypeIdAndSpecId(map);
            if (null == typeSpec) continue;
            this.delTypeSpec(typeSpec.getTypeSpecId(), username);
        }
        LOGGER.info((Object)("\u5220\u9664\u7c7b\u578b\u5173\u8054\u89c4\u683cSUCC" + username));
        this.cascDelMapper.cascDel(username);
    }
}

