/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.goods.service.impl;

import com.qianjiang.goods.bean.GoodsGroupReleProduct;
import com.qianjiang.goods.dao.CascDelMapper;
import com.qianjiang.goods.dao.GoodsGroupReleProductMapper;
import com.qianjiang.goods.service.GoodsGroupReleProductService;
import com.qianjiang.util.MyLogger;
import java.util.HashMap;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="GoodsGroupReleProductService")
public class GoodsGroupReleProductServiceImpl
implements GoodsGroupReleProductService {
    private static final MyLogger LOGGER = new MyLogger(GoodsGroupReleProductServiceImpl.class);
    @Resource(name="GoodsGroupReleProductMapper")
    private GoodsGroupReleProductMapper goodsGroupReleProductMapper;
    @Resource(name="CascDelMapper")
    private CascDelMapper cascDelMapper;

    @Override
    public GoodsGroupReleProduct queryGroupReleProductByGroupIdAndProductId(Long groupId, Long productId) {
        GoodsGroupReleProduct goodsGroupReleProduct = null;
        HashMap<String, Long> map = new HashMap<String, Long>();
        try {
            map.put("groupId", groupId);
            map.put("productId", productId);
            goodsGroupReleProduct = this.goodsGroupReleProductMapper.queryGroupReleProductByGroupIdAndProductId(map);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u4e1a\u52a1\u5c42\u6839\u636e\u7ec4\u5408ID\u548c\u8d27\u54c1ID\u67e5\u8be2\u5173\u8054\u5bf9\u8c61\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return goodsGroupReleProduct;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public int delGroupReleProductByGroupIdAndProductId(Long groupId, Long productId) {
        int result = 0;
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put("groupId", groupId);
            map.put("productId", productId);
            result = this.goodsGroupReleProductMapper.delByGroupIdAndProductId(map);
            this.cascDelMapper.cascDel("");
            LOGGER.info((Object)"\u5220\u9664\u5546\u54c1\u7ec4\u5408\u5173\u8054\u8d27\u54c1\u4fe1\u606fSUCC");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u4e1a\u52a1\u5c42\u6839\u636e\u7ec4\u5408ID\u548c\u8d27\u54c1ID\u5220\u9664\u8bb0\u5f55\u5931\u8d25");
        }
        return result;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public int batchDelGroupReleProductByGroupIdAndProductIds(Long groupId, Long[] productIds) {
        Integer count = 0;
        if (null != productIds && productIds.length > 0) {
            for (int i = 0; i < productIds.length; ++i) {
                count = count + this.delGroupReleProductByGroupIdAndProductId(groupId, productIds[i]);
            }
        }
        LOGGER.info((Object)"\u6279\u91cf\u5220\u9664\u5546\u54c1\u7ec4\u5408\u5173\u8054\u8d27\u54c1\u4fe1\u606fSUCC");
        this.cascDelMapper.cascDel("");
        return count;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public int addGroupReleProductNew(Long groupId, Long[] productIds, Long[] productNums) {
        int count = 0;
        try {
            GoodsGroupReleProduct goodsGroupReleProduct = null;
            if (null != productIds && productIds.length > 0) {
                for (int i = 0; i < productIds.length; ++i) {
                    for (int j = 0; j < productNums.length; ++j) {
                        if (i != j) continue;
                        goodsGroupReleProduct = this.queryGroupReleProductByGroupIdAndProductId(groupId, productIds[i]);
                        if (null == goodsGroupReleProduct) {
                            goodsGroupReleProduct = new GoodsGroupReleProduct();
                            goodsGroupReleProduct.setGroupId(groupId);
                            goodsGroupReleProduct.setProductId(productIds[i]);
                            goodsGroupReleProduct.setProductNum(productNums[j]);
                            goodsGroupReleProduct.setReleProductDelflag("0");
                            count += this.goodsGroupReleProductMapper.insertSelective(goodsGroupReleProduct);
                            continue;
                        }
                        goodsGroupReleProduct.setGroupId(groupId);
                        goodsGroupReleProduct.setProductId(productIds[i]);
                        goodsGroupReleProduct.setProductNum(productNums[j]);
                        count += this.goodsGroupReleProductMapper.updateByPrimaryKeySelective(goodsGroupReleProduct);
                    }
                }
            }
            LOGGER.info((Object)"\u6dfb\u52a0\u5546\u54c1\u7ec4\u5408\u5173\u8054\u8d27\u54c1\u4fe1\u606fSUCC");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u4e1a\u52a1\u5c42\u5546\u54c1\u7ec4\u5408\u6dfb\u52a0\u5173\u8054\u5546\u54c1\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return count;
    }
}

