/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.goods.service.impl;

import com.qianjiang.goods.bean.GoodsReleExpandParam;
import com.qianjiang.goods.dao.CascDelMapper;
import com.qianjiang.goods.dao.GoodsReleExpandParamMapper;
import com.qianjiang.goods.service.GoodsReleExpandParamService;
import com.qianjiang.goods.service.GoodsTypeExpandParamValueService;
import com.qianjiang.goods.vo.GoodsReleExpandParamVo;
import com.qianjiang.util.MyLogger;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="GoodsReleExpandParamService")
public class GoodsReleExpandParamServiceImpl
implements GoodsReleExpandParamService {
    private GoodsReleExpandParamMapper releExpandParamMapper;
    private GoodsTypeExpandParamValueService goodsTypeExpandParamValueService;
    private CascDelMapper cascDelMapper;
    private static final MyLogger LOGGER = new MyLogger(GoodsReleExpandParamServiceImpl.class);

    public CascDelMapper getCascDelMapper() {
        return this.cascDelMapper;
    }

    @Resource(name="CascDelMapper")
    public void setCascDelMapper(CascDelMapper cascDelMapper) {
        this.cascDelMapper = cascDelMapper;
    }

    public GoodsTypeExpandParamValueService getGoodsTypeExpandParamValueService() {
        return this.goodsTypeExpandParamValueService;
    }

    @Resource(name="GoodsTypeExpandParamValueService")
    public void setGoodsTypeExpandParamValueService(GoodsTypeExpandParamValueService goodsTypeExpandParamValueService) {
        this.goodsTypeExpandParamValueService = goodsTypeExpandParamValueService;
    }

    public GoodsReleExpandParamMapper getReleExpandParamMapper() {
        return this.releExpandParamMapper;
    }

    @Resource(name="GoodsReleExpandParamMapper")
    public void setReleExpandParamMapper(GoodsReleExpandParamMapper releExpandParamMapper) {
        this.releExpandParamMapper = releExpandParamMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public int saveExpandParam(String username, Long goodsId, Long expandParamIds, Long expandParamValue) {
        GoodsReleExpandParam goodsReleExpandParam = new GoodsReleExpandParam();
        try {
            goodsReleExpandParam.setReleExpandparamCreateName(username);
            goodsReleExpandParam.setGoodsId(goodsId);
            goodsReleExpandParam.setExpandparamId(expandParamIds);
            goodsReleExpandParam.setExpangparamValueId(expandParamValue);
            goodsReleExpandParam.setReleExpandparamDelflag("0");
            goodsReleExpandParam.setExpandparamValueName(this.goodsTypeExpandParamValueService.queryExpandParamValueByExpandParamId(expandParamValue).getExpandparamValueName());
            int n = this.releExpandParamMapper.insertSelective(goodsReleExpandParam);
            return n;
        }
        finally {
            LOGGER.info((Object)("\u4fdd\u5b58\u6269\u5c55\u5c5e\u6027SUCC" + username));
            goodsReleExpandParam = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GoodsReleExpandParam queryByGoodsIdAndExpandParamId(Long goodsId, Long expandParamId) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        try {
            map.put("goodsId", goodsId);
            map.put("expandParamId", expandParamId);
            GoodsReleExpandParam goodsReleExpandParam = this.releExpandParamMapper.queryByGoodsIdAndExpandParamId(map);
            return goodsReleExpandParam;
        }
        finally {
            map = null;
        }
    }

    @Override
    @Transactional
    public int updateGoodsReleExpandParam(GoodsReleExpandParam goodsReleExpandParam, String username) {
        goodsReleExpandParam.setReleExpandparamModifiedName(username);
        goodsReleExpandParam.setExpandparamValueName(this.goodsTypeExpandParamValueService.queryExpandParamValueByExpandParamId(goodsReleExpandParam.getExpangparamValueId()).getExpandparamValueName());
        LOGGER.info((Object)("\u66f4\u65b0\u5546\u54c1\u5173\u8054\u6269\u5c55\u5c5e\u6027SUCC" + username));
        return this.releExpandParamMapper.updateByPrimaryKeySelective(goodsReleExpandParam);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public int delGoodsReleExpandParam(Long expandParamId, String username) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            map.put("releExpandparamId", expandParamId.toString());
            map.put("delName", username);
            int n = this.releExpandParamMapper.deleteByPrimaryKey(map);
            return n;
        }
        finally {
            LOGGER.info((Object)("\u5220\u9664\u5546\u54c1\u5173\u8054\u6269\u5c55\u5c5e\u6027SUCC" + username));
            this.cascDelMapper.cascDel(username);
            map = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public int delAllExpandParamByGoodsId(Long goodsId, String username) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            map.put("delName", username);
            map.put("goodsId", goodsId.toString());
            int n = this.releExpandParamMapper.delAllExpandParamByGoodsId(map);
            return n;
        }
        finally {
            LOGGER.info((Object)("\u5220\u9664\u5546\u54c1\u5173\u8054\u6269\u5c55\u5c5e\u6027SUCC" + username));
            this.cascDelMapper.cascDel(username);
            map = null;
        }
    }

    @Override
    public List<GoodsReleExpandParamVo> queryExpandParamsByGoodsId(Long goodsId) {
        return this.releExpandParamMapper.queryExpandParamsByGoodsId(goodsId);
    }
}

