/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.goods.service.impl;

import com.qianjiang.goods.bean.GoodsTag;
import com.qianjiang.goods.dao.CascDelMapper;
import com.qianjiang.goods.dao.GoodsTagMapper;
import com.qianjiang.goods.service.GoodsTagService;
import com.qianjiang.goods.util.SelectBean;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="GoodsTagServiceImpl")
public class GoodsTagServiceImpl
implements GoodsTagService {
    @Resource(name="GoodsTagMapperImpl")
    private GoodsTagMapper goodsTagMapper;
    private CascDelMapper cascDelMapper;
    private static final MyLogger LOGGER = new MyLogger(GoodsTagServiceImpl.class);

    public CascDelMapper getCascDelMapper() {
        return this.cascDelMapper;
    }

    @Resource(name="CascDelMapper")
    public void setCascDelMapper(CascDelMapper cascDelMapper) {
        this.cascDelMapper = cascDelMapper;
    }

    public GoodsTagMapper getGoodsTagMapper() {
        return this.goodsTagMapper;
    }

    public void setGoodsTagMapper(GoodsTagMapper goodsTagMapper) {
        this.goodsTagMapper = goodsTagMapper;
    }

    @Override
    public GoodsTag selectByPaimarykey(Long tagId) {
        return this.goodsTagMapper.selectByPrimaryKey(tagId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageBean selectAllTag(PageBean pageBean, SelectBean selectBean) {
        if ("".equals(selectBean.getSearchText())) {
            selectBean.setCondition("");
        }
        pageBean.setRows(this.goodsTagMapper.queryTotalCount(selectBean));
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put("startRowNum", pageBean.getStartRowNum());
            map.put("endRowNum", pageBean.getEndRowNum());
            map.put("condition", selectBean.getCondition());
            map.put("searchText", selectBean.getSearchText());
            pageBean.setList(this.goodsTagMapper.selectAllTag(map));
        }
        finally {
            map = null;
        }
        return pageBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public int deleteByPrimaryKey(Long tagId, String delName) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            map.put("tagId", tagId.toString());
            map.put("del_name", delName);
            int n = this.goodsTagMapper.deleteByPrimaryKey(map);
            return n;
        }
        finally {
            LOGGER.info((Object)("\u5220\u9664\u5546\u54c1\u6807\u7b7eSUCC" + delName));
            this.cascDelMapper.cascDel(delName);
            map = null;
        }
    }

    @Override
    @Transactional
    public int insertSelective(GoodsTag record) {
        record.setTagCreateName("admin");
        record.setTagDelflag("0");
        LOGGER.info((Object)"\u65b0\u5efa\u5546\u54c1\u6807\u7b7eSUCC");
        return this.goodsTagMapper.insertSelective(record);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public int batchDeleteTag(Long[] tagIds, String delName) {
        int count = 0;
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            for (int i = 0; i < tagIds.length; ++i) {
                map.put("tagId", tagIds[i].toString());
                map.put("del_name", delName);
                count += this.goodsTagMapper.deleteByPrimaryKey(map);
                map.clear();
            }
        }
        finally {
            LOGGER.info((Object)("\u6279\u91cf\u5220\u9664\u5546\u54c1\u6807\u7b7eSUCC" + delName));
            this.cascDelMapper.cascDel(delName);
            map = null;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<GoodsTag> queryTagByParam(String columnName, String paramvalue) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            map.put("columnName", columnName);
            map.put("paramvalue", "'%" + paramvalue + "%'");
        }
        finally {
            map = null;
        }
        return this.goodsTagMapper.queryTagByParam(map);
    }

    @Override
    @Transactional
    public int updateTagSelective(GoodsTag tag, String username) {
        tag.setTagModifiedName(username);
        LOGGER.info((Object)("\u66f4\u65b0\u5546\u54c1\u6807\u7b7eSUCC" + username));
        return this.goodsTagMapper.updateByPrimaryKeySelective(tag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Object> queryAllTag() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put("startRowNum", 0);
            map.put("endRowNum", this.goodsTagMapper.queryTotalCount(null));
            List<Object> list = this.goodsTagMapper.selectAllTag(map);
            return list;
        }
        finally {
            map = null;
        }
    }

    @Override
    public boolean checkTagName(String tagName) {
        return this.goodsTagMapper.queryByTagName(tagName) <= 0;
    }
}

