/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.goods.service.impl;

import com.qianjiang.goods.bean.GoodsTypeExpandParam;
import com.qianjiang.goods.bean.GoodsTypeExpandParamValue;
import com.qianjiang.goods.dao.CascDelMapper;
import com.qianjiang.goods.dao.GoodsTypeExpandParamMapper;
import com.qianjiang.goods.service.GoodsTypeExpandParamService;
import com.qianjiang.goods.service.GoodsTypeExpandParamValueService;
import com.qianjiang.goods.vo.GoodsTypeExpandParamVo;
import com.qianjiang.util.MyLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="GoodsTypeExpandParamService")
public class GoodsTypeExpandParamServiceImpl
implements GoodsTypeExpandParamService {
    private static final MyLogger LOGGER = new MyLogger(GoodsTypeExpandParamServiceImpl.class);
    private GoodsTypeExpandParamMapper goodsTypeExpandParamMapper;
    private GoodsTypeExpandParamValueService goodsTypeExpandParamValueService;
    private CascDelMapper cascDelMapper;

    public CascDelMapper getCascDelMapper() {
        return this.cascDelMapper;
    }

    @Resource(name="CascDelMapper")
    public void setCascDelMapper(CascDelMapper cascDelMapper) {
        this.cascDelMapper = cascDelMapper;
    }

    public GoodsTypeExpandParamMapper getGoodsTypeExpandParamMapper() {
        return this.goodsTypeExpandParamMapper;
    }

    @Resource(name="GoodsTypeExpandParamMapper")
    public void setGoodsTypeExpandParamMapper(GoodsTypeExpandParamMapper goodsTypeExpandParamMapper) {
        this.goodsTypeExpandParamMapper = goodsTypeExpandParamMapper;
    }

    public GoodsTypeExpandParamValueService getGoodsTypeExpandParamValueService() {
        return this.goodsTypeExpandParamValueService;
    }

    @Resource(name="GoodsTypeExpandParamValueService")
    public void setGoodsTypeExpandParamValueService(GoodsTypeExpandParamValueService goodsTypeExpandParamValueService) {
        this.goodsTypeExpandParamValueService = goodsTypeExpandParamValueService;
    }

    @Override
    @Transactional
    public Long saveExpandParam(GoodsTypeExpandParam goodsTypeExpandParam, String username) {
        goodsTypeExpandParam.setExpandparamCreateName(username);
        this.goodsTypeExpandParamMapper.insertSelective(goodsTypeExpandParam);
        LOGGER.info((Object)("\u4fdd\u5b58\u5546\u54c1\u7c7b\u578b\u6269\u5c55\u5c5e\u6027SUCC" + username));
        return this.goodsTypeExpandParamMapper.selectLastId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public int delExpandParam(Long paramId, String username) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            map.put("delName", username);
            map.put("expandparamId", paramId.toString());
            int n = this.goodsTypeExpandParamMapper.deleteByPrimaryKey(map);
            return n;
        }
        finally {
            LOGGER.info((Object)("\u5220\u9664\u5546\u54c1\u7c7b\u578b\u6269\u5c55\u5c5e\u6027SUCC" + username));
            this.cascDelMapper.cascDel(username);
            map = null;
        }
    }

    @Override
    @Transactional
    public int updateExpandParam(GoodsTypeExpandParam goodsTypeExpandParam, String username) {
        goodsTypeExpandParam.setExpandparamModifiedName(username);
        LOGGER.info((Object)("\u66f4\u65b0\u5546\u54c1\u7c7b\u578b\u6269\u5c55\u5c5e\u6027SUCC" + username));
        return this.goodsTypeExpandParamMapper.updateByPrimaryKeySelective(goodsTypeExpandParam);
    }

    @Override
    public List<GoodsTypeExpandParamVo> queryParamListByTypeId(Long typeId) {
        return this.goodsTypeExpandParamMapper.queryAllExpandParam(typeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public int batchUpdateExpandParam(String username, Long typeId, Map<String, String[]> map, Map<String, Object> requestmap) {
        Integer count = 0;
        Long lastParamId = null;
        String[] expandparamId = map.get("expandparamId");
        String[] expandparamDelflag = map.get("expandparamDelflag");
        String[] expandnames = map.get("expandnames");
        String[] expandnicknames = map.get("expandnicknames");
        String[] expanparamIsshow = map.get("expandparamIsshow");
        String[] expandparamsort = map.get("expandparamsort");
        String[] expandvalues = map.get("expandvalues");
        ArrayList<GoodsTypeExpandParam> expandParamList = new ArrayList<GoodsTypeExpandParam>();
        GoodsTypeExpandParam expandParam = null;
        try {
            int i;
            if (null != expandparamId) {
                for (i = 0; i < expandparamId.length; ++i) {
                    expandParam = new GoodsTypeExpandParam();
                    expandParam.setExpandparamId(Long.parseLong(expandparamId[i]));
                    expandParam.setExpandparamDelflag(expandparamDelflag[i]);
                    expandParam.setExpandparamName(expandnames[i]);
                    expandParam.setExpandparamNickname(expandnicknames[i]);
                    expandParam.setExpandparamSort(Integer.parseInt(expandparamsort[i]));
                    expandParamList.add(expandParam);
                }
            }
            for (i = 0; i < expandParamList.size(); ++i) {
                expandParam = (GoodsTypeExpandParam)expandParamList.get(i);
                if (-1L == expandParam.getExpandparamId()) {
                    expandParam.setExpandparamId(null);
                    expandParam.setExpandparamDelflag("0");
                    expandParam.setTypeId(typeId);
                    lastParamId = this.saveExpandParam(expandParam, username);
                    if (null == lastParamId || lastParamId <= 0L) continue;
                    this.saveExpandParamValueWhenInsertExpandParam(username, lastParamId, expandvalues, i);
                    continue;
                }
                if ("1".equals(expandParam.getExpandparamDelflag())) {
                    count = count + this.delExpandParam(expandParam.getExpandparamId(), username);
                    continue;
                }
                count = count + this.updateExpandParam(expandParam, username);
                this.updateExpandParamValues(expandparamId[i], requestmap);
            }
            int n = count;
            return n;
        }
        finally {
            LOGGER.info((Object)("" + username));
            count = null;
            lastParamId = null;
            expandparamId = null;
            expandparamDelflag = null;
            expandnames = null;
            expandnames = null;
            expandnicknames = null;
            expanparamIsshow = null;
            expandparamsort = null;
            expandParamList = null;
            expandParam = null;
        }
    }

    private void updateExpandParamValues(String expandParamId, Map<String, Object> requestmap) {
        List list_toArr = (List)requestmap.get("expandParamValueId" + expandParamId);
        String[] expandParamValueIds = list_toArr.toArray(new String[list_toArr.size()]);
        if (expandParamValueIds == null) {
            return;
        }
        List listValueDelFlags_toArr = (List)requestmap.get("expandParamValueDelFlag" + expandParamId);
        String[] expandParamValueDelFlags = listValueDelFlags_toArr.toArray(new String[listValueDelFlags_toArr.size()]);
        List listExpandvaluess_toArr = (List)requestmap.get("expandvalues" + expandParamId);
        String[] expandvalues = listExpandvaluess_toArr.toArray(new String[listExpandvaluess_toArr.size()]);
        List listValuesorts_toArr = (List)requestmap.get("expandvaluesort" + expandParamId);
        String[] expandvaluesorts = listValuesorts_toArr.toArray(new String[listValuesorts_toArr.size()]);
        String username = (String)requestmap.get("name");
        this.goodsTypeExpandParamValueService.updateParamValues(new String[]{expandParamId}, expandParamValueIds, expandParamValueDelFlags, expandvalues, expandvaluesorts, username);
    }

    @Transactional
    private void saveExpandParamValueWhenInsertExpandParam(String username, Long lastParamId, String[] expandvalues, int i) {
        if (null != expandvalues[i] && !"".equals(expandvalues[i])) {
            GoodsTypeExpandParamValue paramValue = null;
            String[] values = expandvalues[i].split("\\|");
            for (int k = 0; k < values.length; ++k) {
                paramValue = new GoodsTypeExpandParamValue();
                paramValue.setExpandparamId(Long.parseLong(String.valueOf(lastParamId)));
                paramValue.setExpandparamValueDelflag("0");
                paramValue.setExpandparamValueName(values[k]);
                this.goodsTypeExpandParamValueService.saveParamValue(paramValue, username);
            }
            values = null;
            paramValue = null;
            LOGGER.info((Object)("\u4fdd\u5b58\u5546\u54c1\u7c7b\u578b\u6269\u5c55\u5c5e\u6027SUCC" + username));
        }
    }
}

