/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.site.goods.service.impl;

import com.qianjiang.goods.dao.GoodsProductMapper;
import com.qianjiang.goods.service.BrowserecordService;
import com.qianjiang.goods.vo.GoodsProductVo;
import com.qianjiang.site.goods.bean.BrowerResBean;
import com.qianjiang.site.goods.service.BrowerService;
import com.qianjiang.util.MyLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="BrowerService")
public class BrowerServiceImpl
implements BrowerService {
    private static final MyLogger LOGGER = new MyLogger(BrowerServiceImpl.class);
    private static final String COOKIE = "_mall_browpro";
    @Resource(name="browserecordServiceMix")
    private BrowserecordService browserecordService;
    @Resource(name="GoodsProductMapper")
    private GoodsProductMapper goodsProductMapper;

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public boolean saveBrowerHis(Long customerId, Long productId) {
        BrowerResBean res = new BrowerResBean();
        boolean result = false;
        try {
            if (null != customerId) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("custId", customerId);
                map.put("productId", productId);
                this.goodsProductMapper.updateGoodsBrowStatus(map);
                this.goodsProductMapper.saveGoodsBrow(map);
                result = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u4e1a\u52a1\u5c42\u4fdd\u5b58\u6d4f\u89c8\u8bb0\u5f55\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @Override
    public Map<String, Object> loadBrowHist(Long customerId, List<Long> productIds) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            if (null != customerId) {
                map.put("type", 1);
                map.put("browHist", this.browserecordService.selectBrowserecord(customerId));
            } else {
                map.put("type", 2);
                String cookiestr = "";
                if (null != productIds) {
                    HashMap<String, Object> proMap = new HashMap<String, Object>();
                    proMap.put("productIds", productIds);
                    List<Object> proList = new ArrayList();
                    ArrayList<GoodsProductVo> calcList = new ArrayList<GoodsProductVo>();
                    proList = this.goodsProductMapper.queryProductsByProductId(proMap);
                    for (int i = productIds.size() - 1; i > -1; --i) {
                        for (GoodsProductVo goodsProductVo : proList) {
                            if (!productIds.get(i).equals(goodsProductVo.getGoodsInfoId())) continue;
                            calcList.add(goodsProductVo);
                        }
                    }
                    map.put("productList", calcList);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u4e1a\u52a1\u5c42\u83b7\u53d6\u6d4f\u89c8\u7684\u5386\u53f2\u8bb0\u5f55\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return map;
    }
}

