/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.site.thirdseller.service.impl;

import com.qianjiang.channel.bean.ChannelAdver;
import com.qianjiang.channel.bean.ChannelStorey;
import com.qianjiang.channel.bean.ChannelStoreyGoods;
import com.qianjiang.channel.bean.ChannelStoreyTag;
import com.qianjiang.channel.dao.ChannelStoreyMapper;
import com.qianjiang.channel.service.ChannelAdverService;
import com.qianjiang.channel.service.ChannelStoreyGoodsService;
import com.qianjiang.channel.service.ChannelStoreyTagService;
import com.qianjiang.site.thirdseller.bean.ThirdIndexFloor;
import com.qianjiang.site.thirdseller.bean.ThirdIndexStoreyAdverBean;
import com.qianjiang.site.thirdseller.bean.ThirdIndexStoreyBean;
import com.qianjiang.site.thirdseller.bean.ThirdIndexStoreyGoodsBean;
import com.qianjiang.site.thirdseller.bean.ThirdIndexStoreyTagBean;
import com.qianjiang.site.thirdseller.bean.ThirdStoreInfo;
import com.qianjiang.site.thirdseller.dao.ThirdStoreInfoMapper;
import com.qianjiang.site.thirdseller.service.ThirdSellerSiteService;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="ThirdSellerSiteService")
public class ThirdSellerSiteServiceImpl
implements ThirdSellerSiteService {
    private ChannelStoreyMapper channelStoreyMapper;
    private ChannelStoreyGoodsService channelStoreyGoodsService;
    private ChannelAdverService channelAdverService;
    private ChannelStoreyTagService channelStoreyTagService;
    private ThirdStoreInfoMapper storeInfoMapper;
    private static final Long ATID3 = 161L;
    private static final Long ADVERTTYPE = 151L;

    @Override
    public ThirdIndexFloor getStoreys(Long tempId, Long thirdId) {
        ThirdIndexFloor thirdIndexFloor = new ThirdIndexFloor();
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("channelId", null);
        map.put("tempId", tempId);
        map.put("temp1", thirdId);
        List storeyList = this.channelStoreyMapper.selectchannelStoreyByParamForSite(map);
        for (ChannelStorey s : storeyList) {
            ThirdIndexStoreyBean indexStoreyBean = new ThirdIndexStoreyBean();
            indexStoreyBean.setChannelStoreyId(s.getChannelStoreyId());
            indexStoreyBean.setStoreyName(s.getStoreyName());
            indexStoreyBean.setStoreySeo(s.getStoreySeo());
            indexStoreyBean.setStoreyImg(s.getStoreyImg());
            indexStoreyBean.setStoreyImgHref(s.getStoreyImgHref());
            indexStoreyBean.setTempId(s.getTempId());
            this.getAdverListForStorey(s, indexStoreyBean);
            this.getGoodsListForStorey(s, indexStoreyBean);
            this.getTagListForStorey(s, indexStoreyBean);
            thirdIndexFloor.getFloorList().add(indexStoreyBean);
        }
        return thirdIndexFloor;
    }

    public void getGoodsListForStorey(ChannelStorey s, ThirdIndexStoreyBean storey) {
        List storeyGoodsList = this.channelStoreyGoodsService.selectchannelStoreyGoodsByParamForSite(s.getChannelStoreyId(), null, null);
        for (int i = 0; i < storeyGoodsList.size(); ++i) {
            ThirdIndexStoreyGoodsBean indexGoodsBean = new ThirdIndexStoreyGoodsBean();
            indexGoodsBean.setName(((ChannelStoreyGoods)storeyGoodsList.get(i)).getGoodsproductName());
            indexGoodsBean.setNumber(((ChannelStoreyGoods)storeyGoodsList.get(i)).getGoodsproductNo());
            indexGoodsBean.setPrice(String.valueOf(((ChannelStoreyGoods)storeyGoodsList.get(i)).getGoodsproductPrice()));
            indexGoodsBean.setUrlpic(((ChannelStoreyGoods)storeyGoodsList.get(i)).getGoodsproductImgsrc());
            indexGoodsBean.setId(String.valueOf(((ChannelStoreyGoods)storeyGoodsList.get(i)).getGoodsproductId()));
            storey.getIndexGoodsList().add(indexGoodsBean);
        }
    }

    public void getAdverListForStorey(ChannelStorey s, ThirdIndexStoreyBean storey) {
        List adverList = this.channelAdverService.selectchannelAdverByParamForSite(null, null, s.getChannelStoreyId(), null, ATID3, ADVERTTYPE, null, "0", null, null);
        for (ChannelAdver channelAdver : adverList) {
            ThirdIndexStoreyAdverBean adverBean = new ThirdIndexStoreyAdverBean();
            adverBean.setAdverName(channelAdver.getAdverName());
            adverBean.setAdverPath(channelAdver.getAdverPath());
            adverBean.setAdverHref(channelAdver.getAdverHref());
            adverBean.setAdverSort(channelAdver.getAdverSort());
            adverBean.setDes(channelAdver.getDes());
            adverBean.setTemp2(channelAdver.getTemp2());
            adverBean.setChannelAdverId(channelAdver.getChannelAdverId());
            storey.getIndexAdverList().add(adverBean);
        }
    }

    public void getTagListForStorey(ChannelStorey s, ThirdIndexStoreyBean storey) {
        List tagList = this.channelStoreyTagService.selectchannelStoreyTagByParamForSite(s.getChannelStoreyId(), null, null);
        for (ChannelStoreyTag tag : tagList) {
            ThirdIndexStoreyTagBean storeyTagBean = new ThirdIndexStoreyTagBean();
            storeyTagBean.setChannelStoreyTagId(tag.getChannelStoreyTagId());
            storeyTagBean.setName(tag.getName());
            storeyTagBean.setSort(tag.getSort());
            this.getAdverListForStoreyTag(storeyTagBean);
            this.getGoodsListForStoreyTag(storeyTagBean);
        }
    }

    public void getGoodsListForStoreyTag(ThirdIndexStoreyTagBean storeyTag) {
        List tagGoodsList = this.channelStoreyGoodsService.selectchannelStoreyGoodsByParamForSite(null, storeyTag.getChannelStoreyTagId(), null);
        for (ChannelStoreyGoods goods : tagGoodsList) {
            ThirdIndexStoreyGoodsBean indexStoreyGoodsBean = new ThirdIndexStoreyGoodsBean();
            indexStoreyGoodsBean.setName(goods.getGoodsproductName());
            indexStoreyGoodsBean.setNumber(goods.getGoodsproductNo());
            indexStoreyGoodsBean.setPrice(String.valueOf(goods.getGoodsproductPrice()));
            indexStoreyGoodsBean.setUrlpic(goods.getGoodsproductImgsrc());
            indexStoreyGoodsBean.setId(String.valueOf(goods.getGoodsproductId()));
            storeyTag.getIndexGoodsList().add(indexStoreyGoodsBean);
        }
    }

    public void getAdverListForStoreyTag(ThirdIndexStoreyTagBean storeyTag) {
        List tagAdverList = this.channelAdverService.selectchannelAdverByParamForSite(null, null, null, storeyTag.getChannelStoreyTagId(), ATID3, ADVERTTYPE, null, "0", null, null);
        for (ChannelAdver adv : tagAdverList) {
            ThirdIndexStoreyAdverBean adverBean = new ThirdIndexStoreyAdverBean();
            adverBean.setAdverName(adv.getAdverName());
            adverBean.setAdverPath(adv.getAdverPath());
            adverBean.setAdverHref(adv.getAdverHref());
            adverBean.setAdverSort(adv.getAdverSort());
            adverBean.setDes(adv.getDes());
            adverBean.setTemp2(adv.getTemp2());
            adverBean.setChannelAdverId(adv.getChannelAdverId());
            storeyTag.getIndexAdverList().add(adverBean);
        }
    }

    @Override
    public ThirdStoreInfo selectByThirdId(Long thirdId) {
        return this.storeInfoMapper.selectByThirdId(thirdId);
    }

    @Resource(name="ChannelStoreyMapper")
    public void setChannelStoreyMapper(ChannelStoreyMapper channelStoreyMapper) {
        this.channelStoreyMapper = channelStoreyMapper;
    }

    @Resource(name="ChannelStoreyGoodsService")
    public void setChannelStoreyGoodsService(ChannelStoreyGoodsService channelStoreyGoodsService) {
        this.channelStoreyGoodsService = channelStoreyGoodsService;
    }

    @Resource(name="ChannelAdverService")
    public void setChannelAdverService(ChannelAdverService channelAdverService) {
        this.channelAdverService = channelAdverService;
    }

    @Resource(name="ChannelStoreyTagService")
    public void setChannelStoreyTagService(ChannelStoreyTagService channelStoreyTagService) {
        this.channelStoreyTagService = channelStoreyTagService;
    }

    @Resource(name="ThirdStoreInfoMapper")
    public void setStoreInfoMapper(ThirdStoreInfoMapper storeInfoMapper) {
        this.storeInfoMapper = storeInfoMapper;
    }
}

