/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.goods.service.impl;

import com.qianjiang.customer.bean.CustomerFollow;
import com.qianjiang.customer.dao.CustomerFollowMapper;
import com.qianjiang.goods.bean.GoodsAtte;
import com.qianjiang.goods.dao.ArrivalNoticeMapper;
import com.qianjiang.goods.dao.CascDelMapper;
import com.qianjiang.goods.dao.GoodsAtteMapper;
import com.qianjiang.goods.dao.GoodsProductMapper;
import com.qianjiang.goods.service.GoodsAtteService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import com.qianjiang.util.SelectBean;
import java.math.BigDecimal;
import java.util.HashMap;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="GoodsAtteService")
public class GoodsAtteServiceImpl
implements GoodsAtteService {
    private GoodsAtteMapper goodsAtteMapper;
    private CascDelMapper cascDelMapper;
    @Resource(name="customerFollowMapper")
    private CustomerFollowMapper customerFollowMapper;
    private static final MyLogger LOGGER = new MyLogger(GoodsAtteServiceImpl.class);
    @Resource(name="GoodsProductMapper")
    private GoodsProductMapper goodsProductMapper;
    @Resource(name="ArrivalNoticeMapper")
    private ArrivalNoticeMapper arrivalNoticeMapper;

    public CascDelMapper getCascDelMapper() {
        return this.cascDelMapper;
    }

    @Resource(name="CascDelMapper")
    public void setCascDelMapper(CascDelMapper cascDelMapper) {
        this.cascDelMapper = cascDelMapper;
    }

    public GoodsAtteMapper getGoodsAtteMapper() {
        return this.goodsAtteMapper;
    }

    @Resource(name="GoodsAtteMapper")
    public void setGoodsAtteMapper(GoodsAtteMapper goodsAtteMapper) {
        this.goodsAtteMapper = goodsAtteMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public int deleteAtte(Long atteId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put("atteId", atteId);
            int n = this.goodsAtteMapper.deleteByPrimaryKey(map);
            return n;
        }
        finally {
            LOGGER.info((Object)("\u5220\u9664\u5173\u6ce8\u4fe1\u606fSUCC\uff0c\u5220\u9664\u7684\u5173\u6ce8ID\u4e3a\uff1a" + atteId));
            this.cascDelMapper.cascDel("");
            map = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public int batchDelAtte(Long[] atteIds) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put("atteIds", atteIds);
            LOGGER.info((Object)"\u6279\u91cf\u5220\u9664\u5173\u6ce8\u4fe1\u606fSUCC");
            int n = this.goodsAtteMapper.batchDelete(map);
            return n;
        }
        finally {
            this.cascDelMapper.cascDel("");
            map = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageBean queryByPageAndParam(PageBean pb, SelectBean selectBean) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put("condition", "".equals(selectBean.getCondition()) ? null : selectBean.getCondition());
            map.put("searchText", "".equals(selectBean.getSearchText()) ? null : selectBean.getSearchText());
            pb.setRows(this.goodsAtteMapper.queryTotalCount(map));
            map.put("startRowNum", pb.getStartRowNum());
            map.put("endRowNum", pb.getEndRowNum());
            pb.setList(this.goodsAtteMapper.queryByParam(map));
            PageBean pageBean = pb;
            return pageBean;
        }
        finally {
            map = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageBean queryByPageAndParamArrival(PageBean pb, SelectBean selectBean) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put("condition", "".equals(selectBean.getCondition()) ? null : selectBean.getCondition());
            map.put("searchText", "".equals(selectBean.getSearchText()) ? null : selectBean.getSearchText());
            pb.setRows(this.goodsProductMapper.queryTotalCountArrival(map));
            map.put("startRowNum", pb.getStartRowNum());
            map.put("endRowNum", pb.getEndRowNum());
            pb.setList(this.goodsProductMapper.queryByParamArrival(map));
            PageBean pageBean = pb;
            return pageBean;
        }
        finally {
            map = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageBean querybyProductId(PageBean pb, Long productId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put("productId", productId);
            pb.setRows(this.goodsAtteMapper.queryTotalCountToProduct(map));
            map.put("startRowNum", pb.getStartRowNum());
            map.put("endRowNum", pb.getEndRowNum());
            pb.setList(this.goodsAtteMapper.queryByProductId(map));
            PageBean pageBean = pb;
            return pageBean;
        }
        finally {
            map = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageBean querybyProductIdArrival(PageBean pb, Long productId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put("goodsInfoId", productId);
            map.put("noticeSturts", Character.valueOf('0'));
            pb.setRows(this.arrivalNoticeMapper.queryTotalCountToProductArrivalNotice(map));
            map.put("startRowNum", pb.getStartRowNum());
            map.put("endRowNum", pb.getEndRowNum());
            pb.setList(this.arrivalNoticeMapper.queryByProductIdArrivalNotice(map));
            PageBean pageBean = pb;
            return pageBean;
        }
        finally {
            map = null;
        }
    }

    @Override
    public int selectGoodsAtteCount() {
        return this.goodsAtteMapper.queryTotalCount(null);
    }

    @Override
    public int saveGoodsAtte(Long custId, Long productId, Long districtId, BigDecimal goodsprice) {
        int result = 0;
        try {
            if (!this.checkAtte(custId, productId)) {
                GoodsAtte siteGoodsAtte = new GoodsAtte();
                siteGoodsAtte.setCustId(custId);
                siteGoodsAtte.setProductId(productId);
                siteGoodsAtte.setDistrictId(districtId);
                siteGoodsAtte.setFollowPrice(goodsprice);
                result = this.goodsAtteMapper.saveGoodsAtte(siteGoodsAtte);
            } else {
                result = -1;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u4fdd\u5b58\u5546\u54c1\u5173\u6ce8\u4fe1\u606f\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @Override
    public int newsaveGoodsAtte(Long custId, Long productId, Long districtId, BigDecimal goodsprice) {
        int result = 0;
        try {
            HashMap<String, Long> map = new HashMap<String, Long>();
            map.put("custId", custId);
            map.put("productId", productId);
            CustomerFollow customerFollow = this.customerFollowMapper.queryByCustIdAndProId(map);
            if (null == customerFollow) {
                GoodsAtte siteGoodsAtte = new GoodsAtte();
                siteGoodsAtte.setCustId(custId);
                siteGoodsAtte.setProductId(productId);
                siteGoodsAtte.setDistrictId(districtId);
                siteGoodsAtte.setFollowPrice(goodsprice);
                result = this.goodsAtteMapper.saveGoodsAtte(siteGoodsAtte);
            } else {
                map.put("customerId", custId);
                map.put("followId", customerFollow.getFollowId());
                this.customerFollowMapper.deleteByPrimaryKey1(map);
                result = -1;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("pc\u7aef\u4e1a\u52a1\u5c42\u5173\u6ce8\u5546\u54c1\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @Override
    public boolean checkAtte(Long custId, Long productId) {
        boolean flag = false;
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("custId", custId);
            map.put("productId", productId);
            Integer queryAtteHistByCustIdAndProId = this.goodsAtteMapper.queryAtteHistByCustIdAndProId(map);
            if (queryAtteHistByCustIdAndProId > 0) {
                flag = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u67e5\u8be2\u5546\u54c1\u662f\u5426\u5df2\u7ecf\u88ab\u5173\u6ce8\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return flag;
    }
}

