/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.goods.service.impl;

import com.qianjiang.goods.service.SearchAsyncService;
import com.qianjiang.goods.util.CreateSolrSimpleIndex;
import com.qianjiang.goods.util.DeleteSolrIndex;
import com.qianjiang.goods.util.DeleteSolrSimpleIndex;
import com.qianjiang.goods.util.UpdateSolrIndex;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

@Service(value="SearchAsyncService")
public class SearchAsyncServiceImpl
implements SearchAsyncService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchAsyncServiceImpl.class);
    @Resource(name="threadPool")
    private ThreadPoolTaskExecutor taskExecutor;
    @Autowired
    private CreateSolrSimpleIndex createSolrSimpleIndex;
    @Autowired
    private UpdateSolrIndex updateSolrIndex;
    @Autowired
    private DeleteSolrSimpleIndex deleteSolrSimpleIndex;
    @Autowired
    private DeleteSolrIndex deleteSolrIndex;

    @Override
    public void insertOneGoodsIndexToEs(final Long goodsId) {
        this.taskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                SearchAsyncServiceImpl.this.createSolrSimpleIndex.simpleCrateSolrIndex(goodsId);
            }
        });
    }

    @Override
    public void updateOneGoodsIndexToEs(final Long goodsId) {
        this.taskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                SearchAsyncServiceImpl.this.updateSolrIndex.updateSimpleSolrIndex(goodsId);
            }
        });
    }

    @Override
    public void updateThirdOneGoodsIndexToEs(final Long goodsId) {
        this.taskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                SearchAsyncServiceImpl.this.updateSolrIndex.updateSimpleSolrIndex(goodsId);
            }
        });
    }

    @Override
    public void updateSolrStock(final Map<String, Object> maps) {
        this.taskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                SearchAsyncServiceImpl.this.updateSolrIndex.updateSolrSeletive(maps);
            }
        });
    }

    @Override
    public void deleteGoodsIndexToEs(final Long goodsInfoId) {
        this.taskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                SearchAsyncServiceImpl.this.deleteSolrSimpleIndex.deleteSolrIndex(goodsInfoId);
            }
        });
    }

    @Override
    public void deleteGoodsByThirdId(String[] storeInfoIds) {
        final Long[] goodsIds = new Long[storeInfoIds.length];
        this.taskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                SearchAsyncServiceImpl.this.deleteSolrIndex.batchDeleteSolrIndex(goodsIds);
            }
        });
    }

    @Override
    public void batchDeleteGoodsIndexToEs(final List<Long> list) {
        this.taskExecutor.execute(new Runnable(){
            Long[] goodsIds;
            {
                this.goodsIds = list.toArray(new Long[list.size()]);
            }

            @Override
            public void run() {
                SearchAsyncServiceImpl.this.deleteSolrIndex.batchDeleteSolrIndex(this.goodsIds);
            }
        });
    }
}

