/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.goods.service.impl;

import com.qianjiang.goods.bean.GoodsImage;
import com.qianjiang.goods.bean.GoodsProduct;
import com.qianjiang.goods.bean.InfoImageManage;
import com.qianjiang.goods.dao.CascDelMapper;
import com.qianjiang.goods.dao.GoodsImageMapper;
import com.qianjiang.goods.dao.ImageSetMapper;
import com.qianjiang.goods.service.GoodsImageService;
import com.qianjiang.goods.service.GoodsProductService;
import com.qianjiang.util.MyLogger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="GoodsImageService")
public class GoodsImageServiceImpl
implements GoodsImageService {
    @Resource(name="GoodsImageMapper")
    private GoodsImageMapper goodsImageMapper;
    @Resource(name="GoodsImageSetMapper")
    private ImageSetMapper imageSetMapper;
    @Resource(name="GoodsProductService")
    private GoodsProductService goodsProductService;
    @Resource(name="CascDelMapper")
    private CascDelMapper cascDelMapper;
    private static final MyLogger LOGGER = new MyLogger(GoodsImageServiceImpl.class);

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public Long saveGoodsImage(GoodsImage image) {
        LOGGER.info((Object)"\u4fdd\u5b58\u5546\u54c1\u56fe\u7247SUCC");
        return this.goodsImageMapper.insertSelective(image);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public int delGoodsImage(Long goodsImageId, String username) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            if (null != goodsImageId) {
                map.put("goodsImgId", goodsImageId.toString());
                map.put("delName", username);
                int n = this.goodsImageMapper.deleteByPrimaryKey(map);
                return n;
            }
        }
        finally {
            LOGGER.info((Object)("\u5220\u9664\u5546\u54c1\u56fe\u7247SUCC" + username));
            this.cascDelMapper.cascDel(username);
            map = null;
        }
        return 0;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public int updateGoodsImage(GoodsImage goodsImage, String username) {
        goodsImage.setGoodsImgModifiedName(username);
        LOGGER.info((Object)("\u66f4\u65b0\u5546\u54c1\u56fe\u7247SUCC" + username));
        return this.goodsImageMapper.updateByPrimaryKeySelective(goodsImage);
    }

    @Override
    public GoodsImage queryByGoodsImageId(Long goodsImageId) {
        return this.goodsImageMapper.selectByPrimaryKey(goodsImageId);
    }

    @Override
    public List<GoodsImage> queryImageListByProductId(Long productId) {
        return this.goodsImageMapper.queryByProductId(productId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public GoodsImage uploadImage(Long productId, String username, List<Map<String, String>> picList) {
        GoodsImage image = null;
        Map<Object, Object> imagePath = new HashMap();
        try {
            if (null != picList && !picList.isEmpty()) {
                for (int i = 0; i < picList.size(); ++i) {
                    if (picList.get(i).isEmpty()) continue;
                    imagePath = picList.get(i);
                    image = new GoodsImage();
                    image.setGoodsInfoId(productId);
                    image.setImageArtworkName((String)imagePath.get("oldimg"));
                    image.setImageThumName((String)imagePath.get("0"));
                    image.setImageInName((String)imagePath.get("1"));
                    image.setImageBigName((String)imagePath.get("2"));
                    image.setGoodsImgSort(0);
                    image.setGoodsImgDelflag("0");
                    image.setGoodsImgCreateName(username);
                    image.setGoodsImgId(this.saveGoodsImage(image));
                }
            }
            GoodsImage goodsImage = image;
            return goodsImage;
        }
        finally {
            LOGGER.info((Object)("\u4e0a\u4f20\u5546\u54c1\u56fe\u7247SUCC" + username));
            image = null;
            imagePath = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public GoodsImage uploadImageSingle(Long productId, String username, Map<String, String> imagePath) {
        GoodsImage image = null;
        try {
            image = new GoodsImage();
            image.setGoodsInfoId(productId);
            image.setImageArtworkName(imagePath.get("oldimg"));
            image.setImageThumName(imagePath.get("0"));
            image.setImageInName(imagePath.get("1"));
            image.setImageBigName(imagePath.get("2"));
            image.setGoodsImgSort(0);
            image.setGoodsImgDelflag("0");
            image.setGoodsImgCreateName(username);
            image.setGoodsImgId(this.saveGoodsImage(image));
            GoodsImage goodsImage = image;
            return goodsImage;
        }
        finally {
            LOGGER.info((Object)("\u4e0a\u4f20\u5546\u54c1\u56fe\u7247SUCC" + username));
            image = null;
            imagePath = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setDefaultImage(Long productId, String imageName, String username) {
        GoodsProduct product = null;
        try {
            if (null != productId && null != imageName) {
                product = new GoodsProduct();
                product.setGoodsInfoId(productId);
                product.setGoodsInfoImgId(imageName);
                int n = this.goodsProductService.updateProduct(product, username, null, null, null);
                return n;
            }
        }
        finally {
            LOGGER.info((Object)("\u8bbe\u7f6e\u9ed8\u8ba4\u5546\u54c1\u56fe\u7247SUCC" + username));
            product = null;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public int batchDelImage(String[] delImages, String username) {
        Integer count = 0;
        try {
            if (null != delImages && delImages.length > 0) {
                for (int i = 0; i < delImages.length; ++i) {
                    count = count + this.delGoodsImage(Long.parseLong(delImages[i]), username);
                }
            }
            int n = count;
            return n;
        }
        finally {
            LOGGER.info((Object)("\u6279\u91cf\u5220\u9664\u5546\u54c1\u56fe\u7247SUCC" + username));
            this.cascDelMapper.cascDel(username);
            count = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public int batchUpdateImage(String[] imageIds, int productId, String username) {
        Integer count = 0;
        GoodsImage image = null;
        try {
            if (null != imageIds && imageIds.length > 0) {
                for (int i = 0; i < imageIds.length; ++i) {
                    image = new GoodsImage();
                    image.setGoodsImgId(Long.parseLong(imageIds[i]));
                    image.setGoodsInfoId(Long.parseLong(String.valueOf(productId)));
                    image.setGoodsImgCreateName(username);
                    count = count + this.goodsImageMapper.updateByPrimaryKeySelective(image);
                }
            }
            int n = count;
            return n;
        }
        finally {
            count = null;
            image = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int batchSaveImage(String[] imageUrl, int productId, String username) {
        int count = 0;
        GoodsImage image = null;
        try {
            if (null != imageUrl && imageUrl.length > 0) {
                for (int i = 0; i < imageUrl.length; ++i) {
                    image = new GoodsImage();
                    image.setGoodsImgCreateName(username);
                    image.setGoodsImgDelflag("0");
                    image.setGoodsImgSort(0);
                    image.setGoodsInfoId(Long.parseLong(String.valueOf(productId)));
                    image.setImageArtworkName(imageUrl[i]);
                    HashMap<String, Object> paramMap = new HashMap<String, Object>();
                    paramMap.put("url", imageUrl[i]);
                    InfoImageManage infoImageManage = this.imageSetMapper.queryImageByUrl(paramMap);
                    image.setImageBigName(infoImageManage.getBigImgUrl() == null ? imageUrl[i] : infoImageManage.getBigImgUrl());
                    image.setImageInName(infoImageManage.getMiddleImgUrl() == null ? imageUrl[i] : infoImageManage.getMiddleImgUrl());
                    image.setImageThumName(infoImageManage.getSmallImgUrl() == null ? imageUrl[i] : infoImageManage.getSmallImgUrl());
                    this.goodsImageMapper.insertSelective(image);
                    ++count;
                }
                int n = count;
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            image = null;
        }
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public int setDefaultImage(Long goodsInfoId, Long goodsImgId) {
        this.goodsImageMapper.updateByProductInfoId(goodsInfoId);
        return this.goodsImageMapper.setDefaultImage(goodsImgId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int batchSaveImageWithDefaultPic(String[] imageUrl, int productId, String username) {
        int count = 0;
        GoodsImage image = null;
        try {
            if (null != imageUrl && imageUrl.length > 0) {
                for (int i = 0; i < imageUrl.length; ++i) {
                    image = new GoodsImage();
                    image.setGoodsImgCreateName(username);
                    image.setGoodsImgDelflag("0");
                    image.setGoodsImgSort(0);
                    image.setGoodsInfoId(Long.parseLong(String.valueOf(productId)));
                    image.setImageArtworkName(imageUrl[i]);
                    HashMap<String, Object> paramMap = new HashMap<String, Object>();
                    paramMap.put("url", imageUrl[i]);
                    InfoImageManage infoImageManage = this.imageSetMapper.queryImageByUrl(paramMap);
                    if (infoImageManage == null) {
                        image.setImageBigName(imageUrl[i]);
                        image.setImageInName(imageUrl[i]);
                        image.setImageThumName(imageUrl[i]);
                    } else {
                        image.setImageBigName(infoImageManage.getBigImgUrl() == null ? imageUrl[i] : infoImageManage.getBigImgUrl());
                        image.setImageInName(infoImageManage.getMiddleImgUrl() == null ? imageUrl[i] : infoImageManage.getBigImgUrl());
                        image.setImageThumName(infoImageManage.getSmallImgUrl() == null ? imageUrl[i] : infoImageManage.getBigImgUrl());
                    }
                    if (count == 0) {
                        image.setGoodsImgSort(1);
                    }
                    this.goodsImageMapper.insertSelective(image);
                    ++count;
                }
                int n = count;
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            image = null;
        }
    }
}

