/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.goods.service.impl;

import com.qianjiang.excel.ImportGoods;
import com.qianjiang.goods.bean.GoodsType;
import com.qianjiang.goods.bean.GoodsTypeBrand;
import com.qianjiang.goods.bean.GoodsTypeExpandParam;
import com.qianjiang.goods.bean.GoodsTypeExpandParamValue;
import com.qianjiang.goods.bean.GoodsTypeParam;
import com.qianjiang.goods.bean.GoodsTypeSpec;
import com.qianjiang.goods.dao.CascDelMapper;
import com.qianjiang.goods.dao.GoodsTypeMapper;
import com.qianjiang.goods.service.GoodsTypeBrandService;
import com.qianjiang.goods.service.GoodsTypeExpandParamService;
import com.qianjiang.goods.service.GoodsTypeExpandParamValueService;
import com.qianjiang.goods.service.GoodsTypeParamService;
import com.qianjiang.goods.service.GoodsTypeService;
import com.qianjiang.goods.service.GoodsTypeSpecService;
import com.qianjiang.goods.util.SelectBean;
import com.qianjiang.goods.vo.GoodsTypeVo;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="GoodsTypeService")
public class GoodsTypeServiceImpl
implements GoodsTypeService {
    private GoodsTypeMapper goodsTypeMapper;
    private GoodsTypeBrandService goodsTypeBrandService;
    private GoodsTypeSpecService goodsTypeSpecService;
    private GoodsTypeExpandParamService goodsTypeExpandParamService;
    private GoodsTypeExpandParamValueService goodsTypeExpandParamValueService;
    private GoodsTypeParamService goodsTypeParamService;
    private CascDelMapper cascDelMapper;
    private ImportGoods importGoods;
    private static final MyLogger LOGGER = new MyLogger(GoodsTypeServiceImpl.class);

    public ImportGoods getImportGoods() {
        return this.importGoods;
    }

    @Resource(name="ImportGoods")
    public void setImportGoods(ImportGoods importGoods) {
        this.importGoods = importGoods;
    }

    public CascDelMapper getCascDelMapper() {
        return this.cascDelMapper;
    }

    @Resource(name="CascDelMapper")
    public void setCascDelMapper(CascDelMapper cascDelMapper) {
        this.cascDelMapper = cascDelMapper;
    }

    public GoodsTypeParamService getGoodsTypeParamService() {
        return this.goodsTypeParamService;
    }

    @Resource(name="GoodsTypeParamService")
    public void setGoodsTypeParamService(GoodsTypeParamService goodsTypeParamService) {
        this.goodsTypeParamService = goodsTypeParamService;
    }

    public GoodsTypeExpandParamService getGoodsTypeExpandParamService() {
        return this.goodsTypeExpandParamService;
    }

    @Resource(name="GoodsTypeExpandParamService")
    public void setGoodsTypeExpandParamService(GoodsTypeExpandParamService goodsTypeExpandParamService) {
        this.goodsTypeExpandParamService = goodsTypeExpandParamService;
    }

    public GoodsTypeExpandParamValueService getGoodsTypeExpandParamValueService() {
        return this.goodsTypeExpandParamValueService;
    }

    @Resource(name="GoodsTypeExpandParamValueService")
    public void setGoodsTypeExpandParamValueService(GoodsTypeExpandParamValueService goodsTypeExpandParamValueService) {
        this.goodsTypeExpandParamValueService = goodsTypeExpandParamValueService;
    }

    public GoodsTypeBrandService getGoodsTypeBrandService() {
        return this.goodsTypeBrandService;
    }

    @Resource(name="GoodsTypeBrandService")
    public void setGoodsTypeBrandService(GoodsTypeBrandService goodsTypeBrandService) {
        this.goodsTypeBrandService = goodsTypeBrandService;
    }

    public GoodsTypeSpecService getGoodsTypeSpecService() {
        return this.goodsTypeSpecService;
    }

    @Resource(name="GoodsTypeSpecService")
    public void setGoodsTypeSpecService(GoodsTypeSpecService goodsTypeSpecService) {
        this.goodsTypeSpecService = goodsTypeSpecService;
    }

    public GoodsTypeMapper getGoodsTypeMapper() {
        return this.goodsTypeMapper;
    }

    @Resource(name="GoodsTypeMapper")
    public void setGoodsTypeMapper(GoodsTypeMapper goodsTypeMapper) {
        this.goodsTypeMapper = goodsTypeMapper;
    }

    @Override
    @Transactional
    public Long saveGoodsType(GoodsType goodsType, String username) {
        goodsType.setTypeCreateName(username);
        this.goodsTypeMapper.insertSelective(goodsType);
        LOGGER.info((Object)("\u4fdd\u5b58\u5546\u54c1\u7c7b\u578bSUCC" + username));
        return this.goodsTypeMapper.selectLastId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public int delGoodsType(Long typeId, String username) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            map.put("delName", username);
            map.put("typeId", typeId.toString());
            int n = this.goodsTypeMapper.deleteByPrimaryKey(map);
            return n;
        }
        finally {
            LOGGER.info((Object)("\u5220\u9664\u5546\u54c1\u7c7b\u578bSUCC" + username));
            this.cascDelMapper.cascDel(username);
            map = null;
        }
    }

    @Override
    @Transactional
    public int updateGoodsType(GoodsType goodsType, String username) {
        goodsType.setTypeModifiedName(username);
        LOGGER.info((Object)("\u66f4\u65b0\u5546\u54c1\u7c7b\u578bSUCC" + username));
        return this.goodsTypeMapper.updateByPrimaryKeySelective(goodsType);
    }

    @Override
    public GoodsTypeVo queryTypeVoByTypeId(Long typeId) {
        return this.goodsTypeMapper.selectByPrimaryKey(typeId);
    }

    @Override
    public PageBean queryListByPageBean(PageBean pb) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        try {
            pb.setRows(this.goodsTypeMapper.queryTotalCount());
            map.put("startRowNum", pb.getStartRowNum());
            map.put("endRowNum", pb.getEndRowNum());
            pb.setList(this.goodsTypeMapper.selectAllType(map));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u67e5\u8be2\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return pb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public int batchDelType(Long[] typeIds, String username) {
        Integer count = 0;
        try {
            for (int i = 0; i < typeIds.length; ++i) {
                count = count + this.delGoodsType(typeIds[i], username);
            }
            int n = count;
            return n;
        }
        finally {
            LOGGER.info((Object)("\u6279\u91cf\u5220\u9664\u5546\u54c1\u7c7b\u578bSUCC" + username));
            this.cascDelMapper.cascDel(username);
            count = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public int saveTypeAndParam(GoodsType goodsType, Map<String, String[]> map, String username) {
        Long lastId = this.saveGoodsType(goodsType, username);
        if (lastId > 0L) {
            try {
                String[] brandIds = map.get("brandIds");
                String[] specIds = map.get("specIds");
                String[] paramname = map.get("paramname");
                String[] paramnickname = map.get("paramnickname");
                String[] expandnames = map.get("expandnames");
                String[] expandnicknames = map.get("expandnicknames");
                String[] expandparamsort = map.get("expandparamsort");
                String[] expandparamisshow = map.get("expandparamisshow");
                String[] expandvalues = map.get("expandvalues");
                this.saveBrand(username, lastId, brandIds);
                this.saveTypeSpec(username, lastId, specIds);
                if (null != expandnames) {
                    GoodsTypeExpandParam typeExpandParam = null;
                    for (int i = 0; i < expandnames.length; ++i) {
                        typeExpandParam = new GoodsTypeExpandParam();
                        typeExpandParam.setTypeId(lastId);
                        typeExpandParam.setExpandparamName(expandnames[i]);
                        typeExpandParam.setExpandparamNickname(expandnicknames[i]);
                        typeExpandParam.setExpandparamSort(Integer.parseInt(expandparamsort[i]));
                        typeExpandParam.setExpandparamDelflag("0");
                        Long paramId = this.goodsTypeExpandParamService.saveExpandParam(typeExpandParam, username);
                        if (paramId <= 0L || null == expandvalues[i]) continue;
                        GoodsTypeExpandParamValue paramValue = null;
                        String[] values = expandvalues[i].split("\\|");
                        for (int k = 0; k < values.length; ++k) {
                            paramValue = new GoodsTypeExpandParamValue();
                            paramValue.setExpandparamId(Long.parseLong(String.valueOf(paramId)));
                            paramValue.setExpandparamValueDelflag("0");
                            paramValue.setExpandparamValueName(values[k]);
                            this.goodsTypeExpandParamValueService.saveParamValue(paramValue, username);
                        }
                        values = null;
                        paramValue = null;
                    }
                    typeExpandParam = null;
                }
                this.saveParam(username, lastId, paramname, paramnickname);
                int n = 1;
                return n;
            }
            finally {
                LOGGER.info((Object)("\u4fdd\u5b58\u5546\u54c1\u7c7b\u578bSUCC" + username));
                lastId = null;
            }
        }
        return 0;
    }

    @Transactional
    private void saveBrand(String username, Long lastId, String[] brandIds) {
        if (brandIds != null) {
            GoodsTypeBrand goodsTypeBrand = null;
            for (int i = 0; i < brandIds.length; ++i) {
                goodsTypeBrand = new GoodsTypeBrand();
                goodsTypeBrand.setTypeId(lastId);
                goodsTypeBrand.setBrandId(Long.parseLong(brandIds[i]));
                goodsTypeBrand.setDelflag("0");
                this.goodsTypeBrandService.insertTypeBrand(goodsTypeBrand, username);
            }
            goodsTypeBrand = null;
        }
    }

    @Transactional
    private void saveTypeSpec(String username, Long lastId, String[] specIds) {
        if (specIds != null) {
            GoodsTypeSpec goodsTypeSpec = null;
            for (int i = 0; i < specIds.length; ++i) {
                goodsTypeSpec = new GoodsTypeSpec();
                goodsTypeSpec.setTypeId(lastId);
                goodsTypeSpec.setSpecId(Long.parseLong(specIds[i]));
                goodsTypeSpec.setTypeSpecDelflag("0");
                this.goodsTypeSpecService.saveTypeSpec(goodsTypeSpec, username);
            }
            goodsTypeSpec = null;
        }
    }

    @Transactional
    private void saveParam(String username, Long lastId, String[] paramname, String[] paramnickname) {
        if (null != paramname) {
            GoodsTypeParam goodsTypeParam = null;
            for (int i = 0; i < paramname.length; ++i) {
                goodsTypeParam = new GoodsTypeParam();
                goodsTypeParam.setParamDelflag("0");
                goodsTypeParam.setParamName(paramname[i]);
                goodsTypeParam.setParamNickname(paramnickname[i]);
                goodsTypeParam.setTypeId(lastId);
                this.goodsTypeParamService.saveTypeParam(goodsTypeParam, username);
            }
            goodsTypeParam = null;
        }
    }

    @Override
    public List<Object> queryAllType() {
        List<Object> goodsTypes = new ArrayList<Object>();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        try {
            map.put("startRowNum", 0);
            map.put("endRowNum", this.goodsTypeMapper.queryTotalCount());
            goodsTypes = this.goodsTypeMapper.selectAllType(map);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u67e5\u8be2\u5546\u54c1\u7c7b\u578b\u9519\u8bef" + e.getMessage(), (Throwable)e);
        }
        return goodsTypes;
    }

    @Override
    public GoodsTypeVo queryTypeVoByCatId(Long catId) {
        return this.goodsTypeMapper.queryTypeVoByCatId(catId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageBean searchListByPageBean(PageBean pageBean, SelectBean selectBean) {
        pageBean.setObjectBean((Object)selectBean);
        if ("".equals(selectBean.getSearchText())) {
            selectBean.setCondition("");
        }
        pageBean.setRows(this.goodsTypeMapper.searchTotalCount(selectBean));
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put("startRowNum", pageBean.getStartRowNum());
            map.put("endRowNum", pageBean.getEndRowNum());
            map.put("condition", selectBean.getCondition());
            map.put("searchText", selectBean.getSearchText());
            pageBean.setList(this.goodsTypeMapper.searchAllType(map));
        }
        finally {
            map = null;
        }
        return pageBean;
    }

    @Override
    public List<GoodsType> exportGoodsType() {
        return this.goodsTypeMapper.selectAll();
    }

    @Override
    public boolean isGoodsTypeExist(Long typeId) {
        return this.goodsTypeMapper.queryGoodsTypeCount(typeId) != 0;
    }

    @Override
    public boolean checkTypeName(String typeName, String id) {
        return this.goodsTypeMapper.queryCountByTypeName(typeName, id) <= 0;
    }

    @Override
    public GoodsTypeVo queryGoodsTypeByCatId(Long catId) {
        return this.goodsTypeMapper.queryTypeVoByCatId(catId);
    }
}

