/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.goods.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.util.StringUtil;
import com.qianjiang.goods.bean.SolrExpandparam;
import com.qianjiang.goods.bean.SolrGoodsBrand;
import com.qianjiang.goods.bean.SolrGoodsCategory;
import com.qianjiang.goods.bean.SolrGoodsImage;
import com.qianjiang.goods.bean.SolrGoodsInfo;
import com.qianjiang.goods.bean.SolrMarketing;
import com.qianjiang.goods.bean.SolrProductWare;
import com.qianjiang.goods.bean.SolrThirdCate;
import com.qianjiang.goods.dao.GoodsSolrMapper;
import com.qianjiang.goods.vo.ThirdStoreInfo;
import com.qianjiang.util.MyLogger;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrInputDocument;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class CreateSolrSimpleIndex {
    private static final MyLogger LOGGER = new MyLogger(CreateSolrSimpleIndex.class);
    @Resource(name="GoodsSolrMapper")
    private GoodsSolrMapper goodsSolrMapper;
    @Resource(name="httpSolrServer")
    private HttpSolrServer solrServer;

    public void simpleCrateSolrIndex(Long goodsIds) {
        if (goodsIds != null) {
            LOGGER.info((Object)"Solr search \u67e5\u8be2\u5355\u6761\u6570\u636e,\u521b\u5efa\u7d22\u5f15\u6587\u6863...");
            LOGGER.info((Object)("goodsIds..." + goodsIds));
            List<SolrGoodsInfo> egoodslist = this.goodsSolrMapper.selectGoodsSolrList(goodsIds);
            SolrInputDocument doc = new SolrInputDocument();
            if (egoodslist != null && !egoodslist.isEmpty()) {
                SolrGoodsInfo goodsInfo = egoodslist.get(0);
                List<Long> specDetailIdLists = this.goodsSolrMapper.selectSpecDetailId(goodsInfo.getGoodsId());
                this.addsolr(goodsInfo, doc, specDetailIdLists);
            }
            try {
                LOGGER.info((Object)"solr search \u5220\u9664\u7d22\u5f15...");
                UpdateResponse resp = this.solrServer.deleteByQuery("goodsId:" + goodsIds);
                if (!doc.isEmpty()) {
                    LOGGER.info((Object)"solr search \u65b0\u589e\u7d22\u5f15...");
                    this.solrServer.add(doc);
                }
                this.solrServer.commit();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void addsolr(SolrGoodsInfo goodsInfo, SolrInputDocument doc, List<Long> specDetailIdLists) {
        if (goodsInfo == null) {
            return;
        }
        if (doc == null) {
            doc = new SolrInputDocument();
        }
        LOGGER.info((Object)("goodsInfo.getGoodsInfoId()" + goodsInfo.getGoodsInfoId()));
        goodsInfo.setGoodsInfoName(goodsInfo.getGoodsName());
        goodsInfo.setCateList(this.cateUtil(goodsInfo.getCatId()));
        goodsInfo.setThirdCateList(this.thirdCateUtil(goodsInfo.getThirdCateId()));
        goodsInfo.setInMarketing(this.isInMarketing(goodsInfo));
        goodsInfo.setExpiryTime(this.isExpiryTime(goodsInfo));
        Long productId = goodsInfo.getGoodsInfoId();
        doc.setField("id", (Object)productId);
        doc.setField("goodsId", (Object)goodsInfo.getGoodsId());
        BigDecimal preferPrice = goodsInfo.getGoodsInfoPreferPrice();
        Double dPreferPrice = preferPrice.doubleValue();
        List<SolrProductWare> wares = goodsInfo.getWareList();
        if (wares != null && wares.size() > 0) {
            dPreferPrice = wares.get(0).getWarePrice().doubleValue();
        }
        doc.setField("product_price", (Object)dPreferPrice);
        SolrGoodsBrand brandInfo = goodsInfo.getBrand();
        String brand = JSONObject.toJSONString((Object)brandInfo);
        doc.setField("brand", (Object)brand);
        String esGoodsInfo = JSONObject.toJSONString((Object)goodsInfo);
        doc.setField("paramList", (Object)esGoodsInfo);
        String brandName = goodsInfo.getBrand().getBrandName();
        doc.setField("brandName", (Object)brandName);
        String specDetailIdList = JSON.toJSONString(specDetailIdLists);
        doc.setField("specDetailId", (Object)specDetailIdList);
        List<SolrExpandparam> paramList = goodsInfo.getParamList();
        if (paramList != null) {
            for (SolrExpandparam param : paramList) {
                String expandparamName = param.getExpandparamName();
                String expandparamValueName = param.getExpandparamValueName();
                if (StringUtil.isEmpty((String)expandparamName) || StringUtil.isEmpty((String)expandparamValueName)) continue;
                doc.addField("paramValueList", (Object)(expandparamName + "+" + expandparamValueName));
            }
        }
        Integer saleCount = goodsInfo.getSaleCount();
        doc.setField("saleCount", (Object)saleCount);
        Integer collectionCount = goodsInfo.getCollectionCount();
        doc.setField("collectionCount", (Object)collectionCount);
        Date goodsInfoAddedTime = goodsInfo.getGoodsInfoAddedTime();
        doc.setField("goodsInfoAddedTime", (Object)goodsInfoAddedTime);
        String auditStatus = goodsInfo.getAuditStatus();
        doc.setField("auditStatus", (Object)auditStatus);
        String goodsInfoAdded = goodsInfo.getGoodsInfoAdded();
        doc.setField("goodsInfoAdded", (Object)goodsInfoAdded);
        BigDecimal goodsInfoCostPrice = goodsInfo.getGoodsInfoCostPrice();
        if (goodsInfoCostPrice != null) {
            Double doubleValue = goodsInfoCostPrice.doubleValue();
            doc.setField("goodsInfoCostPrice", (Object)doubleValue);
        }
        Date goodsInfoCreateTime = goodsInfo.getGoodsInfoCreateTime();
        doc.setField("goodsInfoCreateTime", (Object)goodsInfoCreateTime);
        Long goodsInfoId = goodsInfo.getGoodsInfoId();
        doc.setField("goodsInfoId", (Object)goodsInfoId);
        String goodsInfoImgId = goodsInfo.getGoodsInfoImgId();
        List<SolrGoodsImage> iamges = goodsInfo.getImgList();
        if (iamges != null && iamges.size() > 0) {
            goodsInfoImgId = iamges.get(0).getImageArtworkName();
        }
        doc.setField("goodsInfoImgId", (Object)goodsInfoImgId);
        String goodsInfoItemNo = goodsInfo.getGoodsInfoItemNo();
        doc.setField("goodsInfoItemNo", (Object)goodsInfoItemNo);
        BigDecimal goodsInfoMarketPrice1 = goodsInfo.getGoodsInfoMarketPrice();
        if (goodsInfoMarketPrice1 != null) {
            Double goodsInfoMarketPrice = goodsInfoMarketPrice1.doubleValue();
            doc.setField("goodsInfoMarketPrice", (Object)goodsInfoMarketPrice);
        }
        String goodsInfoModifiedName = goodsInfo.getGoodsInfoModifiedName();
        doc.setField("goodsInfoModifiedName", (Object)goodsInfoModifiedName);
        Date goodsInfoModifiedTime = goodsInfo.getGoodsInfoModifiedTime();
        doc.setField("goodsInfoModifiedTime", (Object)goodsInfoModifiedTime);
        String goodsInfoSubtitle = goodsInfo.getGoodsInfoSubtitle();
        doc.setField("goodsInfoSubtitle", (Object)goodsInfoSubtitle);
        BigDecimal goodsInfoWeight1 = goodsInfo.getGoodsInfoWeight();
        Double goodsInfoWeight = goodsInfoWeight1.doubleValue();
        doc.setField("goodsInfoWeight", (Object)goodsInfoWeight);
        String goodsName = goodsInfo.getGoodsInfoName();
        doc.setField("product_name", (Object)goodsName);
        List<SolrGoodsImage> urlList = goodsInfo.getImgList();
        String urlListJson = JSON.toJSONString(urlList);
        doc.setField("url", (Object)urlListJson);
        List<SolrGoodsCategory> cateLists = goodsInfo.getCateList();
        String cateListJson = JSON.toJSONString(cateLists);
        doc.setField("cateList", (Object)cateListJson);
        for (SolrGoodsCategory category : cateLists) {
            Long catId = category.getCatId();
            doc.addField("catId", (Object)catId);
        }
        List<SolrThirdCate> thirdCateList = goodsInfo.getThirdCateList();
        for (SolrThirdCate thirdCate : thirdCateList) {
            doc.setField("tcatId", (Object)thirdCate.getCatId());
            doc.setField("tcatName", (Object)thirdCate.getCatName());
            doc.setField("tcatParentId", (Object)thirdCate.getCatParentId());
            doc.addField("thirdCateId", (Object)thirdCate.getCatId());
        }
        doc.setField("thirdId", (Object)goodsInfo.getThirdId());
        String inMarketing = goodsInfo.getInMarketing();
        doc.setField("inMarketing", (Object)inMarketing);
        doc.setField("isThird", (Object)goodsInfo.getIsThird());
        doc.setField("showList", (Object)goodsInfo.getShowList());
        doc.setField("showMobile", (Object)goodsInfo.getShowMobile());
        Date expiryTime = goodsInfo.getExpiryTime();
        doc.setField("expiryTime", (Object)expiryTime);
        Long goodsInfoStock = goodsInfo.getGoodsInfoStock();
        if (wares != null && wares.size() > 0) {
            for (SolrProductWare ware : wares) {
                if (ware.getWareStock() > goodsInfoStock) {
                    goodsInfoStock = ware.getWareStock();
                    continue;
                }
                goodsInfoStock = 0L;
            }
        }
        doc.setField("goodsInfoStock", (Object)goodsInfoStock);
    }

    public void addsolr(SolrGoodsInfo goodsInfo, SolrInputDocument doc) {
        if (goodsInfo == null) {
            return;
        }
        if (doc == null) {
            doc = new SolrInputDocument();
        }
        LOGGER.info((Object)("goodsInfo.getGoodsInfoId()" + goodsInfo.getGoodsInfoId()));
        goodsInfo.setGoodsInfoName(goodsInfo.getGoodsName());
        goodsInfo.setCateList(this.cateUtil(goodsInfo.getCatId()));
        goodsInfo.setThirdCateList(this.thirdCateUtil(goodsInfo.getThirdCateId()));
        goodsInfo.setInMarketing(this.isInMarketing(goodsInfo));
        goodsInfo.setExpiryTime(this.isExpiryTime(goodsInfo));
        Long productId = goodsInfo.getGoodsInfoId();
        doc.setField("id", (Object)productId);
        doc.setField("goodsId", (Object)goodsInfo.getGoodsId());
        BigDecimal preferPrice = goodsInfo.getGoodsInfoPreferPrice();
        Double dPreferPrice = preferPrice.doubleValue();
        List<SolrProductWare> wares = goodsInfo.getWareList();
        if (wares != null && wares.size() > 0) {
            dPreferPrice = wares.get(0).getWarePrice().doubleValue();
        }
        doc.setField("product_price", (Object)dPreferPrice);
        SolrGoodsBrand brandInfo = goodsInfo.getBrand();
        String brand = JSONObject.toJSONString((Object)brandInfo);
        doc.setField("brand", (Object)brand);
        String esGoodsInfo = JSONObject.toJSONString((Object)goodsInfo);
        doc.setField("paramList", (Object)esGoodsInfo);
        String brandName = goodsInfo.getBrand().getBrandName();
        doc.setField("brandName", (Object)brandName);
        List<SolrExpandparam> paramList = goodsInfo.getParamList();
        if (paramList != null) {
            for (SolrExpandparam param : paramList) {
                String expandparamName = param.getExpandparamName();
                String expandparamValueName = param.getExpandparamValueName();
                if (StringUtil.isEmpty((String)expandparamName) || StringUtil.isEmpty((String)expandparamValueName)) continue;
                doc.addField("paramValueList", (Object)(expandparamName + "+" + expandparamValueName));
            }
        }
        Integer saleCount = goodsInfo.getSaleCount();
        doc.setField("saleCount", (Object)saleCount);
        Integer collectionCount = goodsInfo.getCollectionCount();
        doc.setField("collectionCount", (Object)collectionCount);
        Date goodsInfoAddedTime = goodsInfo.getGoodsInfoAddedTime();
        doc.setField("goodsInfoAddedTime", (Object)goodsInfoAddedTime);
        String auditStatus = goodsInfo.getAuditStatus();
        doc.setField("auditStatus", (Object)auditStatus);
        String goodsInfoAdded = goodsInfo.getGoodsInfoAdded();
        doc.setField("goodsInfoAdded", (Object)goodsInfoAdded);
        BigDecimal goodsInfoCostPrice = goodsInfo.getGoodsInfoCostPrice();
        if (goodsInfoCostPrice != null) {
            Double doubleValue = goodsInfoCostPrice.doubleValue();
            doc.setField("goodsInfoCostPrice", (Object)doubleValue);
        }
        Date goodsInfoCreateTime = goodsInfo.getGoodsInfoCreateTime();
        doc.setField("goodsInfoCreateTime", (Object)goodsInfoCreateTime);
        Long goodsInfoId = goodsInfo.getGoodsInfoId();
        doc.setField("goodsInfoId", (Object)goodsInfoId);
        String goodsInfoImgId = goodsInfo.getGoodsInfoImgId();
        List<SolrGoodsImage> iamges = goodsInfo.getImgList();
        if (iamges != null && iamges.size() > 0) {
            goodsInfoImgId = iamges.get(0).getImageArtworkName();
        }
        doc.setField("goodsInfoImgId", (Object)goodsInfoImgId);
        String goodsInfoItemNo = goodsInfo.getGoodsInfoItemNo();
        doc.setField("goodsInfoItemNo", (Object)goodsInfoItemNo);
        BigDecimal goodsInfoMarketPrice1 = goodsInfo.getGoodsInfoMarketPrice();
        if (goodsInfoMarketPrice1 != null) {
            Double goodsInfoMarketPrice = goodsInfoMarketPrice1.doubleValue();
            doc.setField("goodsInfoMarketPrice", (Object)goodsInfoMarketPrice);
        }
        String goodsInfoModifiedName = goodsInfo.getGoodsInfoModifiedName();
        doc.setField("goodsInfoModifiedName", (Object)goodsInfoModifiedName);
        Date goodsInfoModifiedTime = goodsInfo.getGoodsInfoModifiedTime();
        doc.setField("goodsInfoModifiedTime", (Object)goodsInfoModifiedTime);
        String goodsInfoSubtitle = goodsInfo.getGoodsInfoSubtitle();
        doc.setField("goodsInfoSubtitle", (Object)goodsInfoSubtitle);
        BigDecimal goodsInfoWeight1 = goodsInfo.getGoodsInfoWeight();
        Double goodsInfoWeight = goodsInfoWeight1.doubleValue();
        doc.setField("goodsInfoWeight", (Object)goodsInfoWeight);
        String goodsName = goodsInfo.getGoodsInfoName();
        doc.setField("product_name", (Object)goodsName);
        List<SolrGoodsImage> urlList = goodsInfo.getImgList();
        String urlListJson = JSON.toJSONString(urlList);
        doc.setField("url", (Object)urlListJson);
        List<SolrGoodsCategory> cateLists = goodsInfo.getCateList();
        String cateListJson = JSON.toJSONString(cateLists);
        doc.setField("cateList", (Object)cateListJson);
        for (SolrGoodsCategory category : cateLists) {
            Long catId = category.getCatId();
            doc.addField("catId", (Object)catId);
        }
        List<SolrThirdCate> thirdCateList = goodsInfo.getThirdCateList();
        for (SolrThirdCate thirdCate : thirdCateList) {
            doc.setField("tcatId", (Object)thirdCate.getCatId());
            doc.setField("tcatName", (Object)thirdCate.getCatName());
            doc.setField("tcatParentId", (Object)thirdCate.getCatParentId());
            doc.addField("thirdCateId", (Object)thirdCate.getCatId());
        }
        doc.setField("thirdId", (Object)goodsInfo.getThirdId());
        String inMarketing = goodsInfo.getInMarketing();
        doc.setField("inMarketing", (Object)inMarketing);
        doc.setField("isThird", (Object)goodsInfo.getIsThird());
        doc.setField("showList", (Object)goodsInfo.getShowList());
        doc.setField("showMobile", (Object)goodsInfo.getShowMobile());
        Date expiryTime = goodsInfo.getExpiryTime();
        doc.setField("expiryTime", (Object)expiryTime);
        Long goodsInfoStock = goodsInfo.getGoodsInfoStock();
        if (wares != null && wares.size() > 0) {
            for (SolrProductWare ware : wares) {
                if (ware.getWareStock() > goodsInfoStock) {
                    goodsInfoStock = ware.getWareStock();
                    continue;
                }
                goodsInfoStock = 0L;
            }
        }
        doc.setField("goodsInfoStock", (Object)goodsInfoStock);
    }

    public List<SolrGoodsCategory> cateUtil(Long catId) {
        if (catId != null) {
            ArrayList<SolrGoodsCategory> list = new ArrayList<SolrGoodsCategory>();
            SolrGoodsCategory solr = this.goodsSolrMapper.selectGoodsCateList(catId);
            if (solr != null && solr.getCatParentId() != null && solr.getCatParentId() != 0L) {
                SolrGoodsCategory solr2;
                SolrGoodsCategory solr1 = this.goodsSolrMapper.selectGoodsCateList(solr.getCatParentId());
                if (solr1 != null && solr1.getCatParentId() != null && solr1.getCatParentId() != 0L && (solr2 = this.goodsSolrMapper.selectGoodsCateList(solr1.getCatParentId())) != null && solr1.getCatParentId() != null) {
                    list.add(solr2);
                }
                list.add(solr1);
            }
            list.add(solr);
            return list;
        }
        return new ArrayList<SolrGoodsCategory>();
    }

    public List<SolrThirdCate> thirdCateUtil(Long catId) {
        if (catId != null) {
            ArrayList<SolrThirdCate> list = new ArrayList<SolrThirdCate>();
            SolrThirdCate solr = this.goodsSolrMapper.selectGoodsThirdCateList(catId);
            if (solr != null && solr.getCatParentId() != null && solr.getCatParentId() != 0L) {
                SolrThirdCate solr2;
                SolrThirdCate solr1 = this.goodsSolrMapper.selectGoodsThirdCateList(solr.getCatParentId());
                if (solr1 != null && solr1.getCatParentId() != null && solr1.getCatParentId() != 0L && (solr2 = this.goodsSolrMapper.selectGoodsThirdCateList(solr1.getCatParentId())) != null && solr1.getCatParentId() != null) {
                    list.add(solr2);
                }
                list.add(solr1);
            }
            list.add(solr);
            return list;
        }
        return new ArrayList<SolrThirdCate>();
    }

    private String isInMarketing(SolrGoodsInfo goodsInfo) {
        List<SolrMarketing> marketings = this.goodsSolrMapper.selectMarketingByGoodsInfoId(goodsInfo.getGoodsInfoId(), goodsInfo.getBrandId(), goodsInfo.getCatId());
        return CollectionUtils.isEmpty(marketings) ? "0" : "1";
    }

    private Date isExpiryTime(SolrGoodsInfo goodsInfo) {
        String dateStr = "2099-12-31 00:00:00";
        Date date = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            date = sdf.parse(dateStr);
            Long storeid = goodsInfo.getThirdId();
            if (storeid != null) {
                if (storeid.equals(0L)) {
                    return date;
                }
                ThirdStoreInfo stireInFo = this.goodsSolrMapper.selectThirdStoreInfo(storeid);
                if (stireInFo.getExpiryTime() != null) {
                    return stireInFo.getExpiryTime();
                }
                return date;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return date;
    }
}

