/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.goods.service.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.qianjiang.goods.bean.GoodsGroup;
import com.qianjiang.goods.bean.GoodsProduct;
import com.qianjiang.goods.bean.ProductWare;
import com.qianjiang.goods.dao.CascDelMapper;
import com.qianjiang.goods.dao.GoodsGroupMapper;
import com.qianjiang.goods.dao.GoodsGroupReleProductMapper;
import com.qianjiang.goods.dao.GoodsProductMapper;
import com.qianjiang.goods.service.GoodsGroupService;
import com.qianjiang.goods.service.ProductWareService;
import com.qianjiang.goods.vo.GoodsGroupReleProductVo;
import com.qianjiang.goods.vo.GoodsGroupVo;
import com.qianjiang.system.dao.StockWarningMapper;
import com.qianjiang.util.CollectionUtil;
import com.qianjiang.util.MapUtil;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="GoodsGroupService")
public class GoodsGroupServiceImpl
implements GoodsGroupService {
    private static final MyLogger LOGGER = new MyLogger(GoodsGroupServiceImpl.class);
    @Resource(name="GoodsGroupMapper")
    private GoodsGroupMapper goodsGroupMapper;
    @Resource(name="GoodsGroupReleProductMapper")
    private GoodsGroupReleProductMapper goodsGroupReleProduct;
    @Resource(name="CascDelMapper")
    private CascDelMapper cascDelMapper;
    @Resource(name="StockWarningMapper")
    private StockWarningMapper stockWarningMapper;
    @Resource(name="GoodsProductMapper")
    private GoodsProductMapper goodsProductMapper;
    @Autowired
    private ProductWareService productWareService;

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public int saveGoodsGroup(GoodsGroup goodsGroup) {
        String groupPrefertype = goodsGroup.getGroupPrefertype();
        if ("1".equals(groupPrefertype)) {
            goodsGroup.setGroupPreferamount(BigDecimal.valueOf(0.0));
        }
        return this.goodsGroupMapper.insertSelective(goodsGroup);
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public int delGoodsGroup(Long goodsGroupId, String username) {
        int result = 0;
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put("delName", username);
            map.put("groupId", goodsGroupId);
            result = this.goodsGroupMapper.deleteByPrimaryKey(map);
            this.goodsGroupReleProduct.delByGroupId(goodsGroupId);
            this.cascDelMapper.cascDel(username);
            LOGGER.info((Object)("\u5220\u9664\u5546\u54c1\u7ec4\u5408SUCC" + username));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u4e1a\u52a1\u5c42\u5220\u9664\u5546\u54c1\u7ec4\u5408\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public int delGoodsGroupNew(Long goodsGroupId, String username, Long thirdId) {
        int result = 0;
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put("delName", username);
            map.put("groupId", goodsGroupId);
            map.put("thirdId", thirdId);
            result = this.goodsGroupMapper.deleteByPrimaryKeyNew(map);
            this.goodsGroupReleProduct.delByGroupId(goodsGroupId);
            this.cascDelMapper.cascDel(username);
            LOGGER.info((Object)("\u5220\u9664\u5546\u54c1\u7ec4\u5408SUCC" + username));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u65b0\u5220\u9664\u5546\u54c1\u7ec4\u5408\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public int updateGoodsGroup(GoodsGroup goodsGroup, String username) {
        goodsGroup.setGroupModifiedTime(new Date());
        goodsGroup.setGroupModifiedName(username);
        if ("1".equals(goodsGroup.getGroupPrefertype())) {
            goodsGroup.setGroupPreferamount(BigDecimal.valueOf(0.0));
        }
        return this.goodsGroupMapper.updateByPrimaryKeySelective(goodsGroup);
    }

    @Override
    public GoodsGroup queryGoodsGroupByPrimaryKey(Long goodsGroupId) {
        return this.goodsGroupMapper.selectByPrimaryKey(goodsGroupId);
    }

    @Override
    public PageBean queryGoodsGroupByPageBean(PageBean pb) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        pb.setRows(this.goodsGroupMapper.queryTotalAcount());
        map.put("startRowNum", pb.getStartRowNum());
        map.put("endRowNum", pb.getEndRowNum());
        pb.setList(this.goodsGroupMapper.queryAllByPageBean(map));
        return pb;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public int batchDelGroup(Long thirdId, Long[] groupIds, String username) {
        int count = 0;
        try {
            if (null != groupIds && groupIds.length > 0) {
                for (int i = 0; i < groupIds.length; ++i) {
                    if (thirdId != null && thirdId > 0L) {
                        GoodsGroupVo goodsGroupVo = this.queryVoByPrimaryKey(groupIds[i]);
                        if (goodsGroupVo == null || !goodsGroupVo.getThirdId().equals(thirdId)) continue;
                        count += this.delGoodsGroupNew(groupIds[i], username, thirdId);
                        continue;
                    }
                    count += this.delGoodsGroupNew(groupIds[i], username, 0L);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u4e1a\u52a1\u5c42\u6279\u91cf\u5220\u9664\u5546\u54c1\u7ec4\u5408\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return count;
    }

    @Override
    public GoodsGroupVo queryVoByPrimaryKey(Long groupId) {
        GoodsGroupVo groupVo = this.goodsGroupMapper.queryVoByPrimaryKey(groupId);
        List productList = CollectionUtil.defaultList(groupVo.getProductList());
        for (GoodsGroupReleProductVo relProduct : productList) {
            List<ProductWare> wareList = this.productWareService.queryAllByProductId(relProduct.getProductId());
            if (null == wareList || wareList.size() <= 0) continue;
            BigDecimal minPrice = wareList.get(0).getWarePrice();
            BigDecimal maxPrice = wareList.get(0).getWarePrice();
            for (ProductWare ware : wareList) {
                minPrice = minPrice.min(ware.getWarePrice());
                maxPrice = maxPrice.max(ware.getWarePrice());
            }
            relProduct.setMinPrice(minPrice);
            relProduct.setMaxPrice(maxPrice);
        }
        return groupVo;
    }

    @Override
    public PageBean queryGoodsGroupByPageBeanAndSearchBean(PageBean pb, GoodsGroup group) {
        Map paramMap = MapUtil.getParamsMap((Object)group);
        try {
            pb.setRows(this.goodsGroupMapper.searchTotalCount(paramMap));
            Integer no = pb.getRows() % pb.getPageSize() == 0 ? pb.getRows() / pb.getPageSize() : pb.getRows() / pb.getPageSize() + 1;
            no = no == 0 ? 1 : no;
            if (pb.getPageNo() >= no) {
                pb.setPageNo(no.intValue());
                pb.setStartRowNum((no - 1) * pb.getPageSize());
            }
            pb.setObjectBean((Object)group);
            paramMap.put("startRowNum", pb.getStartRowNum());
            paramMap.put("endRowNum", pb.getEndRowNum());
            pb.setList(this.goodsGroupMapper.queryAllByPageBeanAndSelBean(paramMap));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u4e1a\u52a1\u5c42\u5e73\u53f0\u7aef\u5206\u9875\u67e5\u8be2\u5546\u54c1\u7ec4\u5408\u4fe1\u606f\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return pb;
    }

    @Override
    public PageBean queryThirdGoodsGroupByPageBeanAndSearchBean(PageBean pb, GoodsGroup group) {
        Map paramMap = MapUtil.getParamsMap((Object)group);
        try {
            pb.setRows(this.goodsGroupMapper.searchThirdTotalCount(paramMap));
            Integer no = pb.getRows() % pb.getPageSize() == 0 ? pb.getRows() / pb.getPageSize() : pb.getRows() / pb.getPageSize() + 1;
            no = no == 0 ? 1 : no;
            if (pb.getPageNo() >= no) {
                pb.setPageNo(no.intValue());
                pb.setStartRowNum((no - 1) * pb.getPageSize());
            }
            pb.setObjectBean((Object)group);
            paramMap.put("startRowNum", pb.getStartRowNum());
            paramMap.put("endRowNum", pb.getEndRowNum());
            pb.setList(this.goodsGroupMapper.queryAllThirdByPageBeanAndSelBean(paramMap));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u4e1a\u52a1\u5c42\u5546\u5bb6\u7aef\u5206\u9875\u67e5\u8be2\u5546\u54c1\u7ec4\u5408\u5217\u8868\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return pb;
    }

    @Override
    public List<GoodsGroupVo> queryGroupVoListByProductId(Long productId) {
        return this.goodsGroupMapper.queryGroupVoByProductId(productId);
    }

    @Override
    public List<GoodsGroupVo> queryGroupVoListWithOutProductId(Long productId) {
        List<GoodsGroupVo> groupList = new ArrayList<GoodsGroupVo>();
        if (productId != null) {
            groupList = this.goodsGroupMapper.queryGroupVoByProductId(productId);
            for (int i = 0; i < groupList.size(); ++i) {
                ArrayList<GoodsGroupReleProductVo> list = new ArrayList<GoodsGroupReleProductVo>();
                for (int j = 0; j < groupList.get(i).getProductList().size(); ++j) {
                    if (groupList.get(i).getProductList().get(j).getProductDetail() == null || groupList.get(i).getProductList().get(j).getProductDetail().getGoodsInfoId().toString().equals(productId.toString())) continue;
                    list.add(groupList.get(i).getProductList().get(j));
                }
                if (list.size() == 0) {
                    groupList.remove(i);
                    continue;
                }
                groupList.get(i).setProductList(list);
            }
        }
        return groupList;
    }

    @Override
    public List<GoodsGroupVo> queryGroupVoListWithProductId(Long productId) {
        ArrayList<GoodsGroupVo> calculatedList = new ArrayList<GoodsGroupVo>();
        try {
            Predicate<GoodsGroupVo> isAvailable;
            List<GoodsGroupVo> groupList;
            ArrayList filteredList;
            if (productId != null && (filteredList = new ArrayList(Collections2.filter(groupList = this.goodsGroupMapper.queryGroupVoByProductId(productId), (Predicate)(isAvailable = new Predicate<GoodsGroupVo>(){

                public boolean apply(GoodsGroupVo groupVo) {
                    List<GoodsGroupReleProductVo> productList = groupVo.getProductList();
                    LOGGER.info((Object)("=====queryGroupVoListWithProductId====" + productList.hashCode()));
                    for (GoodsGroupReleProductVo relProduct : productList) {
                        GoodsProduct goodsProduct = GoodsGroupServiceImpl.this.goodsProductMapper.queryProductByProductId(relProduct.getProductId());
                        if (goodsProduct != null && !"0".equals(goodsProduct.getGoodsInfoAdded())) continue;
                        return false;
                    }
                    return true;
                }
            })))) != null && !filteredList.isEmpty()) {
                for (GoodsGroupVo groupVo : filteredList) {
                    List<GoodsGroupReleProductVo> productList = groupVo.getProductList();
                    if (CollectionUtils.isEmpty(productList)) continue;
                    BigDecimal totalPrice = BigDecimal.ZERO;
                    GoodsGroupReleProductVo curProduct = productList.get(0);
                    for (GoodsGroupReleProductVo relProduct : productList) {
                        if (relProduct.getProductId().equals(productId)) {
                            curProduct = relProduct;
                        }
                        totalPrice = totalPrice.add(relProduct.getProductDetail().getGoodsInfoPreferPrice().multiply(BigDecimal.valueOf(relProduct.getProductNum())));
                    }
                    groupVo.setPrice(totalPrice.subtract(groupVo.getGroupPreferamount()));
                    productList.remove(curProduct);
                    productList.add(0, curProduct);
                    groupVo.setProductList(productList);
                    calculatedList.add(groupVo);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u6839\u636e\u8d27\u54c1ID\u67e5\u8be2\u7ec4\u5408\u6216\u8005\u662f\u5957\u88c5\u5217\u8868\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return calculatedList;
    }

    @Override
    public Map<String, Object> getIndexCount() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("stockCount", this.stockWarningMapper.selectcount(null));
        map.put("groupCount", this.goodsGroupMapper.searchTotalCount(null));
        return map;
    }

    @Override
    public void deleteShoppingCartByFitIds(Long[] groupIds) {
        if (groupIds != null && groupIds.length > 0) {
            for (Long groupId : groupIds) {
                this.goodsGroupMapper.deleteShoppingCartByFitid(groupId);
            }
        }
    }

    @Override
    public int queryGroupCount(String groupId) {
        return this.goodsGroupMapper.queryGroupCount(groupId);
    }
}

