/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.goods.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.util.StringUtil;
import com.qianjiang.goods.bean.GoodsProduct;
import com.qianjiang.goods.bean.SolrGoodsCategory;
import com.qianjiang.goods.bean.SolrGoodsImage;
import com.qianjiang.goods.bean.SolrGoodsInfo;
import com.qianjiang.goods.bean.SolrMarketing;
import com.qianjiang.goods.bean.SolrThirdCate;
import com.qianjiang.goods.dao.GoodsProductMapper;
import com.qianjiang.goods.dao.GoodsSolrMapper;
import com.qianjiang.goods.service.GoodsSolrSearchService;
import com.qianjiang.goods.util.CommonConditions;
import com.qianjiang.goods.util.CreateSolrSimpleIndex;
import com.qianjiang.goods.util.DeleteSolrIndex;
import com.qianjiang.goods.util.DeleteSolrSimpleIndex;
import com.qianjiang.goods.util.SearchPageBean;
import com.qianjiang.goods.util.UpdateSolrIndex;
import com.qianjiang.goods.vo.BrandVo;
import com.qianjiang.goods.vo.ExpandParamVo;
import com.qianjiang.goods.vo.ParamValueVo;
import com.qianjiang.goods.vo.ThirdStoreInfo;
import com.qianjiang.util.MyLogger;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service(value="GoodsSolrSearchService")
@Scope(value="prototype")
public class GoodsSolrSearchServiceImpl
implements GoodsSolrSearchService {
    private static final MyLogger LOGGER = new MyLogger(GoodsSolrSearchServiceImpl.class);
    private static final String BRAND = "brand";
    private static final String PARAMLIST = "paramList";
    private static final String GOODSINFOCREATETIME = "goodsInfoCreateTime";
    private static final String GOODSINFADDEDTETIME = "goodsInfoAddedTime";
    @Resource(name="GoodsSolrMapper")
    private GoodsSolrMapper goodsSolrMapper;
    @Resource(name="httpSolrServer")
    private HttpSolrServer solrServer;
    @Autowired
    private UpdateSolrIndex updateSolrIndex;
    @Autowired
    private DeleteSolrIndex deleteSolrIndex;
    @Autowired
    private DeleteSolrSimpleIndex deleteSolrSimpleIndex;
    @Autowired
    private CreateSolrSimpleIndex createSolrSimpleIndex;
    @Autowired
    private GoodsProductMapper goodsProductMapper;

    public List<SolrGoodsCategory> cateUtil(Long catId) {
        ArrayList<SolrGoodsCategory> list = new ArrayList<SolrGoodsCategory>();
        try {
            if (catId != null) {
                SolrGoodsCategory es = this.goodsSolrMapper.selectGoodsCateList(catId);
                if (es != null && es.getCatParentId() != null && es.getCatParentId() != 0L) {
                    SolrGoodsCategory es2;
                    SolrGoodsCategory es1 = this.goodsSolrMapper.selectGoodsCateList(es.getCatParentId());
                    if (es1 != null && es1.getCatParentId() != null && es1.getCatParentId() != 0L && (es2 = this.goodsSolrMapper.selectGoodsCateList(es1.getCatParentId())) != null && es1.getCatParentId() != null) {
                        list.add(es2);
                    }
                    list.add(es1);
                }
                list.add(es);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u5206\u7c7b\u683c\u5f0f\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return list;
    }

    public List<SolrThirdCate> thirdCateUtil(Long catId) {
        ArrayList<SolrThirdCate> list = new ArrayList<SolrThirdCate>();
        try {
            if (catId != null) {
                SolrThirdCate es = this.goodsSolrMapper.selectGoodsThirdCateList(catId);
                if (es != null && es.getCatParentId() != null && es.getCatParentId() != 0L) {
                    SolrThirdCate es2;
                    SolrThirdCate es1 = this.goodsSolrMapper.selectGoodsThirdCateList(es.getCatParentId());
                    if (es1 != null && es1.getCatParentId() != null && es1.getCatParentId() != 0L && (es2 = this.goodsSolrMapper.selectGoodsThirdCateList(es1.getCatParentId())) != null && es1.getCatParentId() != null) {
                        list.add(es2);
                    }
                    list.add(es1);
                }
                list.add(es);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u7b2c\u4e09\u65b9\u5206\u7c7b\u683c\u5f0f\u9519\u8bef" + e.getMessage(), (Throwable)e);
        }
        return list;
    }

    @Override
    public int createAllGoodsIndex() {
        int result = 0;
        HashMap<Long, SolrGoodsInfo> goods = new HashMap<Long, SolrGoodsInfo>();
        try {
            LOGGER.info((Object)"Solr search \u751f\u6210\u7d22\u5f15,\u67e5\u8be2\u5546\u54c1\u6570\u636e...");
            Integer listCount = this.goodsSolrMapper.selectGoodsSolrListCount();
            LOGGER.info((Object)("\u6240\u6709\u7684\u5546\u54c1\u603b\u6570\u91cf\u4e3a:" + listCount));
            int temp = 5;
            for (int i = 0; i < listCount; i += temp) {
                int start = i;
                List<SolrGoodsInfo> solrgoodslist = this.goodsSolrMapper.selectGoodsSolrListByPage(start, temp);
                if (solrgoodslist == null || solrgoodslist.isEmpty()) continue;
                for (SolrGoodsInfo goodsInfo : solrgoodslist) {
                    Long goodsId = goodsInfo.getGoodsId();
                    if (goods.get(goodsId) != null) continue;
                    goods.put(goodsId, goodsInfo);
                    LOGGER.info((Object)"Solr search \u8c03\u7528\u63a5\u53e3\u521b\u5efa\u7d22\u5f15...");
                    this.createSolrSimpleIndex.simpleCrateSolrIndex(goodsId);
                    LOGGER.info((Object)"Solr search \u521b\u5efa\u7d22\u5f15\u6210\u529f...");
                }
            }
            result = 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u4e1a\u52a1\u5c42\u5efa\u7acb\u7d22\u5f15\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private String isInMarketing(SolrGoodsInfo goodsInfo) {
        String result = "0";
        try {
            Long goodsInfoId = goodsInfo.getGoodsInfoId();
            Long brandId = goodsInfo.getBrandId();
            Long cateId = goodsInfo.getCatId();
            List<SolrMarketing> marketings = this.goodsSolrMapper.selectMarketingByGoodsInfoId(goodsInfoId, brandId, cateId);
            if (CollectionUtils.isNotEmpty(marketings)) {
                result = "1";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private Date isExpiryTime(SolrGoodsInfo goodsInfo) {
        String dateStr = "2099-12-31 00:00:00";
        Date date = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            date = sdf.parse(dateStr);
            Long storeid = goodsInfo.getThirdId();
            if (storeid != null) {
                if (storeid.equals(0L)) {
                    return date;
                }
                ThirdStoreInfo stireInFo = this.goodsSolrMapper.selectThirdStoreInfo(storeid);
                if (stireInFo.getExpiryTime() != null) {
                    return stireInFo.getExpiryTime();
                }
                return date;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return date;
    }

    @Override
    public int createOneGoodsIndex(Long goodsId) {
        int result = 0;
        try {
            if (goodsId != null) {
                LOGGER.info((Object)"solr search \u67e5\u8be2\u5355\u6761\u6570\u636e,\u521b\u5efa\u7d22\u5f15\u6587\u6863...");
                List<SolrGoodsInfo> egoodslist = this.goodsSolrMapper.selectGoodsSolrList(goodsId);
                if (egoodslist != null && !egoodslist.isEmpty()) {
                    LOGGER.info((Object)"solr search \u8c03\u7528\u63a5\u53e3\u521b\u5efa\u5355\u6761\u7d22\u5f15\u6587\u6863...");
                    this.createSolrSimpleIndex.simpleCrateSolrIndex(goodsId);
                    LOGGER.info((Object)"solr search \u521b\u5efa\u5355\u6761\u6587\u6863\u6210\u529f...");
                }
                result = 1;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u4e1a\u52a1\u5c42\u63d2\u5165\u7d22\u5f15\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @Override
    public int updateOneGoodsIndex(Long goodsId) {
        int result = 0;
        try {
            if (goodsId != null) {
                LOGGER.info((Object)"Solr sesarch \u67e5\u8be2\u5355\u6761\u6570\u636e,\u4fee\u6539\u7d22\u5f15\u6587\u6863...");
                List<SolrGoodsInfo> egoodslist = this.goodsSolrMapper.selectGoodsSolrList(goodsId);
                if (egoodslist != null && !egoodslist.isEmpty()) {
                    for (SolrGoodsInfo goodsInfo : egoodslist) {
                        goodsInfo.setCateList(this.cateUtil(goodsInfo.getCatId()));
                        goodsInfo.setThirdCateList(this.thirdCateUtil(goodsInfo.getThirdCateId()));
                        goodsInfo.setInMarketing(this.isInMarketing(goodsInfo));
                        goodsInfo.setExpiryTime(this.isExpiryTime(goodsInfo));
                    }
                    LOGGER.info((Object)"solr search \u8c03\u7528\u63a5\u53e3,\u4fee\u6539\u5355\u6761\u6587\u6863...");
                    this.updateSolrIndex.updateSimpleSolrIndex(goodsId);
                    LOGGER.info((Object)"solr search \u4fee\u6539\u5355\u6761\u6587\u6863\u6210\u529f...");
                }
                result = 1;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u4fee\u6539\u7d22\u5f15\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @Override
    public int updateThirdOneGoodsIndex(Long goodsId) {
        int result = 0;
        try {
            if (goodsId != null) {
                LOGGER.info((Object)"Solr sesarch \u67e5\u8be2\u5355\u6761\u6570\u636e,\u4fee\u6539\u7d22\u5f15\u6587\u6863...");
                List<SolrGoodsInfo> egoodslist = this.goodsSolrMapper.selectGoodsSolrListById(goodsId);
                if (egoodslist != null && !egoodslist.isEmpty()) {
                    for (SolrGoodsInfo goodsInfo : egoodslist) {
                        goodsInfo.setCateList(this.cateUtil(goodsInfo.getCatId()));
                        goodsInfo.setThirdCateList(this.thirdCateUtil(goodsInfo.getThirdCateId()));
                        goodsInfo.setInMarketing(this.isInMarketing(goodsInfo));
                        goodsInfo.setExpiryTime(this.isExpiryTime(goodsInfo));
                    }
                    LOGGER.info((Object)"sorl search \u8c03\u7528\u63a5\u53e3,\u4fee\u6539\u5355\u6761\u6587\u6863...");
                    this.updateSolrIndex.updateSimpleSolrIndex(goodsId);
                    LOGGER.info((Object)"solr search \u4fee\u6539\u5355\u6761\u6587\u6863\u6210\u529f...");
                }
                result = 1;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public Map<String, Object> searchGoods(SearchPageBean<SolrGoodsInfo> pageBean, Long[] wareIds, String keyWords, String[] brands, String[] cats, String[] params, String sort, String priceMin, String priceMax, Long thirdId, String[] thirdCats, String showStock, String showMobile, String isThird, String inMarketing) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ArrayList<SolrGoodsInfo> goodsInfoList = new ArrayList<SolrGoodsInfo>();
        ArrayList<SolrThirdCate> thirdCateList = new ArrayList<SolrThirdCate>();
        ArrayList<JSONObject> aggResultList = new ArrayList<JSONObject>();
        try {
            int i;
            SolrQuery query = new SolrQuery();
            StringBuilder paramstr = new StringBuilder("");
            if (StringUtil.isNotEmpty((String)keyWords)) {
                paramstr.append("product_name:" + keyWords);
                LOGGER.info((Object)("solor product_name:" + keyWords));
            } else if (cats != null && StringUtil.isEmpty((String)keyWords)) {
                Long cid = Long.parseLong(cats[0]);
                paramstr.append("catId:" + cid);
                for (i = 1; i < cats.length; ++i) {
                    cid = Long.parseLong(cats[i]);
                    paramstr.append(" or catId:" + cid);
                }
            } else if (thirdCats != null && thirdCats.length > 0 && StringUtil.isEmpty((String)keyWords) && (cats == null || cats.length == 0)) {
                Long thirdcid = Long.parseLong(thirdCats[0]);
                paramstr.append("thirdCateId:" + thirdcid);
                for (i = 1; i < thirdCats.length; ++i) {
                    thirdcid = Long.parseLong(thirdCats[i]);
                    paramstr.append(" or thirdCateId:" + thirdcid);
                }
            } else {
                paramstr.append("*:*");
            }
            query.setQuery(paramstr.toString());
            if (thirdId != null) {
                query.add("fq", new String[]{"thirdId:" + thirdId});
            }
            if (priceMax != null && !"".equals(priceMax) || priceMin != null && !"".equals(priceMin)) {
                if (StringUtil.isEmpty((String)priceMax)) {
                    priceMax = "9999999999";
                }
                if (StringUtil.isEmpty((String)priceMin)) {
                    priceMin = "0";
                }
                query.add("fq", new String[]{"product_price:[" + priceMin + " TO " + priceMax + "]"});
            }
            if (brands != null) {
                for (String brand : brands) {
                    query.addFilterQuery(new String[]{"brandName:" + brand.replaceAll(":", "+")});
                }
            }
            if (params != null) {
                for (String param : params) {
                    query.addFilterQuery(new String[]{"paramValueList:" + param.replaceAll(":", "+")});
                }
            }
            if (StringUtils.isNotEmpty((String)isThird)) {
                query.add("fq", new String[]{"isThird:" + isThird});
            }
            if (StringUtils.isNotEmpty((String)inMarketing)) {
                query.add("fq", new String[]{"inMarketing:" + inMarketing});
            }
            query.add("fq", new String[]{"showList:1"});
            if (StringUtils.isNotEmpty((String)showMobile)) {
                query.add("fq", new String[]{"showMobile:1"});
            }
            query.add("fq", new String[]{"goodsInfoAdded:1"});
            if (sort != null && !"".equals(sort)) {
                switch (sort) {
                    case "11D": {
                        query.addOrUpdateSort(new SolrQuery.SortClause("product_price", SolrQuery.ORDER.asc));
                        break;
                    }
                    case "1D": {
                        query.addOrUpdateSort(new SolrQuery.SortClause("product_price", SolrQuery.ORDER.desc));
                        break;
                    }
                    case "2D": {
                        query.addSort("saleCount", SolrQuery.ORDER.desc);
                        break;
                    }
                    case "22D": {
                        query.addSort("saleCount", SolrQuery.ORDER.asc);
                        break;
                    }
                    case "33D": {
                        query.addSort(GOODSINFADDEDTETIME, SolrQuery.ORDER.asc);
                        break;
                    }
                    case "3D": {
                        query.addSort(GOODSINFADDEDTETIME, SolrQuery.ORDER.desc);
                        break;
                    }
                    case "44D": {
                        query.addSort("collectionCount", SolrQuery.ORDER.asc);
                        break;
                    }
                    case "4D": {
                        query.addSort("collectionCount", SolrQuery.ORDER.desc);
                        break;
                    }
                    default: {
                        query.addSort("product_price", SolrQuery.ORDER.asc);
                        break;
                    }
                }
            } else {
                query.addSort("product_price", SolrQuery.ORDER.asc);
            }
            pageBean.setPageNo(pageBean.getPageNo());
            pageBean.setPrePageNo(pageBean.getPrePageNo());
            pageBean.setFirstPageNo(pageBean.getFirstPageNo());
            pageBean.setLastPageNo(pageBean.getLastPageNo());
            pageBean.setNextPageNo(pageBean.getNextPageNo());
            pageBean.setTotalPages(pageBean.getTotalPages());
            pageBean.setRows(pageBean.getRows());
            query.setStart(Integer.valueOf(pageBean.getStartRowNum()));
            query.setRows(Integer.valueOf(20));
            query.setHighlight(true);
            query.addHighlightField("product_name");
            query.setHighlightSimplePre("<span style='color:red'>");
            query.setHighlightSimplePost("</span>");
            QueryResponse res = this.solrServer.query((SolrParams)query);
            SolrDocumentList docs = res.getResults();
            Long numFound = docs.getNumFound();
            Integer total = numFound.intValue();
            LOGGER.info((Object)("\u5339\u914d\u5230\u7684\u603b\u8bb0\u5f55\u6570:" + total));
            for (SolrDocument doc : docs) {
                JSONArray jsonArray;
                List lists;
                String hotFlag;
                SolrGoodsInfo solrGoodsInfo = new SolrGoodsInfo();
                String id = (String)doc.get((Object)"id");
                solrGoodsInfo.setGoodsInfoId(Long.parseLong(id));
                GoodsProduct goodsProduct = this.goodsProductMapper.selectHotGoodsById(Long.parseLong(id));
                if (goodsProduct == null || goodsProduct.getHotFlag() == null) {
                    solrGoodsInfo.setHotFlag("0");
                } else if (goodsProduct.getHotFlag().equals("1")) {
                    hotFlag = goodsProduct.getHotFlag();
                    solrGoodsInfo.setHotFlag(hotFlag);
                } else if (goodsProduct.getHotFlag().equals("0")) {
                    hotFlag = goodsProduct.getHotFlag();
                    solrGoodsInfo.setHotFlag(hotFlag);
                }
                String name = (String)doc.get((Object)"product_name");
                Map highlighting = res.getHighlighting();
                Map map1 = (Map)highlighting.get(id);
                if (map1.size() == 0) {
                    solrGoodsInfo.setGoodsInfoName(name);
                } else if (map1.size() > 0 && (lists = (List)map1.get("product_name")).get(0) != null) {
                    solrGoodsInfo.setGoodsInfoName((String)lists.get(0));
                }
                double goodsInfoPrice = (Double)doc.get((Object)"product_price");
                BigDecimal price = new BigDecimal(goodsInfoPrice);
                solrGoodsInfo.setGoodsInfoPreferPrice(price);
                String paramList = (String)doc.get((Object)PARAMLIST);
                JSONObject jsonOject = (JSONObject)JSON.parse((String)paramList);
                aggResultList.add(jsonOject);
                ArrayList<SolrGoodsImage> imgList = new ArrayList<SolrGoodsImage>();
                String urlJson = (String)doc.get((Object)"url");
                JSONArray list = jsonArray = JSON.parseArray((String)urlJson);
                SolrGoodsImage esGoodsImage = new SolrGoodsImage();
                if (list != null && list.size() > 0) {
                    JSONObject map = (JSONObject)list.get(0);
                    String imageBigName = (String)map.get((Object)"imageBigName");
                    String imageInName = (String)map.get((Object)"imageInName");
                    String imageThumName = (String)map.get((Object)"imageThumName");
                    String imageArtworkName = (String)map.get((Object)"imageArtworkName");
                    esGoodsImage.setImageBigName(imageBigName);
                    esGoodsImage.setImageInName(imageInName);
                    esGoodsImage.setImageThumName(imageThumName);
                    esGoodsImage.setImageArtworkName(imageArtworkName);
                }
                imgList.add(esGoodsImage);
                solrGoodsInfo.setImgList(imgList);
                SolrThirdCate solrThirdCate = new SolrThirdCate();
                String tcatName = (String)doc.get((Object)"tcatName");
                solrThirdCate.setCatName(tcatName);
                Long tcatId = (Long)doc.get((Object)"tcatId");
                solrThirdCate.setCatId(tcatId);
                Long tcatParentId = (Long)doc.get((Object)"tcatParentId");
                solrThirdCate.setCatParentId(tcatParentId);
                thirdCateList.add(solrThirdCate);
                solrGoodsInfo.setThirdCateList(thirdCateList);
                String inMarketings = (String)doc.get((Object)"inMarketing");
                solrGoodsInfo.setInMarketing(inMarketings);
                Long goodsInfoStock = (Long)doc.get((Object)"goodsInfoStock");
                solrGoodsInfo.setGoodsInfoStock(goodsInfoStock);
                List<SolrMarketing> marketings = this.goodsSolrMapper.selectMarketingByGoodsInfoId(solrGoodsInfo.getGoodsInfoId(), solrGoodsInfo.getBrandId(), solrGoodsInfo.getCatId());
                if (CollectionUtils.isNotEmpty(marketings)) {
                    solrGoodsInfo.setInMarketing("1");
                } else {
                    solrGoodsInfo.setInMarketing("0");
                }
                goodsInfoList.add(solrGoodsInfo);
                pageBean.setData(goodsInfoList);
                pageBean.setRows(total);
            }
            if (total > 0) {
                resultMap.put("dataNum", total);
            } else {
                resultMap.put("dataNum", 0);
            }
            resultMap.put("pb", pageBean);
            this.processAggResult(resultMap, aggResultList);
        }
        catch (SolrServerException e) {
            e.printStackTrace();
        }
        return resultMap;
    }

    private void processAggResult(Map<String, Object> resultMap, List<JSONObject> aggResultList) {
        if (null == aggResultList || aggResultList.size() <= 0) {
            return;
        }
        JSONObject jsonObject = null;
        ArrayList<ExpandParamVo> paramVoList = new ArrayList<ExpandParamVo>();
        ArrayList<BrandVo> brandVoList = new ArrayList<BrandVo>();
        HashMap<String, ExpandParamVo> oneGradeMap = new HashMap<String, ExpandParamVo>();
        HashMap<String, String> secondGradeMap = new HashMap<String, String>();
        HashMap<String, String> brandMap = new HashMap<String, String>();
        Object paramname = null;
        Object paramvalue = null;
        for (int i = 0; i < aggResultList.size(); ++i) {
            String key;
            Object brandObj;
            JSONObject brand;
            Object brandName;
            jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)aggResultList.get(i)));
            if (jsonObject.containsKey((Object)PARAMLIST)) {
                Object params = jsonObject.get((Object)PARAMLIST);
                JSONArray paramArray = null;
                paramArray = params instanceof JSONArray ? (JSONArray)params : new JSONArray(Arrays.asList(params));
                for (Object paramObj : paramArray) {
                    ExpandParamVo paramVo;
                    if (!(paramObj instanceof JSONObject)) continue;
                    JSONObject paramJson = (JSONObject)paramObj;
                    paramname = paramJson.get((Object)"expandparamName");
                    paramvalue = paramJson.get((Object)"expandparamValueName");
                    if (paramname == null || paramvalue == null) continue;
                    String oneGradeKey = paramname.toString();
                    String secondGradeKey = paramname.toString() + "_" + paramvalue.toString();
                    if (!oneGradeMap.containsKey(oneGradeKey)) {
                        paramVo = new ExpandParamVo(paramname.toString());
                        paramVo.addParamValue(new ParamValueVo(paramvalue.toString()));
                        oneGradeMap.put(oneGradeKey, paramVo);
                        secondGradeMap.put(secondGradeKey, "1");
                        continue;
                    }
                    if (secondGradeMap.containsKey(secondGradeKey)) continue;
                    secondGradeMap.put(secondGradeKey, "1");
                    paramVo = (ExpandParamVo)oneGradeMap.get(oneGradeKey);
                    paramVo.addParamValue(new ParamValueVo(paramvalue.toString()));
                    oneGradeMap.put(oneGradeKey, paramVo);
                }
            }
            if (!jsonObject.containsKey((Object)BRAND) || (brandName = (brand = (JSONObject)(brandObj = jsonObject.get((Object)BRAND))).get((Object)"brandName")) == null || brandMap.containsKey(key = "brand_" + brandName.toString())) continue;
            brandMap.put(key, "1");
            brandVoList.add(new BrandVo(brandName.toString()));
        }
        for (ExpandParamVo paramVo : oneGradeMap.values()) {
            this.sortParamValWithDoubleVal(paramVo);
            paramVoList.add(paramVo);
        }
        resultMap.put("params", paramVoList);
        resultMap.put("brands", brandVoList);
    }

    @Override
    public Map<String, Object> searchGoods(SearchPageBean<SolrGoodsInfo> pageBean, Long[] wareIds, String[] indices, String[] types, String keyWords, String[] brands, String[] cats, String[] params, String sort, String priceMin, String priceMax, Long thirdId, String[] thirdCats, String showStock, String showMobile, String isThird) {
        return this.searchGoods(pageBean, wareIds, keyWords, brands, cats, params, sort, priceMin, priceMax, thirdId, thirdCats, showStock, showMobile, isThird, null);
    }

    @Override
    public Map<String, Object> searchGoods(SearchPageBean<SolrGoodsInfo> pageBean, String[] indices, String[] types, CommonConditions conditions) {
        if (conditions == null) {
            return this.searchGoods(pageBean, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        }
        return this.searchGoods(pageBean, conditions.getWareIds(), conditions.getKeyWords(), conditions.getBrands(), conditions.getCats(), conditions.getParams(), conditions.getSort(), conditions.getPriceMin(), conditions.getPriceMax(), conditions.getThirdId(), conditions.getThirdCats(), conditions.getShowStock(), conditions.getShowMobile(), conditions.getIsThird(), conditions.getInMarketing());
    }

    @Override
    public int batchDeleteGoodsIndex(List<Long> list) {
        int result = 0;
        try {
            if (CollectionUtils.isNotEmpty(list)) {
                Long[] goodsIds = (Long[])list.toArray();
                this.deleteSolrIndex.batchDeleteSolrIndex(goodsIds);
                result = 1;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public int deleteGoodsIndex(Long goodsInfoId) {
        int result = 0;
        try {
            if (goodsInfoId != null) {
                this.deleteSolrSimpleIndex.deleteSolrIndex(goodsInfoId);
                result = 1;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private void sortParamValWithDoubleVal(ExpandParamVo expandParamVo) {
        Collections.sort(expandParamVo.getValueVoList(), new Comparator<ParamValueVo>(){

            @Override
            public int compare(ParamValueVo o1, ParamValueVo o2) {
                Pattern pattern = Pattern.compile("\\d+(\\.\\d+)?");
                Matcher matcher = pattern.matcher(o1.getValueName());
                double v11 = 0.0;
                if (matcher.find()) {
                    v11 = Double.valueOf(matcher.group());
                }
                double v12 = 0.0;
                if (matcher.find()) {
                    v12 = Double.valueOf(matcher.group());
                }
                Matcher matcher1 = pattern.matcher(o2.getValueName());
                double v21 = 0.0;
                if (matcher1.find()) {
                    v21 = Double.valueOf(matcher1.group());
                }
                double v22 = 0.0;
                if (matcher1.find()) {
                    v22 = Double.valueOf(matcher1.group());
                }
                return v11 > v21 ? 1 : (v11 == v21 ? (v12 > v22 ? 1 : (v12 == v22 ? 0 : -1)) : -1);
            }
        });
    }

    @Override
    public List<String> getCompletionSuggest(String keyWords) {
        return null;
    }

    @Override
    public int deleteGoodsByThirdId(String[] storeInfoIds) {
        return 1;
    }

    @Override
    public Map<String, Object> searchGoods(SearchPageBean<SolrGoodsInfo> pageBean, Long[] wareIds, String keyWords, String[] brands, String[] cats, String[] params, String sort, String priceMin, String priceMax, Long thirdId, String[] thirdCats, String showStock, String showMobile, String isThird, String inMarketing, Long caizhi, Long category, Long color) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ArrayList<SolrGoodsInfo> goodsInfoList = new ArrayList<SolrGoodsInfo>();
        ArrayList<SolrThirdCate> thirdCateList = new ArrayList<SolrThirdCate>();
        ArrayList<JSONObject> aggResultList = new ArrayList<JSONObject>();
        try {
            int i;
            SolrQuery query = new SolrQuery();
            StringBuilder paramstr = new StringBuilder("");
            if (StringUtil.isNotEmpty((String)keyWords)) {
                paramstr.append("product_name:" + keyWords);
                LOGGER.info((Object)("solor product_name:" + keyWords));
            } else if (cats != null && StringUtil.isEmpty((String)keyWords)) {
                Long cid = Long.parseLong(cats[0]);
                paramstr.append("catId:" + cid);
                for (i = 1; i < cats.length; ++i) {
                    cid = Long.parseLong(cats[i]);
                    paramstr.append(" or catId:" + cid);
                }
            } else if (thirdCats != null && thirdCats.length > 0 && StringUtil.isEmpty((String)keyWords) && (cats == null || cats.length == 0)) {
                Long thirdcid = Long.parseLong(thirdCats[0]);
                paramstr.append("thirdCateId:" + thirdcid);
                for (i = 1; i < thirdCats.length; ++i) {
                    thirdcid = Long.parseLong(thirdCats[i]);
                    paramstr.append(" or thirdCateId:" + thirdcid);
                }
            } else {
                paramstr.append("*:*");
            }
            query.setQuery(paramstr.toString());
            if (caizhi != null) {
                query.add("fq", new String[]{"specDetailId:*" + caizhi + "*"});
            }
            if (category != null) {
                query.add("fq", new String[]{"specDetailId:*" + category + "*"});
            }
            if (color != null) {
                query.add("fq", new String[]{"specDetailId:*" + color + "*"});
            }
            if (thirdId != null) {
                query.add("fq", new String[]{"thirdId:" + thirdId});
            }
            if (priceMax != null && !"".equals(priceMax) || priceMin != null && !"".equals(priceMin)) {
                if (StringUtil.isEmpty((String)priceMax)) {
                    priceMax = "9999999999";
                }
                if (StringUtil.isEmpty((String)priceMin)) {
                    priceMin = "0";
                }
                query.add("fq", new String[]{"product_price:[" + priceMin + " TO " + priceMax + "]"});
            }
            if (brands != null) {
                for (String brand : brands) {
                    query.addFilterQuery(new String[]{"brandName:" + brand.replaceAll(":", "+")});
                }
            }
            if (params != null) {
                for (String param : params) {
                    query.addFilterQuery(new String[]{"paramValueList:" + param.replaceAll(":", "+")});
                }
            }
            if (StringUtils.isNotEmpty((String)isThird)) {
                query.add("fq", new String[]{"isThird:" + isThird});
            }
            if (StringUtils.isNotEmpty((String)inMarketing)) {
                query.add("fq", new String[]{"inMarketing:" + inMarketing});
            }
            query.add("fq", new String[]{"showList:1"});
            if (StringUtils.isNotEmpty((String)showMobile)) {
                query.add("fq", new String[]{"showMobile:1"});
            }
            query.add("fq", new String[]{"goodsInfoAdded:1"});
            if (sort != null && !"".equals(sort)) {
                switch (sort) {
                    case "11D": {
                        query.addOrUpdateSort(new SolrQuery.SortClause("product_price", SolrQuery.ORDER.asc));
                        break;
                    }
                    case "1D": {
                        query.addOrUpdateSort(new SolrQuery.SortClause("product_price", SolrQuery.ORDER.desc));
                        break;
                    }
                    case "2D": {
                        query.addSort("saleCount", SolrQuery.ORDER.desc);
                        break;
                    }
                    case "22D": {
                        query.addSort("saleCount", SolrQuery.ORDER.asc);
                        break;
                    }
                    case "33D": {
                        query.addSort(GOODSINFADDEDTETIME, SolrQuery.ORDER.asc);
                        break;
                    }
                    case "3D": {
                        query.addSort(GOODSINFADDEDTETIME, SolrQuery.ORDER.desc);
                        break;
                    }
                    case "44D": {
                        query.addSort("collectionCount", SolrQuery.ORDER.asc);
                        break;
                    }
                    case "4D": {
                        query.addSort("collectionCount", SolrQuery.ORDER.desc);
                        break;
                    }
                    default: {
                        query.addSort("product_price", SolrQuery.ORDER.asc);
                        break;
                    }
                }
            } else {
                query.addSort("product_price", SolrQuery.ORDER.asc);
            }
            pageBean.setPageNo(pageBean.getPageNo());
            pageBean.setPrePageNo(pageBean.getPrePageNo());
            pageBean.setFirstPageNo(pageBean.getFirstPageNo());
            pageBean.setLastPageNo(pageBean.getLastPageNo());
            pageBean.setNextPageNo(pageBean.getNextPageNo());
            pageBean.setTotalPages(pageBean.getTotalPages());
            pageBean.setRows(pageBean.getRows());
            query.setStart(Integer.valueOf(pageBean.getStartRowNum()));
            query.setRows(Integer.valueOf(20));
            query.setHighlight(true);
            query.addHighlightField("product_name");
            query.setHighlightSimplePre("<span style='color:red'>");
            query.setHighlightSimplePost("</span>");
            QueryResponse res = this.solrServer.query((SolrParams)query);
            SolrDocumentList docs = res.getResults();
            Long numFound = docs.getNumFound();
            Integer total = numFound.intValue();
            LOGGER.info((Object)("\u5339\u914d\u5230\u7684\u603b\u8bb0\u5f55\u6570:" + total));
            for (SolrDocument doc : docs) {
                JSONArray jsonArray;
                List lists;
                SolrGoodsInfo solrGoodsInfo = new SolrGoodsInfo();
                String id = (String)doc.get((Object)"id");
                solrGoodsInfo.setGoodsInfoId(Long.parseLong(id));
                String name = (String)doc.get((Object)"product_name");
                Map highlighting = res.getHighlighting();
                Map map1 = (Map)highlighting.get(id);
                if (map1.size() == 0) {
                    solrGoodsInfo.setGoodsInfoName(name);
                } else if (map1.size() > 0 && (lists = (List)map1.get("product_name")).get(0) != null) {
                    solrGoodsInfo.setGoodsInfoName((String)lists.get(0));
                }
                double goodsInfoPrice = (Double)doc.get((Object)"product_price");
                BigDecimal price = new BigDecimal(goodsInfoPrice);
                solrGoodsInfo.setGoodsInfoPreferPrice(price);
                String paramList = (String)doc.get((Object)PARAMLIST);
                JSONObject jsonOject = (JSONObject)JSON.parse((String)paramList);
                aggResultList.add(jsonOject);
                ArrayList<SolrGoodsImage> imgList = new ArrayList<SolrGoodsImage>();
                String urlJson = (String)doc.get((Object)"url");
                JSONArray list = jsonArray = JSON.parseArray((String)urlJson);
                SolrGoodsImage esGoodsImage = new SolrGoodsImage();
                if (list != null && list.size() > 0) {
                    JSONObject map = (JSONObject)list.get(0);
                    String imageBigName = (String)map.get((Object)"imageBigName");
                    String imageInName = (String)map.get((Object)"imageInName");
                    String imageThumName = (String)map.get((Object)"imageThumName");
                    String imageArtworkName = (String)map.get((Object)"imageArtworkName");
                    esGoodsImage.setImageBigName(imageBigName);
                    esGoodsImage.setImageInName(imageInName);
                    esGoodsImage.setImageThumName(imageThumName);
                    esGoodsImage.setImageArtworkName(imageArtworkName);
                }
                imgList.add(esGoodsImage);
                solrGoodsInfo.setImgList(imgList);
                SolrThirdCate solrThirdCate = new SolrThirdCate();
                String tcatName = (String)doc.get((Object)"tcatName");
                solrThirdCate.setCatName(tcatName);
                Long tcatId = (Long)doc.get((Object)"tcatId");
                solrThirdCate.setCatId(tcatId);
                Long tcatParentId = (Long)doc.get((Object)"tcatParentId");
                solrThirdCate.setCatParentId(tcatParentId);
                thirdCateList.add(solrThirdCate);
                solrGoodsInfo.setThirdCateList(thirdCateList);
                String inMarketings = (String)doc.get((Object)"inMarketing");
                solrGoodsInfo.setInMarketing(inMarketings);
                Long goodsInfoStock = (Long)doc.get((Object)"goodsInfoStock");
                solrGoodsInfo.setGoodsInfoStock(goodsInfoStock);
                goodsInfoList.add(solrGoodsInfo);
                pageBean.setData(goodsInfoList);
                pageBean.setRows(total);
            }
            if (total > 0) {
                resultMap.put("dataNum", total);
            } else {
                resultMap.put("dataNum", 0);
            }
            resultMap.put("pb", pageBean);
            this.processAggResult(resultMap, aggResultList);
        }
        catch (SolrServerException e) {
            e.printStackTrace();
        }
        return resultMap;
    }
}

