/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.goods.service.impl;

import com.qianjiang.customer.dao.CustomerMapper;
import com.qianjiang.goods.bean.FollowAndCityVo;
import com.qianjiang.goods.bean.WareCity;
import com.qianjiang.goods.bean.WareHouse;
import com.qianjiang.goods.dao.ProductWareMapper;
import com.qianjiang.goods.dao.WareCityMapper;
import com.qianjiang.goods.dao.WareHouseMapper;
import com.qianjiang.goods.service.WareHouseService;
import com.qianjiang.goods.vo.WareHouseVo;
import com.qianjiang.other.bean.CityBean;
import com.qianjiang.other.bean.DistrictBean;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import com.qianjiang.util.SelectBean;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.ArrayUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="WareHouseService")
public class WareHouseServiceImpl
implements WareHouseService {
    private static final MyLogger LOGGER = new MyLogger(WareHouseServiceImpl.class);
    private static final String WARE_ID = "wareId";
    private WareHouseMapper houseMapper;
    private WareCityMapper cityMapper;
    @Resource(name="ProductWareMapper")
    private ProductWareMapper productWareMapper;
    @Resource(name="customerMapper")
    private CustomerMapper customerMapper;

    @Override
    public List<WareHouse> findWares() {
        return this.houseMapper.findWares();
    }

    @Override
    public List<FollowAndCityVo> selectFollow(Long wereId, BigDecimal productPrices, Long goodsId) {
        return this.cityMapper.selectFollow(wereId, productPrices, goodsId);
    }

    @Override
    public List<WareCity> selectByWareId(Long wareId) {
        return this.cityMapper.queryAllByWareId(wareId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public int deleteWareById(Long wareId, String adminName) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put(WARE_ID, wareId);
            map.put("adminName", adminName);
            this.cityMapper.deleteCityByWareId(wareId);
            this.productWareMapper.deleteWareCity(wareId);
            int n = this.houseMapper.deleteByPrimaryKey(map);
            return n;
        }
        finally {
            map = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public Long saveWareHouse(WareHouse wareHouse, String adminName, Long[] distinctIds) {
        wareHouse.setExecName(adminName);
        Long wareId = this.houseMapper.insertSelective(wareHouse);
        WareCity wareCity = null;
        try {
            if (null != distinctIds && distinctIds.length > 0) {
                for (int i = 0; i < distinctIds.length; ++i) {
                    wareCity = new WareCity();
                    wareCity.setWareId(wareId);
                    wareCity.setCityId(distinctIds[i]);
                    wareCity.setDelFlag("0");
                    this.cityMapper.insertSelective(wareCity);
                }
            }
            Long l = wareId;
            return l;
        }
        finally {
            LOGGER.info((Object)("\u4fdd\u5b58\u4ed3\u5e93\u4fe1\u606fSUCC" + adminName));
            wareId = null;
            wareCity = null;
        }
    }

    @Override
    public WareHouseVo selectWareByWareId(Long wareId) {
        return this.houseMapper.selectByPrimaryKey(wareId);
    }

    @Override
    @Transactional
    public int updateWareHouse(WareHouse wareHouse, String adminName, Long[] districtIds) {
        wareHouse.setExecName(adminName);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("distinctIds", districtIds);
        map.put(WARE_ID, wareHouse.getWareId());
        this.cityMapper.delNotInChecked(map);
        WareCity city = null;
        if (null != districtIds && districtIds.length > 0) {
            for (int i = 0; i < districtIds.length; ++i) {
                map.clear();
                map.put(WARE_ID, wareHouse.getWareId());
                map.put("distinctId", districtIds[i]);
                if (this.cityMapper.queryByWareIdAndDistinctId(map) > 0) continue;
                city = new WareCity();
                city.setWareId(wareHouse.getWareId());
                city.setCityId(districtIds[i]);
                this.cityMapper.insertSelective(city);
            }
        }
        LOGGER.info((Object)("\u66f4\u65b0\u4ed3\u5e93\u4fe1\u606fSUCC" + adminName));
        return this.houseMapper.updateByPrimaryKeySelective(wareHouse);
    }

    @Override
    public List<WareHouse> queryAllWareHouse() {
        return this.houseMapper.queryAllWareHouse();
    }

    @Override
    public int queryCountByParams() {
        return this.houseMapper.queryCountByParams(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageBean queryAllWareHouseByPageBean(PageBean pb, SelectBean selectBean) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put("condition", selectBean.getCondition());
            map.put("searchText", selectBean.getSearchText());
            pb.setRows(this.houseMapper.queryCountByParams(map));
            map.put("startRowNum", pb.getStartRowNum());
            map.put("endRowNum", pb.getEndRowNum());
            pb.setList(this.houseMapper.queryAllWareHouseByPageBean(map));
            PageBean pageBean = pb;
            return pageBean;
        }
        finally {
            map = null;
        }
    }

    @Override
    public boolean checkWareName(String wareName) {
        List<WareHouse> wh = this.houseMapper.queryWareCountByWareName(wareName);
        return wh == null || wh.isEmpty();
    }

    @Override
    public List<DistrictBean> getAllWareHouseDistrict() {
        List c = this.customerMapper.selectAllDistrict();
        List<WareCity> wc = this.houseMapper.getAllWareHouseDistrict();
        for (int i = 0; i < c.size(); ++i) {
            if (wc == null || wc.isEmpty()) continue;
            for (int j = 0; j < wc.size(); ++j) {
                if (!((DistrictBean)c.get(i)).getDistrictId().equals(wc.get(j).getCityId())) continue;
                ((DistrictBean)c.get(i)).setChkDisabled(true);
            }
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public int batchDelWare(Long[] wareIds, String adminName) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put("wareIds", wareIds);
            map.put("adminName", adminName);
            int n = this.houseMapper.batchDelWare(map);
            return n;
        }
        finally {
            LOGGER.info((Object)("\u6279\u91cf\u5220\u9664\u4ed3\u5e93\u4fe1\u606fSUCC" + adminName));
            map = null;
        }
    }

    @Override
    public List<DistrictBean> selectCityIdByWareId(Long wareId) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put(WARE_ID, wareId);
        return this.customerMapper.selectAllDistrict();
    }

    @Override
    public List<CityBean> selectCityIdByDid(Long wareId) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put(WARE_ID, wareId);
        return this.customerMapper.selectAllCity();
    }

    @Override
    public int identifyIsExist(String identifyId) {
        return this.houseMapper.identifyIsExist(identifyId);
    }

    @Override
    public boolean checkWareNameHaveId(String wareName, Long wareId) {
        List<WareHouse> s = this.houseMapper.queryWareCountByWareName(wareName);
        if (s != null && !s.isEmpty()) {
            if (s.size() == 1) {
                return s.get(0).getWareId().equals(wareId);
            }
            return false;
        }
        return true;
    }

    public WareHouseMapper getHouseMapper() {
        return this.houseMapper;
    }

    @Resource(name="WareHouseMapper")
    public void setHouseMapper(WareHouseMapper houseMapper) {
        this.houseMapper = houseMapper;
    }

    public WareCityMapper getCityMapper() {
        return this.cityMapper;
    }

    @Resource(name="WareCityMapper")
    public void setCityMapper(WareCityMapper cityMapper) {
        this.cityMapper = cityMapper;
    }

    @Override
    public Long selectWareIdByDistinctId(Long distinctId) {
        return this.houseMapper.selectWareIdByDistinctId(distinctId);
    }

    @Override
    public int isWareCanDelete(Long[] wareId) {
        if (ArrayUtils.isEmpty((Object[])wareId)) {
            return 0;
        }
        for (Long id : wareId) {
            if (null == id || this.isWareCanDelete(id)) continue;
            return 1;
        }
        return 0;
    }

    private boolean isWareCanDelete(Long wareId) {
        return this.houseMapper.selectWareProductNum(wareId) == 0L;
    }
}

