/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.goods.service.impl;

import com.qianjiang.goods.bean.GoodsTypeParam;
import com.qianjiang.goods.dao.CascDelMapper;
import com.qianjiang.goods.dao.GoodsTypeParamMapper;
import com.qianjiang.goods.service.GoodsTypeParamService;
import com.qianjiang.util.MyLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="GoodsTypeParamService")
public class GoodsTypeParamServiceImpl
implements GoodsTypeParamService {
    private GoodsTypeParamMapper goodsTypeParamMapper;
    private CascDelMapper cascDelMapper;
    private static final MyLogger LOGGER = new MyLogger(GoodsTypeParamServiceImpl.class);

    public CascDelMapper getCascDelMapper() {
        return this.cascDelMapper;
    }

    @Resource(name="CascDelMapper")
    public void setCascDelMapper(CascDelMapper cascDelMapper) {
        this.cascDelMapper = cascDelMapper;
    }

    public GoodsTypeParamMapper getGoodsTypeParamMapper() {
        return this.goodsTypeParamMapper;
    }

    @Resource(name="GoodsTypeParamMapper")
    public void setGoodsTypeParamMapper(GoodsTypeParamMapper goodsTypeParamMapper) {
        this.goodsTypeParamMapper = goodsTypeParamMapper;
    }

    @Override
    @Transactional
    public int saveTypeParam(GoodsTypeParam goodsTypeParam, String username) {
        goodsTypeParam.setParamCreateName(username);
        LOGGER.info((Object)("\u4fdd\u5b58\u7c7b\u578b\u53c2\u6570SUCC" + username));
        return this.goodsTypeParamMapper.insertSelective(goodsTypeParam);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public int delTypeParam(Long paramId, String username) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            map.put("delName", username);
            map.put("paramId", paramId.toString());
            int n = this.goodsTypeParamMapper.deleteByPrimaryKey(map);
            return n;
        }
        finally {
            LOGGER.info((Object)("\u5220\u9664\u7c7b\u578b\u53c2\u6570SUCC" + username));
            this.cascDelMapper.cascDel(username);
            map = null;
        }
    }

    @Override
    @Transactional
    public int update(GoodsTypeParam goodsTypeParam, String username) {
        goodsTypeParam.setParamModifiedName(username);
        LOGGER.info((Object)("\u66f4\u65b0\u7c7b\u578b\u53c2\u6570SUCC" + username));
        return this.goodsTypeParamMapper.updateByPrimaryKeySelective(goodsTypeParam);
    }

    @Override
    public GoodsTypeParam queryByPrimaryKey(Long paramId) {
        return this.goodsTypeParamMapper.selectByPrimaryKey(paramId);
    }

    @Override
    public List<GoodsTypeParam> queryParamListByTypeId(Long typeId) {
        return this.goodsTypeParamMapper.queryTypeParamByTypeId(typeId);
    }

    @Override
    @Transactional
    public int batchUpateParam(Long typeId, String username, String[] typeParamId, String[] paramDelflag, String[] paramname, String[] paramnickname) {
        int i;
        ArrayList<GoodsTypeParam> paramList = new ArrayList<GoodsTypeParam>();
        GoodsTypeParam param = null;
        if (null != typeParamId) {
            for (i = 0; i < typeParamId.length; ++i) {
                param = new GoodsTypeParam();
                param.setParamId(Long.parseLong(typeParamId[i]));
                param.setParamDelflag(paramDelflag[i]);
                param.setParamName(paramname[i]);
                param.setParamNickname(paramnickname[i]);
                paramList.add(param);
            }
        }
        for (i = 0; i < paramList.size(); ++i) {
            param = (GoodsTypeParam)paramList.get(i);
            if (-1L == param.getParamId()) {
                param.setParamId(null);
                param.setParamDelflag("0");
                param.setTypeId(typeId);
                this.saveTypeParam(param, username);
                continue;
            }
            if ("1".equals(param.getParamDelflag())) {
                this.delTypeParam(param.getParamId(), username);
                continue;
            }
            this.update(param, username);
        }
        LOGGER.info((Object)("\u6279\u91cf\u5220\u9664\u7c7b\u578b\u53c2\u6570SUCC" + username));
        return 0;
    }
}

