/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.goods.service.impl;

import com.qianjiang.customer.dao.CustomerMapper;
import com.qianjiang.customer.vo.CustomerAllInfo;
import com.qianjiang.goods.bean.GoodsProduct;
import com.qianjiang.goods.bean.ProductCard;
import com.qianjiang.goods.dao.ProductCardMapper;
import com.qianjiang.goods.service.GoodsProductService;
import com.qianjiang.goods.service.ProductCardService;
import com.qianjiang.goods.util.HttpRequestUtils;
import com.qianjiang.goods.util.StringRandom;
import com.qianjiang.system.bean.SMSConf;
import com.qianjiang.system.bean.SMSModel;
import com.qianjiang.system.dao.SMSConfMapper;
import com.qianjiang.system.dao.SMSModelMapper;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.sms.SmsUtil;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="ProductCardService")
public class ProductCardServiceImpl
implements ProductCardService {
    private static final MyLogger LOGGER = new MyLogger(ProductCardServiceImpl.class);
    @Autowired
    private ProductCardMapper productCardMapper;
    @Autowired
    private SMSConfMapper smsConfMapper;
    @Autowired
    private SMSModelMapper smsModelMapper;
    @Autowired
    private GoodsProductService goodsProductService;
    @Autowired
    private CustomerMapper customerMapper;

    @Override
    @Transactional
    public int insertListCard(GoodsProduct product) {
        int insertNum = 0;
        Long cardNum = product.getGoodsInfoStock();
        if (cardNum != null && cardNum > 0L) {
            int presentInsertNum;
            ArrayList<ProductCard> cardList = new ArrayList<ProductCard>();
            int i = 0;
            while ((long)i < cardNum) {
                ProductCard card = new ProductCard();
                card.setGoodsInfoId(product.getGoodsInfoId());
                card.setCardIsBuy("0");
                card.setCardIsUse("0");
                card.setCardNo(StringRandom.getOrderIdByUUId());
                card.setCardPwd(StringRandom.getStringRandom(8));
                cardList.add(card);
                ++i;
            }
            insertNum = presentInsertNum = this.productCardMapper.insertListCard(cardList);
            LOGGER.info((Object)("\u8d27\u54c1id" + product.getGoodsInfoId() + "\u751f\u6210\u793c\u54c1\u5361\u4fe1\u606f\u6570\u91cf" + insertNum));
            return insertNum;
        }
        LOGGER.error("\u8d27\u54c1id" + product.getGoodsInfoId() + "\u83b7\u53d6\u5e93\u5b58\u5931\u8d25,\u751f\u6210\u793c\u54c1\u5361\u5931\u8d25");
        return insertNum;
    }

    @Override
    public int updateCardInfo(Map<String, Object> cardInfo) {
        return this.productCardMapper.updateCardInfo(cardInfo);
    }

    @Override
    public List<ProductCard> findBuyCardByOrderId(Map<String, Object> cardInfo) {
        return this.productCardMapper.findBuyCardByOrderId(cardInfo);
    }

    @Override
    public int sendCardInfoMessage(Map<String, Object> cardMessage) {
        String smsModelType = "21";
        SMSConf smsConf = this.smsConfMapper.querySmsConf();
        if (smsConf == null || smsConf != null && "0".equals(smsConf.getSmsIsOpen())) {
            return 0;
        }
        com.alibaba.fastjson.JSONObject modelParam = new com.alibaba.fastjson.JSONObject();
        modelParam.put("money", cardMessage.get("money"));
        modelParam.put("cartId", cardMessage.get("cartId"));
        modelParam.put("cartPass", cardMessage.get("cartPass"));
        String mobile = String.valueOf(cardMessage.get("mobile"));
        String smsAppKey = smsConf.getSmsAppKey();
        String smsSerect = smsConf.getSmsSerect();
        String smsSign = smsConf.getSmsSign();
        SMSModel smsModel = this.smsModelMapper.querySmsModelByModelType(smsModelType);
        String smsModelId = smsModel.getSmsModelId();
        String smsVersion = smsConf.getSmsVersion();
        boolean isSuccess = false;
        if ("0".equals(smsVersion)) {
            isSuccess = SmsUtil.sendMsgCode((String)smsAppKey, (String)smsSerect, (String)smsSign, (String)smsModelId, (com.alibaba.fastjson.JSONObject)modelParam, (String)smsModelType, (String)mobile);
        } else if ("1".equals(smsVersion)) {
            isSuccess = SmsUtil.sendSms((String)smsAppKey, (String)smsSerect, (String)smsSign, (String)smsModelId, (com.alibaba.fastjson.JSONObject)modelParam, (String)smsModelType, (String)mobile);
        }
        if (isSuccess) {
            return 1;
        }
        return 0;
    }

    @Override
    public int rechargePriceByCard(Map<String, Object> cardInfo) {
        String customerId = String.valueOf(cardInfo.get("customerId"));
        String cardNo = String.valueOf(cardInfo.get("cardNo"));
        String cardPwd = String.valueOf(cardInfo.get("cardPwd"));
        if (customerId == null || "".equals(customerId) || cardNo == null || "".equals(cardNo) || cardPwd == null || "".equals(cardPwd)) {
            return 0;
        }
        ProductCard card = this.productCardMapper.getCardByCardNo(cardNo);
        if (card == null) {
            return -1;
        }
        String card_cardPwd = String.valueOf(card.getCardPwd());
        if (card_cardPwd.equals(cardPwd)) {
            HashMap<String, Object> upCard_map = new HashMap<String, Object>();
            upCard_map.put("cardId", card.getCardId());
            upCard_map.put("cardIsUse", "1");
            upCard_map.put("cardUseTime", "1");
            upCard_map.put("cardUseCustomerId", customerId);
            GoodsProduct goodsProduct = this.goodsProductService.findGoodsProductByGoodsIfoId(card.getGoodsInfoId());
            BigDecimal cardPrice = goodsProduct.getGoodsInfoPreferPrice();
            CustomerAllInfo customerAllInfo = this.customerMapper.selectByPrimaryKey(Long.valueOf(Long.parseLong(customerId)));
            System.out.println("\u4f1a\u5458\u4f7f\u7528\u793c\u54c1\u5361\u5145\u503c\u540e\u8c03\u7528\u5411\u5bfc\u63a5\u53e3\u300b\u5145\u503c\u5f00\u59cb\u5f00\u59cb");
            Object goodsProductAll = null;
            String currentRegister = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
            String curr = String.valueOf(System.currentTimeMillis() / 1000L);
            String s = new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date());
            String results = "";
            String apisign = "erp_prod_key75dec1805b03407186543937ea09c3bf" + s + "";
            byte[] b = null;
            try {
                MessageDigest md5 = MessageDigest.getInstance("MD5");
                try {
                    md5.update(apisign.getBytes("UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                b = md5.digest();
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            StringBuffer buf = new StringBuffer("");
            for (int offset = 0; offset < b.length; ++offset) {
                int i = b[offset];
                if (i < 0) {
                    i += 256;
                }
                if (i < 16) {
                    buf.append("0");
                }
                buf.append(Integer.toHexString(i));
            }
            results = buf.toString();
            System.out.println("result = " + results);
            String cards = "{\"apikey\":\"erp_prod_key\",\"apisign\":\"" + results + "\",\"timestamp\":\"" + s + "\",\"vip_no\":\"" + customerAllInfo.getInfoMobile() + "\",\"bill_date\":\"" + currentRegister + "" + "\",\"prepay_amt\":\"" + cardPrice + "\",\"free_amt\":\"0.00\",\"cash_amt\":\"0.00\",\"remark\":\"\u901a\u8fc7\u793c\u54c1\u5361\u5145\u503c" + cardPrice + "\u5143\"}";
            JSONObject resultJsons = HttpRequestUtils.httpPost("http://fsjk.4008713538.cn/Handler/Util/VipPrepayChange.ashx", JSONObject.fromObject((Object)cards));
            if ("0".equals(resultJsons.getString("code")) && null != resultJsons.getString("code")) {
                LOGGER.info((Object)("\u4f1a\u5458id" + customerId + "\u4f7f\u7528\u793c\u54c1\u5361\u5145\u503c\u6210\u529f,\u91d1\u989d:" + cardPrice));
                int updateCardResult = this.productCardMapper.updateCardByCardNoAndPwd(upCard_map);
                if (updateCardResult > 0) {
                    LOGGER.info((Object)("\u8d27\u793c\u54c1\u5361id" + card.getCardId() + "\u4f7f\u7528\u793c\u54c1\u5361\u6210\u529f"));
                    HashMap<String, Object> upCustomerPrice_map = new HashMap<String, Object>();
                    upCustomerPrice_map.put("customerId", customerId);
                    upCustomerPrice_map.put("userTotalPrice", cardPrice);
                    int updateCustomerResult = this.customerMapper.updateCustomerTotalPrice(upCustomerPrice_map);
                    if (updateCustomerResult > 0) {
                        return 1;
                    }
                    LOGGER.error("\u4f1a\u5458id" + customerId + "\u4f7f\u7528\u793c\u54c1\u5361\u5145\u503c\u5931\u8d25,\u91d1\u989d:" + cardPrice);
                    return -3;
                }
                LOGGER.error("\u8d27\u793c\u54c1\u5361id" + card.getCardId() + "\u4f7f\u7528\u793c\u54c1\u5361\u5931\u8d25");
                return -1;
            }
            return -4;
        }
        return -2;
    }
}

