/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.goods.util;

import com.qianjiang.goods.bean.SolrGoodsCategory;
import com.qianjiang.goods.bean.SolrGoodsInfo;
import com.qianjiang.goods.bean.SolrMarketing;
import com.qianjiang.goods.bean.SolrThirdCate;
import com.qianjiang.goods.dao.GoodsSolrMapper;
import com.qianjiang.goods.service.impl.GoodsServiceImpl;
import com.qianjiang.goods.util.CreateSolrSimpleIndex;
import com.qianjiang.goods.vo.ThirdStoreInfo;
import com.qianjiang.util.MyLogger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class CreateSolrIndex {
    private static final MyLogger LOGGER = new MyLogger(GoodsServiceImpl.class);
    @Resource(name="GoodsSolrMapper")
    private GoodsSolrMapper goodsSolrMapper;
    @Resource(name="httpSolrServer")
    private HttpSolrServer solrServer;
    @Resource
    private CreateSolrSimpleIndex createSolrSimpleIndex;

    public void batchCrateSolrIndex(Long[] goodsIds) {
        for (Long goodsId : goodsIds) {
            try {
                LOGGER.info((Object)("Solr search \u8c03\u7528\u63a5\u53e3\u521b\u5efa\u7d22\u5f15..." + goodsIds));
                this.createSolrSimpleIndex.simpleCrateSolrIndex(goodsId);
                LOGGER.info((Object)"Solr search \u521b\u5efa\u7d22\u5f15\u6210\u529f...");
            }
            catch (Exception e) {
                LOGGER.error("\u521b\u5efa\u7d22\u5f15\u5931\u8d25...", (Throwable)e);
            }
        }
    }

    public List<SolrGoodsCategory> cateUtil(Long catId) {
        if (catId != null) {
            ArrayList<SolrGoodsCategory> list = new ArrayList<SolrGoodsCategory>();
            SolrGoodsCategory es = this.goodsSolrMapper.selectGoodsCateList(catId);
            if (es != null && es.getCatParentId() != null && es.getCatParentId() != 0L) {
                SolrGoodsCategory es2;
                SolrGoodsCategory es1 = this.goodsSolrMapper.selectGoodsCateList(es.getCatParentId());
                if (es1 != null && es1.getCatParentId() != null && es1.getCatParentId() != 0L && (es2 = this.goodsSolrMapper.selectGoodsCateList(es1.getCatParentId())) != null && es1.getCatParentId() != null) {
                    list.add(es2);
                }
                list.add(es1);
            }
            list.add(es);
            return list;
        }
        return new ArrayList<SolrGoodsCategory>();
    }

    public List<SolrThirdCate> thirdCateUtil(Long catId) {
        if (catId != null) {
            ArrayList<SolrThirdCate> list = new ArrayList<SolrThirdCate>();
            SolrThirdCate es = this.goodsSolrMapper.selectGoodsThirdCateList(catId);
            if (es != null && es.getCatParentId() != null && es.getCatParentId() != 0L) {
                SolrThirdCate es2;
                SolrThirdCate es1 = this.goodsSolrMapper.selectGoodsThirdCateList(es.getCatParentId());
                if (es1 != null && es1.getCatParentId() != null && es1.getCatParentId() != 0L && (es2 = this.goodsSolrMapper.selectGoodsThirdCateList(es1.getCatParentId())) != null && es1.getCatParentId() != null) {
                    list.add(es2);
                }
                list.add(es1);
            }
            list.add(es);
            return list;
        }
        return new ArrayList<SolrThirdCate>();
    }

    private String isInMarketing(SolrGoodsInfo goodsInfo) {
        List<SolrMarketing> marketings = this.goodsSolrMapper.selectMarketingByGoodsInfoId(goodsInfo.getGoodsInfoId(), goodsInfo.getBrandId(), goodsInfo.getCatId());
        return CollectionUtils.isEmpty(marketings) ? "0" : "1";
    }

    private Date isExpiryTime(SolrGoodsInfo goodsInfo) throws ParseException {
        Long storeid = goodsInfo.getThirdId();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = sdf.parse("2099-12-31 00:00:00");
        if (storeid != null) {
            if (storeid.equals(0L)) {
                return date;
            }
            ThirdStoreInfo stireInFo = this.goodsSolrMapper.selectThirdStoreInfo(storeid);
            if (stireInFo.getExpiryTime() != null) {
                return stireInFo.getExpiryTime();
            }
            return date;
        }
        return date;
    }
}

