/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.site.thirdseller.service.impl;

import com.qianjiang.site.thirdseller.dao.ThirdCateMapper;
import com.qianjiang.site.thirdseller.service.ThirdCateService;
import com.qianjiang.site.thirdseller.vo.ThirdCateVo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="ThirdCateService")
public class ThirdCateServiceImpl
implements ThirdCateService {
    private static final String THIRDID = "thirdId";
    private static final String CATID = "catId";
    @Autowired
    private ThirdCateMapper thirdCateMapper;

    @Override
    public Long selectByCustomerId(Long customerId) {
        return this.thirdCateMapper.selectByCustomerId(customerId);
    }

    @Override
    public List<ThirdCateVo> getAllCalcThirdCate(Long thirdId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(THIRDID, thirdId);
        ArrayList<ThirdCateVo> cateVoList = new ArrayList<ThirdCateVo>();
        List<ThirdCateVo> parentList = this.thirdCateMapper.queryAllThirdCate(map);
        List<ThirdCateVo> allCateList = this.thirdCateMapper.queryAllCateForList(thirdId);
        if (null != parentList && !parentList.isEmpty()) {
            for (int i = 0; i < parentList.size(); ++i) {
                ThirdCateVo cate = parentList.get(i);
                ThirdCateVo cateVo = new ThirdCateVo();
                cateVo.setCatGrade(cate.getCatGrade());
                cateVo.setCatId(cate.getCatId());
                cateVo.setCatImg(cate.getCatImg());
                cateVo.setCatName(cate.getCatName());
                cateVo.setCatParentId(cate.getCatParentId());
                cateVo.setCatSort(cate.getCatSort());
                cateVo.setThirdId(cate.getThirdId());
                cateVo.setThirdName(cate.getThirdName());
                cateVo.setCatCreateTime(cate.getCatCreateTime());
                cateVo.setCateVos(this.calcCateVo(cateVo.getCatId(), allCateList));
                cateVoList.add(cateVo);
            }
        }
        return cateVoList;
    }

    @Override
    public String findStoreFlag(Long thirdId) {
        return this.thirdCateMapper.findStoreFlag(thirdId);
    }

    @Override
    public List<ThirdCateVo> calcCateVo(Long parentId, List<ThirdCateVo> allCateList) {
        ArrayList<ThirdCateVo> cateVoList = new ArrayList<ThirdCateVo>();
        for (int i = 0; i < allCateList.size(); ++i) {
            if (!parentId.equals(allCateList.get(i).getCatParentId())) continue;
            ThirdCateVo cate = allCateList.get(i);
            ThirdCateVo cateVo = new ThirdCateVo();
            cateVo.setCatGrade(cate.getCatGrade());
            cateVo.setCatId(cate.getCatId());
            cateVo.setCatImg(cate.getCatImg());
            cateVo.setCatName(cate.getCatName());
            cateVo.setCatParentId(cate.getCatParentId());
            cateVo.setCatSort(cate.getCatSort());
            cateVo.setThirdId(cate.getThirdId());
            cateVo.setThirdName(cate.getThirdName());
            cateVo.setCatCreateTime(cate.getCatCreateTime());
            cateVo.setCateVos(this.calcCateVo(cateVo.getCatId(), allCateList));
            cateVoList.add(cateVo);
        }
        return cateVoList;
    }

    @Override
    public List<ThirdCateVo> calcCateVo(Long thirdId, Long cateId) {
        List<ThirdCateVo> cateVoRes = null;
        if (thirdId == null || cateId == null) {
            return new ArrayList<ThirdCateVo>();
        }
        List<ThirdCateVo> allCates = this.queryAllThirdCate(thirdId);
        if (allCates == null || allCates.isEmpty()) {
            return new ArrayList<ThirdCateVo>();
        }
        cateVoRes = this.calcCateVo(cateId, allCates);
        cateVoRes.add(0, this.thirdCateMapper.selectByPrimaryKey(cateId));
        return cateVoRes;
    }

    @Override
    public List<ThirdCateVo> queryAllThirdCate(Long thirdId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put(THIRDID, thirdId);
        return this.thirdCateMapper.queryAllThirdCate(paramMap);
    }

    @Override
    public ThirdCateVo queryThirdCateById(Long cateId) {
        ThirdCateVo thirdCateVo = null;
        thirdCateVo = this.thirdCateMapper.selectByPrimaryKey(cateId);
        thirdCateVo.setParentThirdCateVo(this.thirdCateMapper.selectByPrimaryKey(thirdCateVo.getCatParentId()));
        return thirdCateVo;
    }

    @Override
    public ThirdCateVo queryThirdCateByPraentCateId(Long parentId, Long thirdId) {
        ThirdCateVo thirdCateVo = this.thirdCateMapper.selectByPrimaryKey(parentId);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put(THIRDID, thirdId);
        paramMap.put(CATID, parentId);
        if (thirdCateVo != null) {
            thirdCateVo.setCateVos(this.thirdCateMapper.queryThirdCateByParentCateId(paramMap));
        }
        return thirdCateVo;
    }
}

