/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.gift.service.impl;

import com.qianjiang.coupon.service.CouponService;
import com.qianjiang.customer.bean.CustomerInfo;
import com.qianjiang.customer.bean.CustomerPoint;
import com.qianjiang.customer.bean.CustomerPointLevel;
import com.qianjiang.customer.dao.CustomerInfoMapper;
import com.qianjiang.customer.dao.CustomerPointMapper;
import com.qianjiang.customer.service.CustomerPointServiceMapper;
import com.qianjiang.customer.service.PointLevelServiceMapper;
import com.qianjiang.gift.bean.Gift;
import com.qianjiang.gift.bean.GiftOrder;
import com.qianjiang.gift.dao.GiftCateMapper;
import com.qianjiang.gift.dao.GiftMapper;
import com.qianjiang.gift.dao.GiftOrderMapper;
import com.qianjiang.gift.service.GiftOrderService;
import com.qianjiang.gift.vo.GiftOrderVo;
import com.qianjiang.util.PageBean;
import com.qianjiang.util.UtilDate;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="GiftOrderWebService")
public class GiftOrderServiceImpl
implements GiftOrderService {
    private GiftOrderMapper giftOrderMapper;
    @Resource(name="GiftCateMapper")
    GiftCateMapper giftCateMapper;
    @Resource(name="GiftMapper")
    GiftMapper giftMapper;
    @Resource(name="CouponService")
    CouponService CouponService;
    @Resource(name="customerPointServiceMapper")
    CustomerPointServiceMapper customerPointServiceMapper;
    @Resource(name="customerPointMapper")
    CustomerPointMapper customerPointMapper;
    @Resource(name="customerInfoMapper")
    CustomerInfoMapper customerInfoMapper;
    @Resource(name="pointLevelServiceMapper")
    PointLevelServiceMapper pointLevelServiceMapper;

    @Override
    public PageBean queryGiftOrder(GiftOrderVo giftOrder, PageBean pb) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("giftOrderCode", giftOrder.getGiftOrderCode());
        paramMap.put("giftOrderStatus", giftOrder.getGiftOrderStatus());
        paramMap.put("shoppingMobile", giftOrder.getShoppingMobile());
        paramMap.put("shoppingPerson", giftOrder.getShoppingPerson());
        int rows = this.giftOrderMapper.giftOrderCount(paramMap);
        if (rows > 0) {
            pb.setRows(rows);
        } else {
            pb.setRows(0);
        }
        paramMap.put("startRowNum", pb.getStartRowNum());
        paramMap.put("endRowNum", pb.getEndRowNum());
        pb.setList(this.giftOrderMapper.giftOrderList(paramMap));
        return pb;
    }

    @Override
    public PageBean queryGiftOrder1(PageBean pb, Map<String, Object> paramMap) {
        int rows = this.giftOrderMapper.giftOrderCount1(paramMap);
        if (rows > 0) {
            pb.setRows(rows);
        } else {
            pb.setRows(0);
        }
        paramMap.put("startRowNum", pb.getStartRowNum());
        paramMap.put("endRowNum", pb.getEndRowNum());
        pb.setList(this.giftOrderMapper.giftOrderList1(paramMap));
        return pb;
    }

    @Override
    public GiftOrderVo orderDetail(Long giftOrderId) {
        return this.giftOrderMapper.selectByOrderId(giftOrderId);
    }

    @Override
    public int existOrderCode(String giftOrderCode) {
        if (Integer.parseInt(giftOrderCode) != 0) {
            return 1;
        }
        return 0;
    }

    @Override
    public int updateOrderVice(GiftOrder giftOrder) {
        return this.giftOrderMapper.updateGiftOrder(giftOrder);
    }

    @Override
    public GiftOrderVo queryByOrderCode(String giftOrderCode) {
        return this.giftOrderMapper.selectByOrderCode(giftOrderCode);
    }

    @Override
    public int subOrder(GiftOrder giftOrder, Long giftStock) {
        Gift gift = this.giftMapper.selectGiftDetailById(Long.valueOf(giftOrder.getTemp1()));
        if (gift == null || gift.getDelFlag().equals("1")) {
            return 0;
        }
        CustomerPoint customerPoint = this.CouponService.selectCustomerPointByCustomerId(giftOrder.getCustomerId());
        Long integral = customerPoint.getPointSum() - (long)this.customerPointServiceMapper.getCustomerReducePoint(giftOrder.getCustomerId() + "").intValue();
        if (integral < gift.getGiftIntegral()) {
            return 0;
        }
        String orderOldCode = UtilDate.mathString((Date)new Date());
        Random random = new Random();
        int i = random.nextInt(901) + 100;
        giftOrder.setGiftOrderCode(orderOldCode + i);
        giftOrder.setGiftOrderStatus("0");
        giftOrder.setDelFlag("0");
        giftOrder.setExpressPrice(new BigDecimal(0.0));
        giftOrder.setCreateTime(new Date());
        giftOrder.setPayTime(new Date());
        giftOrder.setOrderIntegral(gift.getGiftIntegral());
        int flag = this.giftOrderMapper.insertSelective(giftOrder);
        if (flag > 0) {
            gift.setGiftStock(giftStock);
            this.giftMapper.doUpdateGift(gift);
            this.addIntegralByGIftOrder(giftOrder.getCustomerId(), "10", giftOrder.getOrderIntegral().intValue(), Long.valueOf(giftOrder.getTemp1()));
        }
        return flag;
    }

    public int addIntegralByGIftOrder(Long customerId, String type, int intetegral, Long giftId) {
        if (type != null) {
            CustomerPoint customerPoint = new CustomerPoint();
            if ("10".equals(type)) {
                customerPoint.setPointDetail("\u79ef\u5206\u5151\u6362\u793c\u54c1");
                customerPoint.setPoint(Integer.valueOf(intetegral));
            }
            customerPoint.setPointType("0");
            customerPoint.setDelFlag("0");
            customerPoint.setCreateTime(new Date());
            customerPoint.setCustomerId(customerId);
            this.customerPointMapper.insertSelective(customerPoint);
            CustomerInfo info = this.customerInfoMapper.selectCustInfoById(customerId);
            info.setInfoPointSum(Integer.valueOf(info.getInfoPointSum() - customerPoint.getPoint()));
            info.setCustomerId(customerId);
            for (CustomerPointLevel level : this.pointLevelServiceMapper.selectAllPointLevel()) {
                String[] points = level.getPointNeed().split("~");
                if (Integer.valueOf(points[0]) > info.getInfoPointSum() || info.getInfoPointSum() > Integer.valueOf(points[1])) continue;
                info.setPointLevelName(level.getPointLevelName());
            }
            this.customerInfoMapper.updateInfoByCustId(info);
        }
        return 0;
    }

    @Override
    public List<GiftOrderVo> orderList() {
        return this.giftOrderMapper.orderVoList();
    }

    @Override
    public PageBean queryGiftOrder(PageBean pb, Map<String, Object> paramMap) {
        int rows = this.giftOrderMapper.giftOrderCount(paramMap);
        if (rows > 0) {
            pb.setRows(rows);
        } else {
            pb.setRows(0);
        }
        paramMap.put("startRowNum", pb.getStartRowNum());
        paramMap.put("endRowNum", pb.getEndRowNum());
        pb.setList(this.giftOrderMapper.giftOrderList(paramMap));
        return pb;
    }

    @Override
    public int updateOrderVice1(Long giftOrderId) {
        GiftOrder giftOrder = this.giftOrderMapper.selectByPrimaryKey(giftOrderId);
        giftOrder.setGiftOrderStatus("2");
        return this.giftOrderMapper.updateByPrimaryKeySelective(giftOrder);
    }

    @Resource(name="GiftOrderWebMapper")
    public void setGiftOrderMapper(GiftOrderMapper giftOrderMapper) {
        this.giftOrderMapper = giftOrderMapper;
    }
}

