/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.gift.service.impl;

import com.qianjiang.gift.bean.GiftPic;
import com.qianjiang.gift.dao.GiftPicMapper;
import com.qianjiang.gift.service.GiftPicService;
import com.qianjiang.goods.bean.InfoImageManage;
import com.qianjiang.goods.dao.ImageSetMapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="GiftPicService")
public class GiftPicServiceImpl
implements GiftPicService {
    private GiftPicMapper giftPicMapper;
    @Resource(name="GoodsImageSetMapper")
    private ImageSetMapper imageSetMapper;

    @Override
    public int delGiftPicByPicId(Long picId) {
        return this.giftPicMapper.delGiftPicByPicId(picId);
    }

    @Override
    public List<GiftPic> selectGiftPicByGiftId(Long giftId) {
        return this.giftPicMapper.selectGiftPicByGiftId(giftId);
    }

    @Override
    public Boolean newuploadImage(Long giftId, String[] url) {
        GiftPic image = null;
        if (null != url && url.length > 0) {
            for (int i = 0; i < url.length; ++i) {
                image = new GiftPic();
                image.setDelFlag("0");
                image.setPicUrl(url[i]);
                image.setGiftId(giftId);
                if (url[i].indexOf(".com") != -1) {
                    image.setPicBig(url[i] + "!352");
                    image.setPicMiddle(url[i] + "!160");
                    image.setPicLittle(url[i] + "!56");
                } else {
                    HashMap<String, String> paramMap = new HashMap<String, String>();
                    paramMap.put("url", url[i]);
                    InfoImageManage infoImageManage = this.imageSetMapper.queryImageByUrl(paramMap);
                    image.setPicBig(infoImageManage.getBigImgUrl());
                    image.setPicMiddle(infoImageManage.getMiddleImgUrl());
                    image.setPicLittle(infoImageManage.getSmallImgUrl());
                }
                this.giftPicMapper.savePic(image);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GiftPic uploadImage(Long giftId, String attribute, List<Map<String, String>> picList) {
        GiftPic image = null;
        try {
            for (int i = 0; i < picList.size(); ++i) {
                if (picList.get(i).isEmpty()) continue;
                image = new GiftPic();
                image.setGiftId(giftId);
                Map<String, String> resultMap = picList.get(i);
                image.setPicUrl(resultMap.get("oldimg"));
                image.setPicLittle(resultMap.get("0"));
                image.setPicMiddle(resultMap.get("1"));
                image.setPicBig(resultMap.get("2"));
                image.setDelFlag("0");
                image.setPicId(this.giftPicMapper.savePic(image));
            }
            GiftPic giftPic = image;
            return giftPic;
        }
        finally {
            image = null;
        }
    }

    public GiftPicMapper getGiftPicMapper() {
        return this.giftPicMapper;
    }

    @Resource(name="GiftPicMapper")
    public void setGiftPicMapper(GiftPicMapper giftPicMapper) {
        this.giftPicMapper = giftPicMapper;
    }
}

