/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.site.login.service.impl;

import com.alibaba.fastjson.JSON;
import com.qianjiang.customer.bean.Customer;
import com.qianjiang.customer.bean.CustomerAddress;
import com.qianjiang.customer.dao.CustomerAddressMapper;
import com.qianjiang.customer.dao.CustomerMapper;
import com.qianjiang.customer.service.CustomerPointServiceMapper;
import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.customer.vo.CustomerAllInfo;
import com.qianjiang.redis.RedisAdapter;
import com.qianjiang.redis.util.RedisUtil;
import com.qianjiang.site.login.bean.ReLogin;
import com.qianjiang.site.login.service.LoginService;
import com.qianjiang.util.UtilDate;
import com.qianjiang.utils.SecurityUtil;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="LoginService")
public class LoginServiceImpl
implements LoginService {
    private static final String UTYPE = "uType";
    @Resource(name="customerMapper")
    private CustomerMapper customerMapper;
    private CustomerAddress address;
    @Resource(name="customerAddressMapper")
    private CustomerAddressMapper addressMapper;
    @Resource(name="customerPointServiceMapper")
    private CustomerPointServiceMapper customerPointServiceMapper;
    @Resource(name="customerServiceMapper")
    private CustomerServiceMapper customerServiceInterface;
    @Resource
    private RedisAdapter redisAdapter;

    @Override
    public ReLogin checkCustomerExists(String ip, String username, String password) {
        ReLogin reLogin = new ReLogin();
        reLogin.setCode(0);
        if (username == null || password == null) {
            return reLogin;
        }
        HashMap<String, String> paramMap = null;
        String nameEmp = username.trim();
        paramMap = new HashMap<String, String>();
        if (nameEmp.indexOf("@") != -1) {
            paramMap.put(UTYPE, "email");
        } else if (Pattern.compile("^0?(13|15|17|18|14)[0-9]{9}$").matcher(nameEmp).find()) {
            paramMap.put(UTYPE, "mobile");
        } else {
            paramMap.put(UTYPE, "username");
        }
        paramMap.put("username", username);
        Customer customer = this.customerMapper.selectCustomerByCustNameAndType(paramMap);
        if (customer != null) {
            String encodePwd = SecurityUtil.getStoreLogpwd((String)customer.getUniqueCode(), (String)password, (String)customer.getSaltVal());
            if (encodePwd.equals(customer.getCustomerPassword())) {
                if ("1".equals(customer.getIsFlag())) {
                    reLogin.setCode(3);
                    return reLogin;
                }
                if (customer.getLoginTime() == null || !UtilDate.todayFormatString((Date)new Date()).equals(UtilDate.todayFormatString((Date)customer.getLoginTime()))) {
                    this.customerPointServiceMapper.addIntegralByType(customer.getCustomerId(), "1");
                }
                customer.setCustomerPassword(null);
                UUID uuid = UUID.randomUUID();
                customer.setLoginKey(uuid.toString());
                customer.setLoginTime(new Date());
                customer.setLoginIp(ip);
                if (customer.getAeadTime() == null) {
                    GregorianCalendar calendar = new GregorianCalendar();
                    calendar.setTime(new Date());
                    ((Calendar)calendar).add(5, -1);
                    customer.setAeadTime(calendar.getTime());
                }
                this.customerMapper.updateByPrimaryKeySelective(customer);
                CustomerAllInfo custInfo = this.customerServiceInterface.selectByPrimaryKey(customer.getCustomerId());
                reLogin.setCustomerId(customer.getCustomerId());
                reLogin.setCust((com.qianjiang.other.bean.CustomerAllInfo)JSON.parseObject((String)JSON.toJSONString((Object)custInfo), com.qianjiang.other.bean.CustomerAllInfo.class));
                RedisAdapter.put((String)RedisUtil.getRedisKeyByKeyAndParameter((String)RedisUtil.CUST, (String)username), (Serializable)custInfo, (int)RedisUtil.LOGIN_SAVE_TIME);
                RedisAdapter.put((String)RedisUtil.getRedisKeyByKeyAndParameter((String)RedisUtil.CUSTOMERID, (String)username), (Serializable)customer.getCustomerId(), (int)RedisUtil.LOGIN_SAVE_TIME);
                this.address = this.addressMapper.selectDefaultAddr(customer.getCustomerId());
                reLogin.setAddress(this.address);
                RedisAdapter.put((String)RedisUtil.getRedisKeyByKeyAndParameter((String)RedisUtil.ADDRESS, (String)username), (Serializable)this.address, (int)RedisUtil.LOGIN_SAVE_TIME);
                reLogin.setCode(1);
                return reLogin;
            }
            reLogin.setCode(0);
            return reLogin;
        }
        reLogin.setCode(2);
        return reLogin;
    }
}

