/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.third.auth.service.impl;

import com.qianjiang.customer.bean.Customer;
import com.qianjiang.customer.dao.CustomerMapper;
import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.customer.vo.CustomerAllInfo;
import com.qianjiang.third.auth.bean.ThirdAuthority;
import com.qianjiang.third.auth.bean.ThirdManagerAuthority;
import com.qianjiang.third.auth.bean.ThirdPage;
import com.qianjiang.third.auth.mapper.ThirdAuthorityMapper;
import com.qianjiang.third.auth.mapper.ThirdAuthorityPageMapper;
import com.qianjiang.third.auth.mapper.ThirdManagerAuthorityMapper;
import com.qianjiang.third.auth.mapper.ThirdManagerMapper;
import com.qianjiang.third.auth.service.ThirdAuthorityService;
import com.qianjiang.util.PageBean;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="thirdAuthorityService")
public class ThirdAuthorityServiceImpl
implements ThirdAuthorityService {
    private static final String THIRDID = "thirdId";
    @Resource(name="thirdAuthorityMapper")
    private ThirdAuthorityMapper thirdAuthorityMapper;
    @Resource(name="thirdAuthorityPageMapper")
    private ThirdAuthorityPageMapper authorityPageMapper;
    private CustomerMapper customerMapper;
    @Resource(name="thirdManagerAuthorityMapper")
    private ThirdManagerAuthorityMapper managerAuthorityMapper;
    private ThirdManagerMapper thirdManagerMapper;
    private CustomerServiceMapper customerServiceMapper;

    @Override
    public ThirdAuthority selectAuthorById(Long id) {
        return this.thirdAuthorityMapper.selectAuthorById(id);
    }

    @Override
    public List<ThirdAuthority> queryThirdAuthorityByStotreId(Long storeId) {
        List<ThirdAuthority> authList = this.thirdAuthorityMapper.queryThirdAuthorityByStotreId(storeId);
        HashMap<String, Object> parmaMap = null;
        for (ThirdAuthority auth : authList) {
            for (ThirdPage page : auth.getPages()) {
                parmaMap = new HashMap<String, Object>();
                parmaMap.put("authorityId", auth.getId());
                parmaMap.put("parentId", page.getId());
                page.setMenuVos(this.authorityPageMapper.selectPageByAuthIdAndParentId(parmaMap));
            }
        }
        return authList;
    }

    @Override
    public int addAuthority(Long storeId, ThirdAuthority thirdAuthority) {
        thirdAuthority.setStoreId(storeId);
        return this.thirdAuthorityMapper.insertSelective(thirdAuthority);
    }

    @Override
    public int checkAuthorityExist(Long thirdId, ThirdAuthority thirdAuthority) {
        List<ThirdAuthority> list = this.thirdAuthorityMapper.selectByDesignation(thirdAuthority.getDesignation(), thirdId);
        if (list != null && !list.isEmpty()) {
            return 1;
        }
        return 0;
    }

    @Override
    public int delAuthority(ThirdAuthority thirdAuthority, Long thirdId) {
        return this.thirdAuthorityMapper.deleteByPrimaryKey(thirdAuthority.getId(), thirdId);
    }

    @Override
    public int updateAuthorityName(ThirdAuthority thirdAuthority) {
        return this.thirdAuthorityMapper.updateByPrimaryKeySelective(thirdAuthority);
    }

    @Override
    public PageBean queryEmployeeListByStotreId(Long stordId, PageBean pb) {
        pb.setPageSize(10);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        Long count = this.thirdManagerMapper.queryEmployeeList(stordId);
        pb.setRows(Integer.parseInt(count == null ? "0" : count.toString()));
        if (pb.getPageNo() > pb.getLastPageNo()) {
            pb.setPageNo(pb.getLastPageNo());
        }
        if (pb.getPageNo() == 0) {
            pb.setPageNo(1);
        }
        paramMap.put("storeId", stordId);
        paramMap.put("startRowNum", pb.getStartRowNum());
        paramMap.put("endRowNum", pb.getEndRowNum());
        pb.setList(this.thirdManagerMapper.queryEmployeeListByStotreId(paramMap));
        return pb;
    }

    @Override
    @Transactional
    public int addEmp(Long thirdId, CustomerAllInfo allInfo, Long authId) {
        allInfo.setThirdId(thirdId);
        allInfo.setIsSeller("2");
        this.customerServiceMapper.addCustomer(allInfo);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("username", allInfo.getCustomerUsername());
        paramMap.put("password", allInfo.getCustomerPassword());
        Customer customer = this.customerMapper.selectCustomerByNamePwd(paramMap);
        if (customer != null) {
            paramMap = new HashMap();
            paramMap.put("customerId", allInfo.getCustomerId());
            paramMap.put("authId", authId);
            paramMap.put("storeId", thirdId);
            this.managerAuthorityMapper.addRecord(paramMap);
        }
        return 0;
    }

    @Override
    public Integer checkUsernameExitOrNot(Map<String, Object> map) {
        return this.customerServiceMapper.checkUsernameExitOrNot(map);
    }

    @Override
    public int updateByPrimaryKeySelective(ThirdManagerAuthority author, Long thirdId) {
        Long bussId = (long)this.managerAuthorityMapper.selectCustomerByManagerId(author.getManagerId());
        if (bussId.equals(thirdId)) {
            return this.managerAuthorityMapper.updateByPrimaryKeySelective(author);
        }
        return 0;
    }

    public CustomerMapper getCustomerMapper() {
        return this.customerMapper;
    }

    @Resource(name="customerMapper")
    public void setCustomerMapper(CustomerMapper customerMapper) {
        this.customerMapper = customerMapper;
    }

    public ThirdManagerMapper getThirdManagerMapper() {
        return this.thirdManagerMapper;
    }

    @Resource(name="thirdManagerMapper")
    public void setThirdManagerMapper(ThirdManagerMapper thirdManagerMapper) {
        this.thirdManagerMapper = thirdManagerMapper;
    }

    public CustomerServiceMapper getCustomerServiceMapper() {
        return this.customerServiceMapper;
    }

    @Resource(name="customerServiceMapper")
    public void setCustomerServiceMapper(CustomerServiceMapper customerServiceMapper) {
        this.customerServiceMapper = customerServiceMapper;
    }

    @Override
    public int updatePassword(Map<String, Object> map) {
        return this.customerMapper.updateThirdPassword(map);
    }
}

