/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.third.seller.service.impl;

import com.qianjiang.customer.bean.Customer;
import com.qianjiang.customer.dao.CustomerMapper;
import com.qianjiang.other.bean.CustomerAllInfo;
import com.qianjiang.third.goods.dao.ThirdGoodsMapper;
import com.qianjiang.third.goods.service.ThirdOtherService;
import com.qianjiang.third.seller.bean.StoreInfo;
import com.qianjiang.third.seller.bean.ThirdMessageModel;
import com.qianjiang.third.seller.bean.ThirdStoreMess;
import com.qianjiang.third.seller.mapper.ApplyBrandMapper;
import com.qianjiang.third.seller.mapper.StoreInfoMapper;
import com.qianjiang.third.seller.mapper.ThirdMessageModelMapper;
import com.qianjiang.third.seller.service.SellerService;
import com.qianjiang.util.MyLogger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="sellerService")
public class SellerServiceImpl
implements SellerService {
    public static final MyLogger LOGGER = new MyLogger(SellerServiceImpl.class);
    private StoreInfoMapper sotreInfoMapper;
    private ApplyBrandMapper applyBrandMapper;
    private ThirdMessageModelMapper thirdMessageModelMapper;
    private CustomerMapper customerMapper;
    private ThirdOtherService thirdOtherService;
    @Autowired
    private ThirdGoodsMapper thirdGoodsMapper;

    @Override
    public StoreInfo selectByEmployeeId(Long customerId) {
        return this.sotreInfoMapper.selectByEmployeeId(customerId);
    }

    @Override
    public StoreInfo selectByCustomerId(Long customerId) {
        return this.sotreInfoMapper.selectByCustomerId(customerId);
    }

    @Override
    public int updateByStoreInfo(StoreInfo storeInfo) {
        return this.sotreInfoMapper.updateByPrimaryKeySelective(storeInfo);
    }

    @Override
    public List<ThirdMessageModel> selectMessByStoreId(Long storeId) {
        return this.thirdMessageModelMapper.selectAllMessModel(storeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ThirdStoreMess queryStoreMessBySidAndMid(Long thirdId, Long mid) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        try {
            paramMap.put("storeId", thirdId);
            paramMap.put("messModId", mid);
            ThirdStoreMess thirdStoreMess = this.sotreInfoMapper.queryStoreMessBySidAndMid(paramMap);
            return thirdStoreMess;
        }
        finally {
            paramMap = null;
        }
    }

    @Override
    public int updateStoreMess(Long thirdId, ThirdStoreMess mess) {
        mess.setStoreId(thirdId);
        return this.sotreInfoMapper.updateStoreMess(mess);
    }

    @Override
    public int addStoreMess(Long thirdId, ThirdStoreMess mess) {
        mess.setStoreId(thirdId);
        return this.sotreInfoMapper.addStoreMess(mess);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public Long saveStoreInfo(Long customerId, String[] appId, StoreInfo storeInfo) {
        StoreInfo sinfo = null;
        CustomerAllInfo customer = new CustomerAllInfo();
        try {
            if (storeInfo.getStoreId() == null) {
                if (storeInfo.getCustomerid() == null) {
                    storeInfo.setCustomerid(customerId);
                }
                if ((sinfo = this.sotreInfoMapper.selectByCustomerId(storeInfo.getCustomerid())) == null) {
                    storeInfo.setIsSubmit("0");
                    this.sotreInfoMapper.insertSelective(storeInfo);
                    customer.setThirdId(storeInfo.getStoreId());
                    customer.setCustomerId(storeInfo.getCustomerid());
                    this.customerMapper.updateByPrimaryKeySelective((Customer)customer);
                    Long l = storeInfo.getStoreId();
                    return l;
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                if (null != appId && appId.length > 0) {
                    map.put("storeId", sinfo.getStoreId());
                    map.put("applyBrandIds", appId);
                    this.applyBrandMapper.updateThirdApplyBrand(map);
                }
                storeInfo.setStoreId(sinfo.getStoreId());
            }
            storeInfo.setIsStoreIndex("1");
            this.sotreInfoMapper.updateByPrimaryKeySelective(storeInfo);
            Long l = storeInfo.getStoreId();
            return l;
        }
        finally {
            sinfo = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int saveStoreCateAndBrand(Long customerId, Long storeId, String cids, String bids) {
        String[] cateIds = cids.split("\\|");
        StoreInfo storeInfo = null;
        try {
            for (int i = 0; i < cateIds.length; ++i) {
                this.thirdOtherService.saveGrantCat(storeId, Long.parseLong(cateIds[i]));
            }
            if (bids != null && bids.length() != 0) {
                String[] brandIds = bids.split("\\|");
                for (int i = 0; i < brandIds.length; ++i) {
                    this.thirdOtherService.saveGrantBrand(storeId, Long.parseLong(brandIds[i]));
                }
            }
            storeInfo = this.sotreInfoMapper.selectByCustomerId(customerId);
            storeInfo.setIsSubmit("1");
            this.sotreInfoMapper.updateByPrimaryKeySelective(storeInfo);
        }
        catch (Exception e) {
            LOGGER.error("" + e);
            int n = 0;
            return n;
        }
        finally {
            cateIds = null;
            storeInfo = null;
        }
        return 1;
    }

    @Override
    public StoreInfo selectRefuseInfo(Long customerId) {
        return this.sotreInfoMapper.selectRefuseInfo(customerId);
    }

    @Override
    public int updateStoreIndexState(StoreInfo storeInfo) {
        return this.sotreInfoMapper.updateByPrimaryKeySelective(storeInfo);
    }

    @Override
    public int updateByStoreInfo(StoreInfo storeInfo, Long customerId) {
        storeInfo.setCustomerid(customerId);
        storeInfo.setRefuseContent("");
        return this.sotreInfoMapper.updateRefuseInfo(storeInfo);
    }

    @Override
    public List<StoreInfo> selectAll() {
        return this.sotreInfoMapper.selectAll();
    }

    @Override
    public int queryCountByStoreName(String storeName) {
        return this.sotreInfoMapper.queryCountByStoreName(storeName.trim());
    }

    @Override
    public StoreInfo selectByStoreName(String storeName) {
        return this.sotreInfoMapper.selectByStoreName(storeName.trim());
    }

    @Override
    public StoreInfo selectByStoreId(Long storeId) {
        return this.sotreInfoMapper.selectByPrimaryKey(storeId);
    }

    public StoreInfoMapper getSotreInfoMapper() {
        return this.sotreInfoMapper;
    }

    @Resource(name="sotreInfoMapper")
    public void setSotreInfoMapper(StoreInfoMapper sotreInfoMapper) {
        this.sotreInfoMapper = sotreInfoMapper;
    }

    public ThirdMessageModelMapper getThirdMessageModelMapper() {
        return this.thirdMessageModelMapper;
    }

    @Resource(name="thirdMessageModelMapper")
    public void setThirdMessageModelMapper(ThirdMessageModelMapper thirdMessageModelMapper) {
        this.thirdMessageModelMapper = thirdMessageModelMapper;
    }

    public CustomerMapper getCustomerMapper() {
        return this.customerMapper;
    }

    @Resource(name="customerMapper")
    public void setCustomerMapper(CustomerMapper customerMapper) {
        this.customerMapper = customerMapper;
    }

    public ThirdOtherService getThirdOtherService() {
        return this.thirdOtherService;
    }

    @Resource(name="ThirdOtherService")
    public void setThirdOtherService(ThirdOtherService thirdOtherService) {
        this.thirdOtherService = thirdOtherService;
    }

    public ApplyBrandMapper getApplyBrandMapper() {
        return this.applyBrandMapper;
    }

    @Resource(name="ApplyBrandMapper")
    public void setApplyBrandMapper(ApplyBrandMapper applyBrandMapper) {
        this.applyBrandMapper = applyBrandMapper;
    }

    @Override
    public int queryThirdGoodsCount(Map<String, Object> paramMap) {
        return this.thirdGoodsMapper.queryThirdGoodsCountByFlag(paramMap);
    }
}

