/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.third.util;

import com.qianjiang.customer.bean.Customer;
import com.qianjiang.util.MyLogger;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class URLInterceptor
extends HandlerInterceptorAdapter {
    private static final String BASEURL = "baseUrl";
    private static final String HTML_DIV = "</div>";
    public static final MyLogger LOGGER = new MyLogger(URLInterceptor.class);

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        String basePath = request.getContextPath();
        LOGGER.info((Object)("basePath:" + basePath));
        String baseUrl = (String)request.getSession().getAttribute(BASEURL);
        if (baseUrl == null || "".equals(baseUrl)) {
            request.getSession().setAttribute(BASEURL, (Object)"");
        }
        String[] noFilterURLs = this.getNoFilters();
        String currentURL = request.getServletPath();
        boolean isFilter = true;
        for (String url : noFilterURLs) {
            if (currentURL.indexOf(url) == -1) continue;
            isFilter = false;
            break;
        }
        StringBuilder builderHead = new StringBuilder();
        StringBuilder builderTip = new StringBuilder();
        StringBuilder builderFoot = new StringBuilder();
        builderHead.append("<html>");
        builderHead.append("<head><link rel='stylesheet' href='" + basePath + "/css/bootstrap.min.css'/>" + "<link rel='stylesheet' href='" + basePath + "/css/style.css'/>");
        builderHead.append("<script type='text/javascript' src='" + basePath + "/js/jquery-1.11.1.min.js'></script>" + "<script type='text/javascript' src='" + basePath + "/js/bootstrap.min.js'></script>" + "<script type='text/javascript' src='" + basePath + "/js/third.js'></script>");
        builderHead.append("</head><html> <body>");
        builderFoot.append("</body></html><script type=\"text/javascript\">");
        builderFoot.append("window.onload=function(){$('#errorpage').modal('show')}");
        builderFoot.append("</script>");
        HttpSession session = request.getSession();
        Customer customerId = (Customer)session.getAttribute("cust");
        response.setContentType("text/html;charset=utf-8");
        if (isFilter) {
            if (customerId == null) {
                try {
                    PrintWriter out = response.getWriter();
                    builderTip.append("<div class=\"modal fade\" id=\"errorpage\" role=\"dialog\" aria-hidden=\"true\">");
                    builderTip.append("     <div class=\"modal-dialog\">");
                    builderTip.append("         <div class=\"modal-content\">");
                    builderTip.append("             <div class=\"modal-header\">");
                    builderTip.append("                 <button type=\"button\" class=\"close\" data-dismiss=\"modal\" aria-label=\"Close\"><span aria-hidden=\"true\">&times;</span></button><h4 class=\"modal-title\" style=\"font-family:\u5fae\u8f6f\u96c5\u9ed1,\u5b8b\u4f53\">\u767b\u5f55\u5931\u6548</h4></div><div  class=\"modal-body\" style=\"text-align: center;\">\u5bf9\u4e0d\u8d77\uff01\u60a8\u7684\u767b\u5f55\u72b6\u6001\u5df2\u7ecf\u5931\u6548\uff0c\u9700\u8981\u91cd\u65b0\u767b\u5f55\u3002</div><div class=\"modal-footer\" style=\"text-align: center;\"><button type=\"button\" class=\"btn btn-default\"  id=\"href\"  onclick=\"javascript:window.location.href='" + request.getContextPath() + "/login.html'\" style=\"color:#fff;background-color:#428bca;border-color:#357ebd;\"  data-dismiss=\"modal\">\u786e\u5b9a</button>");
                    builderTip.append("             </div>");
                    builderTip.append("         </div>");
                    builderTip.append("     </div>");
                    builderTip.append(HTML_DIV);
                    out.print(builderHead.append((CharSequence)builderTip).append((CharSequence)builderFoot).toString());
                    out.close();
                }
                catch (IOException e) {
                    LOGGER.error("" + e);
                    Object out = null;
                }
                return false;
            }
            return true;
        }
        return true;
    }

    private String[] getNoFilters() {
        return new String[]{"/thirdsubsendgoodsorder.htm", "/checkthirdmobileexist", "/logisticssingle.htm", "/checkUserNameExist.htm", "/checkmobilecode.htm", "/sendcodetovalidate.htm", "/findCodeOne.htm", "/checkUserNameExistForforgeting.htm", "/findCodeTwo.htm", "/findCodeThree.htm", "/findCodeFour.htm", "/updatePassword.htm", "/checkpatchca.htm", "/thirdRegisterCustomer.htm", "/jumplogin.htm", "/checkExistCustomerUsername.htm", "/getBasicSetName.htm", "/customer/login.htm", "/checklogin.htm", "/updatelogisticssingle.htm", "/tothirdordersendgoods.htm", "/toAddThirdLogisticsSingle.htm", "/addThirdlogisticssingle.htm", "/toUpdateThirdLogisticsSingle.htm", "/patchca.htm", "/patchcaSession.htm", "/isloginthird.htm", "/writeCaptcha.htm", "/customer/register.htm", "/register.htm", "/checkCustomerUsername", "/thirdsendcode.htm", "/downloadbossapp.htm", "/startbossapp.htm", "/stopbossapp.htm", "/uninstallbossapp.htm", "/updatebossapp.htm", "/downloadthirdapp.htm", "/startthirdapp.htm", "/stopthirdapp.htm", "/uninstallthirdapp.htm", "/updatethirdapp.htm", "/queryAllInstallApps.htm", "/appclient.htm", "/downloadsiteapp.htm", "/startsiteapp.htm", "/stopsiteapp.htm", "/uninstallsiteapp.htm", "/updatesiteapp.htm", "/appStartedNotice.htm", "/queryGoodsMarket.htm", "/queryImageManageByChoose.htm", "/businessenter.htm", "/progress.htm", "/queryProgress.htm", "/register/register_succeed", "/customer/registersucceed.htm", "newregistertwo.htm", "/registerController/registerSendCodeToValidate.htm", "/registerController/checkMobileCode.htm", "/toSellersPages.htm"};
    }
}

