/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.third.register.service.impl;

import com.qianjiang.system.bean.SMSConf;
import com.qianjiang.system.bean.SMSModel;
import com.qianjiang.system.dao.SMSConfMapper;
import com.qianjiang.system.dao.SMSModelMapper;
import com.qianjiang.third.register.service.RegisterService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.sms.SmsUtil;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service(value="registerService")
public class RegisterServiceImpl
implements RegisterService {
    public static final MyLogger LOGGER = new MyLogger(RegisterServiceImpl.class);
    @Autowired
    private SMSConfMapper smsConfMapper;
    @Autowired
    private SMSModelMapper smsModelMapper;
    @Autowired
    private StringRedisTemplate redisTemplate;

    @Override
    public String sendPost(String mobile) {
        String code = SmsUtil.getCode();
        String smsModelType = "1";
        try {
            SMSConf smsConf = this.smsConfMapper.querySmsConf();
            if (smsConf == null || smsConf != null && "0".equals(smsConf.getSmsIsOpen())) {
                return "0";
            }
            String smsAppKey = smsConf.getSmsAppKey();
            String smsSerect = smsConf.getSmsSerect();
            String smsSign = smsConf.getSmsSign();
            String smsVersion = smsConf.getSmsVersion();
            SMSModel smsModel = this.smsModelMapper.querySmsModelByModelType(smsModelType);
            String smsModelId = smsModel.getSmsModelId();
            com.alibaba.fastjson.JSONObject modelParam = new com.alibaba.fastjson.JSONObject();
            modelParam.put("code", (Object)code);
            boolean isSuccess = false;
            if ("0".equals(smsVersion)) {
                isSuccess = SmsUtil.sendMsgCode((String)smsAppKey, (String)smsSerect, (String)smsSign, (String)smsModelId, (com.alibaba.fastjson.JSONObject)modelParam, (String)smsModelType, (String)mobile);
            } else if ("1".equals(smsVersion)) {
                isSuccess = SmsUtil.sendSms((String)smsAppKey, (String)smsSerect, (String)smsSign, (String)smsModelId, (com.alibaba.fastjson.JSONObject)modelParam, (String)smsModelType, (String)mobile);
            }
            if (isSuccess) {
                return code;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u53d1\u9001\u9a8c\u8bc1\u7801\u5931\u8d25" + e);
        }
        return "0";
    }

    @Override
    public String newsendPost(String mobile) {
        String code = SmsUtil.getCode();
        String smsModelType = "1";
        try {
            SMSConf smsConf = this.smsConfMapper.querySmsConf();
            if (smsConf == null || smsConf != null && "0".equals(smsConf.getSmsIsOpen())) {
                return "0";
            }
            String smsAppKey = smsConf.getSmsAppKey();
            String smsSerect = smsConf.getSmsSerect();
            String smsSign = smsConf.getSmsSign();
            String smsVersion = smsConf.getSmsVersion();
            SMSModel smsModel = this.smsModelMapper.querySmsModelByModelType(smsModelType);
            String smsModelId = smsModel.getSmsModelId();
            com.alibaba.fastjson.JSONObject modelParam = new com.alibaba.fastjson.JSONObject();
            modelParam.put("code", (Object)code);
            boolean isSuccess = false;
            if ("0".equals(smsVersion)) {
                isSuccess = SmsUtil.sendMsgCode((String)smsAppKey, (String)smsSerect, (String)smsSign, (String)smsModelId, (com.alibaba.fastjson.JSONObject)modelParam, (String)smsModelType, (String)mobile);
            } else if ("1".equals(smsVersion)) {
                isSuccess = SmsUtil.sendSms((String)smsAppKey, (String)smsSerect, (String)smsSign, (String)smsModelId, (com.alibaba.fastjson.JSONObject)modelParam, (String)smsModelType, (String)mobile);
            }
            if (isSuccess) {
                return "1";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u53d1\u9001\u9a8c\u8bc1\u7801\u5931\u8d25" + e);
        }
        return "0";
    }

    @Override
    public int sendMobileCode(String mobile, String uuid) {
        LOGGER.info((Object)"\u624b\u673a\u9a8c\u8bc1\u7801\u53d1\u9001\u63a5\u53e3\u5f00\u59cb");
        String code = SmsUtil.getCode();
        String smsModelType = "1";
        try {
            SMSConf smsConf = this.smsConfMapper.querySmsConf();
            if (smsConf == null || smsConf != null && "0".equals(smsConf.getSmsIsOpen())) {
                return 0;
            }
            String smsAppKey = smsConf.getSmsAppKey();
            String smsSerect = smsConf.getSmsSerect();
            String smsSign = smsConf.getSmsSign();
            String smsVersion = smsConf.getSmsVersion();
            SMSModel smsModel = this.smsModelMapper.querySmsModelByModelType(smsModelType);
            String smsModelId = smsModel.getSmsModelId();
            com.alibaba.fastjson.JSONObject modelParam = new com.alibaba.fastjson.JSONObject();
            modelParam.put("code", (Object)code);
            boolean isSuccess = false;
            if ("0".equals(smsVersion)) {
                isSuccess = SmsUtil.sendMsgCode((String)smsAppKey, (String)smsSerect, (String)smsSign, (String)smsModelId, (com.alibaba.fastjson.JSONObject)modelParam, (String)smsModelType, (String)mobile);
            } else if ("1".equals(smsVersion)) {
                isSuccess = SmsUtil.sendSms((String)smsAppKey, (String)smsSerect, (String)smsSign, (String)smsModelId, (com.alibaba.fastjson.JSONObject)modelParam, (String)smsModelType, (String)mobile);
            }
            if (isSuccess) {
                HashMap<String, String> mobileCode = new HashMap<String, String>();
                LOGGER.info((Object)("code=[" + code + "];mobile=[" + mobile + "]"));
                mobileCode.put("mcCode", code);
                mobileCode.put("userMobile", mobile);
                String jsonStr = JSONObject.fromObject(mobileCode).toString();
                this.redisTemplate.opsForValue().set((Object)uuid, (Object)jsonStr, 600L, TimeUnit.SECONDS);
                LOGGER.info((Object)"\u624b\u673a\u9a8c\u8bc1\u7801\u53d1\u9001\u6210\u529f");
                return 1;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u53d1\u9001\u9a8c\u8bc1\u7801\u5931\u8d25" + e);
        }
        LOGGER.info((Object)"\u624b\u673a\u9a8c\u8bc1\u7801\u53d1\u9001\u5931\u8d25");
        return 0;
    }
}

