/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.third.auth.service.impl;

import com.qianjiang.customer.bean.Customer;
import com.qianjiang.third.auth.bean.ThirdAuthorityPage;
import com.qianjiang.third.auth.bean.ThirdManager;
import com.qianjiang.third.auth.bean.ThirdPage;
import com.qianjiang.third.auth.mapper.ThirdAuthorityPageMapper;
import com.qianjiang.third.auth.mapper.ThirdManagerAuthorityMapper;
import com.qianjiang.third.auth.mapper.ThirdManagerMapper;
import com.qianjiang.third.auth.service.ThirdAuthorityPageService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="thirdAuthorityPageService")
public final class ThirdAuthorityPageServiceImpl
implements ThirdAuthorityPageService {
    private ThirdManagerMapper thirdManagerMapper;
    @Resource(name="thirdManagerAuthorityMapper")
    private ThirdManagerAuthorityMapper managerAuthorityMapper;
    @Resource(name="thirdAuthorityPageMapper")
    private ThirdAuthorityPageMapper authorityPageMapper;

    @Override
    public List<ThirdPage> queryMenuByManager(Long cid) {
        Customer cust = this.thirdManagerMapper.selectCustByCid(cid);
        return this.getMenuLists(cust);
    }

    public List<ThirdPage> getMenuLists(Customer cust) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        Long num = this.managerAuthorityMapper.selectAuthIdByCust(cust);
        paramMap.put("customerId", cust.getCustomerId());
        List<ThirdPage> menuVoList = this.authorityPageMapper.selectByAuthorityID(num);
        List<ThirdPage> parentMenuVos = this.authorityPageMapper.selectAllMenuVos(num);
        this.fillMenuList(parentMenuVos, menuVoList);
        return parentMenuVos;
    }

    private void fillMenuList(List<ThirdPage> parentMenuVos, List<ThirdPage> menuVoList) {
        for (int i = 0; i < parentMenuVos.size(); ++i) {
            ThirdPage menuVo = parentMenuVos.get(i);
            for (int j = 0; j < menuVoList.size(); ++j) {
                ThirdPage mv = menuVoList.get(j);
                if (!(menuVo.getId() + "").equals(mv.getParentId() + "")) continue;
                if (menuVo.getMenuVos() == null) {
                    menuVo.setMenuVos(new ArrayList<ThirdPage>());
                }
                menuVo.getMenuVos().add(mv);
            }
            parentMenuVos.set(i, menuVo);
            if (menuVo.getMenuVos() == null) continue;
            this.fillMenuList(menuVo.getMenuVos(), menuVoList);
        }
    }

    public void bb(List<ThirdPage> objs) {
        if (objs != null) {
            for (int i = 0; i < objs.size(); ++i) {
                if (objs.get(i).getMenuVos() == null) continue;
                this.bb(objs.get(i).getMenuVos());
            }
        }
    }

    @Override
    public List<ThirdManager> queryThirdManagerByStoreId(Long stordId) {
        return this.thirdManagerMapper.queryThirdManagerByStoreId(stordId);
    }

    @Override
    public List<ThirdPage> loadAllAuthority() {
        return this.thirdManagerMapper.selectAllAuthority();
    }

    @Override
    public List<ThirdPage> queryThirdPageByAuthId(Long authorityId) {
        return this.authorityPageMapper.selectAllPageByAuthorityID(authorityId);
    }

    @Override
    public String updateAuthority(String[] pagesId, Long authId) {
        int j;
        int i;
        List<ThirdPage> pages = this.authorityPageMapper.selectAllPageByAuthorityID(authId);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        ArrayList<Long> delNums = new ArrayList<Long>();
        ArrayList<Long> addNums = new ArrayList<Long>();
        for (i = 0; i < pages.size(); ++i) {
            if (pagesId.length != 0 && pagesId.length > 0) {
                for (j = 0; j < pagesId.length && !pages.get(i).getId().toString().equals(pagesId[j]); ++j) {
                    if (pages.get(i).getId().toString().equals(pagesId[j]) || j != pagesId.length - 1) continue;
                    delNums.add(pages.get(i).getId());
                }
                continue;
            }
            delNums.add(pages.get(i).getId());
        }
        if (pages.isEmpty()) {
            for (i = 0; i < pagesId.length; ++i) {
                addNums.add(Long.parseLong(pagesId[i]));
            }
        } else {
            for (i = 0; i < pagesId.length; ++i) {
                for (j = 0; j < pages.size() && !pages.get(j).getId().toString().equals(pagesId[i]); ++j) {
                    if (pages.get(j).getId().toString().equals(pagesId[i]) || j != pages.size() - 1) continue;
                    addNums.add(Long.parseLong(pagesId[i]));
                }
            }
        }
        if (!delNums.isEmpty()) {
            paramMap.put("authorityId", authId);
            paramMap.put("preIds", delNums);
            this.authorityPageMapper.delPageToAuthority(paramMap);
        }
        for (i = 0; i < addNums.size(); ++i) {
            paramMap = new HashMap();
            paramMap.put("authorityId", authId);
            paramMap.put("pageId", addNums.get(i));
            this.authorityPageMapper.addPageToAuthority(paramMap);
        }
        return null;
    }

    @Override
    @Transactional
    public int insertSupplierPage(ThirdPage page, Long thirdId) {
        int number = this.thirdManagerMapper.insertSelective(page);
        if (number > 0) {
            page.getId();
            System.out.println("\u6253\u5370page.getId..." + page.getId());
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("pageId", page.getId());
            paramMap.put("authorityId", thirdId);
            this.insertSupplierAuthorityPage(paramMap);
        }
        return number;
    }

    public int insertSupplierAuthorityPage(Map<String, Object> paramMap) {
        return this.thirdManagerMapper.addPageToAuthority(paramMap);
    }

    @Override
    @Transactional
    public int updateSupplierPage(ThirdPage page, Long autherPageId, Long thirdId) {
        int number = this.thirdManagerMapper.updateThirdPage(page);
        if (number > 0) {
            page.getId();
            System.out.println("\u6253\u5370\u7f16\u8f91\u7684page.getId..." + page.getId());
            ThirdAuthorityPage authPage = new ThirdAuthorityPage();
            authPage.setId(autherPageId);
            authPage.setPageId(page.getId());
            authPage.setType(page.getType());
            authPage.setAuthorityId(thirdId);
            this.updateAuthIdByCustId(authPage);
        }
        return number;
    }

    @Override
    public Long selectAuthIdByCustId(Long customerId) {
        return this.managerAuthorityMapper.selectAuthIdByCustId(customerId);
    }

    @Override
    public int updateAuthIdByCustId(ThirdAuthorityPage authPage) {
        return this.managerAuthorityMapper.updateSupplierPage(authPage);
    }

    public ThirdManagerMapper getThirdManagerMapper() {
        return this.thirdManagerMapper;
    }

    @Resource(name="thirdManagerMapper")
    public void setThirdManagerMapper(ThirdManagerMapper thirdManagerMapper) {
        this.thirdManagerMapper = thirdManagerMapper;
    }
}

