/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.third.goods.service.impl;

import com.qianjiang.goods.bean.GoodsBrand;
import com.qianjiang.goods.bean.GoodsCate;
import com.qianjiang.goods.bean.GoodsTag;
import com.qianjiang.third.goods.dao.ThirdOtherMapper;
import com.qianjiang.third.goods.service.ThirdOtherService;
import com.qianjiang.util.PageBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="ThirdOtherService")
public class ThirdOtherServiceImpl
implements ThirdOtherService {
    @Resource(name="ThirdOtherMapper")
    private ThirdOtherMapper thirdOtherMapper;

    @Override
    public List<GoodsCate> queryGrandCateForThirdnew(Long thirdId, Long catId) {
        List<GoodsCate> list = new ArrayList<GoodsCate>();
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("thirdId", thirdId);
            map.put("catId", catId);
            list = this.thirdOtherMapper.queryGrandCateForThirdnew(map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    @Override
    public List<GoodsBrand> queryGrandBrandByThirdId(Long thirdId) {
        return this.thirdOtherMapper.queryGrandListByThirdId(thirdId);
    }

    @Override
    public List<GoodsTag> queryAllGoodsTagForThird() {
        return this.thirdOtherMapper.queryAllGoodsTagForThirdId();
    }

    @Override
    public List<GoodsCate> queryGrandCateForThird(Long thirdId) {
        return this.thirdOtherMapper.queryAllGoodsCateForThird(thirdId);
    }

    @Override
    public List<GoodsCate> queryGrandCateForThirdtwo(Long thirdId, Long catId) {
        List<GoodsCate> list = new ArrayList<GoodsCate>();
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("thirdId", thirdId);
            map.put("catId", catId);
            list = this.thirdOtherMapper.queryAllGoodsCateForThirdtwo(map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    @Override
    public GoodsCate queryGoodsCateForThirdById(Long thirdId, Long cateId) {
        GoodsCate goodsCate = null;
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("thirdId", thirdId);
            map.put("catId", cateId);
            goodsCate = this.thirdOtherMapper.queryGoodsCateForThirdById(map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return goodsCate;
    }

    @Override
    public PageBean queryAboutGoodsForThirdByThirdInfo(PageBean pb, Long thirdId, Long goodsCatId) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("thirdId", thirdId);
            map.put("catId", goodsCatId);
            pb.setRows(this.thirdOtherMapper.queryAboutGoodsCountByCatId(map));
            map.put("startRowNum", pb.getStartRowNum());
            map.put("endRowNum", pb.getEndRowNum());
            pb.setList(this.thirdOtherMapper.queryAboutGoodsListByCatId(map));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pb;
    }

    @Override
    @Transactional
    public int saveGrantBrand(Long thirdId, Long brandId) {
        int result = 0;
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("thirdId", thirdId);
            map.put("brandId", brandId);
            result = this.thirdOtherMapper.insertThirdGrantbrand(map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    @Transactional
    public int saveGrantCat(Long thirdId, Long catId) {
        int result = 0;
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("thirdId", thirdId);
            map.put("catId", catId);
            result = this.thirdOtherMapper.insertThirdGrantCat(map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}

