/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.third.analysis.service.impl;

import com.qianjiang.third.analysis.bean.OCustomerFollow;
import com.qianjiang.third.analysis.bean.OOrder;
import com.qianjiang.third.analysis.dao.AnalysisServiceMapper;
import com.qianjiang.third.analysis.service.AnalysisService;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="AnalysisService")
public class AnalysisServiceImpl
implements AnalysisService {
    private static final String STARTTIME = "startTime";
    private static final String ENDTIME = "endTime";
    private static final String BUSINESSID = "businessId";
    @Resource(name="AnalysisServiceMapper")
    private AnalysisServiceMapper analysisServiceMapper;

    @Override
    public List<OCustomerFollow> selectThirdFollowGoods(Long thirdId, String startTime, String endTime, Long catId) {
        List<OCustomerFollow> glist;
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("thirdId", thirdId);
        paramMap.put(STARTTIME, startTime);
        paramMap.put(ENDTIME, endTime + " 23:59:59");
        if (catId != null) {
            paramMap.put("catId", catId);
        }
        if ((glist = this.analysisServiceMapper.selectThirdFollowGoods(paramMap)) != null && !glist.isEmpty()) {
            for (int i = 0; i < glist.size(); ++i) {
                paramMap.put("goodsInfoId", glist.get(i).getGoodsId());
                List<OCustomerFollow> ffist = this.analysisServiceMapper.selectThirdFollowGoodsCount(paramMap);
                if (ffist == null || ffist.isEmpty()) continue;
                HashMap<String, Long> pMap = new HashMap<String, Long>();
                for (OCustomerFollow g : ffist) {
                    pMap.put(g.getGoodsDownTime(), g.getCountSum());
                }
                glist.get(i).setTimeMap(pMap);
            }
        }
        return glist;
    }

    @Override
    public List<OOrder> queryCountByDay(Long businessId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put(BUSINESSID, businessId);
        return this.analysisServiceMapper.queryCountByDay(paramMap);
    }

    @Override
    public OOrder queryNoSuccCountByDay(String startTime, String endTime, Long businessId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put(STARTTIME, startTime);
        paramMap.put(ENDTIME, endTime);
        paramMap.put(BUSINESSID, businessId);
        return this.analysisServiceMapper.queryNoSuccCountByDay(paramMap);
    }

    @Override
    public OOrder querySuccCountByTime(String startTime, String endTime, Long businessId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put(STARTTIME, startTime);
        paramMap.put(ENDTIME, endTime);
        paramMap.put(BUSINESSID, businessId);
        return this.analysisServiceMapper.querySuccCountByTime(paramMap);
    }
}

