/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.third.grandbrand.service.impl;

import com.qianjiang.goods.bean.GoodsBrand;
import com.qianjiang.manager.base.BasicSqlSupport;
import com.qianjiang.third.grandbrand.bean.GrandBrand;
import com.qianjiang.third.grandbrand.mapper.GrandBrandMapper;
import com.qianjiang.third.grandbrand.service.GrandBrandService;
import com.qianjiang.util.MapUtil;
import com.qianjiang.util.PageBean;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="GrandBrandService")
public class GrandBrandServiceImpl
extends BasicSqlSupport
implements GrandBrandService {
    private static final String THIRDID = "thirdId";
    private GrandBrandMapper mapper;

    @Override
    public int checkGoodCount(Long brandId, Long thirdId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("brandId", brandId);
        map.put(THIRDID, thirdId);
        return this.mapper.checkGoodCount(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageBean queryAllGoodsGrandBrand(PageBean pb, GoodsBrand goodsBrand, String rateStatus, Long thirdId) {
        Map map = MapUtil.getParamsMap((Object)goodsBrand);
        map.put("startRowNum", pb.getStartRowNum());
        map.put("endRowNum", pb.getEndRowNum());
        map.put(THIRDID, thirdId);
        map.put("rateStatus", rateStatus);
        map.put("forBrand", null);
        pb.setRows(this.mapper.searchGrandBrandCount(map));
        try {
            pb.setList(this.mapper.queryAllThirdGrandBrand(map));
            PageBean pageBean = pb;
            return pageBean;
        }
        finally {
            map = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageBean queryForGoodsGrandBrand(PageBean pb, GoodsBrand goodsBrand, Long thirdId, String forBrand) {
        Map map = MapUtil.getParamsMap((Object)goodsBrand);
        map.put("startRowNum", pb.getStartRowNum());
        map.put("endRowNum", pb.getEndRowNum());
        map.put(THIRDID, thirdId);
        map.put("rateStatus", null);
        map.put("forBrand", forBrand);
        pb.setRows(this.mapper.searchGrandBrandCount(map));
        try {
            pb.setList(this.mapper.forQueryAllThirdGoodsBrand(map));
            PageBean pageBean = pb;
            return pageBean;
        }
        finally {
            map = null;
        }
    }

    @Override
    public void forTheGoodsBrand(String[] brandId, Long thirdId) {
        ArrayList<GrandBrand> grandBrands = new ArrayList<GrandBrand>();
        for (int i = 0; i < brandId.length; ++i) {
            GrandBrand grandBrand = new GrandBrand();
            grandBrand.setBrandId(Long.valueOf(brandId[i]));
            grandBrand.setThirdId(thirdId);
            grandBrand.setModifyTime(new Date());
            grandBrands.add(grandBrand);
        }
        this.mapper.forTheGoodsBrand(grandBrands);
    }

    @Override
    public void updateGrandBrand(GoodsBrand goodsBrand) {
        this.mapper.updateGrandBrand(goodsBrand);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateGrandBrands(Long[] brandIds, Long thirdId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<Long> grandBrands = new ArrayList<Long>();
        for (int i = 0; i < brandIds.length; ++i) {
            grandBrands.add(brandIds[i]);
        }
        try {
            map.put("grandBrands", brandIds);
            map.put(THIRDID, thirdId);
            this.mapper.updateGrandBrands(map);
        }
        finally {
            grandBrands = null;
        }
    }

    @Override
    public List<Object> queryAllGoodsGrandBrand(Long thirdId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(THIRDID, thirdId);
        return this.mapper.queryAllByThirdGoodsBrand(map);
    }

    @Override
    public GoodsBrand queryBrandById(Long brandId) {
        return this.mapper.selectByPrimaryKey(brandId);
    }

    @Override
    public int updateApplyBrandByName(String applyBrandName) {
        return this.mapper.updateApplyBrandByName(applyBrandName);
    }

    public GrandBrandMapper getMapper() {
        return this.mapper;
    }

    @Resource(name="GrandBrandMapper")
    public void setMapper(GrandBrandMapper mapper) {
        this.mapper = mapper;
    }
}

