/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.alipayceb.util;

import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Call;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class HttpsUtils {
    public static final String SYS_CODE = "cmc.HttpsUtils";
    protected final SupperLogUtil logger = new SupperLogUtil(this.getClass());
    private MyTrustManager mMyTrustManager;

    private SSLSocketFactory createSSLSocketFactory() {
        SSLSocketFactory ssfFactory = null;
        try {
            this.mMyTrustManager = new MyTrustManager();
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, new TrustManager[]{this.mMyTrustManager}, new SecureRandom());
            ssfFactory = sc.getSocketFactory();
        }
        catch (Exception ignored) {
            ignored.printStackTrace();
        }
        return ssfFactory;
    }

    public OkHttpClient getTrustAllClient() {
        OkHttpClient.Builder mBuilder = new OkHttpClient.Builder();
        mBuilder.sslSocketFactory(this.createSSLSocketFactory(), (X509TrustManager)this.mMyTrustManager).hostnameVerifier((HostnameVerifier)new TrustAllHostnameVerifier());
        return mBuilder.build();
    }

    public String doPost(String url, Map<String, String> params) {
        if (StringUtils.isBlank((String)url)) {
            return null;
        }
        FormBody.Builder builder = new FormBody.Builder();
        if (MapUtil.isNotEmpty(params)) {
            for (String key : params.keySet()) {
                builder.add(key, params.get(key));
            }
        }
        FormBody body = builder.build();
        Request request = new Request.Builder().url(url).post((RequestBody)body).build();
        Call call = this.getTrustAllClient().newCall(request);
        try {
            Response response = call.execute();
            if (response.body() != null) {
                return response.body().string();
            }
        }
        catch (IOException e) {
            this.logger.error("cmc.HttpsUtils.doPost.e", (Throwable)e);
        }
        return null;
    }

    private class TrustAllHostnameVerifier
    implements HostnameVerifier {
        private TrustAllHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }

    public class MyTrustManager
    implements X509TrustManager {
        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

