/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.be.order.service;

import com.yqbsoft.laser.service.ext.channel.be.BeConstants;
import com.yqbsoft.laser.service.ext.channel.be.service.HttpRequestUtil;
import com.yqbsoft.laser.service.ext.channel.be.service.SignUtil;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisChannel;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisContractDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisContractGoodsDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisContractproDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisPackageDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.GoodsBean;
import com.yqbsoft.laser.service.ext.channel.discom.service.DisOrderBaseService;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;

public class DisOrderServiceImpl
extends DisOrderBaseService {
    private String SYS_CODE = "be.DisOrderServiceImpl";

    protected String getChannelCode() {
        return BeConstants.channelCode;
    }

    public Map<String, Object> buildComOrderParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        HashMap<String, String> body;
        if (MapUtil.isEmpty(sendParam) || MapUtil.isEmpty(configMap) || null == disChannel) {
            return null;
        }
        String memberCode = (String)param.get("memberCode");
        if (StringUtils.isBlank((String)memberCode)) {
            memberCode = disChannel.getMemberCode();
        }
        Integer timestamp = Integer.valueOf(DisOrderServiceImpl.create_timestamp());
        sendParam.put("timestamp", timestamp);
        sendParam.put("encrypt", "");
        sendParam.put("version", Integer.valueOf(configMap.get("version")));
        if ("cmc.disOrder.queryOrder".equals(channelApiCode)) {
            body = new HashMap<String, String>();
            body.put("shop_id", (String)param.get("shoppingId"));
            sendParam.put("body", JsonUtil.buildNormalBinder().toJson(body));
        } else if ("cmc.disOrder.getSendOrder".equals(channelApiCode)) {
            body = new HashMap();
            body.put("order_id", (String)param.get("contractNbillcode"));
            sendParam.put("body", JsonUtil.buildNormalBinder().toJson(body));
        }
        if ("cmc.disOrder.queryTimeOrder".equals(channelApiCode)) {
            body = new HashMap();
            sendParam.put("body", JsonUtil.buildNormalBinder().toJson(body));
        }
        return sendParam;
    }

    public Object sendComOrder(String channelApiCode, DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        String json;
        if (null == disChannel || null == sendhttpParam || null == configMap) {
            return "ERROR";
        }
        String url = configMap.get("host");
        if (StringUtils.isBlank((String)url)) {
            this.logger.error(this.SYS_CODE + ".sendComSaveGoodsClass.url", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        try {
            json = HttpRequestUtil.sendPost(url, sendhttpParam);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".sendComSaveGoodsClass.e", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()), (Throwable)e);
            return "ERROR";
        }
        if (StringUtils.isBlank((String)json)) {
            this.logger.error(this.SYS_CODE + ".sendComSaveGoodsClass.json", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        Map beOrderMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(json, String.class, Object.class);
        if (MapUtil.isEmpty((Map)beOrderMap)) {
            return null;
        }
        if ("cmc.disOrder.queryTimeOrder".equals(channelApiCode)) {
            Map result = (Map)beOrderMap.get("body");
            if (MapUtil.isEmpty((Map)result)) {
                return null;
            }
            List listMap = (List)result.get("list");
            if (ListUtil.isEmpty((Collection)listMap)) {
                return null;
            }
            return this.createListOrder(listMap, disChannel);
        }
        if ("cmc.disOrder.getSendOrder".equals(channelApiCode)) {
            Map map = (Map)beOrderMap.get("body");
            if (MapUtil.isEmpty((Map)map)) {
                this.logger.error(this.SYS_CODE + ".sendComOrder.json.map", (Object)("===" + json + "====" + sendhttpParam.toString() + "====" + channelApiCode + "===" + url));
                return null;
            }
            if (!"0".equals((Integer)map.get("errno")) && !"success".equals((String)map.get("error"))) {
                this.logger.error(this.SYS_CODE + ".sendComOrder.result is error", (Object)("===" + json + "====" + sendhttpParam.toString() + "====" + channelApiCode + "===" + url));
                return null;
            }
            Map dataMap = (Map)map.get("data");
            if (MapUtil.isEmpty((Map)dataMap)) {
                this.logger.error(this.SYS_CODE + ".sendComOrder.json.dataMap", (Object)("===" + json + "====" + sendhttpParam.toString() + "====" + channelApiCode + "===" + url));
                return null;
            }
            return this.createOrder(dataMap, disChannel);
        }
        return null;
    }

    private List<DisContractDomain> createListOrder(List<Map<String, Object>> list, DisChannel disChannel) {
        if (ListUtil.isEmpty(list)) {
            return null;
        }
        ArrayList<DisContractDomain> disContractDomainList = new ArrayList<DisContractDomain>();
        for (Map<String, Object> map : list) {
            DisContractDomain disContractDomain = this.makeOrder(map, disChannel);
            if (null == disContractDomain) continue;
            disContractDomainList.add(disContractDomain);
        }
        return disContractDomainList;
    }

    private DisContractDomain createOrder(Map<String, Object> param, DisChannel disChannel) {
        if (MapUtil.isEmpty(param)) {
            return null;
        }
        return this.makeOrder(param, disChannel);
    }

    private DisContractDomain makeOrder(Map<String, Object> map, DisChannel disChannel) {
        Integer packageFee;
        if (null == map || null == disChannel) {
            return null;
        }
        Map orderMap = (Map)map.get("order");
        Map userMap = (Map)map.get("user");
        Map shopMap = (Map)map.get("shop");
        List productsMap = (List)map.get("products");
        List discountMap = (List)map.get("discount");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        DisContractDomain disContractDomain = new DisContractDomain();
        disContractDomain.setGoodsReceiptArrdess((String)userMap.get("address"));
        disContractDomain.setChannelCode(disChannel.getChannelCode());
        disContractDomain.setChannelName(disChannel.getChannelName());
        disContractDomain.setTenantCode(disChannel.getTenantCode());
        String activeAt = (String)orderMap.get("create_time");
        Integer deliverTime = (Integer)orderMap.get("latest_send_time");
        Integer confirmCookingTime = (Integer)orderMap.get("delivery_time");
        try {
            disContractDomain.setContractValidate(StringUtils.isNotBlank((String)activeAt) ? sdf.parse(activeAt) : null);
            disContractDomain.setContractEffectivedate(StringUtils.isNotBlank((String)String.valueOf(deliverTime)) ? sdf.parse(String.valueOf(deliverTime)) : null);
            disContractDomain.setGmtVaild(StringUtils.isNotBlank((String)String.valueOf(confirmCookingTime)) ? sdf.parse(String.valueOf(confirmCookingTime)) : null);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        Integer deliverFee = (Integer)orderMap.get("send_fee");
        if (null == deliverFee) {
            deliverFee = new Integer("0");
        }
        disContractDomain.setGoodsLogmoney(BigDecimal.valueOf(deliverFee.intValue()));
        disContractDomain.setContractRemark((String)orderMap.get("remark"));
        disContractDomain.setContractInvoice((String)orderMap.get("invoice_title"));
        disContractDomain.setContractTypepro("00");
        if ("2".equals(orderMap.get("send_immediately"))) {
            disContractDomain.setContractTypepro("01");
        }
        disContractDomain.setContractType("19");
        disContractDomain.setContractPmode("1");
        if ("2".equals(orderMap.get("pay_type"))) {
            disContractDomain.setContractPmode("0");
        }
        disContractDomain.setContractNbillcode((String)orderMap.get("order_id"));
        disContractDomain.setGoodsReceiptPhone((String)userMap.get("phone"));
        String memberCcode = this.getMemberCode(disChannel.getTenantCode(), disChannel.getChannelCode(), String.valueOf(shopMap.get("id")));
        disContractDomain.setMemberCode(disChannel.getMemberCode());
        disContractDomain.setMemberName(disChannel.getMemberName());
        disContractDomain.setMemberCcode(memberCcode);
        disContractDomain.setMemberCname((String)shopMap.get("name"));
        this.setContractPro(disContractDomain, "daySn", String.valueOf(orderMap.get("order_index")), "\u6d41\u6c34\u53f7");
        disContractDomain.setDataStatestr(String.valueOf((Integer)orderMap.get("status")));
        String dataState = this.getOrderState(disChannel.getTenantCode(), disChannel.getChannelCode(), String.valueOf((Integer)orderMap.get("status")));
        if (StringUtils.isBlank((String)dataState) || "null".equals(dataState)) {
            dataState = "2";
        }
        disContractDomain.setDataState(Integer.valueOf(Integer.parseInt(dataState)));
        String refundStatus = this.getRefundFlag(disChannel.getTenantCode(), disChannel.getChannelCode(), String.valueOf((Integer)orderMap.get("status")));
        if (StringUtils.isBlank((String)refundStatus) || "null".equals(refundStatus)) {
            refundStatus = "0";
        }
        disContractDomain.setRefundFlag(Integer.valueOf(Integer.parseInt(refundStatus)));
        disContractDomain.setMemberBcode((String)map.get("source"));
        Integer income = (Integer)orderMap.get("user_fee");
        if (null == income) {
            income = new Integer("0");
        }
        disContractDomain.setDataBmoney(BigDecimal.valueOf(income.intValue()));
        Integer totalPrice = (Integer)map.get("total_fee");
        if (null == totalPrice) {
            totalPrice = new Integer("0");
        }
        disContractDomain.setContractMoney(BigDecimal.valueOf(totalPrice.intValue()));
        Integer originalPrice = (Integer)map.get("total_fee");
        if (null == originalPrice) {
            originalPrice = new Integer("0");
        }
        disContractDomain.setContractInmoney(BigDecimal.valueOf(originalPrice.intValue()));
        Map coordAmap = (Map)userMap.get("coord_amap");
        this.setContractPro(disContractDomain, "longitudeGeo", String.valueOf((Double)coordAmap.get("longitude")), "\u9ad8\u5fb7\u7ecf\u5ea6");
        this.setContractPro(disContractDomain, "latitudeGeo", String.valueOf((Double)coordAmap.get("latitude")), "\u9ad8\u5fb7\u7eac\u5ea6");
        disContractDomain.setGoodsReceiptMem((String)userMap.get("name"));
        if ("1".equals(orderMap.get("need_invoice"))) {
            String str = "{ \"invoice_title\":" + (String)orderMap.get("invoice_title") + ",\"taxer_id\":" + (String)orderMap.get("taxer_id") + "}";
            disContractDomain.setContractInvoicestr(str);
        }
        this.setContractPro(disContractDomain, "downgraded", String.valueOf((Integer)orderMap.get("down_flag")), "\u964d\u7ea7\u6807\u8bc6");
        if (0 < discountMap.size()) {
            disContractDomain.setContractActives(JsonUtil.buildNormalBinder().toJson((Object)((String)((Map)discountMap.get(0)).get("desc"))));
        }
        if (null == (packageFee = (Integer)orderMap.get("package_fee"))) {
            packageFee = new Integer("0");
        }
        disContractDomain.setContractPaymoney(BigDecimal.valueOf(packageFee.intValue()));
        String coldBoxFeeStr = (String)orderMap.get("cold_box_fee");
        Integer coldBoxFee = Integer.valueOf(coldBoxFeeStr);
        if (null == coldBoxFee) {
            coldBoxFee = new Integer("0");
        }
        disContractDomain.setContractEarnest(BigDecimal.valueOf(coldBoxFee.intValue()));
        this.setContractPro(disContractDomain, "cancelOrderCreatedAt", String.valueOf(orderMap.get("cancel_time")), "\u7528\u6237\u7533\u8bf7\u53d6\u6d88\u65f6\u95f4");
        disContractDomain.setContractCommis(JsonUtil.buildNormalBinder().toJson(orderMap.get("commission")));
        disContractDomain.setContractExtinfo(JsonUtil.buildNormalBinder().toJson(orderMap.get("remark")));
        disContractDomain.setPackageBillno(String.valueOf(orderMap.get("order_index")));
        disContractDomain.setContractProperty("0");
        this.setContractPro(disContractDomain, "order_from", (String)orderMap.get("order_from"), "\u8ba2\u5355\u6765\u6e90", "");
        List<DisPackageDomain> disPackageDomains = this.makeDisPackageDomain(productsMap, disContractDomain);
        disContractDomain.setPackageList(disPackageDomains);
        return disContractDomain;
    }

    private String changeParam(List<String> list) {
        if (ListUtil.isEmpty(list)) {
            return null;
        }
        String rStr = "";
        for (String str : list) {
            rStr = rStr + str + ",";
        }
        return rStr;
    }

    private List<DisPackageDomain> makeDisPackageDomain(List<Map<String, Object>> goodGroup, DisContractDomain disContractDomain) {
        if (ListUtil.isEmpty(goodGroup)) {
            return null;
        }
        ArrayList<DisPackageDomain> rePagList = new ArrayList<DisPackageDomain>();
        DisPackageDomain pag = null;
        BigDecimal goodsWeight = BigDecimal.ZERO;
        BigDecimal goodsNum = BigDecimal.ZERO;
        List oGoodsGroupList = (List)((Object)goodGroup.get(0));
        Map groupMap = (Map)oGoodsGroupList.get(0);
        pag = new DisPackageDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pag, (Object)disContractDomain);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".makeDisPackageDomain.e", (Throwable)e);
        }
        pag.setPackageName((String)groupMap.get("product_name"));
        Integer type = (Integer)groupMap.get("product_type");
        String goodsType = "0";
        if (1 == type) {
            goodsType = "5";
        } else if (2 == type) {
            goodsType = "6";
        } else if (3 == type) {
            goodsType = "7";
        }
        pag.setPackageType(goodsType);
        List<DisContractGoodsDomain> goodsList = this.makeDisContractGoodsDomain(goodGroup, pag, disContractDomain);
        goodsNum = goodsNum.add(pag.getGoodsNum());
        goodsWeight = goodsWeight.add(pag.getGoodsWeight());
        pag.setContractGoodsList(goodsList);
        rePagList.add(pag);
        disContractDomain.setGoodsNum(goodsNum);
        disContractDomain.setDataBnum(goodsNum);
        disContractDomain.setGoodsWeight(goodsWeight);
        disContractDomain.setDataBweight(goodsWeight);
        return rePagList;
    }

    private List<DisContractGoodsDomain> makeDisContractGoodsDomain(List<Map<String, Object>> items, DisPackageDomain disPackageDomain, DisContractDomain disContractDomain) {
        if (ListUtil.isEmpty(items)) {
            return null;
        }
        ArrayList<DisContractGoodsDomain> goodsDomainList = new ArrayList<DisContractGoodsDomain>();
        DisContractGoodsDomain disContractGoodsDomain = null;
        BigDecimal goodsMoney = BigDecimal.ZERO;
        BigDecimal goodsInmoney = BigDecimal.ZERO;
        BigDecimal goodsPef = BigDecimal.ZERO;
        BigDecimal packageGoodsWeight = BigDecimal.ZERO;
        BigDecimal packageGoodsNum = BigDecimal.ZERO;
        List map = (List)((Object)items.get(0));
        Map oGoodsItemCon = (Map)map.get(0);
        disContractGoodsDomain = new DisContractGoodsDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disContractGoodsDomain, (Object)disPackageDomain);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".makeDisContractGoodsDomain.e", (Throwable)e);
        }
        disContractGoodsDomain.setContractGoodsGtype(disPackageDomain.getPackageType());
        GoodsBean goodsBean = this.getResourceBySkuNo((String)oGoodsItemCon.get("custom_sku_id"), disContractDomain.getMemberCode(), disContractDomain.getMemberCcode(), disContractDomain.getChannelCode(), disContractDomain.getTenantCode());
        if (null != goodsBean && null != goodsBean.getRsSku()) {
            disContractGoodsDomain.setSkuCode(goodsBean.getRsSku().getSkuCode());
        }
        disContractGoodsDomain.setSkuNo((String)oGoodsItemCon.get("custom_sku_id"));
        disContractGoodsDomain.setSkuEocode(String.valueOf(oGoodsItemCon.get("custom_sku_id")));
        disContractGoodsDomain.setGoodsEocode(String.valueOf(oGoodsItemCon.get("baidu_product_id")));
        disContractGoodsDomain.setSkuName((String)oGoodsItemCon.get("product_name"));
        disContractGoodsDomain.setPricesetNprice(BigDecimal.valueOf(((Integer)oGoodsItemCon.get("product_price")).intValue()));
        disContractGoodsDomain.setContractGoodsPrice(BigDecimal.valueOf(((Integer)oGoodsItemCon.get("product_price")).intValue()));
        if (null == disContractGoodsDomain.getContractGoodsPrice() || disContractGoodsDomain.getContractGoodsPrice().compareTo(BigDecimal.ZERO) <= 0) {
            disContractGoodsDomain.setContractGoodsPrice(disContractGoodsDomain.getPricesetNprice());
        }
        BigDecimal goodsNum = new BigDecimal((Integer)oGoodsItemCon.get("product_amount"));
        disContractGoodsDomain.setGoodsCamount(goodsNum);
        disContractGoodsDomain.setGoodsNum(goodsNum);
        disContractGoodsDomain.setGoodsCweight(BigDecimal.ZERO);
        disContractGoodsDomain.setGoodsWeight(BigDecimal.ZERO);
        disContractGoodsDomain.setContractGoodsInmoney(disContractGoodsDomain.getPricesetNprice().multiply(goodsNum));
        disContractGoodsDomain.setContractGoodsMoney(disContractGoodsDomain.getContractGoodsPrice().multiply(goodsNum));
        disContractGoodsDomain.setGoodsProtins(null == oGoodsItemCon.get("product_features") ? null : JsonUtil.buildNormalBinder().toJson(oGoodsItemCon.get("product_features")));
        if (null == disContractGoodsDomain.getGoodsNum()) {
            disContractGoodsDomain.setGoodsNum(BigDecimal.ZERO);
        }
        packageGoodsNum = packageGoodsNum.add(disContractGoodsDomain.getGoodsNum());
        if (null == disContractGoodsDomain.getContractGoodsInmoney()) {
            disContractGoodsDomain.setContractGoodsInmoney(BigDecimal.ZERO);
        }
        goodsInmoney = goodsInmoney.add(disContractGoodsDomain.getContractGoodsInmoney());
        if (null == disContractGoodsDomain.getContractGoodsMoney()) {
            disContractGoodsDomain.setContractGoodsMoney(BigDecimal.ZERO);
        }
        goodsMoney = goodsMoney.add(disContractGoodsDomain.getContractGoodsMoney());
        if (null == disContractGoodsDomain.getContractGoodsPefinmoney()) {
            disContractGoodsDomain.setContractGoodsPefinmoney(BigDecimal.ZERO);
        }
        goodsPef = goodsPef.add(disContractGoodsDomain.getContractGoodsPefinmoney());
        if (null == disContractGoodsDomain.getGoodsWeight()) {
            disContractGoodsDomain.setGoodsWeight(BigDecimal.ZERO);
        }
        packageGoodsWeight = packageGoodsWeight.add(disContractGoodsDomain.getGoodsWeight());
        goodsDomainList.add(disContractGoodsDomain);
        disPackageDomain.setGoodsWeight(packageGoodsWeight);
        disPackageDomain.setGoodsNum(packageGoodsNum);
        disPackageDomain.setMemberBcode(disContractDomain.getMemberBcode());
        disPackageDomain.setMemberBname(disContractDomain.getMemberBname());
        disPackageDomain.setGoodsMoney(goodsInmoney);
        disPackageDomain.setPricesetRefrice(goodsPef);
        disPackageDomain.setGoodsPmoney(goodsMoney);
        return goodsDomainList;
    }

    private void setContractPro(DisContractDomain disContractDomain, String contractproKey, String contractproValue, String contractproName, String contractproValue1) {
        if (null == disContractDomain || StringUtils.isBlank((String)contractproKey) || StringUtils.isBlank((String)contractproValue) || StringUtils.isBlank((String)contractproName)) {
            return;
        }
        DisContractproDomain contractproDomain = new DisContractproDomain();
        contractproDomain.setContractproKey(contractproKey);
        contractproDomain.setContractproValue(contractproValue);
        contractproDomain.setContractproName(contractproName);
        contractproDomain.setContractproValue1(contractproValue1);
        this.setContractPro(disContractDomain, contractproDomain);
    }

    private void setContractPro(DisContractDomain disContractDomain, String contractproKey, String contractproValue, String contractproName) {
        this.setContractPro(disContractDomain, contractproKey, contractproValue, contractproName, null);
    }

    private void setContractPro(DisContractDomain disContractDomain, DisContractproDomain disContractproDomain) {
        if (null == disContractDomain || null == disContractproDomain) {
            return;
        }
        ArrayList<DisContractproDomain> disContractproDomainList = disContractDomain.getOcContractproDomainList();
        if (null == disContractproDomainList) {
            disContractproDomainList = new ArrayList<DisContractproDomain>();
            disContractDomain.setOcContractproDomainList(disContractproDomainList);
        }
        disContractproDomainList.add(disContractproDomain);
    }

    public Map<String, Object> buildOrderParam(Map<String, Object> map) {
        return map;
    }

    public String saveOrderParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        this.logger.error(this.SYS_CODE + ".saveOrderParam", (Object)("====" + sendhttpParam.toString() + "===" + param.toString() + "====" + configMap.toString()));
        HashMap source_order_id = new HashMap();
        Random rand = new Random(Integer.MAX_VALUE);
        int i = rand.nextInt(Integer.MAX_VALUE);
        String sourceId = String.valueOf(i);
        if (null == sendhttpParam) {
            this.logger.error(this.SYS_CODE + ".saveOrderParam param is null");
            return DisOrderServiceImpl.beResult(0, "success", sourceId, "resp.order.create", configMap.get("sign"), configMap.get("source"), configMap.get("ticket"), Integer.valueOf(DisOrderServiceImpl.create_timestamp()), configMap.get("version"), configMap);
        }
        if (null == sendhttpParam.get("cmd")) {
            return DisOrderServiceImpl.beResult(0, "success", sourceId, "resp.order.create", configMap.get("sign"), configMap.get("source"), configMap.get("ticket"), Integer.valueOf(DisOrderServiceImpl.create_timestamp()), configMap.get("version"), configMap);
        }
        String cmd = (String)sendhttpParam.get("cmd");
        String sign = configMap.get("sign");
        String ticket = configMap.get("ticket");
        String source = configMap.get("source");
        String version = (String)sendhttpParam.get("version");
        if ("order.create".equals(cmd)) {
            Map bodyMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap((String)sendhttpParam.get("body"), String.class, Object.class);
            if (MapUtil.isEmpty((Map)bodyMap)) {
                this.logger.error(this.SYS_CODE + ".saveOrderParam.bodyMap.create", (Object)sendhttpParam.toString());
                return DisOrderServiceImpl.beResult(-1, "false", sourceId, "resp." + cmd, sign, source, ticket, Integer.valueOf(DisOrderServiceImpl.create_timestamp()), version, configMap);
            }
            String orderId = (String)bodyMap.get("order_id");
            DisContractDomain disContractDomain = this.getSendOrder(orderId, (String)sendhttpParam.get("memberCode"), (String)sendhttpParam.get("tenantCode"));
            if (null == disContractDomain) {
                this.logger.error(this.SYS_CODE + ".saveOrderParam.disContractDomain is null");
                return DisOrderServiceImpl.beResult(-1, "false", sourceId, "resp." + cmd, sign, source, ticket, Integer.valueOf(DisOrderServiceImpl.create_timestamp()), version, configMap);
            }
            ArrayList<DisContractDomain> disContractList = new ArrayList<DisContractDomain>();
            disContractList.add(disContractDomain);
            try {
                this.saveOrder(disContractList, disChannel);
            }
            catch (Exception e) {
                this.logger.error(this.SYS_CODE + ".saveOrderParam.saveOrder", (Throwable)e);
            }
            return DisOrderServiceImpl.beResult(0, "success", sourceId, "resp." + cmd, sign, source, ticket, Integer.valueOf(DisOrderServiceImpl.create_timestamp()), version, configMap);
        }
        if ("order.status.push".equals(cmd)) {
            Map bodyMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap((String)sendhttpParam.get("body"), String.class, Object.class);
            if (MapUtil.isEmpty((Map)bodyMap)) {
                this.logger.error(this.SYS_CODE + ".saveOrderParam.bodyMap.order.status.push", (Object)sendhttpParam.toString());
                return DisOrderServiceImpl.beResult(-1, "false", sourceId, "resp." + cmd, sign, source, ticket, Integer.valueOf(DisOrderServiceImpl.create_timestamp()), version, configMap);
            }
            String orderId = (String)bodyMap.get("order_id");
            String status = (String)bodyMap.get("status");
            String dataStateStr = this.getOrderState(disChannel.getTenantCode(), disChannel.getChannelCode(), status);
            if (StringUtils.isBlank((String)dataStateStr) || "null".equals(dataStateStr)) {
                dataStateStr = String.valueOf(status);
            }
            Integer dataState = Integer.valueOf(dataStateStr);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("dataStatestr", status);
            try {
                this.updateOrder(disChannel.getTenantCode(), orderId, dataState, null, map, disChannel);
            }
            catch (Exception e) {
                this.logger.error(this.SYS_CODE + ".updateOrder000 result is error", (Throwable)e);
            }
            return DisOrderServiceImpl.beResult(0, "success", sourceId, "resp." + cmd, sign, source, ticket, Integer.valueOf(DisOrderServiceImpl.create_timestamp()), version, configMap);
        }
        return DisOrderServiceImpl.beResult(0, "success", sourceId, "resp." + cmd, sign, source, ticket, Integer.valueOf(DisOrderServiceImpl.create_timestamp()), version, configMap);
    }

    private static String create_timestamp() {
        return Long.toString(System.currentTimeMillis() / 1000L);
    }

    protected String createUUIDString() {
        return UUID.randomUUID().toString();
    }

    private static String beResult(Integer errno, String error, String sourceOrderId, String cmd, String sign, String source, String ticket, Integer timestamp, String version, Map<String, String> configMap) {
        String result = "{\"body\":{\"errno\":" + errno + ",\"error\":" + '\"' + error + '\"' + ",\"data\":" + "{\"source_order_id\":" + '\"' + sourceOrderId + '\"' + "}" + "}" + "," + "\"cmd\":" + '\"' + cmd + '\"' + ",\"sign\":\"" + sign + "\"," + "\"source\":" + '\"' + source + '\"' + ",\"ticket\":" + '\"' + ticket + '\"' + ",\"timestamp\":" + timestamp + ",\"version\":" + '\"' + version + '\"' + "}";
        Map jsonToMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(result, String.class, Object.class);
        HashMap<String, Object> needSign = new HashMap<String, Object>();
        if (null != jsonToMap.get("body")) {
            Map body = (Map)jsonToMap.get("body");
            String cmdStr = (String)jsonToMap.get("cmd");
            needSign.put("cmd", cmdStr);
            needSign.put("body", JsonUtil.buildNormalBinder().toJson((Object)body));
            String msg = DisOrderServiceImpl.signOrder(needSign, configMap);
            jsonToMap.put("sign", msg);
            jsonToMap.put("encrypt", "");
        }
        String s = JsonUtil.buildNormalBinder().toJson((Object)jsonToMap);
        return s;
    }

    public static String signOrder(Map<String, Object> paramMap, Map<String, String> configMap) {
        if (MapUtil.isEmpty(paramMap) || MapUtil.isEmpty(configMap)) {
            return "ERROR";
        }
        return SignUtil.getSign(paramMap);
    }
}

