/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.be.goods.service;

import com.yqbsoft.laser.service.ext.channel.be.BeConstants;
import com.yqbsoft.laser.service.ext.channel.be.service.HttpRequestUtil;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisChannel;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisChannelApiparam;
import com.yqbsoft.laser.service.ext.channel.discom.domain.RsGoodsClassDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.RsGoodsFileDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.RsResourceGoodsReDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.RsSkuDomain;
import com.yqbsoft.laser.service.ext.channel.discom.service.DisGoodsBaseService;
import com.yqbsoft.laser.service.tool.codec.Base64;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.HashedMap;

public class DisGoodsServiceImpl
extends DisGoodsBaseService {
    private String SYS_CODE = "be.DisGoodsServiceImpl";

    protected String getChannelCode() {
        return BeConstants.channelCode;
    }

    public Map<String, Object> buildComGoodsClassParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        if (MapUtil.isEmpty(sendParam) || MapUtil.isEmpty(configMap) || null == disChannel) {
            return null;
        }
        if (MapUtil.isEmpty(param)) {
            return null;
        }
        List apiparamList = (List)param.get("apiparamList");
        if (ListUtil.isEmpty((Collection)apiparamList)) {
            return sendParam;
        }
        sendParam.put("timestamp", new Date().getTime() / 1000L);
        HashMap<String, Object> body = new HashMap<String, Object>();
        for (DisChannelApiparam disChannelApiparam : apiparamList) {
            if (("cmc.disGoods.saveSendGoodsClass".equals(channelApiCode) || "cmc.disGoods.updateSendGoodsClass".equals(channelApiCode)) && "parentId".equals(disChannelApiparam.getChannelApiparamKey())) {
                String parentId = (String)sendParam.remove(disChannelApiparam.getChannelApiparamKey());
                String elmParentId = this.getCategoryId((String)param.get("tenantCode"), (String)param.get("channelCode"), parentId);
                body.put(disChannelApiparam.getChannelApiparamKey(), elmParentId);
                continue;
            }
            body.put(disChannelApiparam.getChannelApiparamKey(), sendParam.remove(disChannelApiparam.getChannelApiparamKey()));
        }
        sendParam.put("body", JsonUtil.buildNormalBinder().toJson(body));
        return sendParam;
    }

    public String sendComSaveGoodsClass(String channelApiCode, DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        if (null == disChannel || null == sendhttpParam || null == configMap) {
            return "ERROR";
        }
        String url = configMap.get(BeConstants.serviceUrl);
        if (StringUtils.isBlank((String)url)) {
            this.logger.error(this.SYS_CODE + ".sendComSaveGoodsClass.url", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        String json = HttpRequestUtil.sendPost(url, sendhttpParam);
        if (StringUtils.isBlank((String)json)) {
            this.logger.error(this.SYS_CODE + ".sendStoreEndParam.json", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        Map<String, Object> beResult = this.make(json);
        if (null == beResult) {
            return json;
        }
        if (null != beResult.get("error") && !beResult.get("error").equals("success")) {
            if ("cmc.disGoods.saveSendGoodsClass".equals(channelApiCode)) {
                this.getSendGoodsClass(param, (String)param.get("memberCode"), (String)param.get("tenantCode"));
            }
            return (String)beResult.get("error");
        }
        if ("cmc.disGoods.saveSendGoodsClass".equals(channelApiCode)) {
            Map data = (Map)beResult.get("data");
            String id = (String)data.get("category_id");
            this.saveClassDictionary(disChannel, (String)param.get("memberCode"), ((RsGoodsClassDomain)param.get("rsGoodsClassDomain")).getGoodsClassCode(), id, (String)param.get("tenantCode"));
        }
        if ("cmc.disGoods.getSendGoodsClass".equals(channelApiCode)) {
            RsGoodsClassDomain rsGoodsClassDomain = (RsGoodsClassDomain)param.get("rsGoodsClassDomain");
            Map reMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(json, String.class, Object.class);
            if (MapUtil.isEmpty((Map)reMap)) {
                return "ERROR";
            }
            if (null == beResult) {
                return "ERROR";
            }
            if (null != beResult.get("error") && !beResult.get("error").equals("success")) {
                return (String)beResult.get("error");
            }
            Map dataMap = (Map)beResult.get("data");
            if (MapUtil.isEmpty((Map)dataMap)) {
                return null;
            }
            List categorysList = (List)dataMap.get("categorys");
            HashedMap mtClass = new HashedMap();
            for (Map valMap : categorysList) {
                if (StringUtils.isBlank((String)((String)valMap.get("category_id")))) continue;
                mtClass.put((String)valMap.get("name"), (String)valMap.get("category_id"));
                List childClass = new ArrayList();
                childClass = (List)valMap.get("children");
                if (!ListUtil.isNotEmpty(childClass)) continue;
                for (Map childMap : childClass) {
                    if (StringUtils.isBlank((String)((String)childMap.get("category_id")))) continue;
                    mtClass.put((String)childMap.get("name"), (String)childMap.get("category_id"));
                }
            }
            if (null != rsGoodsClassDomain && StringUtils.isNotBlank((String)rsGoodsClassDomain.getGoodsClassCode()) && mtClass.containsKey(rsGoodsClassDomain.getGoodsClassName())) {
                this.saveClassDictionary(disChannel, (String)param.get("memberCode"), rsGoodsClassDomain.getGoodsClassCode(), (String)mtClass.get(rsGoodsClassDomain.getGoodsClassName()), (String)param.get("tenantCode"));
            }
        }
        return "SUCCESS";
    }

    private Map<String, Object> make(String json) {
        if (StringUtils.isBlank((String)json)) {
            this.logger.error(this.SYS_CODE + ".make.json");
            return null;
        }
        Map data = (Map)JsonUtil.buildNormalBinder().getJsonToMap(json, String.class, Object.class);
        Map beResult = (Map)data.get("body");
        if (null == beResult) {
            return null;
        }
        return beResult;
    }

    private void makeSku(DisChannel disChannel, RsSkuDomain rsSkuDomain, boolean check, Map<String, Object> body) {
        if (null == disChannel || null == rsSkuDomain || MapUtil.isEmpty(body)) {
            return;
        }
        DecimalFormat formatter = new DecimalFormat("#");
        if (check) {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("skuCode", rsSkuDomain.getSkuCode());
            param.put("skuNo", rsSkuDomain.getSkuNo());
            String reust = this.getSendGoods(param, StringUtils.isBlank((String)rsSkuDomain.getMemberCcode()) ? rsSkuDomain.getMemberCode() : rsSkuDomain.getMemberCcode(), rsSkuDomain.getTenantCode());
            if (StringUtils.isNotBlank((String)reust) && "SUCCESS".equals(reust)) {
                this.logger.error(this.SYS_CODE + ".makeSku.checkexist", (Object)((Object)param).toString());
                return;
            }
        }
        body.put("name", StringUtils.isBlank((String)rsSkuDomain.getGoodsShowname()) ? rsSkuDomain.getGoodsName() : rsSkuDomain.getGoodsShowname());
        List<Map<String, Object>> imageList = this.createImageList(disChannel, rsSkuDomain.getRsGoodsFileDomainList(), rsSkuDomain.getDataPic());
        if (ListUtil.isNotEmpty(imageList)) {
            body.put("photos", imageList);
        } else {
            imageList = new ArrayList<Map<String, Object>>();
            HashedMap imgMap = new HashedMap();
            imgMap.put("url", "https://img-star.elemecdn.com/pb/4ceb8ec360a4b6d316637e5e07637d1147");
            imgMap.put("is_master", 1);
            imageList.add((Map<String, Object>)imgMap);
            body.put("photos", imageList);
        }
        body.put("upc", rsSkuDomain.getSkuBarcode());
        BigDecimal price = rsSkuDomain.getPricesetNprice() == null ? BigDecimal.ZERO : rsSkuDomain.getPricesetNprice();
        BigDecimal supplyNum = rsSkuDomain.getGoodsSupplynum() == null ? BigDecimal.ZERO : rsSkuDomain.getGoodsSupplynum();
        BigDecimal supplyWeight = rsSkuDomain.getGoodsSupplyweight() == null ? BigDecimal.ZERO : rsSkuDomain.getGoodsSupplyweight();
        body.put("sale_price", formatter.format(price));
        if (rsSkuDomain.getPricesetMakeprice() != null) {
            body.put("market_price", formatter.format(rsSkuDomain.getPricesetMakeprice()));
        }
        body.put("left_num", formatter.format(supplyNum));
        body.put("weight", formatter.format(supplyWeight));
        String desc = rsSkuDomain.getSkuRemark();
        if (StringUtils.isNotBlank((String)desc)) {
            body.put("desc", desc);
        }
        body.put("custom_sku_id", rsSkuDomain.getSkuNo());
        if (null != rsSkuDomain.getGoodsMinnum()) {
            body.put("minimum", rsSkuDomain.getGoodsMinnum());
        }
        body.put("status", 0);
        if (null != rsSkuDomain.getDataOpbillstate()) {
            body.put("status", rsSkuDomain.getDataOpbillstate());
        }
    }

    private List<Map<String, Object>> createImageList(DisChannel disChannel, List<RsGoodsFileDomain> rsGoodsFileDomainList, String imagePath) {
        if (ListUtil.isEmpty(rsGoodsFileDomainList)) {
            return null;
        }
        ArrayList<Map<String, Object>> imageList = new ArrayList<Map<String, Object>>();
        HashedMap imageMap = new HashedMap();
        String code = "";
        for (RsGoodsFileDomain rsGoodsFileDomain : rsGoodsFileDomainList) {
            code = this.getFileOcode(disChannel, rsGoodsFileDomain.getGoodsFileName(), this.getChannelCode(), rsGoodsFileDomain.getTenantCode());
            if (StringUtils.isNotBlank((String)code)) {
                imageMap.put("url", code);
                imageMap.put("is_master", 0);
                if (rsGoodsFileDomain.getGoodsFileUrl().equals(imagePath)) {
                    imageMap.put("is_master", 1);
                }
            }
            imageList.add((Map<String, Object>)imageMap);
        }
        return imageList;
    }

    private void createGoods(DisChannel disChannel, RsResourceGoodsReDomain rsResourceGoodsReDomain, boolean check, Map<String, Object> body) {
        if (null == disChannel || null == rsResourceGoodsReDomain || ListUtil.isEmpty((Collection)rsResourceGoodsReDomain.getRsSkuDomainList()) || MapUtil.isEmpty(body)) {
            return;
        }
        for (RsSkuDomain rsSkuDomain : rsResourceGoodsReDomain.getRsSkuDomainList()) {
            this.makeSku(disChannel, rsSkuDomain, check, body);
        }
    }

    public Map<String, Object> buildComGoodsParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        sendParam.put("timestamp", new Date().getTime() / 1000L);
        DecimalFormat formatter = new DecimalFormat("#");
        HashMap<String, Object> body = new HashMap<String, Object>();
        List apiparamList = (List)param.get("apiparamList");
        if (ListUtil.isEmpty((Collection)apiparamList)) {
            return sendParam;
        }
        for (DisChannelApiparam disChannelApiparam : apiparamList) {
            body.put(disChannelApiparam.getChannelApiparamKey(), sendParam.remove(disChannelApiparam.getChannelApiparamKey()));
        }
        if ("cmc.disGoods.uploadImage".equals(channelApiCode)) {
            if (null == body.get("data")) {
                return null;
            }
            String images = Base64.encodeBase64String((byte[])((byte[])body.get("data")));
            try {
                images = URLDecoder.decode(images, "utf-8");
            }
            catch (Exception e) {
                this.logger.error(this.SYS_CODE + ".buildComGoodsParam.uploadImage.images", (Throwable)e);
                return null;
            }
            body.put("data", images);
        } else if ("cmc.disGoods.saveSendGoods".equals(channelApiCode) || "cmc.disGoods.updateSendGoods".equals(channelApiCode)) {
            RsResourceGoodsReDomain rsResourceGoodsReDomain = (RsResourceGoodsReDomain)param.get("rsResourceGoodsReDomain");
            boolean check = true;
            if ("cmc.disGoods.updateSendGoods".equals(channelApiCode)) {
                check = false;
            }
            this.createGoods(disChannel, rsResourceGoodsReDomain, check, body);
            if ("cmc.disGoods.updateSendGoods".equals(channelApiCode) && StringUtils.isBlank((String)((String)body.get("custom_sku_id")))) {
                body.put("sku_id", rsResourceGoodsReDomain.getGoodsEocode());
            }
            body.put("category_id", param.get("categoryId"));
        } else if ("cmc.disGoods.saveSendSku".equals(channelApiCode) || "cmc.disGoods.updateSendSku".equals(channelApiCode)) {
            RsSkuDomain rsSkuDomain = (RsSkuDomain)param.get("rsSkuDomain");
            if (null == rsSkuDomain) {
                this.logger.error(this.SYS_CODE + ".buildComGoodsParam.rsSkuDomain.isNull \uff1a ", (Object)param.toString());
                return null;
            }
            String categoryId = (String)param.get("categoryId");
            if (StringUtils.isBlank((String)categoryId) && StringUtils.isBlank((String)(categoryId = this.getCategoryId(disChannel.getTenantCode(), disChannel.getChannelCode(), rsSkuDomain.getClasstreeShopcode())))) {
                this.logger.error(this.SYS_CODE + ".buildComGoodsParam.categoryId is null \uff1a ", (Object)param.toString());
                return null;
            }
            boolean check = true;
            if ("cmc.disGoods.updateSendSku".equals(channelApiCode)) {
                check = false;
                body.put("custom_sku_id", rsSkuDomain.getSkuEocode());
            }
            this.makeSku(disChannel, rsSkuDomain, check, body);
            body.put("category_id", categoryId);
        } else if ("cmc.disGoods.getSendGoods".equals(channelApiCode)) {
            body.put("shop_id", param.get("shoppingId"));
            body.put("custom_sku_id", param.get("skuNo"));
        } else if (!"cmc.disGoods.getSendGoodsClass".equals(channelApiCode)) {
            String str;
            String skuId;
            String key;
            if ("cmc.disGoods.updateSendSkuNum".equals(channelApiCode)) {
                if (null == param.get("goodsSupplynum") || null == param.get("skuEocode")) {
                    this.logger.error(this.SYS_CODE + ".buildComGoodsParam.goodsSupplynum", (Object)param.toString());
                }
                key = "skuid_stocks";
                String string = skuId = null == (String)param.get("goodsEocode") ? "0" : (String)param.get("skuEocode");
                if (StringUtils.isBlank((String)skuId) || skuId.equals("0")) {
                    key = "custom_sku_id";
                    skuId = (String)param.get("skuNo");
                }
                skuId = skuId + ":" + param.get("goodsSupplynum");
                body.put(key, skuId);
            } else if ("cmc.disGoods.updateSendSkuPrice".equals(channelApiCode)) {
                key = "skuid_price";
                String string = skuId = null == (String)param.get("goodsEocode") ? "0" : (String)param.get("skuEocode");
                if (StringUtils.isBlank((String)skuId) || skuId.equals("0")) {
                    key = "custom_sku_id";
                    skuId = (String)param.get("skuNo");
                }
                String nPrice = null == param.get("pricesetNprice") ? "0" : param.get("pricesetNprice").toString();
                String price = formatter.format(new BigDecimal(Double.parseDouble(nPrice)).multiply(BigDecimal.valueOf(100L)));
                skuId = skuId + ":" + price;
                body.put(key, skuId);
            } else if ("cmc.disGoods.updateSendSkuUp".equals(channelApiCode) || "cmc.disGoods.updateSendGoodsUp".equals(channelApiCode)) {
                str = this.batchSku(param);
                body.put("custom_sku_id", str);
            } else if ("cmc.disGoods.updateSendSkuDow".equals(channelApiCode) || "cmc.disGoods.updateSendGoodsDow".equals(channelApiCode)) {
                str = this.batchSku(param);
                body.put("custom_sku_id", str);
            } else if ("cmc.disGoods.delSendSku".equals(channelApiCode)) {
                sendParam.put("custom_sku_id", param.get("skuNo"));
            } else if ("cmc.disGoods.delSendGoods".equals(channelApiCode)) {
                sendParam.put("custom_sku_id", param.get("skuNo"));
            }
        }
        sendParam.put("body", JsonUtil.buildNormalBinder().toJson(body));
        return sendParam;
    }

    private String batchSku(Map<String, Object> param) {
        List skuList = (List)param.get("skuNoList");
        String str = "";
        if (ListUtil.isNotEmpty((Collection)skuList)) {
            for (String sku : skuList) {
                str = str + sku + ",";
            }
            str = str.substring(0, str.length() - 1);
        } else {
            str = (String)param.get("skuNo");
        }
        return str;
    }

    public String sendComSaveGoods(String channelApiCode, DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        String skuId;
        Map dataMap;
        if ("cmc.disGoods.saveSendGoods".equals(channelApiCode) && MapUtil.isEmpty(sendhttpParam)) {
            return "SUCCESS";
        }
        if (null == disChannel || null == sendhttpParam || null == configMap) {
            return "ERROR";
        }
        String url = configMap.get(BeConstants.serviceUrl);
        if (StringUtils.isBlank((String)url)) {
            this.logger.error(this.SYS_CODE + ".sendComSaveGoods.url", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        String json = HttpRequestUtil.sendPost(url, sendhttpParam);
        if (StringUtils.isBlank((String)json)) {
            this.logger.error(this.SYS_CODE + ".sendComSaveGoods.json", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        if ("cmc.disGoods.uploadImage".equals(channelApiCode)) {
            Map<String, Object> beResult = this.make(json);
            if (null == beResult) {
                return "ERROR";
            }
            if (null != beResult.get("error") && !beResult.get("error").equals("success")) {
                return (String)beResult.get("error");
            }
            Map dataMap2 = (Map)beResult.get("data");
            String code = (String)dataMap2.get("url");
            return code;
        }
        Map<String, Object> beResult = this.make(json);
        if (null == beResult) {
            return "ERROR";
        }
        if (null != beResult.get("error") && !beResult.get("error").equals("success")) {
            this.logger.error(this.SYS_CODE + ".sendComSaveGoods.beResult", (Object)((String)beResult.get("error") + "=" + url + ":" + JsonUtil.buildNormalBinder().toJson(sendhttpParam) + ":" + configMap.toString()));
            return (String)beResult.get("error");
        }
        if ("cmc.disGoods.getSendGoods".equals(channelApiCode)) {
            if (MapUtil.isEmpty((Map)((Map)beResult.get("data")))) {
                return "ERROR";
            }
            return "SUCCESS";
        }
        if ("cmc.disGoods.saveSendGoods".equals(channelApiCode)) {
            RsResourceGoodsReDomain rsResourceGoodsReDomain = (RsResourceGoodsReDomain)param.get("rsResourceGoodsReDomain");
            if (null == rsResourceGoodsReDomain) {
                this.logger.error(this.SYS_CODE + ".sendComSaveGoods.rsResourceGoodsReDomain", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                return "ERROR";
            }
            dataMap = (Map)beResult.get("data");
            skuId = (String)dataMap.get("sku_id");
            this.saveGoods(disChannel, disChannel.getChannelCode(), rsResourceGoodsReDomain.getGoodsNo(), rsResourceGoodsReDomain.getGoodsCode(), skuId, rsResourceGoodsReDomain.getTenantCode(), (String)param.get("memberCode"));
            this.saveSku(disChannel, disChannel.getChannelCode(), rsResourceGoodsReDomain.getGoodsNo(), null, skuId, rsResourceGoodsReDomain.getTenantCode(), (String)param.get("memberCode"));
        }
        if ("cmc.disGoods.saveSendSku".equals(channelApiCode)) {
            RsSkuDomain rsSkuDomain = (RsSkuDomain)param.get("rsSkuDomain");
            if (null == rsSkuDomain) {
                this.logger.error(this.SYS_CODE + ".sendComSaveGoods.rsSkuDomain", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                return "ERROR";
            }
            dataMap = (Map)beResult.get("data");
            skuId = (String)dataMap.get("sku_id");
            this.saveSku(disChannel, disChannel.getChannelCode(), rsSkuDomain.getSkuNo(), rsSkuDomain.getSkuCode(), skuId, rsSkuDomain.getTenantCode(), (String)param.get("memberCode"));
        }
        return "SUCCESS";
    }

    public static void main(String[] args) {
        DecimalFormat formatter = new DecimalFormat("#");
        System.out.println(formatter.format(BigDecimal.TEN));
    }
}

