/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.be.service;

import com.yqbsoft.laser.service.tool.util.MD5Util;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class SignUtil {
    public static String getSign(Map<String, Object> data) {
        TreeMap<String, Object> arr = new TreeMap<String, Object>();
        arr.put("body", data.get("body"));
        arr.put("cmd", data.get("cmd"));
        arr.put("encrypt", "");
        arr.put("secret", data.get("secret"));
        arr.put("source", data.get("source"));
        String timestamp = String.valueOf(data.get("timestamp"));
        String ticket = String.valueOf(data.get("ticket")).toUpperCase();
        if (StringUtils.isBlank((String)timestamp) || timestamp.equals("null")) {
            timestamp = String.valueOf(new Date().getTime() / 1000L);
        }
        if (StringUtils.isBlank((String)ticket)) {
            ticket = SignUtil.buildTicket(timestamp);
        }
        arr.put("ticket", ticket);
        arr.put("timestamp", timestamp);
        arr.put("version", data.get("version"));
        StringBuilder strSignTmp = new StringBuilder("");
        Iterator it = arr.keySet().iterator();
        while (it.hasNext()) {
            String key = it.next().toString();
            strSignTmp.append(key + "=" + arr.get(key) + "&");
        }
        String strSign = strSignTmp.toString().substring(0, strSignTmp.length() - 1);
        String sign = SignUtil.getMD5(strSign.toString());
        return sign;
    }

    public static String getMD5(String input) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] messageDigest = md.digest(input.getBytes());
            BigInteger number = new BigInteger(1, messageDigest);
            String hashtext = number.toString(16);
            while (hashtext.length() < 32) {
                hashtext = "0" + hashtext;
            }
            return hashtext.toUpperCase();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String buildTicket(String timestamp) {
        String md5Str = MD5Util.generate32md5((String)timestamp);
        StringBuilder stringBuilder = new StringBuilder(md5Str);
        stringBuilder.insert(20, "-");
        stringBuilder.insert(16, "-");
        stringBuilder.insert(12, "-");
        stringBuilder.insert(8, "-");
        return stringBuilder.toString().toUpperCase();
    }
}

