/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.be.oauth.service;

import com.yqbsoft.laser.service.ext.channel.be.BeConstants;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisChannel;
import com.yqbsoft.laser.service.ext.channel.discom.domain.OauthBean;
import com.yqbsoft.laser.service.ext.channel.discom.service.DisOauthBaseServiceImpl;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.tool.util.WebUtils;
import java.util.HashMap;
import java.util.Map;

public class DisOauthServiceImpl
extends DisOauthBaseServiceImpl {
    private String SYS_CODE = "be.DisOauthServiceImpl";

    private String saveDisToken(DisChannel disChannel, String json, String memberCode) {
        if (StringUtils.isBlank((String)json) || null == disChannel) {
            this.logger.error(this.SYS_CODE + ".saveDisToken.json");
            return "error";
        }
        OauthBean oauthBean = (OauthBean)JsonUtil.buildNormalBinder().getJsonToObject(json, OauthBean.class);
        if (null == oauthBean) {
            this.logger.error(this.SYS_CODE + ".saveDisToken.oauthBean", (Object)(json + ":" + disChannel.getChannelCode() + ":" + disChannel.getMemberCode() + ":" + disChannel.getTenantCode()));
            return "error";
        }
        if (null == oauthBean.getExpires_in()) {
            oauthBean.setExpires_in(Integer.valueOf(0));
        }
        oauthBean.setExpires_in(Integer.valueOf(oauthBean.getExpires_in() * 1000));
        return this.saveDisToken(disChannel, oauthBean, memberCode);
    }

    public String sendGetToken(DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        if (null == disChannel || MapUtil.isEmpty(sendParam) || MapUtil.isEmpty(configMap) || MapUtil.isEmpty(param)) {
            this.logger.error(this.SYS_CODE + ".sendGetToken.param");
            return "error";
        }
        String json = null;
        String url = configMap.get(BeConstants.serviceUrl);
        String authorization = this.getAuthorization(configMap);
        HashMap<String, String> httpParam = new HashMap<String, String>();
        if (MapUtil.isNotEmpty(sendParam)) {
            for (String key : sendParam.keySet()) {
                httpParam.put(key, String.valueOf(sendParam.get(key)));
            }
        }
        try {
            json = WebUtils.doPost((String)url, httpParam, (int)30000, (int)30000, (String)authorization);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".sendGetToken.e", (Object)(url + ":" + sendParam.toString() + ":" + configMap.toString()), (Throwable)e);
            return "error";
        }
        if (StringUtils.isBlank((String)json)) {
            this.logger.error(this.SYS_CODE + ".sendGetToken.json", (Object)(url + ":" + sendParam.toString() + ":" + configMap.toString()));
            return "error";
        }
        String memberCode = (String)param.get("memberCode");
        return this.saveDisToken(disChannel, json, memberCode);
    }

    public String sendReflashToken(DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        if (null == disChannel || MapUtil.isEmpty(sendParam) || MapUtil.isEmpty(configMap) || MapUtil.isEmpty(param)) {
            this.logger.error(this.SYS_CODE + ".sendReflashToken.param");
            return "error";
        }
        String json = null;
        String url = configMap.get(BeConstants.serviceUrl);
        String authorization = this.getAuthorization(configMap);
        HashMap<String, String> httpParam = new HashMap<String, String>();
        if (MapUtil.isNotEmpty(sendParam)) {
            for (String key : sendParam.keySet()) {
                httpParam.put(key, String.valueOf(sendParam.get(key)));
            }
        }
        try {
            json = WebUtils.doPost((String)url, httpParam, (int)30000, (int)30000, (String)authorization);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".sendReflashToken.e", (Object)(url + ":" + sendParam.toString() + ":" + configMap.toString() + ":" + authorization), (Throwable)e);
            return "error";
        }
        if (StringUtils.isBlank((String)json)) {
            this.logger.error(this.SYS_CODE + ".sendReflashToken.json", (Object)(url + ":" + sendParam.toString() + ":" + configMap.toString()));
            return "error";
        }
        String memberCode = (String)param.get("memberCode");
        return this.saveDisToken(disChannel, json, memberCode);
    }

    public void befAppentParam(DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap) {
    }

    public Map<String, Object> sendGetTokenParam(Map<String, Object> map) {
        return map;
    }

    protected String getChannelCode() {
        return BeConstants.channelCode;
    }
}

