/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.ceb.util;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.tool.json.JSONArray;
import com.yqbsoft.laser.service.tool.json.JSONObject;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.springframework.util.FileCopyUtils;

public class XmlUtils {
    public static String readFile(String path) throws Exception {
        File file = new File(path);
        FileInputStream fis = new FileInputStream(file);
        FileChannel fc = fis.getChannel();
        ByteBuffer bb = ByteBuffer.allocate(new Long(file.length()).intValue());
        fc.read(bb);
        bb.flip();
        String str = new String(bb.array(), "UTF8");
        fc.close();
        fis.close();
        return str;
    }

    public static JSONObject xml2Json(String xmlStr) throws DocumentException {
        Document doc = DocumentHelper.parseText((String)xmlStr);
        JSONObject json = new JSONObject();
        XmlUtils.dom4j2Json(doc.getRootElement(), json);
        return json;
    }

    public static void dom4j2Json(Element element, JSONObject json) {
        for (Object o : element.attributes()) {
            Attribute attr = (Attribute)o;
            if (XmlUtils.isEmpty(attr.getValue())) continue;
        }
        List chdEl = element.elements();
        if (chdEl.isEmpty() && !XmlUtils.isEmpty(element.getText())) {
            json.put(element.getName(), (Object)element.getText());
        }
        for (Element e : chdEl) {
            if (!e.elements().isEmpty()) {
                JSONObject chdjson = new JSONObject();
                XmlUtils.dom4j2Json(e, chdjson);
                Object o = json.get((Object)e.getName());
                if (o != null) {
                    JSONArray jsona = null;
                    if (o instanceof JSONObject) {
                        JSONObject jsono = (JSONObject)o;
                        json.remove((Object)e.getName());
                        jsona = new JSONArray();
                        jsona.add(jsono);
                        jsona.add(chdjson);
                    }
                    if (o instanceof JSONArray) {
                        jsona = (JSONArray)o;
                        jsona.add(chdjson);
                    }
                    json.put(e.getName(), (Object)jsona);
                    continue;
                }
                if (chdjson.isEmpty()) continue;
                json.put(e.getName(), (Object)chdjson);
                continue;
            }
            for (Object o : element.attributes()) {
                Attribute attr = (Attribute)o;
                if (XmlUtils.isEmpty(attr.getValue())) continue;
            }
            if (e.getText().isEmpty()) continue;
            if (null != e.attributes() && 0 < e.attributes().size()) {
                Attribute attr = (Attribute)e.attributes().get(0);
                json.put(attr.getValue(), (Object)e.getText());
                continue;
            }
            json.put(e.getName(), (Object)e.getText());
        }
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().isEmpty() || "null".equals(str);
    }

    public static byte[] createXmlFile(String xml, String xmlName) {
        File file1;
        String path = Thread.currentThread().getContextClassLoader().getResource("").getPath() + "/temp";
        File file = new File(path);
        if (!file.exists()) {
            file.mkdir();
        }
        if (!(file1 = new File(path = path + "/" + xmlName + ".xml")).exists()) {
            try {
                boolean newFile = file1.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            FileOutputStream fops = new FileOutputStream(file1);
            fops.write(xml.getBytes());
            fops.flush();
            fops.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        byte[] bytes = null;
        try {
            bytes = XmlUtils.InputStreamByteArray(path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        file1.delete();
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] InputStreamByteArray(String filePath) throws IOException {
        FileInputStream in = null;
        try {
            byte[] data;
            in = new FileInputStream(filePath);
            byte[] byArray = data = XmlUtils.toByteArray(in);
            return byArray;
        }
        finally {
            if (null != in) {
                ((InputStream)in).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(InputStream in) throws IOException {
        ByteArrayOutputStream out = null;
        try {
            out = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            int n = 0;
            while ((n = in.read(buffer)) != -1) {
                out.write(buffer, 0, n);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            if (null != out) {
                out.close();
            }
        }
    }

    public static byte[] fileToBinArray(File file) {
        try {
            FileInputStream fis = new FileInputStream(file);
            byte[] bytes = FileCopyUtils.copyToByteArray((InputStream)fis);
            return bytes;
        }
        catch (Exception ex) {
            throw new RuntimeException("transform file into bin Array \u51fa\u9519", ex);
        }
    }

    public static String fileToBinStr(File file) {
        try {
            FileInputStream fis = new FileInputStream(file);
            byte[] bytes = FileCopyUtils.copyToByteArray((InputStream)fis);
            return new String(bytes, "ISO-8859-1");
        }
        catch (Exception ex) {
            throw new RuntimeException("transform file into bin String \u51fa\u9519", ex);
        }
    }

    public static File binToFile(String bin, String fileName, String parentPath) {
        try {
            File fout = new File(parentPath, fileName);
            fout.createNewFile();
            byte[] bytes1 = bin.getBytes("ISO-8859-1");
            FileCopyUtils.copy((byte[])bytes1, (File)fout);
            return fout;
        }
        catch (Exception ex) {
            throw new RuntimeException("transform bin into File \u51fa\u9519", ex);
        }
    }

    public static byte[] getFileToByte(File file) {
        byte[] by = new byte[(int)file.length()];
        try {
            FileInputStream is = new FileInputStream(file);
            ByteArrayOutputStream bytestream = new ByteArrayOutputStream();
            byte[] bb = new byte[2048];
            int ch = ((InputStream)is).read(bb);
            while (ch != -1) {
                bytestream.write(bb, 0, ch);
                ch = ((InputStream)is).read(bb);
            }
            by = bytestream.toByteArray();
        }
        catch (Exception ex) {
            throw new RuntimeException("transform file into bin Array \u51fa\u9519", ex);
        }
        return by;
    }

    public static String readTxt(String filePath) {
        String lineTxt = "";
        try {
            BufferedReader br;
            File file = new File(filePath);
            if (file.isFile() && file.exists()) {
                InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(file), "utf-8");
                br = new BufferedReader(isr);
                String readtemp = null;
                while ((readtemp = br.readLine()) != null) {
                    lineTxt = lineTxt + readtemp;
                }
            } else {
                throw new ApiException("\u6587\u4ef6\u4e0d\u5b58\u5728!");
            }
            br.close();
            file.delete();
        }
        catch (Exception e) {
            throw new ApiException("\u6587\u4ef6\u8bfb\u53d6\u9519\u8bef!");
        }
        return lineTxt;
    }

    public static String covertFileByte(byte[] filecontent, String fileName) {
        String path = Thread.currentThread().getContextClassLoader().getResource("").getPath() + "/temp";
        File fout = new File(path, fileName);
        try {
            fout.createNewFile();
            FileCopyUtils.copy((byte[])filecontent, (File)fout);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return XmlUtils.readTxt(path + "/" + fileName);
    }

    public static void main(String[] args) throws Exception {
        File file = new File("C:/Users/ChengCheng/Desktop/aa.txt");
        FileInputStream fis = new FileInputStream(file);
        byte[] bytes = FileCopyUtils.copyToByteArray((InputStream)fis);
        System.out.println(bytes);
        String xml = XmlUtils.covertFileByte(bytes, "aa.txt");
        System.out.println(xml);
    }
}

