/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.cmbweb.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.ext.channel.cmbweb.util.MD5Utils;
import com.yqbsoft.laser.service.ext.channel.cmbweb.util.SignatureUtil;
import com.yqbsoft.laser.service.ext.channel.cmbweb.util.Utils;
import com.yqbsoft.laser.service.ext.channel.com.domain.BankRequest;
import com.yqbsoft.laser.service.ext.channel.com.domain.ChannelRequest;
import com.yqbsoft.laser.service.ext.channel.com.domain.ChannelRest;
import com.yqbsoft.laser.service.ext.channel.com.domain.CmChannelClear;
import com.yqbsoft.laser.service.ext.channel.com.service.ChannelBaseSignService;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class ChannelSignServiceImpl
extends ChannelBaseSignService {
    public static final String SYS_CODE = "cmc.ChannelSignServiceImpl";

    public void sign(ChannelRequest channelRequest) {
        if (null == channelRequest || null == channelRequest.getConfigMap() || channelRequest.getConfigMap().isEmpty()) {
            throw new ApiException("cmc.ChannelSignServiceImpl.sign.null", "");
        }
        Map exmap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(channelRequest.getCmChannelClear().getExtension(), String.class, String.class);
        String publicKey = (String)channelRequest.getConfigMap().get("publicKey");
        String url = (String)channelRequest.getConfigMap().get("url");
        if (StringUtils.isBlank((String)url)) {
            url = "https://api.cmburl.cn:8065/polypay/v1.0/mchorders/qrcodeapply";
        }
        String appId = (String)channelRequest.getConfigMap().get("appId");
        String appSecret = (String)channelRequest.getConfigMap().get("appSecret");
        String termId = (String)channelRequest.getConfigMap().get("termId");
        String userId = (String)channelRequest.getConfigMap().get("userId");
        String notify_url = (String)channelRequest.getConfigMap().get("notify_url");
        String merId = (String)channelRequest.getConfigMap().get("merId");
        String signResult = ChannelSignServiceImpl.signMethod(channelRequest);
        try {
            ObjectMapper mapper = new ObjectMapper();
            Map signResultMap = (Map)mapper.readValue(signResult, Map.class);
            TreeMap<String, String> apiSign = new TreeMap<String, String>();
            apiSign.put("appid", appId);
            apiSign.put("secret", appSecret);
            apiSign.put("sign", (String)signResultMap.get("sign"));
            apiSign.put("timestamp", "" + System.currentTimeMillis() / 1000L);
            String MD5Content = SignatureUtil.getSignContent(apiSign);
            String apiSignString = MD5Utils.getMD5Content(MD5Content).toLowerCase();
            HashMap<String, String> apiHeader = new HashMap<String, String>();
            apiHeader.put("appid", appId);
            apiHeader.put("timestamp", "" + System.currentTimeMillis() / 1000L);
            apiHeader.put("apisign", apiSignString);
            Map<String, String> response = Utils.postForEntity(url, signResult, apiHeader);
            this.logger.error("cmc.ChannelSignServiceImpl.response", (Object)JsonUtil.buildNonDefaultBinder().toJson(response));
            Boolean checkResult1 = ChannelSignServiceImpl.checkSign(mapper.writeValueAsString(response), publicKey);
            if (!checkResult1.booleanValue()) {
                return;
            }
            if (!"SUCCESS".equals(response.get("respCode"))) {
                return;
            }
            Map biz_content = (Map)JsonUtil.buildNonEmptyBinder().getJsonToMap(response.get("biz_content"), String.class, String.class);
            CmChannelClear cmChannelClear = channelRequest.getCmChannelClear();
            biz_content.put("out_trade_no", cmChannelClear.getChannelClearSeqno());
            biz_content.put("fchannelCode", cmChannelClear.getFchannelCode());
            biz_content.put("tenantCode", cmChannelClear.getTenantCode());
            biz_content.put("fchannelPmode", cmChannelClear.getFchannelPmodeCode());
            biz_content.put("total_fee", cmChannelClear.getOrderAmount().setScale(2, RoundingMode.HALF_UP).toString());
            channelRequest.setRequestData(biz_content);
            channelRequest.setBankRescode("01");
        }
        catch (Exception e) {
            this.logger.error("cmc.ChannelSignServiceImpl.response.e", (Throwable)e);
        }
    }

    private static Boolean checkSign(String string, String publicKey) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            Map responseBodyMap = (Map)objectMapper.readValue(string, Map.class);
            String sign = (String)responseBodyMap.remove("sign");
            String contentStr = SignatureUtil.getSignContent(responseBodyMap);
            boolean result = SignatureUtil.rsaCheck(contentStr, sign, publicKey, "UTF-8");
            if (result) {
                System.out.println("\u62a5\u6587\u9a8c\u7b7e\u6210\u529f!");
            } else {
                System.out.println("\u62a5\u6587\u9a8c\u7b7e\u5931\u8d25!");
            }
            return result;
        }
        catch (Exception e) {
            System.out.println("\u9a8c\u7b7e\u53d1\u751f\u5f02\u5e38\uff01");
            e.printStackTrace();
            return false;
        }
    }

    private void makeSubmch(Map<String, String> configMap, Map<String, String> requestMap) {
        if (configMap != null && configMap.containsKey("sub_appid")) {
            requestMap.put("sub_appid", configMap.get("sub_appid"));
            requestMap.put("sub_openid", requestMap.remove("openid"));
        }
        if (configMap != null && configMap.containsKey("sub_mch_id")) {
            requestMap.put("sub_mch_id", configMap.get("sub_mch_id"));
        }
    }

    private void processDate(Map<String, String> resMap, ChannelRequest channelRequest) {
        Date channelAcceptDate = null;
        String timeEnd = resMap.get("time_end");
        if (StringUtils.isNotBlank((String)timeEnd)) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            try {
                channelAcceptDate = sdf.parse(timeEnd);
            }
            catch (ParseException e) {
                channelAcceptDate = new Date();
                this.logger.error("ChannelSignServiceImpl.processDate", (Object)("\u6e20\u9053\u53d7\u7406\u65f6\u95f4\u8f6c\u6362\u51fa\u9519\uff0c\u8ba2\u5355\u53f7\uff1a" + channelRequest.getCmChannelClear().getChannelClearSeqno()));
            }
        }
        channelRequest.setChannelAcceptDate(channelAcceptDate);
    }

    public static void main(String[] args) {
    }

    public ChannelRest verifySign(BankRequest bankRequest) {
        if (null == bankRequest || null == bankRequest.getConfigMap() || bankRequest.getConfigMap().isEmpty()) {
            throw new ApiException("cmc.ChannelSignServiceImpl.verifySign.null", "");
        }
        this.logger.error("cmc.ChannelSignServiceImplverifySign.processDate", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)bankRequest));
        Map res = bankRequest.getRequestData();
        bankRequest.setRequestData(res);
        return this.buildApiCallParam(bankRequest);
    }

    private static String signMethod(ChannelRequest channelRequest) {
        TreeMap<String, String> requestPublicParams = new TreeMap<String, String>();
        String requestStr = null;
        try {
            requestPublicParams.put("version", "0.0.1");
            requestPublicParams.put("encoding", "UTF-8");
            requestPublicParams.put("signMethod", "01");
            HashMap<String, String> requestTransactionParams = new HashMap<String, String>();
            requestTransactionParams.put("body", channelRequest.getCmChannelClear().getPaymentOrderMemo());
            requestTransactionParams.put("currencyCode", "156");
            requestTransactionParams.put("merId", (String)channelRequest.getConfigMap().get("merId"));
            requestTransactionParams.put("notifyUrl", "http://pcb2b.ebestmobile.com/laserBank/http/post/bank/cmbweb/PRO/2020021700000001");
            requestTransactionParams.put("orderId", channelRequest.getCmChannelClear().getPaymentOrderSeqno());
            requestTransactionParams.put("tradeScene", "OFFLINE");
            requestTransactionParams.put("payValidTime", "1200");
            requestTransactionParams.put("termId", (String)channelRequest.getConfigMap().get("termId"));
            requestTransactionParams.put("txnAmt", "1");
            requestTransactionParams.put("userId", (String)channelRequest.getConfigMap().get("userId"));
            ObjectMapper mapper = new ObjectMapper();
            requestPublicParams.put("biz_content", mapper.writeValueAsString(requestTransactionParams));
            String privateKey = (String)channelRequest.getConfigMap().get("privateKey");
            String signContent = SignatureUtil.getSignContent(requestPublicParams);
            requestPublicParams.put("sign", SignatureUtil.rsaSign(signContent, privateKey, "UTF-8"));
            requestStr = mapper.writeValueAsString(requestPublicParams);
            return requestStr;
        }
        catch (Exception e) {
            throw new ApiException("cmc.ChannelSignServiceImpl.sign.e", "\u52a0\u7b7e\u53d1\u751f\u5f02\u5e38\uff01");
        }
    }
}

