/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.com.service;

import com.yqbsoft.laser.service.dynamic.GroovyUtil;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.ext.channel.com.api.BankCall;
import com.yqbsoft.laser.service.ext.channel.com.domain.BankHtmlForm;
import com.yqbsoft.laser.service.ext.channel.com.domain.BankRequest;
import com.yqbsoft.laser.service.ext.channel.com.domain.ChannelRequest;
import com.yqbsoft.laser.service.ext.channel.com.domain.ChannelRest;
import com.yqbsoft.laser.service.ext.channel.com.domain.CmChannelClear;
import com.yqbsoft.laser.service.ext.channel.com.domain.CmChannelGildDomain;
import com.yqbsoft.laser.service.ext.channel.com.domain.CmFchannelApi;
import com.yqbsoft.laser.service.ext.channel.com.domain.CmFchannelApiparam;
import com.yqbsoft.laser.service.ext.channel.com.domain.CmFchannelReparse;
import com.yqbsoft.laser.service.ext.channel.com.enumc.ChannelApiParamType;
import com.yqbsoft.laser.service.ext.channel.com.enumc.ChannelApiRetype;
import com.yqbsoft.laser.service.ext.channel.com.enumc.ChannelApiSign;
import com.yqbsoft.laser.service.ext.channel.com.enumc.ChannelConfigScope;
import com.yqbsoft.laser.service.ext.channel.com.secure.ChannelSignService;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.ScriptUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public abstract class ChannelBaseService
extends BaseServiceImpl {
    private static final String SYS_CODE = "cmc.ChannelBaseService";
    protected Map<String, String> apicode = new ConcurrentHashMap<String, String>(){
        private static final long serialVersionUID = 3757846883081103776L;
        {
            this.put("bankChannelCall", "cmc.channelCall.bankChannelCall");
            this.put("channelSPay", "cmc.channelIn.channelSPay");
            this.put("channelBPay", "cmc.channelIn.channelBPay");
            this.put("channelSOut", "cmc.channelOut.channelSOut");
            this.put("channelBOut", "cmc.channelOut.channelBOut");
            this.put("channelSQuery", "cmc.channelQuery.channelSQuery");
            this.put("channelBQuery", "cmc.channelQuery.channelBQuery");
            this.put("channelSRe", "cmc.channelRe.channelSRe");
            this.put("channelBRe", "cmc.channelRe.channelBRe");
        }
    };
    private ChannelSignService channelSignService;

    public ChannelSignService getChannelSignService() {
        return this.channelSignService;
    }

    public Map<String, Object> makeMap(Map<String, String> requestData) {
        if (null == requestData || requestData.isEmpty()) {
            return null;
        }
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        for (String key : requestData.keySet()) {
            parammap.put(key, requestData.get(key));
        }
        return parammap;
    }

    public abstract String getFchannelCode();

    public void setChannelSignService(ChannelSignService channelSignService) {
        this.channelSignService = channelSignService;
    }

    protected String getApiCode(String method) {
        return this.apicode.get(method);
    }

    protected String getChannelStr(ChannelRequest channelRequest) {
        if (null == channelRequest) {
            return "";
        }
        BankHtmlForm bankHtmlForm = new BankHtmlForm();
        bankHtmlForm.setRequestData(channelRequest.getRequestData());
        bankHtmlForm.setHtmlStr(channelRequest.getHtmlStr());
        return JsonUtil.buildNormalBinder().toJson((Object)bankHtmlForm);
    }

    protected ChannelRest buildSend(String channelApiCode, CmChannelClear cmChannelClear) {
        return this.send(this.buildApiReuestParam(channelApiCode, cmChannelClear), cmChannelClear);
    }

    protected ChannelRest send(ChannelRequest channelRequest, CmChannelClear cmChannelClear) {
        if (null == channelRequest.getCmFchannelApi()) {
            throw new ApiException("cmc.ChannelBaseService.send.error", "");
        }
        ChannelRest channelRest = null;
        if (!ChannelApiRetype.HTML.getCode().equals(channelRequest.getCmFchannelApi().getFchannelApiRetype())) {
            if (StringUtils.isBlank((String)channelRequest.getCmFchannelApi().getAppapiCode())) {
                throw new ApiException("cmc.ChannelBaseService.send.apicode", channelRequest.getCmFchannelApi().getFchannelApiCode());
            }
            String res = null;
            if (ChannelApiRetype.HTTP.getCode().equals(channelRequest.getCmFchannelApi().getFchannelApiRetype())) {
                res = this.httpInvoke(channelRequest);
                this.checkHttpInvokeResult(res);
            } else {
                res = this.invoke(channelRequest.getCmFchannelApi().getAppapiCode(), channelRequest.getRequestData());
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("res", res);
            map.put("channelClearFchannel", cmChannelClear.getChannelClearFchannel());
            map.put("channelClearSeqno", cmChannelClear.getChannelClearSeqno());
            map.put("tenantCode", cmChannelClear.getTenantCode());
            map.put("clearOrderSeqno", cmChannelClear.getClearOrderSeqno());
            channelRest = this.buildResponeBank(map, channelRequest);
            if (null == channelRest) {
                throw new ApiException("cmc.ChannelBaseService.send.channelRest", "");
            }
            channelRest.setClearOrderSeqno(cmChannelClear.getClearOrderSeqno());
        } else {
            channelRest = new ChannelRest();
            channelRest.setChannelClearFchannel(cmChannelClear.getChannelClearFchannel());
            channelRest.setChannelClearSeqno(cmChannelClear.getChannelClearSeqno());
            channelRest.setTenantCode(cmChannelClear.getTenantCode());
            channelRest.setClearOrderSeqno(cmChannelClear.getClearOrderSeqno());
            channelRest.setBankSeqno(cmChannelClear.getChannelClearSeqno());
            channelRest.setDataState(1);
            channelRest.setRestMemo("");
            channelRest.setChannelSubStr(this.getChannelStr(channelRequest));
            channelRest.setDebitFlag(channelRequest.isDebitFlag());
            channelRest.setDebitResult(channelRequest.getDebitResult());
            channelRest.setBankRescode(channelRequest.getBankRescode());
            channelRest.setBankResmsg(channelRequest.getBankResmsg());
            channelRest.setBankSeqno(channelRequest.getBankSeqno());
            channelRest.setChannelAcceptDate(channelRequest.getChannelAcceptDate());
            if (channelRest.isDebitFlag() && "SUCCESS".equals(channelRest.getDebitResult())) {
                channelRest.setDataState(2);
            }
        }
        return channelRest;
    }

    protected String invoke(String url, Map request) {
        return this.internalInvoke(url, request);
    }

    protected String httpInvoke(ChannelRequest channelRequest) {
        return null;
    }

    protected ChannelRequest buildApiReuestParam(String channelApiCode, CmChannelClear cmChannelClear) {
        Map readlConfigMap;
        String realConfigkey;
        String realConfigStr;
        CmFchannelApi cmFchannelApi;
        ChannelRequest channelRequest = new ChannelRequest();
        channelRequest.setSuccess(false);
        if (StringUtils.isBlank((String)channelApiCode) || null == cmChannelClear) {
            this.logger.error("cmc.ChannelBaseService.buildApiReuestParam.null");
            channelRequest.setBmsg("\u53c2\u6570\u4e3a\u7a7a");
            return channelRequest;
        }
        String fchannelCode = this.getFchannelCode();
        if (StringUtils.isBlank((String)fchannelCode)) {
            this.logger.error("cmc.ChannelBaseService.buildApiReuestParam.fchannelCode", (Object)fchannelCode);
            channelRequest.setBmsg("fchannelCode");
            return channelRequest;
        }
        cmChannelClear.setChannelClearFchannel(fchannelCode);
        String key = fchannelCode + "-" + channelApiCode + "-" + cmChannelClear.getTenantCode();
        String apiStr = DisUtil.getMap((String)"Fchannel_api", (String)key);
        if (StringUtils.isBlank((String)apiStr)) {
            key = fchannelCode + "-" + channelApiCode + "-" + "00000000";
            apiStr = DisUtil.getMap((String)"Fchannel_api", (String)key);
        }
        if (null == (cmFchannelApi = (CmFchannelApi)JsonUtil.buildNormalBinder().getJsonToObject(apiStr, CmFchannelApi.class))) {
            this.logger.error("cmc.ChannelBaseService.buildApiReuestParam.cmFchannelApi", (Object)(key + ":" + apiStr));
            channelRequest.setBmsg("API\u672a\u8bbe\u7f6e1");
            return channelRequest;
        }
        channelRequest.setCmFchannelApi(cmFchannelApi);
        channelRequest.setApiRetype(cmFchannelApi.getFchannelApiRetype());
        channelRequest.setChannelApiCode(channelApiCode);
        String paramkey = fchannelCode + "-" + channelApiCode + "-" + ChannelApiParamType.IN.getCode() + "-" + cmChannelClear.getTenantCode();
        String apiParamStr = DisUtil.getMap((String)"Fchannel_apiparam", (String)paramkey);
        if (StringUtils.isBlank((String)apiParamStr)) {
            paramkey = fchannelCode + "-" + channelApiCode + "-" + ChannelApiParamType.IN.getCode() + "-" + "00000000";
            apiParamStr = DisUtil.getMap((String)"Fchannel_apiparam", (String)paramkey);
        }
        if (StringUtils.isBlank((String)apiParamStr)) {
            this.logger.error("cmc.ChannelBaseService.buildApiReuestParam.apiParamStr", (Object)paramkey);
            channelRequest.setBmsg("apiParam\u672a\u8bbe\u7f6e");
            return channelRequest;
        }
        List apiparamList = (List)JsonUtil.buildNormalBinder().getJsonToList(apiParamStr, CmFchannelApiparam.class);
        if (null == apiparamList) {
            this.logger.error("cmc.ChannelBaseService.buildApiReuestParam.cmFchannelApiparam", (Object)(paramkey + ":" + apiParamStr));
            channelRequest.setBmsg("apiParam\u672a\u8bbe\u7f6e1");
            return channelRequest;
        }
        String configkey = fchannelCode + "-" + ChannelConfigScope.PRO.getCode() + "-" + cmChannelClear.getTenantCode();
        String configStr = DisUtil.getMap((String)"Fchannel_config", (String)configkey);
        if (StringUtils.isBlank((String)configStr)) {
            this.logger.error("cmc.ChannelBaseService.buildApiReuestParam.configStr", (Object)configkey);
            channelRequest.setBmsg("\u6e20\u9053\u63a5\u5165\u53c2\u6570\u672a\u8bbe\u7f6e");
            return channelRequest;
        }
        Map configMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(configStr, String.class, String.class);
        if (null == configMap || configMap.isEmpty()) {
            this.logger.error("cmc.ChannelBaseService.buildApiReuestParam.configMap", (Object)(configkey + ":" + configStr));
            channelRequest.setBmsg("\u6e20\u9053\u63a5\u5165\u53c2\u6570\u672a\u8bbe\u7f6e1");
            return channelRequest;
        }
        if (StringUtils.isNotBlank((String)cmChannelClear.getChannelClearFchannel()) && !cmChannelClear.getChannelClearFchannel().equals(fchannelCode) && StringUtils.isNotBlank((String)(realConfigStr = DisUtil.getMap((String)"Fchannel_config", (String)(realConfigkey = cmChannelClear.getChannelClearFchannel() + "-" + ChannelConfigScope.PRO.getCode() + "-" + cmChannelClear.getTenantCode())))) && MapUtil.isNotEmpty((Map)(readlConfigMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(realConfigStr, String.class, String.class)))) {
            configMap.putAll(readlConfigMap);
        }
        channelRequest.setConfigMap(configMap);
        if (!this.buildParamMap(channelRequest, configMap, apiparamList, cmChannelClear, cmFchannelApi)) {
            this.logger.error("cmc.ChannelBaseService.buildApiReuestParam.buildParamMap");
            channelRequest.setBmsg("\u53c2\u6570\u7ed1\u5b9a\u5931\u8d25");
            return channelRequest;
        }
        if (ChannelApiRetype.HTML.getCode().equals(channelRequest.getApiRetype()) && StringUtils.isNotBlank((String)cmFchannelApi.getFchannelApiCallext())) {
            this.buildHtmlStr(channelRequest, cmFchannelApi.getFchannelApiCallext(), cmFchannelApi);
        }
        channelRequest.setSuccess(true);
        return channelRequest;
    }

    protected void buildHtmlStr(ChannelRequest channelRequest, String callext, CmFchannelApi cmFchannelApi) {
        if (null == channelRequest || StringUtils.isBlank((String)callext)) {
            return;
        }
        HashMap<String, Object> jsMap = new HashMap<String, Object>();
        jsMap.put("map", channelRequest.getRequestData());
        jsMap.put("cmFchannelApi", cmFchannelApi);
        String htmlStr = (String)ScriptUtil.evel((String)callext, jsMap);
        channelRequest.setHtmlStr(htmlStr);
    }

    private boolean buildParamMap(ChannelRequest channelRequest, Map<String, String> configMap, List<CmFchannelApiparam> apiparamList, CmChannelClear cmChannelClear, CmFchannelApi cmFchannelApi) {
        if (null == channelRequest) {
            this.logger.error("cmc.ChannelBaseService.buildParamMap.channelRequest");
            return false;
        }
        if (null == configMap || configMap.isEmpty() || null == apiparamList || apiparamList.isEmpty() || null == cmChannelClear) {
            this.logger.error("cmc.ChannelBaseService.buildParamMap.null");
            return false;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        HashMap<String, Object> jsMap = new HashMap<String, Object>();
        jsMap.put("cmChannelClear", cmChannelClear);
        jsMap.put("config", configMap);
        jsMap.put("cmFchannelApi", cmFchannelApi);
        this.putExtension(cmChannelClear, jsMap);
        for (CmFchannelApiparam cmFchannelApiparam : apiparamList) {
            Object value = "";
            String jsstr = cmFchannelApiparam.getFchannelApiparamMcon();
            String mname = cmFchannelApiparam.getFchannelApiparamMname();
            if (StringUtils.isNotBlank((String)jsstr)) {
                value = jsstr.equals("java:makeGild") ? this.makeGild(cmChannelClear, cmFchannelApi, configMap) : (jsstr.equals("java:timestamp") ? DateUtils.parseDateTime((Date)new Date()) : (jsstr.equals("java:uuid") ? UUID.randomUUID().toString().replaceAll("-", "") : ScriptUtil.evel((String)jsstr, jsMap)));
            } else if (StringUtils.isNotBlank((String)mname)) {
                value = BeanUtils.forceGetProperty(jsMap, (String)mname);
            }
            paramMap.put(cmFchannelApiparam.getFchannelApiparamKey(), String.valueOf(value));
        }
        channelRequest.setRequestData(paramMap);
        channelRequest.setCmChannelClear(cmChannelClear);
        if (ChannelApiSign.SIGN.getCode().equals(cmFchannelApi.getFchannelApiSecure())) {
            this.getChannelSignService().sign(channelRequest);
        }
        return true;
    }

    public static void main(String[] args) {
        HashMap jsMap = new HashMap();
        HashMap<String, Integer> ext = new HashMap<String, Integer>();
        ext.put("test", 10);
        jsMap.put("ext", ext);
        Object value = ScriptUtil.evel((String)"var fee=ext.get('test'); fee=Math.round(fee*100); return fee.toFixed();", jsMap);
        System.out.println(value);
    }

    private void putExtension(CmChannelClear cmChannelClear, Map<String, Object> jsMap) {
        if (cmChannelClear == null) {
            return;
        }
        if (StringUtils.isNotBlank((String)cmChannelClear.getExtension())) {
            String extJsonStr = cmChannelClear.getExtension();
            Map extMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(extJsonStr, String.class, Object.class);
            jsMap.put("extension", extMap);
        }
    }

    private String makeGild(CmChannelClear cmChannelClear, CmFchannelApi cmFchannelApi, Map<String, String> configMap) {
        if (null == cmChannelClear || null == cmFchannelApi) {
            return null;
        }
        CmChannelGildDomain cmChannelGildDomain = new CmChannelGildDomain();
        try {
            BeanUtils.copyAllPropertys((Object)cmChannelGildDomain, (Object)cmChannelClear);
            BeanUtils.copyAllPropertys((Object)cmChannelGildDomain, (Object)cmFchannelApi);
            cmChannelGildDomain.setChannelClearFchannel(this.getFchannelCode());
            cmChannelGildDomain.setChannelApiCtype(cmFchannelApi.getFchannelApiCtype());
            cmChannelGildDomain.setChannelApiType(cmFchannelApi.getFchannelApiType());
            cmChannelGildDomain.setAccountExname(cmChannelClear.getFaccountAname());
            cmChannelGildDomain.setBankName(cmChannelClear.getFaccountName());
            cmChannelGildDomain.setTenantCode(cmChannelClear.getTenantCode());
            return JsonUtil.buildNormalBinder().toJson((Object)cmChannelGildDomain);
        }
        catch (Exception e) {
            this.logger.error("cmc.ChannelBaseService.makeGild.e", (Throwable)e);
            return null;
        }
    }

    protected ChannelRest buildBank(Map<String, String> map) {
        BankRequest bankRequest = this.parse(map);
        if (null == bankRequest) {
            this.logger.error("cmc.ChannelBaseService.bankChannelCall.bankRequest");
            return null;
        }
        bankRequest.setSing(true);
        return this.buildBankCall(bankRequest);
    }

    protected ChannelRest buildResponeBank(Map<String, String> map, ChannelRequest channelRequest) {
        if (null == channelRequest || null == map || map.isEmpty() || null == channelRequest.getCmFchannelApi()) {
            return null;
        }
        map.put("type", ChannelApiParamType.OUT.getCode());
        String respase = channelRequest.getCmFchannelApi().getFchannelApiReparse();
        if (StringUtils.isBlank((String)respase)) {
            throw new ApiException("cmc.ChannelBaseService.buildResponeBank.respase", "");
        }
        BankRequest bankRequest = this.bankReustPaser(map, this.getFchannelCode(), channelRequest.getCmFchannelApi().getTenantCode(), "respone", respase);
        if (null == bankRequest) {
            this.logger.error("cmc.ChannelBaseService.buildResponeBank.bankRequest");
            return null;
        }
        bankRequest.setChannelApiCode(channelRequest.getCmFchannelApi().getChannelApiCode());
        bankRequest.setType(ChannelApiParamType.OUT.getCode());
        if (ChannelApiSign.SIGN.getCode().equals(channelRequest.getCmFchannelApi().getFchannelApiResign())) {
            bankRequest.setSing(true);
        } else {
            bankRequest.setSing(false);
        }
        return this.buildBankCall(bankRequest);
    }

    private BankRequest parse(Map<String, String> map) {
        BankRequest bankRequest = new BankRequest();
        bankRequest.setSuccess(false);
        if (null == map) {
            bankRequest.setBmsg("\u53c2\u6570\u4e3a\u7a7a");
            return bankRequest;
        }
        String fchannelCode = map.get("channelClearFchannel");
        String tenantCode = map.get("tenantCode");
        String type = "call";
        String strs = DisUtil.getMap((String)"Fchannel_parse_pro", (String)(fchannelCode + "-" + type + "-" + tenantCode));
        if (StringUtils.isBlank((String)strs)) {
            strs = DisUtil.getMap((String)"Fchannel_parse_pro", (String)(fchannelCode + "-" + type + "-" + "00000000"));
        }
        if (StringUtils.isBlank((String)strs)) {
            this.logger.error("cmc.ChannelBaseService.parse.strs", (Object)(fchannelCode + "-call-" + tenantCode));
            bankRequest.setBmsg("\u89e3\u6790\u6a21\u677f\u4e3a\u7a7a");
            return bankRequest;
        }
        CmFchannelReparse cmFchannelReparse = (CmFchannelReparse)JsonUtil.buildNormalBinder().getJsonToObject(strs, CmFchannelReparse.class);
        if (null == cmFchannelReparse) {
            this.logger.error("cmc.ChannelBaseService.parse.cmFchannelReparse", (Object)(fchannelCode + "-" + type + "-" + tenantCode));
            bankRequest.setBmsg("\u89e3\u6790\u6a21\u677f\u4e3a\u7a7a1");
            return bankRequest;
        }
        BankRequest rebankRequest = this.bankReustPaser(map, fchannelCode, tenantCode, type, cmFchannelReparse.getFchannelReparseRe());
        if (null == rebankRequest) {
            this.logger.error("cmc.ChannelBaseService.parse.rebankRequest", (Object)(fchannelCode + "-" + type + "-" + tenantCode));
            bankRequest.setBmsg("\u89e3\u6790\u5931\u8d251");
            return bankRequest;
        }
        rebankRequest.setType(ChannelApiParamType.CALL.getCode());
        rebankRequest.setReError(cmFchannelReparse.getFchannelReparseError());
        rebankRequest.setReSuccess(cmFchannelReparse.getFchannelReparseSuccess());
        return rebankRequest;
    }

    private BankRequest bankReustPaser(Map<String, String> map, String fchannelCode, String tenantCode, String type, String reparseStr) {
        Map readlConfigMap;
        String realConfigkey;
        String realConfigStr;
        BankRequest rebankRequest;
        if (StringUtils.isBlank((String)fchannelCode) || StringUtils.isBlank((String)reparseStr)) {
            this.logger.error("cmc.ChannelBaseService.bankReustPaser.null", (Object)(fchannelCode + "-" + type + "-" + tenantCode));
            return null;
        }
        BankCall bankCall = (BankCall)GroovyUtil.executeCalculate((String)reparseStr);
        if (null == bankCall) {
            this.logger.error("cmc.ChannelBaseService.bankReustPaser.bankCall", (Object)(fchannelCode + "-" + type + "-" + tenantCode));
            return null;
        }
        try {
            rebankRequest = bankCall.callEx(map);
            if (null == rebankRequest || null == rebankRequest.getRequestData() || rebankRequest.getRequestData().isEmpty()) {
                this.logger.error("cmc.ChannelBaseService.bankReustPaser.remap", (Object)(fchannelCode + "-" + type + "-" + tenantCode));
                return rebankRequest;
            }
        }
        catch (Exception e) {
            this.logger.error("cmc.ChannelBaseService.bankReustPaser.remap", (Object)(fchannelCode + "-" + type + "-" + tenantCode), (Throwable)e);
            return null;
        }
        String configkey = fchannelCode + "-" + ChannelConfigScope.PRO.getCode() + "-" + tenantCode;
        String configStr = DisUtil.getMap((String)"Fchannel_config", (String)configkey);
        if (StringUtils.isBlank((String)configStr)) {
            this.logger.error("cmc.ChannelBaseService.bankReustPaser.configStr", (Object)configkey);
            return null;
        }
        Map configMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(configStr, String.class, String.class);
        if (null == configMap || configMap.isEmpty()) {
            this.logger.error("cmc.ChannelBaseService.bankReustPaser.configMap", (Object)(configkey + ":" + configStr));
            return null;
        }
        String realFchannelCode = map.get("realFchannelCode");
        if (StringUtils.isNotBlank((String)realFchannelCode) && !fchannelCode.equals(realFchannelCode) && StringUtils.isNotBlank((String)(realConfigStr = DisUtil.getMap((String)"Fchannel_config", (String)(realConfigkey = realFchannelCode + "-" + ChannelConfigScope.PRO.getCode() + "-" + tenantCode)))) && MapUtil.isNotEmpty((Map)(readlConfigMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(realConfigStr, String.class, String.class)))) {
            configMap.putAll(readlConfigMap);
        }
        rebankRequest.setConfigMap(configMap);
        return rebankRequest;
    }

    private ChannelRest buildBankCall(BankRequest bankRequest) {
        if (null == bankRequest || null == bankRequest.getRequestData() || bankRequest.getRequestData().isEmpty()) {
            return null;
        }
        try {
            ChannelRest channelRest = this.getChannelSignService().verifySign(bankRequest);
            return channelRest;
        }
        catch (Exception e) {
            return null;
        }
    }

    private void checkHttpInvokeResult(String res) {
        if (StringUtils.isEmpty((String)res)) {
            throw new ApiException("cmc.ChannelBaseService.checkHttpInvokeResult", "http\u8bf7\u6c42\u7ed3\u679c\u8fd4\u56de\u503c\u4e3a\u7a7a");
        }
    }
}

