/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.com.service;

import com.yqbsoft.laser.service.dynamic.GroovyUtil;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.ext.channel.com.api.BankCall;
import com.yqbsoft.laser.service.ext.channel.com.api.ChannelDownloadService;
import com.yqbsoft.laser.service.ext.channel.com.domain.BankRequest;
import com.yqbsoft.laser.service.ext.channel.com.domain.ChannelRequest;
import com.yqbsoft.laser.service.ext.channel.com.domain.CmFchannelApi;
import com.yqbsoft.laser.service.ext.channel.com.domain.CmFchannelApiparam;
import com.yqbsoft.laser.service.ext.channel.com.domain.CmFchannelReparse;
import com.yqbsoft.laser.service.ext.channel.com.domain.ExtFmFile;
import com.yqbsoft.laser.service.ext.channel.com.domain.ExtPtfchannel;
import com.yqbsoft.laser.service.ext.channel.com.domain.FileBean;
import com.yqbsoft.laser.service.ext.channel.com.domain.FileDomain;
import com.yqbsoft.laser.service.ext.channel.com.enumc.ChannelApiParamType;
import com.yqbsoft.laser.service.ext.channel.com.enumc.ChannelApiSign;
import com.yqbsoft.laser.service.ext.channel.com.enumc.ChannelConfigScope;
import com.yqbsoft.laser.service.ext.channel.com.service.ChannelBaseService;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ScriptUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public abstract class ChannelDownloadBaseService
extends ChannelBaseService
implements ChannelDownloadService {
    public static final String SYS_CODE = "cmc.ChannelDownloadBaseService";

    public Map<String, String> channelReuestParam(ExtPtfchannel ptePtfchannel) {
        if (null == ptePtfchannel) {
            throw new ApiException("cmc.ChannelDownloadBaseService.channelSDownload.error", "");
        }
        String configkey = this.getFchannelCode() + "-" + ChannelConfigScope.PRO.getCode() + "-" + ptePtfchannel.getTenantCode();
        String configStr = DisUtil.getMap((String)"Fchannel_config", (String)configkey);
        if (StringUtils.isBlank((String)configStr)) {
            this.logger.error("cmc.ChannelDownloadBaseService.buildApiReuestParam.configStr", (Object)configkey);
            return null;
        }
        Map configMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(configStr, String.class, String.class);
        if (null == configMap || configMap.isEmpty()) {
            this.logger.error("cmc.ChannelDownloadBaseService.buildApiReuestParam.configMap", (Object)(configkey + ":" + configStr));
            return null;
        }
        return configMap;
    }

    public ChannelRequest getChannelRequest(ExtPtfchannel ptePtfchannel) {
        if (null == ptePtfchannel) {
            throw new ApiException("cmc.ChannelDownloadBaseService.channelSDownload.error", "");
        }
        ChannelRequest channelRequest = new ChannelRequest();
        String channelApiCode = "cmc.channelIn.channelSDownload";
        channelRequest.setChannelApiCode(channelApiCode);
        String configkey = this.getFchannelCode() + "-" + ChannelConfigScope.PRO.getCode() + "-" + ptePtfchannel.getTenantCode();
        String configStr = DisUtil.getMap((String)"Fchannel_config", (String)configkey);
        if (StringUtils.isBlank((String)configStr)) {
            this.logger.error("cmc.ChannelDownloadBaseService.buildApiReuestParam.configStr", (Object)configkey);
            channelRequest.setSuccess(false);
            return channelRequest;
        }
        Map configMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(configStr, String.class, String.class);
        if (null == configMap || configMap.isEmpty()) {
            this.logger.error("cmc.ChannelDownloadBaseService.buildApiReuestParam.configMap", (Object)(configkey + ":" + configStr));
            channelRequest.setSuccess(false);
            return channelRequest;
        }
        channelRequest.setConfigMap(configMap);
        String key = this.getFchannelCode() + "-" + channelApiCode + "-" + "00000000";
        String apiStr = DisUtil.getMap((String)"Fchannel_api", (String)key);
        if (StringUtils.isBlank((String)apiStr)) {
            this.logger.error("cmc.ChannelDownloadBaseService.buildApiReuestParam.apiStr", (Object)key);
            channelRequest.setSuccess(false);
            return channelRequest;
        }
        CmFchannelApi cmFchannelApi = (CmFchannelApi)JsonUtil.buildNormalBinder().getJsonToObject(apiStr, CmFchannelApi.class);
        if (null == cmFchannelApi) {
            this.logger.error("cmc.ChannelDownloadBaseService.buildApiReuestParam.cmFchannelApi", (Object)(key + ":" + apiStr));
            channelRequest.setSuccess(false);
            return channelRequest;
        }
        channelRequest.setCmFchannelApi(cmFchannelApi);
        String paramkey = this.getFchannelCode() + "-" + channelApiCode + "-" + ChannelApiParamType.IN.getCode() + "-" + "00000000";
        String apiParamStr = DisUtil.getMap((String)"Fchannel_apiparam", (String)paramkey);
        if (StringUtils.isBlank((String)apiParamStr)) {
            this.logger.error("cmc.ChannelDownloadBaseService.buildApiReuestParam.apiParamStr", (Object)paramkey);
            channelRequest.setSuccess(false);
            return channelRequest;
        }
        List apiparamList = (List)JsonUtil.buildNormalBinder().getJsonToList(apiParamStr, CmFchannelApiparam.class);
        if (null == apiparamList) {
            this.logger.error("cmc.ChannelDownloadBaseService.buildApiReuestParam.cmFchannelApiparam", (Object)(paramkey + ":" + apiParamStr));
            channelRequest.setSuccess(false);
            return channelRequest;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        Object value = "";
        String jsstr = "";
        HashMap<String, Object> jsMap = new HashMap<String, Object>();
        jsMap.put("ptePtfchannel", ptePtfchannel);
        jsMap.put("config", configMap);
        jsMap.put("cmFchannelApi", cmFchannelApi);
        String mname = "";
        for (CmFchannelApiparam cmFchannelApiparam : apiparamList) {
            jsstr = cmFchannelApiparam.getFchannelApiparamMcon();
            mname = cmFchannelApiparam.getFchannelApiparamMname();
            if (StringUtils.isNotBlank((String)jsstr)) {
                value = jsstr.equals("java:timestamp") ? DateUtils.parseDateTime((Date)new Date()) : (jsstr.equals("java:uuid") ? UUID.randomUUID().toString().replaceAll("-", "") : ScriptUtil.evel((String)jsstr, jsMap));
            } else if (StringUtils.isNotBlank((String)mname)) {
                value = BeanUtils.forceGetProperty(jsMap, (String)mname);
            }
            paramMap.put(cmFchannelApiparam.getFchannelApiparamKey(), String.valueOf(value));
        }
        channelRequest.setRequestData(paramMap);
        if (ChannelApiSign.SIGN.getCode().equals(cmFchannelApi.getFchannelApiSecure())) {
            this.getChannelSignService().sign(channelRequest);
        }
        return channelRequest;
    }

    protected ExtFmFile parse(Map<String, String> map) {
        byte[] result;
        BankRequest rebankRequest;
        CmFchannelReparse cmFchannelReparse = this.getCmFchannelReparse();
        if (cmFchannelReparse == null) {
            return null;
        }
        BankCall bankCall = (BankCall)GroovyUtil.executeCalculate((String)cmFchannelReparse.getFchannelReparseRe());
        if (bankCall == null) {
            this.logger.error("cmc.ChannelDownloadBaseService.bankReustPaser.bankCall", (Object)this.getFieldName(map.get("tenantCode")));
            return null;
        }
        try {
            rebankRequest = bankCall.callEx(map);
            if (null == rebankRequest || StringUtils.isEmpty((String)rebankRequest.getReSuccess())) {
                this.logger.error("cmc.ChannelDownloadBaseService.parse.remap", (Object)this.getFieldName(map.get("tenantCode")));
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error("cmc.ChannelDownloadBaseService.parse.remap", (Object)this.getFieldName(map.get("tenantCode")), (Throwable)e);
            return null;
        }
        try {
            result = rebankRequest.getReSuccess().getBytes("GBK");
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error((Throwable)e);
            return null;
        }
        String fileName = String.format("%s-ALL-%s-%s.csv", map.get("fchanelType"), map.get("tenantCode"), map.get("date"));
        return this.saveFile(result, fileName, "00000000", "FILE_06", File.separator + map.get("date"));
    }

    private CmFchannelReparse getCmFchannelReparse() {
        String strs = DisUtil.getMap((String)"Fchannel_parse_pro", (String)this.getFieldName("00000000"));
        if (StringUtils.isBlank((String)strs)) {
            this.logger.error("cmc.ChannelDownloadBaseService.parse.strs.null", (Object)this.getFieldName("00000000"));
            return null;
        }
        return (CmFchannelReparse)JsonUtil.buildNormalBinder().getJsonToObject(strs, CmFchannelReparse.class);
    }

    private String getFieldName(String tenantCode) {
        return String.format("%s-downloadcall-%s", this.getFchannelCode(), tenantCode);
    }

    protected ExtFmFile saveFile(byte[] bills, String filename, String tenantCode, String fileSort, String fileStructure) {
        try {
            if (bills.length == 0) {
                return null;
            }
            HashMap<String, String> paramsMap = new HashMap<String, String>();
            String fileType = filename.substring(filename.lastIndexOf(".") + 1, filename.length());
            String name = filename.substring(0, filename.lastIndexOf("."));
            FileDomain fileDomainBean = new FileDomain();
            fileDomainBean.setFileName(name);
            fileDomainBean.setFileType("1");
            fileDomainBean.setFileCtype(fileType);
            fileDomainBean.setFileSort(fileSort);
            fileDomainBean.setTenantCode("00000000");
            fileDomainBean.setFlag(true);
            fileDomainBean.setFileSize(bills.length);
            fileDomainBean.setRootPath(fileStructure);
            ArrayList<FileBean> fileBeanList = new ArrayList<FileBean>();
            FileBean fileBean = new FileBean();
            fileBean.setFileType(fileType);
            fileBean.setOriginalFilename(name);
            fileBean.setBytes(bills);
            fileBean.setSize(Long.valueOf(bills.length));
            fileBeanList.add(fileBean);
            paramsMap.put("fmFileDomainBean", JsonUtil.buildNormalBinder().toJson((Object)fileDomainBean));
            paramsMap.put("fileBeanList", JsonUtil.buildNormalBinder().toJson(fileBeanList));
            String fileJson = this.internalInvoke("fm.file.saveFile", paramsMap);
            return (ExtFmFile)JsonUtil.buildNormalBinder().getJsonToObject(fileJson, ExtFmFile.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected Date getOrderDate(String retryFlag, Date requestDate) {
        return DateUtils.addDays((Date)this.getBillFileDate(retryFlag, requestDate), (int)-1);
    }

    protected Date getBillFileDate(String retryFlag, Date requestDate) {
        if ("retry".equals(retryFlag)) {
            return requestDate;
        }
        return Calendar.getInstance().getTime();
    }
}

