/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.com.service;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.ext.channel.com.domain.BankHtmlForm;
import com.yqbsoft.laser.service.ext.channel.com.domain.BankRequest;
import com.yqbsoft.laser.service.ext.channel.com.domain.ChannelRequest;
import com.yqbsoft.laser.service.ext.channel.com.domain.ChannelRest;
import com.yqbsoft.laser.service.ext.channel.com.domain.CmChannelClear;
import com.yqbsoft.laser.service.ext.channel.com.domain.CmChannelGildDomain;
import com.yqbsoft.laser.service.ext.channel.com.domain.CmFchannelApi;
import com.yqbsoft.laser.service.ext.channel.com.domain.CmFchannelApiparam;
import com.yqbsoft.laser.service.ext.channel.com.enumc.ChannelApiParamType;
import com.yqbsoft.laser.service.ext.channel.com.enumc.ChannelApiRetype;
import com.yqbsoft.laser.service.ext.channel.com.enumc.ChannelApiSign;
import com.yqbsoft.laser.service.ext.channel.com.enumc.ChannelConfigScope;
import com.yqbsoft.laser.service.ext.channel.com.secure.ChannelSignService;
import com.yqbsoft.laser.service.ext.channel.com.service.ChannelSuppService;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.ScriptUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public abstract class ChannelBaseService
extends ChannelSuppService {
    private static final String SYS_CODE = "cmc.ChannelBaseService";
    private ChannelSignService channelSignService;

    public ChannelSignService getChannelSignService() {
        return this.channelSignService;
    }

    public void setChannelSignService(ChannelSignService channelSignService) {
        this.channelSignService = channelSignService;
    }

    protected String getChannelStr(ChannelRequest channelRequest) {
        if (null == channelRequest) {
            return "";
        }
        BankHtmlForm bankHtmlForm = new BankHtmlForm();
        bankHtmlForm.setRequestData(channelRequest.getRequestData());
        bankHtmlForm.setHtmlStr(channelRequest.getHtmlStr());
        return JsonUtil.buildNormalBinder().toJson((Object)bankHtmlForm);
    }

    protected ChannelRest buildSend(String channelApiCode, CmChannelClear cmChannelClear) {
        return this.send(this.buildApiReuestParam(channelApiCode, cmChannelClear), cmChannelClear);
    }

    protected ChannelRest send(ChannelRequest channelRequest, CmChannelClear cmChannelClear) {
        if (null == channelRequest.getCmFchannelApi()) {
            throw new ApiException("cmc.ChannelBaseService.send.error", "");
        }
        ChannelRest channelRest = null;
        if (!ChannelApiRetype.HTML.getCode().equals(channelRequest.getCmFchannelApi().getFchannelApiRetype())) {
            if (StringUtils.isBlank((String)channelRequest.getCmFchannelApi().getAppapiCode())) {
                throw new ApiException("cmc.ChannelBaseService.send.apicode", channelRequest.getCmFchannelApi().getFchannelApiCode());
            }
            String res = null;
            if (ChannelApiRetype.HTTP.getCode().equals(channelRequest.getCmFchannelApi().getFchannelApiRetype())) {
                res = this.httpInvoke(channelRequest);
                this.checkHttpInvokeResult(res);
            } else {
                res = this.invoke(channelRequest.getCmFchannelApi().getAppapiCode(), channelRequest.getRequestData());
            }
            this.logger.error("cmc.ChannelBaseService.send.res", (Object)res);
            this.logger.error("cmc.ChannelBaseService.send.res1", (Object)JsonUtil.buildNormalBinder().toJson((Object)channelRequest));
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("res", res);
            map.put("channelClearFchannel", cmChannelClear.getChannelClearFchannel());
            map.put("channelClearSeqno", cmChannelClear.getChannelClearSeqno());
            map.put("tenantCode", cmChannelClear.getTenantCode());
            map.put("clearOrderSeqno", cmChannelClear.getClearOrderSeqno());
            channelRest = this.buildResponeBank(map, channelRequest);
            if (null == channelRest) {
                throw new ApiException("cmc.ChannelBaseService.send.channelRest", "");
            }
            channelRest.setClearOrderSeqno(cmChannelClear.getClearOrderSeqno());
        } else {
            channelRest = new ChannelRest();
            channelRest.setChannelClearFchannel(cmChannelClear.getChannelClearFchannel());
            channelRest.setChannelClearSeqno(cmChannelClear.getChannelClearSeqno());
            channelRest.setTenantCode(cmChannelClear.getTenantCode());
            channelRest.setClearOrderSeqno(cmChannelClear.getClearOrderSeqno());
            channelRest.setBankSeqno(cmChannelClear.getChannelClearSeqno());
            channelRest.setDataState(1);
            channelRest.setRestMemo("");
            channelRest.setChannelSubStr(this.getChannelStr(channelRequest));
            channelRest.setDebitFlag(channelRequest.isDebitFlag());
            channelRest.setDebitResult(channelRequest.getDebitResult());
            channelRest.setBankRescode(channelRequest.getBankRescode());
            channelRest.setBankResmsg(channelRequest.getBankResmsg());
            channelRest.setBankSeqno(channelRequest.getBankSeqno());
            channelRest.setChannelAcceptDate(channelRequest.getChannelAcceptDate());
            if (channelRest.isDebitFlag() && "SUCCESS".equals(channelRest.getDebitResult())) {
                channelRest.setDataState(2);
            }
        }
        return channelRest;
    }

    protected String invoke(String url, Map request) {
        return this.internalInvoke(url, request);
    }

    protected String httpInvoke(ChannelRequest channelRequest) {
        return null;
    }

    protected ChannelRequest buildApiReuestParam(String channelApiCode, CmChannelClear cmChannelClear) {
        Map exmap;
        ChannelRequest channelRequest = new ChannelRequest();
        channelRequest.setSuccess(false);
        if (StringUtils.isBlank((String)channelApiCode) || null == cmChannelClear) {
            this.logger.error("cmc.ChannelBaseService.buildApiReuestParam.null");
            channelRequest.setBmsg("\u53c2\u6570\u4e3a\u7a7a");
            return channelRequest;
        }
        String fchannelCode = this.getFchannelCode();
        if (StringUtils.isBlank((String)fchannelCode)) {
            this.logger.error("cmc.ChannelBaseService.buildApiReuestParam.fchannelCode", (Object)fchannelCode);
            channelRequest.setBmsg("fchannelCode");
            return channelRequest;
        }
        cmChannelClear.setChannelClearFchannel(fchannelCode);
        CmFchannelApi cmFchannelApi = this.getCmFchannelApi(fchannelCode, channelApiCode, cmChannelClear.getTenantCode());
        if (null == cmFchannelApi) {
            this.logger.error("cmc.ChannelBaseService.buildApiReuestParam.cmFchannelApi", (Object)(fchannelCode + ":" + channelApiCode + ":" + cmChannelClear.getTenantCode() + ":"));
            channelRequest.setBmsg("API\u672a\u8bbe\u7f6e1");
            return channelRequest;
        }
        channelRequest.setCmFchannelApi(cmFchannelApi);
        channelRequest.setApiRetype(cmFchannelApi.getFchannelApiRetype());
        channelRequest.setChannelApiCode(channelApiCode);
        String paramkey = fchannelCode + "-" + channelApiCode + "-" + ChannelApiParamType.IN.getCode() + "-" + cmChannelClear.getTenantCode();
        List<CmFchannelApiparam> apiparamList = this.getCmFchannelApiparam(fchannelCode, channelApiCode, ChannelApiParamType.IN.getCode(), cmChannelClear.getTenantCode());
        if (ListUtil.isEmpty(apiparamList)) {
            this.logger.error("cmc.ChannelBaseService.buildApiReuestParam.apiParamStr", (Object)paramkey);
            channelRequest.setBmsg("apiParam\u672a\u8bbe\u7f6e");
            return channelRequest;
        }
        String proappCode = "";
        if (StringUtils.isNotBlank((String)cmChannelClear.getExtension()) && null != (exmap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(cmChannelClear.getExtension(), String.class, String.class)) && StringUtils.isBlank((String)(proappCode = (String)exmap.get("wap_name")))) {
            proappCode = "";
        }
        Map<String, String> configMap = this.getConfigMap(cmChannelClear.getChannelClearFchannel(), ChannelConfigScope.PRO.getCode(), fchannelCode, proappCode, cmChannelClear.getTenantCode());
        channelRequest.setConfigMap(configMap);
        if (!this.buildParamMap(channelRequest, configMap, apiparamList, cmChannelClear, cmFchannelApi)) {
            this.logger.error("cmc.ChannelBaseService.buildApiReuestParam.buildParamMap");
            channelRequest.setBmsg("\u53c2\u6570\u7ed1\u5b9a\u5931\u8d25");
            return channelRequest;
        }
        if (ChannelApiRetype.HTML.getCode().equals(channelRequest.getApiRetype()) && StringUtils.isNotBlank((String)cmFchannelApi.getFchannelApiCallext())) {
            this.buildHtmlStr(channelRequest, cmFchannelApi.getFchannelApiCallext(), cmFchannelApi);
        }
        channelRequest.setSuccess(true);
        return channelRequest;
    }

    protected void buildHtmlStr(ChannelRequest channelRequest, String callext, CmFchannelApi cmFchannelApi) {
        if (null == channelRequest || StringUtils.isBlank((String)callext)) {
            return;
        }
        HashMap<String, Object> jsMap = new HashMap<String, Object>();
        jsMap.put("map", channelRequest.getRequestData());
        jsMap.put("cmFchannelApi", cmFchannelApi);
        jsMap.put("config", channelRequest.getConfigMap());
        String htmlStr = (String)ScriptUtil.evel((String)callext, jsMap);
        if (StringUtils.isBlank((String)htmlStr)) {
            this.logger.error("cmc.ChannelBaseService.buildHtmlStr.htmlStr", (Object)callext);
            this.logger.error("cmc.ChannelBaseService.buildHtmlStr.htmlStr", (Object)((Object)jsMap).toString());
        }
        channelRequest.setHtmlStr(htmlStr);
    }

    private boolean buildParamMap(ChannelRequest channelRequest, Map<String, String> configMap, List<CmFchannelApiparam> apiparamList, CmChannelClear cmChannelClear, CmFchannelApi cmFchannelApi) {
        if (null == channelRequest) {
            this.logger.error("cmc.ChannelBaseService.buildParamMap.channelRequest");
            return false;
        }
        if (null == configMap || configMap.isEmpty() || null == apiparamList || apiparamList.isEmpty() || null == cmChannelClear) {
            this.logger.error("cmc.ChannelBaseService.buildParamMap.null");
            return false;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        HashMap<String, Object> jsMap = new HashMap<String, Object>();
        jsMap.put("cmChannelClear", cmChannelClear);
        jsMap.put("config", configMap);
        jsMap.put("cmFchannelApi", cmFchannelApi);
        this.putExtension(cmChannelClear, jsMap);
        for (CmFchannelApiparam cmFchannelApiparam : apiparamList) {
            Object value = "";
            String jsstr = cmFchannelApiparam.getFchannelApiparamMcon();
            String mname = cmFchannelApiparam.getFchannelApiparamMname();
            if (StringUtils.isNotBlank((String)jsstr)) {
                value = jsstr.equals("java:makeGild") ? this.makeGild(cmChannelClear, cmFchannelApi, configMap) : (jsstr.equals("java:timestamp") ? DateUtils.parseDateTime((Date)new Date()) : (jsstr.equals("java:uuid") ? UUID.randomUUID().toString().replaceAll("-", "") : ScriptUtil.evel((String)jsstr, jsMap)));
            } else if (StringUtils.isNotBlank((String)mname)) {
                value = BeanUtils.forceGetProperty(jsMap, (String)mname);
            }
            paramMap.put(cmFchannelApiparam.getFchannelApiparamKey(), String.valueOf(value));
        }
        channelRequest.setRequestData(paramMap);
        channelRequest.setCmChannelClear(cmChannelClear);
        if (ChannelApiSign.SIGN.getCode().equals(cmFchannelApi.getFchannelApiSecure())) {
            this.getChannelSignService().sign(channelRequest);
        }
        return true;
    }

    public static void main(String[] args) {
        HashMap jsMap = new HashMap();
        HashMap<String, Integer> ext = new HashMap<String, Integer>();
        ext.put("test", 10);
        jsMap.put("ext", ext);
        Object value = ScriptUtil.evel((String)"var fee=ext.get('test'); fee=Math.round(fee*100); return fee.toFixed();", jsMap);
        System.out.println(value);
    }

    private void putExtension(CmChannelClear cmChannelClear, Map<String, Object> jsMap) {
        if (cmChannelClear == null) {
            return;
        }
        if (StringUtils.isNotBlank((String)cmChannelClear.getExtension())) {
            String extJsonStr = cmChannelClear.getExtension();
            Map extMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(extJsonStr, String.class, Object.class);
            jsMap.put("extension", extMap);
        }
    }

    private String makeGild(CmChannelClear cmChannelClear, CmFchannelApi cmFchannelApi, Map<String, String> configMap) {
        if (null == cmChannelClear || null == cmFchannelApi) {
            return null;
        }
        CmChannelGildDomain cmChannelGildDomain = new CmChannelGildDomain();
        try {
            BeanUtils.copyAllPropertys((Object)cmChannelGildDomain, (Object)cmChannelClear);
            BeanUtils.copyAllPropertys((Object)cmChannelGildDomain, (Object)cmFchannelApi);
            cmChannelGildDomain.setChannelClearFchannel(this.getFchannelCode());
            cmChannelGildDomain.setChannelApiCtype(cmFchannelApi.getFchannelApiCtype());
            cmChannelGildDomain.setChannelApiType(cmFchannelApi.getFchannelApiType());
            cmChannelGildDomain.setAccountExname(cmChannelClear.getFaccountAname());
            cmChannelGildDomain.setBankName(cmChannelClear.getFaccountName());
            cmChannelGildDomain.setTenantCode(cmChannelClear.getTenantCode());
            return JsonUtil.buildNormalBinder().toJson((Object)cmChannelGildDomain);
        }
        catch (Exception e) {
            this.logger.error("cmc.ChannelBaseService.makeGild.e", (Throwable)e);
            return null;
        }
    }

    private void checkHttpInvokeResult(String res) {
        if (StringUtils.isEmpty((String)res)) {
            throw new ApiException("cmc.ChannelBaseService.checkHttpInvokeResult", "http\u8bf7\u6c42\u7ed3\u679c\u8fd4\u56de\u503c\u4e3a\u7a7a");
        }
    }

    @Override
    protected ChannelRest verifySign(BankRequest bankRequest) {
        if (null == bankRequest || null == bankRequest.getRequestData() || bankRequest.getRequestData().isEmpty()) {
            return null;
        }
        try {
            ChannelRest channelRest = this.getChannelSignService().verifySign(bankRequest);
            return channelRest;
        }
        catch (Exception e) {
            return null;
        }
    }
}

