/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.com.service;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.ext.channel.com.domain.BankRequest;
import com.yqbsoft.laser.service.ext.channel.com.domain.ChannelRest;
import com.yqbsoft.laser.service.ext.channel.com.domain.CmFchannelApi;
import com.yqbsoft.laser.service.ext.channel.com.domain.CmFchannelApiparam;
import com.yqbsoft.laser.service.ext.channel.com.domain.CmFchannelApires;
import com.yqbsoft.laser.service.ext.channel.com.secure.ChannelSignService;
import com.yqbsoft.laser.service.ext.channel.com.util.DateFormatSupport;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.ScriptUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public abstract class ChannelBaseSignService
extends BaseServiceImpl
implements ChannelSignService {
    private static final String SYS_CODE = "cmc.ChannelBaseService";

    protected ChannelRest buildApiCallParam(BankRequest bankRequest) {
        if (null == bankRequest) {
            throw new ApiException("cmc.ChannelBaseService.buildApiCallParam.null", "\u53c2\u6570\u4e3a\u7a7a");
        }
        String channelApiCode = bankRequest.getChannelApiCode();
        if (StringUtils.isBlank((String)channelApiCode)) {
            throw new ApiException("cmc.ChannelBaseService.buildApiCallParam.channelApiCode", "\u53c2\u6570\u4e3a\u7a7a");
        }
        String fchannelCode = bankRequest.getChannelClearFchannel();
        if (StringUtils.isBlank((String)fchannelCode)) {
            throw new ApiException("cmc.ChannelBaseService.buildApiCallParam.fchannelCode", fchannelCode);
        }
        String key = fchannelCode + "-" + channelApiCode + "-" + bankRequest.getTenantCode();
        CmFchannelApi cmFchannelApi = (CmFchannelApi)DisUtil.getMapJson((String)"Fchannel_api", (String)key, CmFchannelApi.class);
        if (null == cmFchannelApi) {
            key = fchannelCode + "-" + channelApiCode + "-" + "00000000";
            cmFchannelApi = (CmFchannelApi)DisUtil.getMapJson((String)"Fchannel_api", (String)key, CmFchannelApi.class);
        }
        if (null == cmFchannelApi) {
            throw new ApiException("cmc.ChannelBaseService.buildApiCallParam.apiStr", key);
        }
        String paramkey = fchannelCode + "-" + channelApiCode + "-" + bankRequest.getType() + "-" + bankRequest.getTenantCode();
        List apiparamList = DisUtil.getMapListJson((String)"Fchannel_apiparam", (String)paramkey, CmFchannelApiparam.class);
        if (ListUtil.isEmpty((Collection)apiparamList)) {
            paramkey = fchannelCode + "-" + channelApiCode + "-" + bankRequest.getType() + "-" + "00000000";
            apiparamList = DisUtil.getMapListJson((String)"Fchannel_apiparam", (String)paramkey, CmFchannelApiparam.class);
        }
        if (ListUtil.isEmpty((Collection)apiparamList)) {
            throw new ApiException("cmc.ChannelBaseService.buildApiCallParam.apiParamStr", "apiParam\u672a\u8bbe\u7f6e", paramkey);
        }
        return this.buildCallParamMap(bankRequest, apiparamList, cmFchannelApi);
    }

    private ChannelRest buildCallParamMap(BankRequest bankRequest, List<CmFchannelApiparam> apiparamList, CmFchannelApi cmFchannelApi) {
        if (null == bankRequest) {
            this.logger.error("cmc.ChannelBaseService.buildCallParamMap.channelRequest");
            return null;
        }
        if (null == apiparamList || apiparamList.isEmpty()) {
            this.logger.error("cmc.ChannelBaseService.buildCallParamMap.null");
            return null;
        }
        Object value = "";
        String jsstr = "";
        HashMap<String, Object> jsMap = new HashMap<String, Object>();
        jsMap.put("bankRequest", bankRequest);
        jsMap.put("cmFchannelApi", cmFchannelApi);
        String mname = "";
        ChannelRest channelRest = new ChannelRest();
        channelRest.setChannelClearFchannel(bankRequest.getChannelClearFchannel());
        for (CmFchannelApiparam cmFchannelApiparam : apiparamList) {
            jsstr = cmFchannelApiparam.getFchannelApiparamMcon();
            mname = cmFchannelApiparam.getFchannelApiparamMname();
            if (StringUtils.isNotBlank((String)jsstr)) {
                value = jsstr.contains("formatDate#") ? DateFormatSupport.format(jsstr, (String)ScriptUtil.evel((String)mname, jsMap)) : ScriptUtil.evel((String)jsstr, jsMap);
            } else if (StringUtils.isNotBlank((String)mname)) {
                value = BeanUtils.forceGetProperty(jsMap, (String)mname);
            }
            BeanUtils.forceSetProperty((Object)channelRest, (String)cmFchannelApiparam.getFchannelApiparamKey(), (Object)value);
        }
        this.logger.error("cmc.ChannelBaseService.buildCallParamMap.channelRest" + JsonUtil.buildNormalBinder().toJson((Object)channelRest) + "bankRequest" + JsonUtil.buildNormalBinder().toJson((Object)bankRequest));
        if (!this.mappingBankResCode(channelRest, bankRequest)) {
            return null;
        }
        return channelRest;
    }

    private boolean mappingBankResCode(ChannelRest channelRest, BankRequest bankRequest) {
        if (null == channelRest || null == bankRequest) {
            return false;
        }
        String key = bankRequest.getChannelClearFchannel() + "-" + bankRequest.getChannelApiCode() + "-" + channelRest.getBankRescode() + "-" + bankRequest.getTenantCode();
        CmFchannelApires cmFchannelApires = (CmFchannelApires)DisUtil.getMapJson((String)"Fchannel_apires", (String)key, CmFchannelApires.class);
        if (null == cmFchannelApires) {
            key = bankRequest.getChannelClearFchannel() + "-" + bankRequest.getChannelApiCode() + "-" + channelRest.getBankRescode() + "-" + "00000000";
            cmFchannelApires = (CmFchannelApires)DisUtil.getMapJson((String)"Fchannel_apires", (String)key, CmFchannelApires.class);
        }
        if (null == cmFchannelApires) {
            this.logger.error("cmc.ChannelBaseService.mappingBankResCode.null", (Object)key);
            return false;
        }
        channelRest.setDataState(Integer.valueOf(cmFchannelApires.getFchannelApiresOrder()));
        return true;
    }
}

