/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.com.service;

import com.yqbsoft.laser.service.ext.channel.com.domain.BankRequest;
import com.yqbsoft.laser.service.ext.channel.com.domain.ChannelRest;
import com.yqbsoft.laser.service.ext.channel.com.domain.ChannelRlRequest;
import com.yqbsoft.laser.service.ext.channel.com.domain.CmChannelGildDomain;
import com.yqbsoft.laser.service.ext.channel.com.domain.CmFchannelApi;
import com.yqbsoft.laser.service.ext.channel.com.domain.CmFchannelApiparam;
import com.yqbsoft.laser.service.ext.channel.com.domain.UmUserDomain;
import com.yqbsoft.laser.service.ext.channel.com.domain.UmUserinfoQuaDomain;
import com.yqbsoft.laser.service.ext.channel.com.enumc.ChannelApiParamType;
import com.yqbsoft.laser.service.ext.channel.com.enumc.ChannelApiSign;
import com.yqbsoft.laser.service.ext.channel.com.enumc.ChannelConfigScope;
import com.yqbsoft.laser.service.ext.channel.com.secure.ChannelRlSignService;
import com.yqbsoft.laser.service.ext.channel.com.service.ChannelSuppService;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.ScriptUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public abstract class ChannelRelBaseService
extends ChannelSuppService {
    private static final String SYS_CODE = "cmc.ChannelRelBaseService";
    private ChannelRlSignService channelRlSignService;

    public void setChannelRlSignService(ChannelRlSignService channelRlSignService) {
        this.channelRlSignService = channelRlSignService;
    }

    public ChannelRlSignService getChannelRlSignService() {
        return this.channelRlSignService;
    }

    protected ChannelRlRequest buildSend(String channelApiCode, String tenantCode, Map<String, Object> map) {
        return this.send(this.buildApiReuestParam(channelApiCode, tenantCode, map), map);
    }

    protected abstract ChannelRlRequest send(ChannelRlRequest var1, Map<String, Object> var2);

    protected abstract Object retrunParam(ChannelRlRequest var1, Map<String, Object> var2);

    protected ChannelRlRequest buildApiReuestParam(String channelApiCode, String tenantCode, Map<String, Object> map) {
        ChannelRlRequest channelRequest = new ChannelRlRequest();
        channelRequest.setSuccess(false);
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)channelApiCode) || MapUtil.isEmpty(map)) {
            this.logger.error("cmc.ChannelRelBaseService.buildApiReuestParam.null", (Object)(tenantCode + "-" + channelApiCode + "-" + map.toString()));
            channelRequest.setBmsg("\u53c2\u6570\u4e3a\u7a7a");
            return channelRequest;
        }
        String fchannelCode = this.getFchannelCode();
        if (StringUtils.isBlank((String)fchannelCode)) {
            this.logger.error("cmc.ChannelRelBaseService.buildApiReuestParam.fchannelCode", (Object)fchannelCode);
            channelRequest.setBmsg("fchannelCode");
            return channelRequest;
        }
        channelRequest.setSendData(map);
        CmFchannelApi cmFchannelApi = this.getCmFchannelApi(fchannelCode, channelApiCode, tenantCode);
        if (null == cmFchannelApi) {
            this.logger.error("cmc.ChannelRelBaseService.buildApiReuestParam.cmFchannelApi", (Object)(fchannelCode + ":" + channelApiCode + ":" + tenantCode + ":"));
            channelRequest.setBmsg("API\u672a\u8bbe\u7f6e1");
            return channelRequest;
        }
        channelRequest.setCmFchannelApi(cmFchannelApi);
        channelRequest.setApiRetype(cmFchannelApi.getFchannelApiRetype());
        channelRequest.setChannelApiCode(channelApiCode);
        String paramkey = fchannelCode + "-" + channelApiCode + "-" + ChannelApiParamType.IN.getCode() + "-" + tenantCode;
        List<CmFchannelApiparam> apiparamList = this.getCmFchannelApiparam(fchannelCode, channelApiCode, ChannelApiParamType.IN.getCode(), tenantCode);
        if (ListUtil.isEmpty(apiparamList)) {
            this.logger.error("cmc.ChannelRelBaseService.buildApiReuestParam.apiParamStr", (Object)paramkey);
            channelRequest.setBmsg("apiParam\u672a\u8bbe\u7f6e");
            return channelRequest;
        }
        String proappCode = (String)map.get("proappCode");
        String channelClearFchannel = (String)map.get("channelClearFchannel");
        Map<String, String> configMap = this.getConfigMap(channelClearFchannel, ChannelConfigScope.PRO.getCode(), fchannelCode, proappCode, tenantCode);
        channelRequest.setConfigMap(configMap);
        if (!this.buildParamMap(channelRequest, configMap, apiparamList, map, cmFchannelApi)) {
            this.logger.error("cmc.ChannelRelBaseService.buildApiReuestParam.buildParamMap");
            channelRequest.setBmsg("\u53c2\u6570\u7ed1\u5b9a\u5931\u8d25");
            return channelRequest;
        }
        channelRequest.setSuccess(true);
        return channelRequest;
    }

    private boolean buildParamMap(ChannelRlRequest channelRequest, Map<String, String> configMap, List<CmFchannelApiparam> apiparamList, Map<String, Object> map, CmFchannelApi cmFchannelApi) {
        if (null == channelRequest) {
            this.logger.error("cmc.ChannelRelBaseService.buildParamMap.channelRequest");
            return false;
        }
        if (null == configMap || configMap.isEmpty() || null == apiparamList || apiparamList.isEmpty() || MapUtil.isEmpty(map)) {
            this.logger.error("cmc.ChannelRelBaseService.buildParamMap.null");
            return false;
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        HashMap<String, Object> jsMap = new HashMap<String, Object>();
        jsMap.put("cmChannelClear", map);
        jsMap.put("config", configMap);
        jsMap.put("cmFchannelApi", cmFchannelApi);
        for (CmFchannelApiparam cmFchannelApiparam : apiparamList) {
            Object value = "";
            String jsstr = cmFchannelApiparam.getFchannelApiparamMcon();
            String mname = cmFchannelApiparam.getFchannelApiparamMname();
            if (StringUtils.isNotBlank((String)jsstr)) {
                value = jsstr.equals("java:makeGild") ? this.makeGild(map, cmFchannelApi, configMap) : (jsstr.equals("java:timestamp") ? DateUtils.parseDateTime((Date)new Date()) : (jsstr.equals("java:uuid") ? UUID.randomUUID().toString().replaceAll("-", "") : ScriptUtil.evel((String)jsstr, jsMap)));
            } else if (StringUtils.isNotBlank((String)mname)) {
                value = BeanUtils.forceGetProperty(jsMap, (String)mname);
            }
            paramMap.put(cmFchannelApiparam.getFchannelApiparamKey(), String.valueOf(value));
        }
        channelRequest.setRequestData(paramMap);
        if (ChannelApiSign.SIGN.getCode().equals(cmFchannelApi.getFchannelApiSecure())) {
            this.getChannelRlSignService().sign(channelRequest);
        }
        return true;
    }

    private String makeGild(Map<String, Object> map, CmFchannelApi cmFchannelApi, Map<String, String> configMap) {
        if (MapUtil.isEmpty(map) || null == cmFchannelApi) {
            return null;
        }
        CmChannelGildDomain cmChannelGildDomain = new CmChannelGildDomain();
        try {
            BeanUtils.copyAllPropertys((Object)cmChannelGildDomain, map);
            BeanUtils.copyAllPropertys((Object)cmChannelGildDomain, (Object)cmFchannelApi);
            cmChannelGildDomain.setChannelClearFchannel(this.getFchannelCode());
            cmChannelGildDomain.setChannelApiCtype(cmFchannelApi.getFchannelApiCtype());
            cmChannelGildDomain.setChannelApiType(cmFchannelApi.getFchannelApiType());
            cmChannelGildDomain.setTenantCode((String)map.get("tenantCode"));
            return JsonUtil.buildNormalBinder().toJson((Object)cmChannelGildDomain);
        }
        catch (Exception e) {
            this.logger.error("cmc.ChannelRelBaseService.makeGild.e", (Throwable)e);
            return null;
        }
    }

    @Override
    protected ChannelRest verifySign(BankRequest bankRequest) {
        if (null == bankRequest || null == bankRequest.getRequestData() || bankRequest.getRequestData().isEmpty()) {
            return null;
        }
        try {
            ChannelRest channelRest = this.getChannelRlSignService().verifySign(bankRequest);
            return channelRest;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected UmUserinfoQuaDomain getUmUserInfoQuaByOcode(String tenantCode, String userOcode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)userOcode)) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        map.put("userinfoQuaCode", userOcode);
        String userinfoQuaJson = (String)this.getInternalRouter().inInvoke("um.userinfoQua.getUserinfoQuaByCode", map);
        return (UmUserinfoQuaDomain)JsonUtil.buildNormalBinder().getJsonToObject(userinfoQuaJson, UmUserinfoQuaDomain.class);
    }

    protected UmUserDomain getUmUserByPcode(String tenantCode, String userPcode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)userPcode)) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        map.put("userPhone", userPcode);
        String umUserJson = (String)this.getInternalRouter().inInvoke("um.user.getUserByPcode", map);
        return (UmUserDomain)JsonUtil.buildNormalBinder().getJsonToObject(umUserJson, UmUserDomain.class);
    }
}

