/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.discom.service;

import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.channel.discom.api.DisOrderService;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisChannel;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisContract;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisContractDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisContractGoodsDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisDictionary;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisPackageDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisRefundDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisRefundFileDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisRefundReDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisStatementContract;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisStatementContractDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.GoodsBean;
import com.yqbsoft.laser.service.ext.channel.discom.domain.OcContract;
import com.yqbsoft.laser.service.ext.channel.discom.domain.OcRefund;
import com.yqbsoft.laser.service.ext.channel.discom.domain.ResChannelsendDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.ResEvaluateGoodsDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.ResEvaluateReplyDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.ResEvaluateScopeDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.RsSku;
import com.yqbsoft.laser.service.ext.channel.discom.domain.SgOccontractReDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.SgSendgoodsDataDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.SgSendgoodsDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.SgSendgoodsLogDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.SgSendgoodsReDomain;
import com.yqbsoft.laser.service.ext.channel.discom.service.DisBaseServiceImpl;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class DisOrderBaseService
extends DisBaseServiceImpl
implements DisOrderService {
    private String SYS_CODE = "cmc.DisOrderBaseService";

    @Override
    public Map<String, Object> buildComParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        if (StringUtils.isBlank((String)channelApiCode)) {
            this.logger.error(this.SYS_CODE + ".buildComParam.channelApiCode");
            return null;
        }
        return this.buildComOrderParam(channelApiCode, disChannel, sendParam, configMap, param);
    }

    public abstract Map<String, Object> buildComOrderParam(String var1, DisChannel var2, Map<String, Object> var3, Map<String, String> var4, Map<String, Object> var5);

    public abstract Object sendComOrder(String var1, DisChannel var2, Map<String, Object> var3, Map<String, String> var4, Map<String, Object> var5);

    @Override
    public Object sendComParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        if (StringUtils.isBlank((String)channelApiCode)) {
            this.logger.error(this.SYS_CODE + ".sendComParam.channelApiCode");
            return null;
        }
        return this.sendComOrder(channelApiCode, disChannel, sendhttpParam, configMap, param);
    }

    @Override
    public QueryResult<DisContractDomain> queryOrder(String memberCode, String tenantCode, String param, int pageNo, int pageSize) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disOrder.queryOrder";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.put("pageNo", pageNo);
        paramMap.put("pageSize", pageSize);
        paramMap.put("param", param);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (QueryResult)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public QueryResult<DisContractDomain> queryTimeOrder(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            return null;
        }
        String memberCode = (String)map.get("memberCode");
        String tenantCode = (String)map.get("tenantCode");
        String channelApiCode = "cmc.disOrder.queryTimeOrder";
        map.put("channelApiCode", channelApiCode);
        return (QueryResult)this.sendCall(map, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public DisContractDomain getSendOrder(String contractNbillcode, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disOrder.getSendOrder";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.put("contractNbillcode", contractNbillcode);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        Object obj = this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
        if (null == obj) {
            return null;
        }
        if (obj instanceof DisContractDomain) {
            return (DisContractDomain)obj;
        }
        this.logger.error(this.SYS_CODE + ".getSendOrder.return", obj);
        return null;
    }

    @Override
    public String saveSendOrderState(Map<String, Object> map) {
        String channelApiCode;
        Map<String, String> configMap;
        this.logger.error(this.SYS_CODE + ".saveSendOrderState", (Object)JsonUtil.buildNonDefaultBinder().toJson(map));
        if (MapUtil.isEmpty(map)) {
            this.logger.error(this.SYS_CODE + ".saveSendOrderState.map");
            return null;
        }
        String channelCode = (String)map.get("channelCode");
        String memberCode = (String)map.get("memberCode");
        String tenantCode = (String)map.get("tenantCode");
        DisChannel disChannel = this.getDisChannel(tenantCode, channelCode);
        if (null == disChannel) {
            this.logger.error(this.SYS_CODE + ".saveSendOrderState.disChannel", (Object)(tenantCode + "-" + channelCode));
            return "ERROR";
        }
        if (StringUtils.isBlank((String)memberCode)) {
            memberCode = disChannel.getMemberCode();
        }
        if (MapUtil.isEmpty(configMap = this.getChannelConfig(tenantCode, channelCode, channelApiCode = "cmc.disOrder.saveSendOrderState"))) {
            this.logger.error(this.SYS_CODE + ".saveSendOrderState.configMap", (Object)(tenantCode + "-" + channelCode + "-" + channelApiCode));
            return "ERROR";
        }
        if (!this.getDisSignService().verifySign(map, configMap)) {
            this.logger.error(this.SYS_CODE + ".saveSendOrderState.verifySign", (Object)(map.toString() + "=" + configMap.toString()));
            return "\u9a8c\u7b7e\u5931\u8d25";
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        paramMap.putAll(map);
        Map<String, Object> sendparam = this.buildOrderParam(paramMap);
        if (MapUtil.isEmpty(sendparam)) {
            this.logger.error(this.SYS_CODE + ".saveSendOrderState.sendparam: ", paramMap);
            return null;
        }
        return this.saveOrderParam(channelApiCode, disChannel, sendparam, configMap, paramMap);
    }

    @Override
    public SgSendgoodsDomain getSendCannelDelivery(Map<String, Object> map, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disOrder.getSendCannelDelivery";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.putAll(map);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (SgSendgoodsDomain)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    public abstract Map<String, Object> buildOrderParam(Map<String, Object> var1);

    public abstract String saveOrderParam(String var1, DisChannel var2, Map<String, Object> var3, Map<String, String> var4, Map<String, Object> var5);

    protected void saveOrder(List<DisContractDomain> disContractDomainList, DisChannel disChannel) {
        if (null == disChannel || ListUtil.isEmpty(disContractDomainList)) {
            return;
        }
        String apiCode = "dis.channelsendBase.saveContractBatch";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("disContractDomainList", JsonUtil.buildNormalBinder().toJson(disContractDomainList));
        this.internalInvoke(apiCode, paramMap);
    }

    protected DisContractDomain getContractByNbCode(String tenantCode, String contractNbillcode, DisChannel disChannel) {
        if (null == disChannel || StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)contractNbillcode)) {
            return null;
        }
        String apiCode = "dis.contract.getContractByNbCode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("contractNbillcode", contractNbillcode);
        paramMap.put("channelCode", disChannel.getChannelCode());
        return (DisContractDomain)this.getForObject(apiCode, DisContractDomain.class, paramMap);
    }

    protected DisContractDomain getContractDomainByCode(String tenantCode, String contractBillcode, DisChannel disChannel) {
        if (null == disChannel || StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)contractBillcode)) {
            return null;
        }
        String apiCode = "dis.contract.getContractDomainByCode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("contractBillcode", contractBillcode);
        paramMap.put("channelCode", disChannel.getChannelCode());
        return (DisContractDomain)this.getForObject(apiCode, DisContractDomain.class, paramMap);
    }

    protected void updateOrder(String tenantCode, String contractNbillcode, Integer dataState, Integer oldDataState, Map<String, Object> map, DisChannel disChannel) {
        if (null == disChannel || StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)contractNbillcode)) {
            return;
        }
        String apiCode = "dis.channelsendBase.sendUpdateContractStateByNbCode";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("contractNbillcode", contractNbillcode);
        paramMap.put("dataState", dataState);
        paramMap.put("channelCode", disChannel.getChannelCode());
        paramMap.put("oldDataState", oldDataState);
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        this.internalInvoke(apiCode, paramMap);
    }

    protected void updateExtrinsicStateByRefundCode(String refundCode, String dataOpnextbillstate, String tenantCode) {
        if (StringUtils.isBlank((String)refundCode) || StringUtils.isBlank((String)dataOpnextbillstate) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(this.SYS_CODE + ".updateExtrinsicStateByRefundCode.", (Object)(refundCode + "=:=" + dataOpnextbillstate + "=:=" + tenantCode));
            return;
        }
        String apiCode = "oc.refund.updateExtrinsicStateByRefundCode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("refundCode", refundCode);
        paramMap.put("dataOpnextbillstate", dataOpnextbillstate);
        paramMap.put("tenantCode", tenantCode);
        this.internalInvoke(apiCode, paramMap);
    }

    protected OcRefund queryRefundByNbbillcode(String channelCode, String contractNbbillcode, String tenantCode) {
        if (StringUtils.isBlank((String)channelCode) || StringUtils.isBlank((String)contractNbbillcode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(this.SYS_CODE + ".queryRefundByNbbillcode.", (Object)(channelCode + "=:=" + contractNbbillcode + "=:=" + tenantCode));
            return null;
        }
        String apiCode = "oc.refund.queryRefundPage";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("contractNbbillcode", contractNbbillcode);
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("channelCode", channelCode);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        QueryResult queryResult = this.getQueryResutl(apiCode, param, OcRefund.class);
        if (null == queryResult || ListUtil.isEmpty((Collection)queryResult.getList())) {
            this.logger.error(this.SYS_CODE + ".queryRefundByNbbillcode.queryResult ", paramMap);
            return null;
        }
        return (OcRefund)queryResult.getList().get(0);
    }

    protected void updateRefunFlagByCode(BigDecimal contractGoodsRefnum, String tenantCode, String channelCode, String contractGoodsCode) {
        if (null == contractGoodsRefnum || StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)channelCode) || StringUtils.isBlank((String)contractGoodsCode)) {
            this.logger.error(this.SYS_CODE + ".updateRefunFlagByCode.param ", (Object)(contractGoodsRefnum + " =:= " + tenantCode + " =:= " + channelCode + " =:= " + contractGoodsCode));
            return;
        }
        String apiCode = "dis.contract.updateRefunFlagByCode";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("channelCode", channelCode);
        paramMap.put("contractGoodsRefnum", contractGoodsRefnum);
        paramMap.put("refundFlag", 1);
        paramMap.put("contractGoodsCode", contractGoodsCode);
        this.internalInvoke(apiCode, paramMap);
    }

    protected GoodsBean getResourceBySkuNo(String skuNo, String memberCode, String memberCcode, String channelCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)memberCcode) || StringUtils.isBlank((String)skuNo)) {
            return null;
        }
        String apiCode = "rs.resourceGoods.getResourceBySkuNo";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("skuNo", skuNo);
        paramMap.put("memberCode", memberCode);
        paramMap.put("memberCcode", memberCcode);
        paramMap.put("channelCode", channelCode);
        return (GoodsBean)this.getForObject(apiCode, GoodsBean.class, paramMap);
    }

    protected RsSku getSkuBySkuNo(String skuNo, String memberCode, String memberCcode, String channelCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)memberCcode) || StringUtils.isBlank((String)skuNo)) {
            return null;
        }
        String apiCode = "rs.sku.getSkuBySkuNo";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("skuNo", skuNo);
        paramMap.put("memberCode", memberCode);
        paramMap.put("memberCcode", memberCcode);
        paramMap.put("channelCode", channelCode);
        return (RsSku)this.getForObject(apiCode, RsSku.class, paramMap);
    }

    protected SgOccontractReDomain getOccontractByNbbillCode(String tenantCode, String channelCode, String contractNbbillcode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)channelCode) || StringUtils.isBlank((String)contractNbbillcode)) {
            this.logger.error(this.SYS_CODE + ".getOccontractByNbbillCode.", (Object)(channelCode + " =:= " + channelCode + " =:= " + contractNbbillcode));
            return null;
        }
        String apiCode = "sg.sgOccontract.getOccontractByNbbillCode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("contractNbbillcode", contractNbbillcode);
        paramMap.put("channelCode", channelCode);
        return (SgOccontractReDomain)this.getForObject(apiCode, SgOccontractReDomain.class, paramMap);
    }

    protected void saveRefund(List<DisRefundDomain> disRefundDomainList, DisChannel disChannel) {
        if (null == disChannel || ListUtil.isEmpty(disRefundDomainList)) {
            return;
        }
        String apiCode = "dis.channelsendBase.sendSaveRefundBatch";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("disRefundDomainList", JsonUtil.buildNormalBinder().toJson(disRefundDomainList));
        this.internalInvoke(apiCode, paramMap);
    }

    protected void sendUpdateRefundStateByCode(String tenantCode, String refundCode, String channelCode, Integer dataState, Integer oldDataState, Map<String, Object> map) {
        if (null == tenantCode || null == refundCode || null == channelCode || null == dataState || null == oldDataState) {
            return;
        }
        String apiCode = "dis.channelsendBase.sendUpdateRefundStateByCode";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("refundCode", refundCode);
        paramMap.put("channelCode", channelCode);
        paramMap.put("dataState", dataState);
        paramMap.put("oldDataState", oldDataState);
        paramMap.put("map", map);
        this.internalInvoke(apiCode, paramMap);
    }

    protected DisRefundDomain getRefundByOCode(String tenantCode, String refundOcode, DisChannel disChannel) {
        if (null == disChannel || StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)refundOcode)) {
            return null;
        }
        String apiCode = "dis.refund.getRefundByOcode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("refundOcode", refundOcode);
        paramMap.put("channelCode", disChannel.getChannelCode());
        return (DisRefundDomain)this.getForObject(apiCode, DisRefundDomain.class, paramMap);
    }

    protected DisRefundReDomain getRefundByNbillcode(String tenantCode, String contractNbillcode, DisChannel disChannel) {
        if (null == disChannel || StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)contractNbillcode)) {
            return null;
        }
        String apiCode = "dis.refund.getRefundByNbillcode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("contractNbillcode", contractNbillcode);
        paramMap.put("channelCode", disChannel.getChannelCode());
        return (DisRefundReDomain)this.getForObject(apiCode, DisRefundReDomain.class, paramMap);
    }

    protected SgSendgoodsLogDomain getSgsendgoodsLogBysgCode(String tenantCode, String sendgoodsCode, DisChannel disChannel) {
        if (null == disChannel || StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)sendgoodsCode)) {
            return null;
        }
        String apiCode = "sg.sendgoodsLog.querySendgoodsLogBySendCode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("sendgoodsCode", sendgoodsCode);
        return (SgSendgoodsLogDomain)this.getForObject(apiCode, SgSendgoodsLogDomain.class, paramMap);
    }

    @Override
    public String updateSendOrderCanRefund(Map<String, Object> map, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disOrder.updateSendOrderCanRefund";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.putAll(map);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (String)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String viewStatus(String contractNbillcode, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disOrder.viewStatus";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.put("contractNbillcode", contractNbillcode);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (String)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String privateinfo(Map<String, Object> map, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disOrder.privateinfo";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.putAll(map);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (String)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String queryComment(Map<String, Object> map, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disOrder.queryComment";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.putAll(map);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (String)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String queryCommentStoreAll(String page, String pageSize, String tenantCode, String channelCode, Integer hour) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)channelCode)) {
            this.logger.error(this.SYS_CODE + ".queryCommentStoreAll ", (Object)(pageSize + "=:=" + tenantCode + "=:=" + channelCode + "=:=" + page));
            return null;
        }
        List<DisDictionary> disDictionaries = this.queryDictionary(tenantCode, channelCode);
        this.logger.info(this.SYS_CODE + ".disDictionaries.", (Object)JsonUtil.buildNormalBinder().toJson(disDictionaries));
        if (ListUtil.isEmpty(disDictionaries)) {
            this.logger.error(this.SYS_CODE + ".disDictionaries", (Object)(tenantCode + "=:=" + channelCode));
            return null;
        }
        Integer HOUR_DEFAU = 24;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("channelCode", channelCode);
        map.put("tenantCode", tenantCode);
        if ("jddj".equals(channelCode)) {
            SimpleDateFormat dft = new SimpleDateFormat("yyyy-MM-dd HH");
            if (null == hour) {
                calendar.add(5, -7);
            } else if (hour < HOUR_DEFAU) {
                calendar.add(11, -hour.intValue());
            } else {
                calendar.add(5, -7);
            }
            String startTime = dft.format(calendar.getTime());
            String endTime = dft.format(new Date());
            this.logger.error(this.SYS_CODE + ".startTime.endTime.", (Object)(startTime + "=:=" + endTime));
            for (DisDictionary disDictionary : disDictionaries) {
                List<DisContract> disContracts = this.queryContractByTime(tenantCode, channelCode, disDictionary.getDictionaryValue(), startTime, endTime);
                if (null == disContracts || ListUtil.isEmpty(disContracts)) {
                    this.logger.error(this.SYS_CODE + ".jddj.disContracts", (Object)(tenantCode + "=:=" + channelCode + "=:=" + disDictionary.getDictionaryValue() + "=:=" + dateFormat.format(calendar.getTime()) + "=:=" + dateFormat.format(new Date())));
                    continue;
                }
                map.put("memberCcode", disDictionary.getDictionaryValue());
                map.put("memberCname", disDictionary.getDictionaryName());
                for (DisContract disContract : disContracts) {
                    map.put("orderId", disContract.getContractNbillcode());
                    this.queryComment(map, disDictionary.getDictionaryValue(), tenantCode);
                }
            }
        } else {
            if (StringUtils.isNotBlank((String)page)) {
                map.put("page", page);
            }
            if (StringUtils.isNotBlank((String)pageSize)) {
                map.put("pageSize", pageSize);
            }
            if (null == hour) {
                if ("mt".equals(channelCode)) {
                    calendar.add(5, -1);
                    map.put("end_time", dateFormat.format(calendar.getTime()));
                    calendar.add(5, -6);
                    map.put("start_time", dateFormat.format(calendar.getTime()));
                }
            } else {
                if (hour < HOUR_DEFAU) {
                    return null;
                }
                Integer dayVal = hour / HOUR_DEFAU;
                if ("mt".equals(channelCode)) {
                    Integer day = 1;
                    calendar.add(5, -day.intValue());
                    map.put("end_time", dateFormat.format(calendar.getTime()));
                    calendar.add(5, -(dayVal - day));
                    map.put("start_time", dateFormat.format(calendar.getTime()));
                } else {
                    map.put("end_time", dateFormat.format(calendar.getTime()));
                    calendar.add(5, -dayVal.intValue());
                    map.put("start_time", dateFormat.format(calendar.getTime()));
                }
            }
            for (DisDictionary disDictionary : disDictionaries) {
                map.put("memberCcode", disDictionary.getDictionaryValue());
                map.put("memberCname", disDictionary.getDictionaryName());
                this.queryComment(map, disDictionary.getDictionaryValue(), tenantCode);
            }
        }
        return null;
    }

    protected List<DisContract> queryContractByTime(String tenantCode, String channelCode, String memberCcode, String startDate, String endDate) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)channelCode) || StringUtils.isBlank((String)memberCcode) || StringUtils.isBlank((String)startDate) || StringUtils.isBlank((String)endDate)) {
            this.logger.error(this.SYS_CODE + ".queryContractByTime ", (Object)(tenantCode + "=:=" + channelCode + "=:=" + startDate + "=:=" + endDate));
            return null;
        }
        String apiCode = "dis.contract.queryContractPage";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("channelCode", channelCode);
        paramMap.put("memberCcode", memberCcode);
        paramMap.put("startDate", startDate);
        paramMap.put("endDate", endDate);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        QueryResult queryResult = this.getQueryResutl(apiCode, param, DisContract.class);
        if (null == queryResult || ListUtil.isEmpty((Collection)queryResult.getList())) {
            this.logger.error(this.SYS_CODE + ".queryContractByTime.queryResult ", paramMap);
            return null;
        }
        return queryResult.getList();
    }

    protected List<DisDictionary> queryDictionary(String tenantCode, String channelCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)channelCode)) {
            this.logger.error(this.SYS_CODE + ".queryDictionary ", (Object)(tenantCode + "=:=" + channelCode));
            return null;
        }
        String apiCode = "dis.dictionary.queryDictionaryPage";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("channelCode", channelCode);
        paramMap.put("dictionaryType", "UmUserinfo");
        paramMap.put("dictionaryDisgoods", "shopId");
        paramMap.put("dictionaryGoods", "userinfoCode");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        QueryResult queryResult = this.getQueryResutl(apiCode, param, DisDictionary.class);
        if (null == queryResult || ListUtil.isEmpty((Collection)queryResult.getList())) {
            this.logger.error(this.SYS_CODE + ".queryDictionary.queryResult ", paramMap);
            return null;
        }
        return queryResult.getList();
    }

    @Override
    public String commentReply(Map<String, Object> map, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disOrder.commentReply";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.putAll(map);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (String)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String updateSendOrderAccept(Map<String, Object> map, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disOrder.updateSendOrderAccept";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.putAll(map);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (String)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String updateSendOrderPlatDelivery(Map<String, Object> map, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disOrder.updateSendOrderPlatDelivery";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.putAll(map);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (String)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    protected SgSendgoodsReDomain getSgSendGoodsByCode(String tenantCode, String sendGoodsCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)sendGoodsCode)) {
            return null;
        }
        String apiCode = "sg.sendgoods.getSendgoodsReDomainByCode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("sendgoodsCode", sendGoodsCode);
        return (SgSendgoodsReDomain)this.getForObject(apiCode, SgSendgoodsReDomain.class, paramMap);
    }

    protected SgSendgoodsReDomain getSgSendGoods(String tenantCode, String channelCode, String contractBillcode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)channelCode) || StringUtils.isBlank((String)contractBillcode)) {
            return null;
        }
        String apiCode = "sg.sendgoods.getSgSendGoods";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        map.put("channelCode", channelCode);
        map.put("contractBillcode", contractBillcode);
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return (SgSendgoodsReDomain)this.getForObject(apiCode, SgSendgoodsReDomain.class, paramMap);
    }

    protected SgSendgoodsReDomain getSendgoodsReDomainByNbbillcode(String tenantCode, String sendGoodsCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)sendGoodsCode)) {
            return null;
        }
        String apiCode = "sg.sendgoods.getSendgoodsReDomainByNbbillcode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("contractNbbillcode", sendGoodsCode);
        return (SgSendgoodsReDomain)this.getForObject(apiCode, SgSendgoodsReDomain.class, paramMap);
    }

    protected String getSgSendgoodsState(String tenantCode, String channelCode, String status) {
        String dataState = this.getDictionaryDisValue(tenantCode, channelCode, "SgSendgoods", "status", status);
        if (StringUtils.isBlank((String)dataState)) {
            this.logger.debug(this.SYS_CODE + ".getSgSendgoodsState.dataState", (Object)(channelCode + "-" + status + "-" + tenantCode));
            return null;
        }
        return dataState;
    }

    protected String getOcContractState(String tenantCode, String channelCode, String status) {
        String dataState = this.getDictionaryDisValue(tenantCode, channelCode, "ocContract", "status", status);
        if (StringUtils.isBlank((String)dataState)) {
            this.logger.debug(this.SYS_CODE + ".getOcContractState.dataState", (Object)(channelCode + "-" + status + "-" + tenantCode));
            return null;
        }
        return dataState;
    }

    protected void sendSaveSgSendGoodsState(List<SgSendgoodsDataDomain> sgSendgoodsDataDomainList) {
        if (ListUtil.isEmpty(sgSendgoodsDataDomainList)) {
            this.logger.error(this.SYS_CODE + ".sendSaveSgSendGoodsState ", sgSendgoodsDataDomainList);
            return;
        }
        String apiCode = "sg.sendgoods.sendSgSendgoodsDataBatch";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("sgSendgoodsDataDomainList", JsonUtil.buildNormalBinder().toJson(sgSendgoodsDataDomainList));
        this.internalInvoke(apiCode, paramMap);
    }

    protected void saveChannelsendBatch(List<ResChannelsendDomain> resChannelsendDomainList) {
        if (ListUtil.isEmpty(resChannelsendDomainList)) {
            this.logger.error(this.SYS_CODE + ".saveChannelsendBatch ", resChannelsendDomainList);
            return;
        }
        String apiCode = "res.evaluateBase.sendChannelSendBatch";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("resChannelsendDomainList", JsonUtil.buildNormalBinder().toJson(resChannelsendDomainList));
        this.internalInvoke(apiCode, paramMap);
    }

    @Override
    public String updateSendOrderDelivery(Map<String, Object> map, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disOrder.updateSendOrderDelivery";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.putAll(map);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (String)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String updateSendOrderReceiveAccept(Map<String, Object> map, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disOrder.updateSendOrderReceiveAccept";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.putAll(map);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (String)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String updateSendOrderOK(Map<String, Object> map, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disOrder.updateSendOrderOK";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.putAll(map);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (String)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String updateSendOrderPrint(Map<String, Object> map, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disOrder.updateSendOrderPrint";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.putAll(map);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (String)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String updateSendOrderUserAccept(Map<String, Object> map, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disOrder.updateSendOrderUserAccept";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.putAll(map);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (String)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String updateSendOrderUserNoAccept(Map<String, Object> map, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disOrder.updateSendOrderUserNoAccept";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.putAll(map);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (String)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String getSendOrderLog(Map<String, Object> map, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disOrder.getSendOrderLog";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.putAll(map);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (String)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String updateSendOrderUserCanelAccept(Map<String, Object> map, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disOrder.updateSendOrderUserCanelAccept";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.putAll(map);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (String)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String updateSendOrderAddTips(Map<String, Object> map, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disOrder.updateSendOrderAddTips";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.putAll(map);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (String)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String updateSendOrderPickCode(Map<String, Object> map, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disOrder.updateSendOrderPickCode";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.putAll(map);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (String)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String remindReply(Map<String, Object> map, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disOrder.remindReply";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.putAll(map);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (String)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String untreatedRemind(Map<String, Object> map, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disOrder.untreatedRemind";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.putAll(map);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (String)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String untreatedCancelList(Map<String, Object> map, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disOrder.untreatedCancelList";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.putAll(map);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (String)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String convertOrderNum(Map<String, Object> map, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disOrder.convertOrderNum";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.putAll(map);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (String)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String getOrderDaySeq(Map<String, Object> map, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disOrder.getOrderDaySeq";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.putAll(map);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (String)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String partrefundApply(Map<String, Object> map, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disOrder.partrefundApply";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.putAll(map);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (String)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String getOrderActDetail(Map<String, Object> map, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disOrder.getOrderActDetail";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.putAll(map);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (String)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String getOrderIdByDaySeq(Map<String, Object> map, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disOrder.getOrderIdByDaySeq";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.putAll(map);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (String)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String getOrderIdByDaySeqSection(Map<String, Object> map, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disOrder.getOrderIdByDaySeqSection";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.putAll(map);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (String)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String getHandleReportRecord(Map<String, Object> map, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disOrder.getHandleReportRecord";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.putAll(map);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (String)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String updateSendOrderAdjust(Map<String, Object> map, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disOrder.updateSendOrderAdjust";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.putAll(map);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (String)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String getPartRefundDetail(String contractNbillcode, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disOrder.updateSendOrderAdjust";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.put("contractNbillcode", contractNbillcode);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (String)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String partRefundFoodsDetail(String contractNbillcode, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disOrder.updateSendOrderAdjust";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.put("contractNbillcode", contractNbillcode);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (String)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String updateSendOrderDeling(Map<String, Object> map, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(this.SYS_CODE + ".updateSendOrderDeling ", (Object)(memberCode + "=:=" + tenantCode));
            return null;
        }
        String channelApiCode = "cmc.disOrder.updateSendOrderDeling";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.putAll(map);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (String)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String updateSendRefundReceipt(Map<String, Object> map, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(this.SYS_CODE + ".updateSendRefundReceipt ", (Object)(memberCode + "=:=" + tenantCode));
            return null;
        }
        String channelApiCode = "cmc.disOrder.updateSendRefundReceipt";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.putAll(map);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        return (String)this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public DisRefundDomain getSendRefundByOcode(String refundOcode, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disOrder.getSendRefundByOcode";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.put("refundOcode", refundOcode);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        Object obj = this.sendCall(paramMap, channelApiCode, memberCode, tenantCode);
        if (null == obj) {
            return null;
        }
        if (obj instanceof DisRefundDomain) {
            return (DisRefundDomain)obj;
        }
        this.logger.error(this.SYS_CODE + ".getSendRefundByOcode.return", obj);
        return null;
    }

    @Override
    public Object queryReconciliation(Map<String, Object> map) {
        this.logger.error(this.SYS_CODE + ".queryReconciliation", (Object)JsonUtil.buildNonDefaultBinder().toJson(map));
        String channelApiCode = "cmc.disOrder.queryReconciliation";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.putAll(map);
        paramMap.put("memberCode", map.get("memberCode"));
        paramMap.put("tenantCode", map.get("tenantCode"));
        return (String)this.sendCall(paramMap, channelApiCode, (String)map.get("memberCode"), (String)map.get("tenantCode"));
    }

    @Override
    public Object saveStoreNotice(Map<String, Object> map) {
        this.logger.error(this.SYS_CODE + ".queryReconciliation", (Object)JsonUtil.buildNonDefaultBinder().toJson(map));
        String channelApiCode = "cmc.disOrder.saveStoreNotice";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.putAll(map);
        paramMap.put("memberCode", map.get("memberCode"));
        paramMap.put("tenantCode", map.get("tenantCode"));
        return (String)this.sendCall(paramMap, channelApiCode, (String)map.get("memberCode"), (String)map.get("tenantCode"));
    }

    @Override
    public Object retrievalOrder(Map<String, Object> map) {
        this.logger.error(this.SYS_CODE + ".queryReconciliation", (Object)JsonUtil.buildNonDefaultBinder().toJson(map));
        String channelApiCode = "cmc.disOrder.retrievalOrder";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelApiCode", channelApiCode);
        paramMap.putAll(map);
        paramMap.put("memberCode", map.get("memberCode"));
        paramMap.put("tenantCode", map.get("tenantCode"));
        return (String)this.sendCall(paramMap, channelApiCode, (String)map.get("memberCode"), (String)map.get("tenantCode"));
    }

    protected List<DisRefundFileDomain> createFile(List<String> pictures, DisRefundDomain disRefundDomain) {
        if (ListUtil.isEmpty(pictures) || null == disRefundDomain) {
            return null;
        }
        ArrayList<DisRefundFileDomain> disRefundFileDomainList = new ArrayList<DisRefundFileDomain>();
        for (String refundFileUrl : pictures) {
            DisRefundFileDomain disRefundFileDomain = new DisRefundFileDomain();
            try {
                BeanUtils.copyAllPropertys((Object)disRefundFileDomain, (Object)disRefundDomain);
            }
            catch (Exception e) {
                this.logger.error(this.SYS_CODE + ".makeRefund.copyAllPropertys", (Throwable)e);
            }
            disRefundFileDomain.setRefundFileUrl(refundFileUrl);
            disRefundFileDomainList.add(disRefundFileDomain);
        }
        return disRefundFileDomainList;
    }

    protected Map<String, DisContractGoodsDomain> getMap(DisContractDomain disContractDomain) {
        if (null == disContractDomain || ListUtil.isEmpty(disContractDomain.getPackageList())) {
            return null;
        }
        HashMap<String, DisContractGoodsDomain> map = new HashMap<String, DisContractGoodsDomain>();
        for (DisPackageDomain disPackageDomain : disContractDomain.getPackageList()) {
            for (DisContractGoodsDomain disContractGoodsDomain : disPackageDomain.getContractGoodsList()) {
                map.put(disContractGoodsDomain.getSkuNo(), disContractGoodsDomain);
            }
        }
        return map;
    }

    protected List<DisContractGoodsDomain> getList(DisContractDomain disContractDomain) {
        if (null == disContractDomain || ListUtil.isEmpty(disContractDomain.getPackageList())) {
            return null;
        }
        ArrayList<DisContractGoodsDomain> relist = new ArrayList<DisContractGoodsDomain>();
        for (DisPackageDomain disPackageDomain : disContractDomain.getPackageList()) {
            for (DisContractGoodsDomain disContractGoodsDomain : disPackageDomain.getContractGoodsList()) {
                relist.add(disContractGoodsDomain);
            }
        }
        return relist;
    }

    protected OcContract getByNbCode(String contractNbillcode, String channelCode, String tenantCode) {
        if (StringUtils.isBlank((String)contractNbillcode) || StringUtils.isBlank((String)channelCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(this.SYS_CODE + ".getByNbCode.", (Object)(contractNbillcode + "=:=" + channelCode + "=:=" + tenantCode));
            return null;
        }
        String apiCode = "oc.contract.getByNbCode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("contractNbillcode", contractNbillcode);
        paramMap.put("channelCode", channelCode);
        paramMap.put("tenantCode", tenantCode);
        return (OcContract)this.getForObject(apiCode, OcContract.class, paramMap);
    }

    protected void updateCallOcRefundState(String refundCode, String channelCode, String tenantCode) {
        if (StringUtils.isBlank((String)refundCode) || StringUtils.isBlank((String)channelCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(this.SYS_CODE + ".updateCallOcRefundState.", (Object)(refundCode + "=:=" + channelCode + "=:=" + tenantCode));
            return;
        }
        String apiCode = "oc.refund.updateCallOcRefundState";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("refundCode", refundCode);
        paramMap.put("channelCode", channelCode);
        paramMap.put("tenantCode", tenantCode);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        this.internalInvoke(apiCode, param);
    }

    protected void defaultEvaluateScope(List<ResEvaluateScopeDomain> resEvaluateScopeDomains, DisChannel disChannel, Integer scope, String templateCode, String templateTitle, String type) {
        if (null == resEvaluateScopeDomains || null == disChannel || null == scope || StringUtils.isBlank((String)templateCode) || StringUtils.isBlank((String)templateTitle) || StringUtils.isBlank((String)type)) {
            this.logger.error(this.SYS_CODE + ".defaultEvaluateScope ", (Object)(scope + "=:=" + templateCode + "=:=" + templateTitle + "=:=" + type));
            return;
        }
        for (int i = 0; i < scope; ++i) {
            ResEvaluateScopeDomain resEvaluateScopeDomain = new ResEvaluateScopeDomain();
            resEvaluateScopeDomain.setTemplateCode(templateCode);
            resEvaluateScopeDomain.setTemplateTitle(templateTitle);
            resEvaluateScopeDomain.setEvaluateScopeValue("1");
            resEvaluateScopeDomain.setTemplateType(type);
            resEvaluateScopeDomain.setTenantCode(disChannel.getTenantCode());
            resEvaluateScopeDomain.setChannelCode(disChannel.getChannelCode());
            resEvaluateScopeDomain.setChannelName(disChannel.getChannelName());
            resEvaluateScopeDomain.setTemplateValuesCode(templateCode + i);
            resEvaluateScopeDomains.add(resEvaluateScopeDomain);
        }
    }

    protected ResEvaluateReplyDomain defaultEvaluateReply(ResEvaluateGoodsDomain resEvaluateGoodsDomain, DisChannel disChannel, String replyContent, String orderId, Date date) {
        if (null == resEvaluateGoodsDomain || null == disChannel || StringUtils.isBlank((String)replyContent) || StringUtils.isBlank((String)orderId)) {
            this.logger.error(this.SYS_CODE + ".defaultEvaluateReply ", (Object)(resEvaluateGoodsDomain + "=:=" + disChannel + "=:=" + replyContent + "=:=" + orderId));
            return null;
        }
        ResEvaluateReplyDomain resEvaluateReplyDomain = new ResEvaluateReplyDomain();
        resEvaluateReplyDomain.setEvaluateReplyContent(replyContent);
        resEvaluateReplyDomain.setEvaluateGoodsOcode(orderId);
        resEvaluateReplyDomain.setTenantCode(disChannel.getTenantCode());
        resEvaluateReplyDomain.setChannelCode(disChannel.getChannelCode());
        resEvaluateReplyDomain.setChannelName(disChannel.getChannelName());
        resEvaluateReplyDomain.setMemberCcode(resEvaluateGoodsDomain.getMemberCcode());
        resEvaluateReplyDomain.setMemberCname(resEvaluateGoodsDomain.getMemberCname());
        resEvaluateReplyDomain.setEvaluateGoodsType(resEvaluateGoodsDomain.getEvaluateGoodsType());
        resEvaluateReplyDomain.setMemberBcode(resEvaluateGoodsDomain.getMemberBcode());
        resEvaluateReplyDomain.setMemberBname(resEvaluateGoodsDomain.getMemberBname());
        if (null != date) {
            resEvaluateReplyDomain.setEvaluateReplyDate(date);
        }
        return resEvaluateReplyDomain;
    }

    protected void defaultEvaluateGoods(ResEvaluateGoodsDomain resEvaluateGoodsDomain, DisChannel disChannel, String memberCcode, String memberCname) {
        if (null == resEvaluateGoodsDomain || null == disChannel) {
            this.logger.error(this.SYS_CODE + ".defaultEvaluateGoods ", (Object)(resEvaluateGoodsDomain + "=:=" + disChannel));
            return;
        }
        resEvaluateGoodsDomain.setMemberCcode(StringUtils.isBlank((String)memberCcode) ? disChannel.getMemberCode() : memberCcode);
        resEvaluateGoodsDomain.setMemberCname(StringUtils.isBlank((String)memberCname) ? disChannel.getMemberCname() : memberCname);
        resEvaluateGoodsDomain.setMemberCode(disChannel.getMemberCode());
        resEvaluateGoodsDomain.setMemberName(disChannel.getMemberName());
        resEvaluateGoodsDomain.setTenantCode(disChannel.getTenantCode());
        resEvaluateGoodsDomain.setChannelCode(disChannel.getChannelCode());
        resEvaluateGoodsDomain.setChannelName(disChannel.getChannelName());
    }

    protected ResChannelsendDomain makeResChannelsend(ResEvaluateGoodsDomain resEvaluateGoodsDomain, String dir) {
        if (null == resEvaluateGoodsDomain || StringUtils.isBlank((String)dir)) {
            this.logger.error(this.SYS_CODE + ".makeResChannelsend ", (Object)(resEvaluateGoodsDomain + "=:=" + dir));
            return null;
        }
        ResChannelsendDomain resChannelsendDomain = new ResChannelsendDomain();
        resChannelsendDomain.setChannelsendTxt(JsonUtil.buildNormalBinder().toJson((Object)resEvaluateGoodsDomain));
        resChannelsendDomain.setChannelsendDir(dir);
        resChannelsendDomain.setTenantCode(resEvaluateGoodsDomain.getTenantCode());
        resChannelsendDomain.setChannelCode(resEvaluateGoodsDomain.getChannelCode());
        resChannelsendDomain.setChannelsendType("DisComment");
        return resChannelsendDomain;
    }

    protected SgSendgoodsDataDomain makeSgSendgoodsDataByOc(SgOccontractReDomain sgOc, String sendgoodsDataDir) {
        if (null == sgOc || StringUtils.isEmpty((String)sendgoodsDataDir)) {
            this.logger.error(this.SYS_CODE + ".makeSgSendgoodsDataByOc.", (Object)(sendgoodsDataDir + " =:= " + JsonUtil.buildNormalBinder().toJson((Object)sgOc)));
            return null;
        }
        SgSendgoodsDataDomain sgSendgoodsDataDomain = new SgSendgoodsDataDomain();
        sgSendgoodsDataDomain.setSendgoodsDataTxt(JsonUtil.buildNormalBinder().toJson((Object)sgOc));
        sgSendgoodsDataDomain.setSendgoodsDataDir(sendgoodsDataDir);
        sgSendgoodsDataDomain.setAppmanageIcode(sgOc.getAppmanageIcode());
        sgSendgoodsDataDomain.setMemberBcode(sgOc.getMemberBcode());
        sgSendgoodsDataDomain.setMemberBname(sgOc.getMemberBname());
        sgSendgoodsDataDomain.setMemberCcode(sgOc.getMemberCcode());
        sgSendgoodsDataDomain.setMemberCname(sgOc.getMemberCname());
        sgSendgoodsDataDomain.setMemberCode(sgOc.getMemberCode());
        sgSendgoodsDataDomain.setMemberName(sgOc.getMemberName());
        sgSendgoodsDataDomain.setSendgoodsCode(sgOc.getContractBillcode());
        sgSendgoodsDataDomain.setTenantCode(sgOc.getTenantCode());
        sgSendgoodsDataDomain.setChannelCode(sgOc.getChannelCode());
        sgSendgoodsDataDomain.setSendgoodsDataType("DisContractNotice");
        return sgSendgoodsDataDomain;
    }

    protected SgSendgoodsDataDomain makeSgSendgoodsData(SgSendgoodsReDomain sgSendgoodsDomain, List<SgSendgoodsLogDomain> sgLogList, String sendgoodsDataDir, String sgDataType) {
        if (null == sgSendgoodsDomain || StringUtils.isBlank((String)sendgoodsDataDir) || StringUtils.isBlank((String)sgDataType)) {
            this.logger.error(this.SYS_CODE + ".makeSgSendgoodsData.", (Object)(sgLogList + "=:=" + sendgoodsDataDir + "=:=" + sgDataType));
            return null;
        }
        sgSendgoodsDomain.setSgSendgoodsLogDomainList(sgLogList);
        SgSendgoodsDataDomain sgSendgoodsDataDomain = new SgSendgoodsDataDomain();
        sgSendgoodsDataDomain.setSendgoodsDataTxt(JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsDomain));
        sgSendgoodsDataDomain.setSendgoodsDataDir(sendgoodsDataDir);
        sgSendgoodsDataDomain.setAppmanageIcode(sgSendgoodsDomain.getAppmanageIcode());
        sgSendgoodsDataDomain.setMemberBcode(sgSendgoodsDomain.getMemberBcode());
        sgSendgoodsDataDomain.setMemberBname(sgSendgoodsDomain.getMemberBname());
        sgSendgoodsDataDomain.setMemberCcode(sgSendgoodsDomain.getMemberCcode());
        sgSendgoodsDataDomain.setMemberCname(sgSendgoodsDomain.getMemberCname());
        sgSendgoodsDataDomain.setMemberCode(sgSendgoodsDomain.getMemberCode());
        sgSendgoodsDataDomain.setMemberName(sgSendgoodsDomain.getMemberName());
        sgSendgoodsDataDomain.setSendgoodsCode(sgSendgoodsDomain.getSendgoodsCode());
        sgSendgoodsDataDomain.setTenantCode(sgSendgoodsDomain.getTenantCode());
        sgSendgoodsDataDomain.setChannelCode(sgSendgoodsDomain.getChannelCode());
        sgSendgoodsDataDomain.setSendgoodsDataType(sgDataType);
        return sgSendgoodsDataDomain;
    }

    protected DisContract getContractByCode(String contractNbillcode, String tenantCode, String channelCode) {
        String apiCode = "dis.contract.getContractByNbCode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("contractNbillcode", contractNbillcode);
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("channelCode", channelCode);
        return (DisContract)this.getForObject(apiCode, DisContract.class, paramMap);
    }

    protected DisStatementContractDomain getStatementContractByCode(String statementContractCode, String tenantCode) {
        String apiCode = "dis.statement.getStatementContractByCode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("statementContractCode", statementContractCode);
        paramMap.put("tenantCode", tenantCode);
        return (DisStatementContractDomain)this.getForObject(apiCode, DisStatementContractDomain.class, paramMap);
    }

    protected List<DisStatementContract> queryStatementContractPage(String channelCode, String memberCcode, String startDate, String endDate, String tenantCode) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("channelCode", channelCode);
        paramMap.put("memberCcode", memberCcode);
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("dataState", 0);
        paramMap.put("pageNo", "1");
        paramMap.put("pageSize", "10");
        this.logger.error(this.SYS_CODE + ".queryStatementContractPage", (Object)JsonUtil.buildNonDefaultBinder().toJson(paramMap));
        String QueryResultJson = "";
        try {
            QueryResultJson = (String)this.getInternalRouter().inInvoke("dis.statement.queryStatementContractPage", paramMap);
            if (StringUtils.isBlank((String)QueryResultJson)) {
                this.logger.error(this.SYS_CODE + ".externalReconciliation.QueryResultJson.null", (Object)((Object)paramMap).toString());
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".externalReconciliation.QueryResultJson.e", (Object)((Object)paramMap).toString(), (Throwable)e);
            return null;
        }
        ArrayList<DisStatementContract> disStatementContractList = new ArrayList();
        try {
            QueryResult queryResult = (QueryResult)JsonUtil.buildNormalBinder().getJsonToObject(QueryResultJson, QueryResult.class);
            disStatementContractList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)queryResult.getList()), DisStatementContract.class);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".externalReconciliation.queryResult.e", (Object)QueryResultJson, (Throwable)e);
            return null;
        }
        return disStatementContractList;
    }

    protected void updateStatementContract(DisStatementContractDomain disStatementContractDomain) {
        String apiCode = "dis.statement.updateStatementContract";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("disStatementContractDomain", JsonUtil.buildNonDefaultBinder().toJson((Object)disStatementContractDomain));
        this.getInternalRouter().inInvoke(apiCode, paramMap);
    }

    protected void updateStatementContractStateByCode(String tenantCode, String statementContractCode, Integer dataState, Integer oldDataState) {
        String apiCode = "dis.statement.updateStatementContractStateByCode";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("statementContractCode", statementContractCode);
        paramMap.put("dataState", dataState);
        paramMap.put("oldDataState", oldDataState);
        paramMap.put("map", null);
        this.getInternalRouter().inInvoke(apiCode, paramMap);
    }

    protected DisStatementContract getStatementContract(Integer statementContractId) {
        String apiCode = "dis.statement.getStatementContract";
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        paramMap.put("statementContractId", statementContractId);
        return (DisStatementContract)this.getForObject(apiCode, DisStatementContract.class, paramMap);
    }
}

