/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.discom.service;

import com.yqbsoft.laser.service.ext.channel.discom.ComConstants;
import com.yqbsoft.laser.service.ext.channel.discom.api.DisOauthService;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisChannel;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisOauthTokenDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.OauthBean;
import com.yqbsoft.laser.service.ext.channel.discom.service.DisBaseServiceImpl;
import com.yqbsoft.laser.service.tool.codec.Base64;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public abstract class DisOauthBaseServiceImpl
extends DisBaseServiceImpl
implements DisOauthService {
    private String SYS_CODE = "cmc.DisOauthBaseServiceImpl";

    @Override
    public String updateToken(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String channelCode = (String)map.get("channelCode");
        String memberCode = (String)map.get("memberCode");
        String tenantCode = (String)map.get("tenantCode");
        DisChannel disChannel = this.getDisChannel(tenantCode, channelCode);
        if (null == disChannel) {
            this.logger.error(this.SYS_CODE + ".getToken.disChannel", (Object)(tenantCode + "-" + channelCode));
            return "ERROR";
        }
        if (StringUtils.isBlank((String)memberCode)) {
            memberCode = disChannel.getMemberCode();
        }
        map = this.sendGetTokenParam(map);
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (MapUtil.isNotEmpty(map)) {
            param.putAll(map);
        }
        String channelApiCode = "cmc.disOauth.getToken";
        param.put("channelApiCode", channelApiCode);
        param.put("channelCode", channelCode);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        Map<String, String> configMap = this.getConfig(channelCode, memberCode, tenantCode, channelApiCode);
        if (MapUtil.isEmpty(configMap)) {
            this.logger.error(this.SYS_CODE + ".getToken.configMap", (Object)(tenantCode + "-" + channelCode + "-" + channelApiCode));
            return "ERROR";
        }
        Map<String, Object> sendParam = this.getApiparam(param, channelCode, channelApiCode, tenantCode);
        if (MapUtil.isEmpty(sendParam)) {
            this.logger.error(this.SYS_CODE + ".getToken.sendParam", (Object)(tenantCode + "-" + channelCode + "-" + channelApiCode + ":" + configMap.toString()));
            return "ERROR";
        }
        return this.sendGetToken(disChannel, sendParam, configMap, param);
    }

    private Map<String, String> getConfig(String channelCode, String memberCode, String tenantCode, String channelApiCode) {
        String serviceUrl;
        Map<String, String> configMap = this.getChannelConfig(tenantCode, channelCode, channelApiCode);
        if (MapUtil.isEmpty(configMap)) {
            this.logger.error(this.SYS_CODE + ".getConfig.configMap", (Object)(tenantCode + "-" + channelCode + "-" + channelApiCode));
            return null;
        }
        String redirect_uri = configMap.get("redirect_uri");
        if (StringUtils.isNotBlank((String)redirect_uri) && redirect_uri.indexOf("{memberCode}") >= 0) {
            redirect_uri = redirect_uri.replaceAll("\\{memberCode\\}", memberCode);
            configMap.put("redirect_uri", redirect_uri);
        }
        if (StringUtils.isNotBlank((String)(serviceUrl = configMap.get("serviceUrl"))) && serviceUrl.indexOf("{host}") >= 0) {
            serviceUrl = serviceUrl.replaceAll("\\{host\\}", configMap.get("host"));
            configMap.put("serviceUrl", serviceUrl);
        }
        return configMap;
    }

    public abstract Map<String, Object> sendGetTokenParam(Map<String, Object> var1);

    public abstract String sendGetToken(DisChannel var1, Map<String, Object> var2, Map<String, String> var3, Map<String, Object> var4);

    protected String getAuthorization(Map<String, String> configMap) {
        if (MapUtil.isEmpty(configMap)) {
            return null;
        }
        String key = configMap.get(ComConstants.key);
        String secret = configMap.get(ComConstants.secret);
        String authorization = Base64.encodeBase64String((byte[])(key + ":" + secret).getBytes());
        return authorization;
    }

    @Override
    public String reflashToken(String oauthRefreshToken, String channelCode, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)oauthRefreshToken) || StringUtils.isBlank((String)channelCode) || StringUtils.isBlank((String)tenantCode)) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        DisChannel disChannel = this.getDisChannel(tenantCode, channelCode);
        if (null == disChannel) {
            this.logger.error(this.SYS_CODE + ".reflashToken.disChannel", (Object)(tenantCode + "-" + channelCode));
            return "ERROR";
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("oauthRefreshToken", oauthRefreshToken);
        param.put("channelCode", channelCode);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        String channelApiCode = "cmc.disOauth.reflashToken";
        param.put("channelApiCode", channelApiCode);
        Map<String, String> configMap = this.getConfig(channelCode, memberCode, tenantCode, channelApiCode);
        if (MapUtil.isEmpty(configMap)) {
            this.logger.error(this.SYS_CODE + ".reflashToken.configMap", (Object)(tenantCode + "-" + channelCode + "-" + channelApiCode));
            return "ERROR";
        }
        Map<String, Object> sendParam = this.getApiparam(param, channelCode, channelApiCode, tenantCode);
        if (MapUtil.isEmpty(sendParam)) {
            this.logger.error(this.SYS_CODE + ".reflashToken.sendParam", (Object)(tenantCode + "-" + channelCode + "-" + channelApiCode + ":" + configMap.toString()));
            return "ERROR";
        }
        return this.sendReflashToken(disChannel, sendParam, configMap, param);
    }

    public abstract String sendReflashToken(DisChannel var1, Map<String, Object> var2, Map<String, String> var3, Map<String, Object> var4);

    @Override
    public String getUrl(String channelCode, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)channelCode) || StringUtils.isBlank((String)tenantCode)) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        DisChannel disChannel = this.getDisChannel(tenantCode, channelCode);
        if (null == disChannel) {
            this.logger.error(this.SYS_CODE + ".getUrl.disChannel", (Object)(tenantCode + "-" + channelCode));
            return "ERROR";
        }
        if (StringUtils.isBlank((String)memberCode)) {
            memberCode = disChannel.getMemberCode();
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelCode", channelCode);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        String channelApiCode = "cmc.disOauth.getUrl";
        param.put("channelApiCode", channelApiCode);
        Map<String, String> configMap = this.getConfig(channelCode, memberCode, tenantCode, channelApiCode);
        if (MapUtil.isEmpty(configMap)) {
            this.logger.error(this.SYS_CODE + ".getUrl.configMap", (Object)(tenantCode + "-" + channelCode + "-" + channelApiCode));
            return "ERROR";
        }
        Map<String, Object> sendParam = this.getApiparam(param, channelCode, channelApiCode, tenantCode);
        if (MapUtil.isEmpty(sendParam)) {
            this.logger.error(this.SYS_CODE + ".getUrl.sendParam", (Object)(tenantCode + "-" + channelCode + "-" + channelApiCode + ":" + configMap.toString()));
            return "ERROR";
        }
        this.befAppentParam(disChannel, sendParam, configMap);
        String url = configMap.get(ComConstants.serviceUrl);
        if (StringUtils.isBlank((String)url)) {
            this.logger.error(this.SYS_CODE + ".getUrl.url", (Object)(tenantCode + "-" + channelCode + "-" + channelApiCode));
            return "ERROR";
        }
        url = url + "?";
        String pstr = "";
        if (url.contains("success") && sendParam.keySet().size() == 1 && sendParam.keySet().iterator().next().equals("success")) {
            return "success";
        }
        for (String key : sendParam.keySet()) {
            if (StringUtils.isNotBlank((String)pstr)) {
                pstr = pstr + "&";
            }
            pstr = pstr + key + "=" + sendParam.get(key);
        }
        return url + pstr;
    }

    public abstract void befAppentParam(DisChannel var1, Map<String, Object> var2, Map<String, String> var3);

    @Override
    public Map<String, Object> buildComParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        this.logger.error(this.SYS_CODE + "\u3002\u6d4b\u8bd53");
        if (StringUtils.isBlank((String)channelApiCode)) {
            this.logger.error(this.SYS_CODE + ".buildComParam.channelApiCode");
            return null;
        }
        return null;
    }

    @Override
    public Object sendComParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        if (StringUtils.isBlank((String)channelApiCode)) {
            this.logger.error(this.SYS_CODE + ".sendComParam.channelApiCode");
            return null;
        }
        return null;
    }

    protected String saveDisToken(DisChannel disChannel, OauthBean oauthBean, String memberCode) {
        if (StringUtils.isBlank((String)memberCode) || null == disChannel || null == oauthBean) {
            this.logger.error(this.SYS_CODE + ".saveDisToken.json");
            return "error";
        }
        String api = "dis.oauth.saveOauthToken";
        if (StringUtils.isBlank((String)memberCode)) {
            memberCode = disChannel.getMemberCode();
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        DisOauthTokenDomain disOauthTokenDomain = new DisOauthTokenDomain();
        disOauthTokenDomain.setChannelCode(disChannel.getChannelCode());
        disOauthTokenDomain.setChannelName(disChannel.getChannelName());
        disOauthTokenDomain.setMemberCode(memberCode);
        disOauthTokenDomain.setMemberName(memberCode);
        disOauthTokenDomain.setOauthTokenExpireIn(oauthBean.getExpires_in());
        disOauthTokenDomain.setOauthTokenRefreshToken(oauthBean.getRefresh_token());
        disOauthTokenDomain.setOauthTokenToken(oauthBean.getAccess_token());
        Long updateTime = new Date().getTime() + (long)disOauthTokenDomain.getOauthTokenExpireIn().intValue();
        disOauthTokenDomain.setOauthTokenUpdateTime(new Date(updateTime));
        disOauthTokenDomain.setTenantCode(disChannel.getTenantCode());
        paramMap.put("disOauthTokenDomain", JsonUtil.buildNormalBinder().toJson((Object)disOauthTokenDomain));
        this.internalInvoke(api, paramMap);
        return "success";
    }

    public static void main(String[] args) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Accept-Encoding", "gzip");
        params.put("Authorization", "Basic aU9MaGpQaFR0bTo3MGFjMWVkMzFkNmJjYTE3ZGQxNjc4OTY5YzAwNTQxNDc1OThiZDI0");
        params.put("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
        params.put("User-Agent", "eleme-openapi-java-sdk");
    }
}

