/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.discom.service;

import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.channel.discom.api.DisGoodsService;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisChannel;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisDgoodsuplistDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisDictionary;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisDictionaryDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.ImageBean;
import com.yqbsoft.laser.service.ext.channel.discom.domain.RsGoodsClass;
import com.yqbsoft.laser.service.ext.channel.discom.domain.RsGoodsClassDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.RsResourceGoodsReDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.RsSkuDomain;
import com.yqbsoft.laser.service.ext.channel.discom.service.DisBaseServiceImpl;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class DisGoodsBaseService
extends DisBaseServiceImpl
implements DisGoodsService {
    private String SYS_CODE = "cmc.DisGoodsBaseService";

    @Override
    public Map<String, Object> buildComParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        if (StringUtils.isBlank((String)channelApiCode)) {
            this.logger.error(this.SYS_CODE + ".buildComParam.channelApiCode");
            return null;
        }
        if (channelApiCode.equals("cmc.disGoods.saveSendGoodsClass")) {
            return this.buildComGoodsClassParam(channelApiCode, disChannel, sendParam, configMap, param);
        }
        if (channelApiCode.equals("cmc.disGoods.delSendGoodsClass")) {
            return this.buildComGoodsClassParam(channelApiCode, disChannel, sendParam, configMap, param);
        }
        if (channelApiCode.equals("cmc.disGoods.updateSendGoodsClass")) {
            return this.buildComGoodsClassParam(channelApiCode, disChannel, sendParam, configMap, param);
        }
        if (channelApiCode.equals("cmc.disGoods.updateSendClassCodeByName")) {
            return this.buildComGoodsClassParam(channelApiCode, disChannel, sendParam, configMap, param);
        }
        if (channelApiCode.equals("cmc.disGoods.updateSendGoodsClassSort")) {
            return this.buildComGoodsClassParam(channelApiCode, disChannel, sendParam, configMap, param);
        }
        if (channelApiCode.equals("cmc.disGoods.getSendGoodsClass") || channelApiCode.equals("cmc.disGoods.querySendClass")) {
            return this.buildComGoodsClassParam(channelApiCode, disChannel, sendParam, configMap, param);
        }
        return this.buildComGoodsParam(channelApiCode, disChannel, sendParam, configMap, param);
    }

    protected String getExcShopping(String tenantCode, String channelCode) {
        String shoppingIdStr = this.getDictionaryValue(tenantCode, channelCode, "exclude", "excludeCode", "0");
        if (StringUtils.isBlank((String)shoppingIdStr)) {
            this.logger.debug(this.SYS_CODE + ".getExcShopping.shoppingIdStr", (Object)(channelCode + "-0-" + tenantCode));
            return null;
        }
        return shoppingIdStr;
    }

    @Override
    public Object sendComParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        String shopId;
        if (StringUtils.isBlank((String)channelApiCode)) {
            this.logger.error(this.SYS_CODE + ".sendComParam.channelApiCode");
            return null;
        }
        String string = shopId = null == param.get("shoppingId") ? null : (String)param.get("shoppingId");
        if (StringUtils.isNotBlank((String)shopId)) {
            String excStr = this.getExcShopping(disChannel.getTenantCode(), disChannel.getChannelCode());
            if (StringUtils.isNotBlank((String)excStr) && excStr.indexOf(shopId) >= 0) {
                this.logger.error(this.SYS_CODE + ".sendComParam.excStr.n", (Object)(excStr + "-" + disChannel.getTenantCode() + "-" + disChannel.getChannelCode()));
                return "SUCCESS";
            }
            this.logger.error(this.SYS_CODE + ".sendComParam.excStr.y", (Object)(excStr + "-" + disChannel.getTenantCode() + "-" + disChannel.getChannelCode()));
        } else {
            this.logger.error(this.SYS_CODE + ".sendComParam.excStr.shopId", (Object)(disChannel.getTenantCode() + "-" + disChannel.getChannelCode()));
        }
        if (channelApiCode.equals("cmc.disGoods.saveSendGoodsClass")) {
            return this.sendComSaveGoodsClass(channelApiCode, disChannel, sendhttpParam, configMap, param);
        }
        if (channelApiCode.equals("cmc.disGoods.delSendGoodsClass")) {
            return this.sendComSaveGoodsClass(channelApiCode, disChannel, sendhttpParam, configMap, param);
        }
        if (channelApiCode.equals("cmc.disGoods.updateSendGoodsClass")) {
            return this.sendComSaveGoodsClass(channelApiCode, disChannel, sendhttpParam, configMap, param);
        }
        if (channelApiCode.equals("cmc.disGoods.updateSendClassCodeByName")) {
            return this.sendComSaveGoodsClass(channelApiCode, disChannel, sendhttpParam, configMap, param);
        }
        if (channelApiCode.equals("cmc.disGoods.updateSendGoodsClassSort")) {
            return this.sendComSaveGoodsClass(channelApiCode, disChannel, sendhttpParam, configMap, param);
        }
        if (channelApiCode.equals("cmc.disGoods.getSendGoodsClass")) {
            return this.sendComSaveGoodsClass(channelApiCode, disChannel, sendhttpParam, configMap, param);
        }
        if (channelApiCode.equals("cmc.disGoods.sendImportGoods")) {
            return this.sendComSaveGoods(channelApiCode, disChannel, sendhttpParam, configMap, param);
        }
        if (channelApiCode.equals("cmc.disGoods.sendUpdateInformation")) {
            this.logger.error(this.SYS_CODE + ".sendComSaveGoods" + channelApiCode);
            return this.sendComSaveGoods(channelApiCode, disChannel, sendhttpParam, configMap, param);
        }
        return this.sendComSaveExtGoods(channelApiCode, disChannel, sendhttpParam, configMap, param);
    }

    protected String getClassDictionaryBvalue(String dictionaryType, String channelCode, String dictionaryGoods, String value, String tenantCode) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        String apiCode = "dis.dictionary.queryDictionaryPage";
        paramMap.put("dictionaryType", dictionaryType);
        paramMap.put("channelCode", channelCode);
        paramMap.put("dictionaryGoods", dictionaryGoods);
        paramMap.put("dictionaryValue", value);
        paramMap.put("tenantCode", tenantCode);
        HashMap<String, String> sendmap = new HashMap<String, String>();
        sendmap.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        String result = this.internalInvoke(apiCode, sendmap);
        if (null == result) {
            return null;
        }
        QueryResult rs = (QueryResult)JsonUtil.buildNormalBinder().getJsonToObject(result, QueryResult.class);
        if (null == rs) {
            return null;
        }
        List dislist = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)rs.getList()), DisDictionary.class);
        if (0 == dislist.size() || ListUtil.isEmpty((Collection)dislist)) {
            return null;
        }
        return ((DisDictionary)dislist.get(0)).getDictionaryBvalue();
    }

    protected void updateVerByNo(String skuNo, String memberCcode, Integer channelTver, String channelCode, String tenantCode) {
        if (StringUtils.isBlank((String)skuNo) || StringUtils.isBlank((Integer)channelTver) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(this.SYS_CODE + ".updateVerByNo.param", (Object)(skuNo + "=:=" + memberCcode + "=:=" + channelTver + "=:=" + channelCode + "=:=" + tenantCode));
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        String apiCode = "rs.sku.updateVerByNo";
        paramMap.put("skuNo", skuNo);
        paramMap.put("channelCode", channelCode);
        paramMap.put("memberCcode", memberCcode);
        paramMap.put("channelTver", channelTver);
        paramMap.put("tenantCode", tenantCode);
        this.internalInvoke(apiCode, paramMap);
    }

    protected void saveClassDictionary(DisChannel disChannel, String memberCode, String goodsClassCode, String thirdClassCode, String tenantCode) {
        if (null == disChannel || StringUtils.isBlank((String)goodsClassCode) || StringUtils.isBlank((String)thirdClassCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        DisDictionaryDomain disDictionaryDomain = new DisDictionaryDomain();
        disDictionaryDomain.setChannelCode(disChannel.getChannelCode());
        disDictionaryDomain.setTenantCode(tenantCode);
        disDictionaryDomain.setDictionaryType("RsGoodsClass");
        disDictionaryDomain.setDictionaryName("\u5206\u7c7bID");
        disDictionaryDomain.setDictionaryGoods("goodsClassCode");
        disDictionaryDomain.setDictionaryValue(memberCode + "-" + goodsClassCode);
        disDictionaryDomain.setDictionaryDisgoods("categoryId");
        disDictionaryDomain.setDictionaryBvalue(thirdClassCode);
        String apiCode = "dis.dictionary.saveDictionary";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("disDictionaryDomain", JsonUtil.buildNormalBinder().toJson((Object)disDictionaryDomain));
        this.internalInvoke(apiCode, paramMap);
    }

    protected String getCategoryId(String tenantCode, String memberCode, String channelCode, String goodsClassCode) {
        String categoryId = this.getDictionaryValue(tenantCode, channelCode, "RsGoodsClass", "goodsClassCode", memberCode + "-" + goodsClassCode);
        if (StringUtils.isBlank((String)categoryId)) {
            this.logger.error(this.SYS_CODE + ".getCategoryId.categoryId", (Object)(channelCode + "-" + memberCode + "-" + goodsClassCode + "-" + tenantCode));
            return null;
        }
        return categoryId;
    }

    public abstract Map<String, Object> buildComGoodsClassParam(String var1, DisChannel var2, Map<String, Object> var3, Map<String, String> var4, Map<String, Object> var5);

    public abstract String sendComSaveGoodsClass(String var1, DisChannel var2, Map<String, Object> var3, Map<String, String> var4, Map<String, Object> var5);

    public abstract Map<String, Object> buildComGoodsParam(String var1, DisChannel var2, Map<String, Object> var3, Map<String, String> var4, Map<String, Object> var5);

    public abstract Object sendComSaveExtGoods(String var1, DisChannel var2, Map<String, Object> var3, Map<String, String> var4, Map<String, Object> var5);

    public abstract String sendComSaveGoods(String var1, DisChannel var2, Map<String, Object> var3, Map<String, String> var4, Map<String, Object> var5);

    @Override
    public String saveSendGoodsClass(RsGoodsClassDomain rsGoodsClassDomain, String memberCode, String tenantCode) {
        if (null == rsGoodsClassDomain || StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disGoods.saveSendGoodsClass";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelApiCode", channelApiCode);
        param.put("rsGoodsClassDomain", rsGoodsClassDomain);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        return (String)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String delSendGoodsClass(String goodsClassCode, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)goodsClassCode)) {
            this.logger.error(this.SYS_CODE + ".delSendGoodsClass.param");
            return null;
        }
        String channelCode = this.getChannelCode();
        String categoryId = this.getCategoryId(tenantCode, memberCode, channelCode, goodsClassCode);
        if (StringUtils.isBlank((String)categoryId)) {
            return "\u3010" + goodsClassCode + "-" + memberCode + "-" + channelCode + "-" + tenantCode + "\u3011\u672a\u5bf9\u7167";
        }
        String channelApiCode = "cmc.disGoods.delSendGoodsClass";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelApiCode", channelApiCode);
        param.put("goodsClassCode", goodsClassCode);
        param.put("categoryId", categoryId);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        return (String)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String updateSendGoodsClass(RsGoodsClassDomain rsGoodsClassDomain, String memberCode, String tenantCode) {
        if (null == rsGoodsClassDomain || StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String goodsClassCode = rsGoodsClassDomain.getGoodsClassCode();
        String channelCode = this.getChannelCode();
        String categoryId = this.getCategoryId(tenantCode, memberCode, channelCode, goodsClassCode);
        if (StringUtils.isBlank((String)categoryId)) {
            return "\u3010" + goodsClassCode + "-" + memberCode + "-" + channelCode + "-" + tenantCode + "\u3011\u672a\u5bf9\u7167";
        }
        String channelApiCode = "cmc.disGoods.updateSendGoodsClass";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("categoryId", categoryId);
        param.put("channelApiCode", channelApiCode);
        param.put("rsGoodsClassDomain", rsGoodsClassDomain);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        return (String)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String querySendClass(Map<String, Object> map, String memberCode, String tenantCode) {
        if (MapUtil.isEmpty(map)) {
            return null;
        }
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disGoods.querySendClass";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelApiCode", channelApiCode);
        param.putAll(map);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        return (String)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String querySendGoods(Map<String, Object> map, String memberCode, String tenantCode) {
        if (MapUtil.isEmpty(map)) {
            return null;
        }
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disGoods.querySendGoods";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelApiCode", channelApiCode);
        param.putAll(map);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        return (String)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String updateSendClassCodeByName(Map<String, Object> map, String memberCode, String tenantCode) {
        if (MapUtil.isEmpty(map)) {
            return null;
        }
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disGoods.updateSendClassCodeByName";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelApiCode", channelApiCode);
        param.putAll(map);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        return (String)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String uploadImage(ImageBean imageBean) {
        if (null == imageBean) {
            return "ERROR";
        }
        String channelApiCode = "cmc.disGoods.uploadImage";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelApiCode", channelApiCode);
        param.put("imageBean", (Object)imageBean);
        param.put("tenantCode", imageBean.getTenantCode());
        return (String)this.sendCall(param, channelApiCode, null, imageBean.getTenantCode());
    }

    @Override
    public String saveSendGoods(RsResourceGoodsReDomain rsResourceGoodsReDomain, String memberCode, String tenantCode) {
        if (null == rsResourceGoodsReDomain || StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(this.SYS_CODE + ".saveSendGoods.", (Object)("===" + rsResourceGoodsReDomain.toString() + "===" + memberCode + "===" + tenantCode));
            return null;
        }
        String channelCode = this.getChannelCode();
        String goodsClassCode = rsResourceGoodsReDomain.getClasstreeShopcode();
        if (StringUtils.isBlank((String)goodsClassCode)) {
            goodsClassCode = rsResourceGoodsReDomain.getClasstreeCode();
        }
        String categoryId = this.getCategoryId(tenantCode, memberCode, channelCode, goodsClassCode);
        String channelApiCode = "cmc.disGoods.saveSendGoods";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelApiCode", channelApiCode);
        param.put("categoryId", categoryId);
        param.put("rsResourceGoodsReDomain", rsResourceGoodsReDomain);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        return (String)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }

    public String batchAddSku(RsSkuDomain rsSkuDomain, String memberCode, String tenantCode) {
        if (null == rsSkuDomain || StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(this.SYS_CODE + ".batchAddSku.", (Object)("===" + rsSkuDomain.toString() + "===" + memberCode + "===" + tenantCode));
            return null;
        }
        String channelCode = this.getChannelCode();
        String goodsClassCode = rsSkuDomain.getClasstreeShopcode();
        if (StringUtils.isBlank((String)goodsClassCode)) {
            goodsClassCode = rsSkuDomain.getClasstreeCode();
        }
        String categoryId = this.getCategoryId(tenantCode, memberCode, channelCode, goodsClassCode);
        String channelApiCode = "cmc.disGoods.batchAddSku";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelApiCode", channelApiCode);
        param.put("categoryId", categoryId);
        param.put("rsSkuDomain", rsSkuDomain);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        return (String)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String updateSendGoods(RsResourceGoodsReDomain rsResourceGoodsReDomain, String memberCode, String tenantCode) {
        if (null == rsResourceGoodsReDomain || StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelCode = this.getChannelCode();
        String goodsClassCode = rsResourceGoodsReDomain.getClasstreeShopcode();
        if (StringUtils.isBlank((String)goodsClassCode)) {
            goodsClassCode = rsResourceGoodsReDomain.getClasstreeCode();
        }
        String categoryId = this.getCategoryId(tenantCode, memberCode, channelCode, goodsClassCode);
        String channelApiCode = "cmc.disGoods.updateSendGoods";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("categoryId", categoryId);
        param.put("channelApiCode", channelApiCode);
        param.put("rsResourceGoodsReDomain", rsResourceGoodsReDomain);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        return (String)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String delSendGoods(Map<String, Object> map, String memberCode, String tenantCode) {
        if (MapUtil.isEmpty(map)) {
            return null;
        }
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disGoods.delSendGoods";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelApiCode", channelApiCode);
        param.putAll(map);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        return (String)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String delSendSku(Map<String, Object> map, String memberCode, String tenantCode) {
        if (MapUtil.isEmpty(map)) {
            return null;
        }
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disGoods.delSendSku";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelApiCode", channelApiCode);
        param.putAll(map);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        return (String)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }

    protected void saveFileList(DisChannel disChannel, String fileCode, String fchannelCode, String imageCode, String tenantCode) {
        if (null == disChannel || StringUtils.isBlank((String)fileCode) || StringUtils.isBlank((String)fchannelCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        String apiCode = "fm.file.updateFileOcode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("fileCode", fileCode);
        paramMap.put("fchannelCode", fchannelCode);
        paramMap.put("imageCode", imageCode);
        paramMap.put("tenantCode", tenantCode);
        this.internalInvoke(apiCode, paramMap);
    }

    protected void saveGoods(DisChannel disChannel, String channelCode, String goodsNo, String goodsCode, String goodsEocode, String tenantCode, String memberCcode) {
        if (null == disChannel || StringUtils.isBlank((String)goodsEocode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        if (StringUtils.isBlank((String)goodsNo) && StringUtils.isBlank((String)goodsCode)) {
            this.logger.error(this.SYS_CODE + ".saveGoods");
            return;
        }
        String apiCode = "rs.resourceGoods.updateGoodsEocodeByno";
        if (StringUtils.isNotBlank((String)goodsCode)) {
            apiCode = "rs.resourceGoods.updateGoodsEocode";
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("goodsCode", goodsCode);
        paramMap.put("memberCcode", memberCcode);
        paramMap.put("goodsNo", goodsNo);
        paramMap.put("goodsEocode", goodsEocode);
        paramMap.put("channelCode", channelCode);
        paramMap.put("tenantCode", tenantCode);
        this.internalInvoke(apiCode, paramMap);
    }

    protected void saveGoodsByCode(String goodsCode, String goodsEocode, String tenantCode) {
        if (StringUtils.isBlank((String)goodsCode) || StringUtils.isBlank((String)goodsEocode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(this.SYS_CODE + ".saveGoodsByCode");
            return;
        }
        String apiCode = "rs.resource.sendUpdateGoodsEocode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("goodsCode", goodsCode);
        paramMap.put("goodsEocode", goodsEocode);
        paramMap.put("tenantCode", tenantCode);
        this.internalInvoke(apiCode, paramMap);
    }

    protected void saveSkuByCode(String skuCode, String skuEocode, String tenantCode) {
        if (StringUtils.isBlank((String)skuCode) || StringUtils.isBlank((String)skuEocode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(this.SYS_CODE + ".saveSkuByCode");
            return;
        }
        String apiCode = "rs.resource.sendUpdateSkuEocode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("skuCode", skuCode);
        paramMap.put("skuEocode", skuEocode);
        paramMap.put("tenantCode", tenantCode);
        this.internalInvoke(apiCode, paramMap);
    }

    protected void saveSku(DisChannel disChannel, String channelCode, String skuNo, String skuCode, String skuEocode, String tenantCode, String memberCcode) {
        if (null == disChannel || StringUtils.isBlank((String)skuEocode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        if (StringUtils.isBlank((String)skuNo) && StringUtils.isBlank((String)skuCode)) {
            this.logger.error(this.SYS_CODE + ".saveSku");
            return;
        }
        String apiCode = "rs.resourceGoods.updateSkuEocodeByno";
        if (StringUtils.isNotBlank((String)skuCode)) {
            apiCode = "rs.resourceGoods.updateSkuEocode";
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("skuCode", skuCode);
        paramMap.put("skuNo", skuNo);
        paramMap.put("memberCcode", memberCcode);
        paramMap.put("skuEocode", skuEocode);
        paramMap.put("channelCode", channelCode);
        paramMap.put("tenantCode", tenantCode);
        this.internalInvoke(apiCode, paramMap);
    }

    protected String fetchMainMemCode(DisChannel disChannel) {
        return SupDisUtil.getMap((String)"tmtenant-user-code", (String)disChannel.getTenantCode());
    }

    protected String getFileOcode(DisChannel disChannel, String fileCode, String fchannelCode, String tenantCode) {
        if (null == disChannel || StringUtils.isBlank((String)fileCode) || StringUtils.isBlank((String)fchannelCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String apiCode = "fm.file.getFileOcode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("fileCode", fileCode);
        paramMap.put("fchannelCode", fchannelCode);
        paramMap.put("tenantCode", tenantCode);
        String value = this.internalInvoke(apiCode, paramMap);
        return value;
    }

    @Override
    public String updateSendGoodsClassSort(Integer goodsClassOrder, String goodsClassCode, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)goodsClassCode) || StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelCode = this.getChannelCode();
        String categoryId = this.getCategoryId(tenantCode, memberCode, channelCode, goodsClassCode);
        String channelApiCode = "cmc.disGoods.updateSendGoodsClassSort";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelApiCode", channelApiCode);
        param.put("categoryId", categoryId);
        param.put("goodsClassCode", goodsClassCode);
        param.put("goodsClassOrder", goodsClassOrder);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        return (String)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String saveSendBatchGoods(List<RsResourceGoodsReDomain> rsResourceGoodsReDomainList, String memberCode, String tenantCode) {
        if (ListUtil.isEmpty(rsResourceGoodsReDomainList) || StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disGoods.saveSendBatchGoods";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelApiCode", channelApiCode);
        param.put("rsResourceGoodsReDomainList", rsResourceGoodsReDomainList);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        return (String)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String saveSendSku(RsSkuDomain rsSkuDomain, String memberCode, String tenantCode) {
        if (null == rsSkuDomain || StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disGoods.saveSendSku";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelApiCode", channelApiCode);
        param.put("rsSkuDomain", rsSkuDomain);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        return (String)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String updateSendSku(RsSkuDomain rsSkuDomain, String memberCode, String tenantCode) {
        if (null == rsSkuDomain || StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disGoods.updateSendSku";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelApiCode", channelApiCode);
        param.put("rsSkuDomain", rsSkuDomain);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        return (String)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String saveSendBatchSku(List<RsSkuDomain> rsSkuDomainList, String memberCode, String tenantCode) {
        if (ListUtil.isEmpty(rsSkuDomainList) || StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disGoods.saveSendBatchSku";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelApiCode", channelApiCode);
        param.put("rsSkuDomainList", rsSkuDomainList);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        return (String)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String updateSendSkuUp(Map<String, Object> map, String memberCode, String tenantCode) {
        if (MapUtil.isEmpty(map)) {
            return null;
        }
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disGoods.updateSendSkuUp";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelApiCode", channelApiCode);
        param.putAll(map);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        return (String)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String updateSendSkuDow(Map<String, Object> map, String memberCode, String tenantCode) {
        if (MapUtil.isEmpty(map)) {
            return null;
        }
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disGoods.updateSendSkuDow";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelApiCode", channelApiCode);
        param.putAll(map);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        return (String)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String updateSendSkuCentUp(Map<String, Object> map, String memberCode, String tenantCode) {
        if (MapUtil.isEmpty(map)) {
            return null;
        }
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disGoods.updateSendSkuCentUp";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelApiCode", channelApiCode);
        param.putAll(map);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        return (String)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String updateSendSkuCentDow(Map<String, Object> map, String memberCode, String tenantCode) {
        if (MapUtil.isEmpty(map)) {
            return null;
        }
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disGoods.updateSendSkuCentDow";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelApiCode", channelApiCode);
        param.putAll(map);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        return (String)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String updateSendGoodsCentUp(Map<String, Object> map, String memberCode, String tenantCode) {
        if (MapUtil.isEmpty(map)) {
            this.logger.error(this.SYS_CODE + ".updateSendGoodsCentUp1", (Object)("====" + memberCode + "===" + tenantCode));
            return null;
        }
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(this.SYS_CODE + ".updateSendGoodsCentUp2", (Object)("===" + map.size()));
            return null;
        }
        String channelApiCode = "cmc.disGoods.updateSendGoodsCentUp";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelApiCode", channelApiCode);
        param.putAll(map);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        return (String)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String updateSendGoodsCentDow(Map<String, Object> map, String memberCode, String tenantCode) {
        if (MapUtil.isEmpty(map)) {
            this.logger.error(this.SYS_CODE + ".updateSendGoodsCentDow1", (Object)("====" + memberCode + "===" + tenantCode));
            return null;
        }
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(this.SYS_CODE + ".updateSendGoodsCentDow2", (Object)("===" + map.size()));
            return null;
        }
        String channelApiCode = "cmc.disGoods.updateSendGoodsCentDow";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelApiCode", channelApiCode);
        param.putAll(map);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        return (String)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String updateSendGoodsUp(Map<String, Object> map, String memberCode, String tenantCode) {
        if (MapUtil.isEmpty(map)) {
            return null;
        }
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disGoods.updateSendGoodsUp";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelApiCode", channelApiCode);
        param.putAll(map);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        return (String)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String updateSendGoodsDow(Map<String, Object> map, String memberCode, String tenantCode) {
        if (MapUtil.isEmpty(map)) {
            return null;
        }
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disGoods.updateSendGoodsDow";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelApiCode", channelApiCode);
        param.putAll(map);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        return (String)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String updateSendSkuPrice(Map<String, Object> map, String memberCode, String tenantCode) {
        if (MapUtil.isEmpty(map)) {
            this.logger.error(this.SYS_CODE + ".updateSendSkuPrice map is empty!");
            return null;
        }
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(this.SYS_CODE + ".updateSendSkuPrice memberCode or tenantCode is empty!");
            return null;
        }
        String channelApiCode = "cmc.disGoods.updateSendSkuPrice";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelApiCode", channelApiCode);
        param.putAll(map);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        return (String)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String updateSendSkuNum(Map<String, Object> map, String memberCode, String tenantCode) {
        if (MapUtil.isEmpty(map)) {
            this.logger.error(this.SYS_CODE + ".updateSendSkuNum map is empty!");
            return null;
        }
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(this.SYS_CODE + ".updateSendSkuNum memberCode or tenantCode is empty!");
            return null;
        }
        String channelApiCode = "cmc.disGoods.updateSendSkuNum";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelApiCode", channelApiCode);
        param.putAll(map);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        return (String)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String getSendGoodsClass(Map<String, Object> map, String memberCode, String tenantCode) {
        if (MapUtil.isEmpty(map)) {
            return null;
        }
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disGoods.getSendGoodsClass";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelApiCode", channelApiCode);
        param.putAll(map);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        return (String)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String getSendGoods(Map<String, Object> map, String memberCode, String tenantCode) {
        if (MapUtil.isEmpty(map)) {
            return null;
        }
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disGoods.getSendGoods";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelApiCode", channelApiCode);
        param.putAll(map);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        return (String)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String getSendSku(Map<String, Object> map, String memberCode, String tenantCode) {
        if (MapUtil.isEmpty(map)) {
            return null;
        }
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disGoods.getSendSku";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelApiCode", channelApiCode);
        param.putAll(map);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        return (String)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String updateAppFoodCodeByNameAndSpec(Map<String, Object> map, String memberCode, String tenantCode) {
        if (MapUtil.isEmpty(map)) {
            return null;
        }
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disGoods.updateAppFoodCodeByNameAndSpec";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelApiCode", channelApiCode);
        param.putAll(map);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        return (String)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String resetauditSendGoods(Map<String, Object> map, String memberCode, String tenantCode) {
        if (MapUtil.isEmpty(map)) {
            return null;
        }
        if (StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disGoods.resetauditSendGoods";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelApiCode", channelApiCode);
        param.putAll(map);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        return (String)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String auditSendGoods(Map<String, Object> map, String memberCode, String tenantCode) {
        if (MapUtil.isEmpty(map)) {
            return null;
        }
        if (StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disGoods.auditSendGoods";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelApiCode", channelApiCode);
        param.putAll(map);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        return (String)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String getgoodswarehouse(Map<String, Object> map, String memberCode, String tenantCode) {
        if (MapUtil.isEmpty(map)) {
            return null;
        }
        if (StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disGoods.getgoodswarehouse";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelApiCode", channelApiCode);
        param.putAll(map);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        return (String)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String sendImportGoods(String memberCode, String tenantCode, String bizPoolIdStr) {
        if (StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disGoods.sendImportGoods";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelApiCode", channelApiCode);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        if (StringUtils.isNotBlank((String)bizPoolIdStr)) {
            param.put("bizPoolIdStr", bizPoolIdStr);
        }
        return (String)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String sendUpdateInformation(String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disGoods.sendUpdateInformation";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelApiCode", channelApiCode);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        return (String)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }

    @Override
    public String sendUpdateGoodsNprice(String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String channelApiCode = "cmc.disGoods.sendUpdateGoodsNprice";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelApiCode", channelApiCode);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        return (String)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }

    public String saveSendBatchGoodsByUpc(List<RsSkuDomain> rsSkuDomainList, String memberCode, String tenantCode) {
        if (ListUtil.isEmpty(rsSkuDomainList) || StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(this.SYS_CODE + ".saveSendBatchGoodsByUpc.null", (Object)("===" + memberCode + "===" + tenantCode));
            return null;
        }
        String channelApiCode = "cmc.disGoods.saveSendBatchGoodsByUpc";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelApiCode", channelApiCode);
        param.put("rsSkuDomainList", rsSkuDomainList);
        param.put("memberCode", memberCode);
        param.put("tenantCode", tenantCode);
        return (String)this.sendCall(param, channelApiCode, memberCode, tenantCode);
    }

    protected RsGoodsClassDomain getGoodsClass(Map<String, Object> paramMap) {
        if (MapUtil.isEmpty(paramMap)) {
            return null;
        }
        String apiCode = "rs.goodsClass.getGoodsClassByCode";
        return (RsGoodsClassDomain)this.getForObject(apiCode, RsGoodsClassDomain.class, paramMap);
    }

    protected String getDictionary(Map<String, Object> paramMap) {
        if (MapUtil.isEmpty(paramMap)) {
            return null;
        }
        String apiCode = "dis.dictionary.queryDictionaryPage";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        QueryResult queryResult = this.getQueryResutl(apiCode, param, DisDictionary.class);
        if (null == queryResult || ListUtil.isEmpty((Collection)queryResult.getList())) {
            return null;
        }
        DisDictionary disDictionary = (DisDictionary)queryResult.getList().get(0);
        return disDictionary.getDictionaryBvalue();
    }

    protected Map<String, String> queryGoodsClass(Map<String, Object> paramMap) {
        if (MapUtil.isEmpty(paramMap)) {
            return null;
        }
        String apiCode = "rs.goodsClass.queryGoodsClassPage";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        QueryResult queryResult = this.getQueryResutl(apiCode, param, RsGoodsClass.class);
        if (null == queryResult || ListUtil.isEmpty((Collection)queryResult.getList())) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (RsGoodsClass rsGoodsClass : queryResult.getList()) {
            map.put(rsGoodsClass.getGoodsClassCode(), rsGoodsClass.getGoodsClassName());
        }
        return map;
    }

    protected void saveDgoodsuplist(DisDgoodsuplistDomain disDgoodsuplistDomain) {
        if (null == disDgoodsuplistDomain) {
            this.logger.error(this.SYS_CODE + ".disDgoodsuplistDomain is null");
            return;
        }
        String apiCode = "dis.dgoodsuplist.saveDgoodsuplist";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("disDgoodsuplistDomain", JsonUtil.buildNormalBinder().toJson((Object)disDgoodsuplistDomain));
        this.internalInvoke(apiCode, paramMap);
    }

    protected void updateSku(String goodsSp, String skuNo, String memberCode, String tenantCode, String channelCode) {
        if (StringUtils.isBlank((String)goodsSp) || StringUtils.isBlank((String)skuNo) || StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)channelCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(this.SYS_CODE + ".updateSku param is null");
            return;
        }
        String apiCode = "rs.sku.updateGoodsSpByNo";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("goodsSp", goodsSp);
        paramMap.put("skuNo", skuNo);
        paramMap.put("memberCcode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("channelCode", channelCode);
        this.internalInvoke(apiCode, paramMap);
    }

    protected String getSkuSp(String skuNo, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)skuNo) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(this.SYS_CODE + ".updateSkuSp param is null");
            return null;
        }
        String apiCode = "rs.sku.getSkuBySkuNo";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("skuNo", skuNo);
        paramMap.put("memberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        RsSkuDomain rsSkuDomain = (RsSkuDomain)this.getForObject(apiCode, RsSkuDomain.class, paramMap);
        if (null == rsSkuDomain) {
            return null;
        }
        return rsSkuDomain.getGoodsSp();
    }

    protected void updateSkuSpByCode(String goodsSp, String skuCode, String tenantCode) {
        if (StringUtils.isBlank((String)goodsSp) || StringUtils.isBlank((String)skuCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(this.SYS_CODE + ".updateSkuSp param is null");
            return;
        }
        String apiCode = "rs.sku.updateGoodsSpByCode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("goodsSp", goodsSp);
        paramMap.put("skuCode", skuCode);
        paramMap.put("tenantCode", tenantCode);
        this.internalInvoke(apiCode, paramMap);
    }

    protected DisDgoodsuplistDomain buildDisDgoodsuplist(DisChannel disChannel, RsSkuDomain rsSkuDomain, String name) {
        if (null == disChannel || null == rsSkuDomain || StringUtils.isBlank((String)name)) {
            this.logger.error(this.SYS_CODE + ".buildDisDgoodsuplist param is null");
            return null;
        }
        DisDgoodsuplistDomain disDgoodsuplistDomain = new DisDgoodsuplistDomain();
        disDgoodsuplistDomain.setDgoodsuplistType("0");
        disDgoodsuplistDomain.setChannelCode(disChannel.getChannelCode());
        disDgoodsuplistDomain.setChannelName(disChannel.getChannelName());
        disDgoodsuplistDomain.setChannelType("2");
        disDgoodsuplistDomain.setChannelSort("0");
        disDgoodsuplistDomain.setMemberCode(rsSkuDomain.getMemberCcode());
        disDgoodsuplistDomain.setMemberName(rsSkuDomain.getMemberCname());
        disDgoodsuplistDomain.setMemberMcode(rsSkuDomain.getMemberCcode());
        disDgoodsuplistDomain.setMemberMname(rsSkuDomain.getMemberCname());
        disDgoodsuplistDomain.setTenantCode(disChannel.getTenantCode());
        disDgoodsuplistDomain.setSkuNo(rsSkuDomain.getSkuNo());
        disDgoodsuplistDomain.setGoodsName(rsSkuDomain.getSkuName());
        disDgoodsuplistDomain.setGoodsNo(rsSkuDomain.getSkuNo());
        disDgoodsuplistDomain.setGoodsName(rsSkuDomain.getGoodsName());
        disDgoodsuplistDomain.setGoodsShowname(name);
        disDgoodsuplistDomain.setClasstreeShopcode(rsSkuDomain.getClasstreeShopcode());
        disDgoodsuplistDomain.setClasstreeShopname(rsSkuDomain.getClasstreeShopname());
        this.logger.error(this.SYS_CODE + " buildDisDgoodsuplist ; " + " skuCode:" + rsSkuDomain.getSkuCode() + " shopCode" + rsSkuDomain.getClasstreeShopcode() + ":" + disDgoodsuplistDomain.getClasstreeShopcode() + " shopName:" + rsSkuDomain.getClasstreeShopname() + ":" + disDgoodsuplistDomain.getClasstreeShopname());
        return disDgoodsuplistDomain;
    }
}

