/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.discom.util;

import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EmojiUtil {
    public static boolean isHasEmoji(String reviewerName) {
        if (StringUtils.isBlank((String)reviewerName)) {
            return true;
        }
        Pattern pattern = Pattern.compile("[\ud83c\udc00-\ud83c\udfff]|[\ud83d\udc00-\ud83d\udfff]|[\u2600-\u27ff]");
        Matcher matcher = pattern.matcher(reviewerName);
        return matcher.find();
    }

    public static String removeEmoji(String reviewerName) {
        if (StringUtils.isBlank((String)reviewerName)) {
            return reviewerName;
        }
        if (!EmojiUtil.isHasEmoji(reviewerName)) {
            return reviewerName;
        }
        String replaceAll = reviewerName.replaceAll("[\\ud800\\udc00-\\udbff\\udfff\\ud800-\\udfff]", "");
        return replaceAll;
    }

    public static String filterEmoji(String source) {
        int len = source.length();
        StringBuilder buf = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char codePoint = source.charAt(i);
            if (EmojiUtil.isNotEmojiCharacter(codePoint)) {
                buf.append(codePoint);
                continue;
            }
            buf.append("*");
        }
        return buf.toString();
    }

    private static boolean isNotEmojiCharacter(char codePoint) {
        return codePoint == '\u0000' || codePoint == '\t' || codePoint == '\n' || codePoint == '\r' || codePoint >= ' ' && codePoint <= '\ud7ff' || codePoint >= '\ue000' && codePoint <= '\ufffd' || codePoint >= '\u10000' && codePoint <= '\u10ffff';
    }

    public static void main(String[] args) {
        String reviewerName = "\u5e26\u5305**\u7ec6\u652f**\u4e00\u5305 \u611f\u8c22\ud83d\ude4f \u3010\u5982\u9047\u7f3a\u8d27\u3011\uff1a \u7f3a\u8d27\u65f6\u7535\u8bdd\u4e0e\u6211\u6c9f\u901a \u6536\u9910\u4eba\u9690\u79c1\u53f7 173****3727\uff0c\u624b\u673a\u53f7 173****3727 \u987e\u5ba2\u672a\u5bf9\u9910\u5177\u6570\u91cf\u505a\u9009\u62e9";
        System.out.println(EmojiUtil.isHasEmoji(reviewerName));
        String replaceAll = reviewerName.replaceAll("[\\ud800\\udc00-\\udbff\\udfff\\ud800-\\udfff]", "");
        System.out.println(EmojiUtil.isHasEmoji(replaceAll));
        System.out.println(EmojiUtil.removeEmoji(reviewerName));
        System.out.println(EmojiUtil.filterEmoji(reviewerName));
    }
}

