/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.dms.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.channel.dms.api.Constant;
import com.yqbsoft.laser.service.ext.channel.dms.domain.CpWithdrawReDomain;
import com.yqbsoft.laser.service.ext.channel.dms.domain.CtCustrel;
import com.yqbsoft.laser.service.ext.channel.dms.domain.OcContract;
import com.yqbsoft.laser.service.ext.channel.dms.domain.OcContractDomain;
import com.yqbsoft.laser.service.ext.channel.dms.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.ext.channel.dms.domain.OcRefundDomain;
import com.yqbsoft.laser.service.ext.channel.dms.domain.OcRefundReDomain;
import com.yqbsoft.laser.service.ext.channel.dms.domain.OrgDepart;
import com.yqbsoft.laser.service.ext.channel.dms.domain.OrgDepartDomain;
import com.yqbsoft.laser.service.ext.channel.dms.domain.SgSendgoodsGoodsDomain;
import com.yqbsoft.laser.service.ext.channel.dms.domain.SgSendgoodsReDomain;
import com.yqbsoft.laser.service.ext.channel.dms.domain.WhStoreSku;
import com.yqbsoft.laser.service.ext.channel.dms.domain.WhUserwh;
import com.yqbsoft.laser.service.ext.channel.dms.domain.WhWarehouse;
import com.yqbsoft.laser.service.ext.channel.dms.enums.ResultEnums;
import com.yqbsoft.laser.service.ext.channel.dms.service.OrderService;
import com.yqbsoft.laser.service.ext.channel.dms.utils.BuildOrderUtil;
import com.yqbsoft.laser.service.ext.channel.dms.utils.WebUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class OrderServiceImpl
extends BaseServiceImpl
implements OrderService {
    private String SYS_CODE = "ervice.ext.channel.dms.OrderServiceImpl";

    @Override
    public String saveSgSendgoods(SgSendgoodsReDomain sgSendgoodsReDomain) throws ApiException {
        this.logger.error(this.SYS_CODE + "OrderServiceImpl.saveSgSendgoods", (Object)("sgSendgoodsReDomain is " + sgSendgoodsReDomain));
        String url = "http://47.111.186.163:8080/eOrder/rest/gateway/masterdata/sosaleimport";
        if (sgSendgoodsReDomain == null) {
            this.logger.error(this.SYS_CODE + "OrderServiceImpl.saveSgSendgoods", (Object)"sgSendgoodsReDomain is null");
            return ResultEnums.success.getCode();
        }
        String orgNum = this.getorgNum(sgSendgoodsReDomain.getDepartCode(), sgSendgoodsReDomain.getTenantCode());
        WhWarehouse warehouseInfo = this.getWarehouseInfo(sgSendgoodsReDomain.getWarehouseCode(), sgSendgoodsReDomain.getTenantCode());
        String code = warehouseInfo.getMemberUrl();
        String areaCode = warehouseInfo.getAreaCode();
        String memberBcode = sgSendgoodsReDomain.getMemberBcode();
        String storeCode = this.getStoreCode(sgSendgoodsReDomain.getMemberBcode(), sgSendgoodsReDomain.getTenantCode());
        Map<String, Object> map = BuildOrderUtil.builSendParam(sgSendgoodsReDomain, orgNum, code, areaCode, storeCode);
        this.logger.error(this.SYS_CODE + "OrderServiceImpl.saveSgSendgoods", (Object)("dms.paramMap is " + map));
        ArrayList<Map<String, Object>> sendgoodsList = new ArrayList<Map<String, Object>>();
        sendgoodsList.add(map);
        String resultStr = null;
        try {
            resultStr = OrderServiceImpl.doPostByJson(url, sendgoodsList);
        }
        catch (Exception e) {
            throw new ApiException(this.SYS_CODE + ".saveMemberInfo", (Throwable)e);
        }
        this.logger.error(this.SYS_CODE + "OrderServiceImpl.saveSgSendgoods", (Object)("resultStr is " + resultStr));
        Map jsonToMap = (Map)JsonUtil.buildNonNullBinder().getJsonToMap(resultStr, String.class, Object.class);
        if (!jsonToMap.get("returncode").equals("0")) {
            this.logger.error(this.SYS_CODE + "OrderServiceImpl.saveSgSendgoods", (Object)"request is fail");
            return ResultEnums.error.getCode();
        }
        String data = (String)jsonToMap.get("data");
        List jsonToList = (List)JsonUtil.buildNonNullBinder().getJsonToList(data, Map.class);
        Map resultMap = (Map)jsonToList.get(0);
        String orderId = (String)resultMap.get("Customer_order_num");
        this.logger.error(this.SYS_CODE + "OrderServiceImpl.saveSgSendgoods", (Object)("resultStr is " + resultStr));
        this.updateContract(sgSendgoodsReDomain, orderId);
        return String.valueOf(jsonToMap.get("msg"));
    }

    public String getStoreCode(String memberBcode, String tenantCode) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("userinfoCode", memberBcode);
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(paramMap));
        QueryResult queryResutl = this.getQueryResutl("ct.custrel.queryCustrelPage", invokeMap, CtCustrel.class);
        if (ListUtil.isEmpty((Collection)queryResutl.getList())) {
            return null;
        }
        String storeCode = ((CtCustrel)queryResutl.getList().get(0)).getCustrelUicode();
        return storeCode;
    }

    public String getorgNum(String departCode, String tenantCode) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("departCode", departCode);
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(paramMap));
        QueryResult queryResutl = this.getQueryResutl("org.depart.queryDepartPage", invokeMap, OrgDepartDomain.class);
        String orgNum = ((OrgDepartDomain)queryResutl.getList().get(0)).getDepartContacts();
        return orgNum;
    }

    public WhWarehouse getWarehouseInfo(String warehouseCode, String tenantCode) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("warehouseCode", warehouseCode);
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(paramMap));
        QueryResult queryResutl = this.getQueryResutl("wh.warehouse.queryWarehousePage", invokeMap, WhWarehouse.class);
        if (ListUtil.isEmpty((Collection)queryResutl.getList())) {
            return null;
        }
        return (WhWarehouse)queryResutl.getList().get(0);
    }

    public String getUserWhWaCode(String departCode, String tenantCode) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("departCode", departCode);
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(paramMap));
        QueryResult queryResutl = this.getQueryResutl("wh.WhUserwh.queryUserwhPage", invokeMap, WhUserwh.class);
        String warehouseCode = ((WhUserwh)queryResutl.getList().get(0)).getWarehouseCode();
        return warehouseCode;
    }

    @Override
    public String sosaleReturnBillImport(OcRefundReDomain ocRefundReDomain) throws ApiException {
        String url = "";
        if (ocRefundReDomain == null) {
            this.logger.error(this.SYS_CODE + "OrderServiceImpl.saveSgSendgoods", (Object)"sosaleReturnBillImport is null");
            return ResultEnums.success.getCode();
        }
        String contractBillcode = ocRefundReDomain.getContractBillcode();
        OcContract orderInfo = this.getOrderInfo(contractBillcode, ocRefundReDomain.getTenantCode());
        String tenantCode = ocRefundReDomain.getTenantCode();
        String departCode = orderInfo.getDepartCode();
        String orgNum = this.getorgNum(departCode, tenantCode);
        String warehouseCode = this.getUserWhWaCode(departCode, tenantCode);
        Map<String, Object> itemMap = this.getItemIdByRefundGoods(ocRefundReDomain, warehouseCode);
        Map<String, Object> map = BuildOrderUtil.builrefundParam(orderInfo, ocRefundReDomain, itemMap, orgNum);
        this.logger.error(this.SYS_CODE + "OrderServiceImpl.saveSgSendgoods", (Object)("map is " + map));
        ArrayList<Map<String, Object>> sendgoodsList = new ArrayList<Map<String, Object>>();
        sendgoodsList.add(map);
        String resultStr = null;
        try {
            resultStr = OrderServiceImpl.doPostByJson(url, sendgoodsList);
        }
        catch (Exception e) {
            throw new ApiException(this.SYS_CODE + ".saveMemberInfo", (Throwable)e);
        }
        Map jsonToMap = (Map)JsonUtil.buildNonNullBinder().getJsonToMap(resultStr, String.class, Object.class);
        String data = (String)jsonToMap.get("data");
        List jsonToList = (List)JsonUtil.buildNonNullBinder().getJsonToList(data, Map.class);
        Map resultMap = (Map)jsonToList.get(0);
        String orderId = (String)resultMap.get("Customer_order_num");
        this.logger.error(this.SYS_CODE + "OrderServiceImpl.saveSgSendgoods", (Object)("orderId is " + orderId));
        this.updateRefundInvoke(ocRefundReDomain, resultMap);
        return null;
    }

    public void updateRefundInvoke(OcRefundReDomain ocRefundReDomain, Map<String, Object> resultMap) {
        OcRefundDomain ocRefundDomain = new OcRefundDomain();
        ocRefundDomain.setContractBillcode(ocRefundReDomain.getContractBillcode());
        ocRefundDomain.setTenantCode(ocRefundReDomain.getTenantCode());
        ocRefundDomain.setDataStatestr((String)resultMap.get("Status"));
        ocRefundDomain.setContractNbbillcode((String)resultMap.get("Customer_order_num"));
        ocRefundDomain.setRefundOcode((String)resultMap.get("Auto_xt_num"));
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson((Object)ocRefundDomain));
        this.logger.error(this.SYS_CODE + "OrderServiceImpl.updateContract", (Object)("invokeMap is " + invokeMap));
        this.internalInvoke("oc.refund.updateRefund", invokeMap);
    }

    public OcContract getOrderInfo(String contractBillcode, String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", tenantCode);
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(map));
        QueryResult queryResutl = this.getQueryResutl("oc.contract.queryContractPage", invokeMap, OcContract.class);
        if (ListUtil.isEmpty((Collection)queryResutl.getList())) {
            return null;
        }
        OcContract ocContract = (OcContract)queryResutl.getList().get(0);
        return ocContract;
    }

    public Map<String, List> getItemId(SgSendgoodsReDomain sgSendgoodsReDomain, String warehouseCode) {
        HashMap<String, List> resultMap = new HashMap<String, List>();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", sgSendgoodsReDomain.getTenantCode());
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        List<SgSendgoodsGoodsDomain> sgSendgoodsGoodsDomainList = sgSendgoodsReDomain.getSgSendgoodsGoodsDomainList();
        for (SgSendgoodsGoodsDomain sgSendgoodsGoodsDomain : sgSendgoodsGoodsDomainList) {
            int goodsNum = 0;
            String goodsNo = sgSendgoodsGoodsDomain.getGoodsNo();
            paramMap.put("goodsNo", goodsNo);
            paramMap.put("warehouseCode", warehouseCode);
            invokeMap.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
            QueryResult queryResutl = this.getQueryResutl("wh.whStoreGoods.queryStoreSkuPage", invokeMap, WhStoreSku.class);
            List whStoreSkuList = queryResutl.getList();
            ArrayList<String> itemum = new ArrayList<String>();
            for (WhStoreSku whStoreSku : whStoreSkuList) {
                if (goodsNum >= sgSendgoodsGoodsDomain.getGoodsNum().intValue()) {
                    resultMap.put(goodsNo, itemum);
                    continue;
                }
                itemum.add(whStoreSku.getGoodsEocode());
                goodsNum += whStoreSku.getGoodsNum().intValue();
            }
        }
        return resultMap;
    }

    public Map<String, Object> getItemIdByRefundGoods(OcRefundReDomain ocRefundReDomain, String warehouseCode) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", ocRefundReDomain.getTenantCode());
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        List<OcContractGoodsDomain> goodsList = ocRefundReDomain.getGoodsList();
        for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
            String goodsNo = ocContractGoodsDomain.getGoodsNo();
            paramMap.put("goodsNo", goodsNo);
            paramMap.put("warehouseCode", warehouseCode);
            invokeMap.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
            QueryResult queryResutl = this.getQueryResutl("wh.whStoreGoods.queryStoreSkuPage", invokeMap, WhStoreSku.class);
            String goodsEocode = ((WhStoreSku)queryResutl.getList().get(0)).getGoodsEocode();
            resultMap.put(goodsNo, goodsEocode);
        }
        return resultMap;
    }

    public void updateContract(SgSendgoodsReDomain sgSendgoodsReDomain, String orderId) {
        HashMap paramMap = new HashMap();
        OcContractDomain ocContractDomain = new OcContractDomain();
        ocContractDomain.setContractBillcode(sgSendgoodsReDomain.getContractBillcode());
        ocContractDomain.setTenantCode(sgSendgoodsReDomain.getTenantCode());
        ocContractDomain.setContractNbillcode(orderId);
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson((Object)ocContractDomain));
        this.logger.error(this.SYS_CODE + "OrderServiceImpl.updateContract", (Object)("invokeMap is " + invokeMap));
        this.internalInvoke("oc.contract.updateContract", invokeMap);
    }

    @Override
    public String updateSgSendgoodsStatus(SgSendgoodsReDomain sgSendgoodsReDomain) throws ApiException {
        if (sgSendgoodsReDomain == null) {
            this.logger.error("sgSendgoodsReDomain is null");
        }
        String url = "http://47.111.186.163:8080/eOrder/rest/gateway/masterdata/sosalecancle";
        Map<String, Object> map = BuildOrderUtil.buildSosalecancleParam(sgSendgoodsReDomain);
        Map<String, Object> resultMap = this.webUtilRequest(url, map);
        if (!map.get("returncode").equals("0")) {
            return "error";
        }
        return JsonUtil.buildNonNullBinder().toJson(map);
    }

    @Override
    public String updateSgSendgoods(SgSendgoodsReDomain sgSendgoodsReDomain) throws ApiException {
        return null;
    }

    @Override
    public String updateCpWithdraw(CpWithdrawReDomain cpWithdrawReDomain) throws ApiException {
        return null;
    }

    @Override
    public String getSgSendgoodsStatus(String tenantCode, String userinfoCode) throws ApiException {
        String url = "/rest/gateway/masterdata/sosalestatus";
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataState", 0);
        map.put("tenantCode", tenantCode);
        String str = this.internalInvoke("oc.contract.queryContractPage", map);
        if (StringUtils.isEmpty((String)str)) {
            this.logger.error("str is null");
            return null;
        }
        QueryResult sgSendgoodsQueryResult = (QueryResult)JsonUtil.buildNormalBinder().getJsonToObject(str, QueryResult.class);
        String strList = JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsQueryResult.getList());
        List ocContractDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(strList, OcContract.class);
        for (OcContract ocContract : ocContractDomainList) {
            String returncode;
            String contractNbillcode = ocContract.getContractNbillcode();
            Map sendMap = this.getTimeMap();
            sendMap.put("customer_order_num", contractNbillcode);
            Map<String, Object> resultMap = this.webUtilRequest(url, sendMap);
            if (MapUtil.isEmpty(resultMap)) {
                this.logger.error("resultMap is null");
            }
            if (!(returncode = (String)resultMap.get("returncode")).equals("0")) {
                return null;
            }
            Object data = resultMap.get("data");
            List jsonToList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson(data), Map.class);
            for (Map paramsMap : jsonToList) {
                Integer oldDataState = ocContract.getDataState();
                String status = String.valueOf(paramsMap.get("status"));
                Integer newDataState = this.checkStatus(status);
                HashMap<String, Serializable> updateMap = new HashMap<String, Serializable>();
                updateMap.put("sendgoodsGoodsId", ocContract.getContractId());
                updateMap.put("dataState", newDataState);
                updateMap.put("oldDataState", oldDataState);
                updateMap.put("map", new HashMap());
                this.internalInvoke("oc.contract.updateContractGoodsState", updateMap);
            }
        }
        return null;
    }

    @Override
    public String updateSalesSlip(String tenantCode, String userinfoCode) throws ApiException {
        String returncode;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        HashMap<String, String> sendMap = new HashMap<String, String>();
        sendMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        String departStr = this.internalInvoke("org.depart.queryDepartPage", sendMap);
        QueryResult queryResult = (QueryResult)JsonUtil.buildNormalBinder().getJsonToObject(departStr, QueryResult.class);
        String strList = JsonUtil.buildNormalBinder().toJson((Object)queryResult.getList());
        List orgDepartList = (List)JsonUtil.buildNormalBinder().getJsonToList(strList, OrgDepart.class);
        HashMap<String, String> orgNumMap = new HashMap<String, String>();
        ArrayList<HashMap<String, String>> orgNumList = new ArrayList<HashMap<String, String>>();
        for (OrgDepart orgDepart : orgDepartList) {
            String orgNum = orgDepart.getDepartContacts();
            orgNumMap.put("orgNum", orgNum);
            orgNumList.add(orgNumMap);
        }
        HashMap<String, Object> orgNumListMap = new HashMap<String, Object>();
        orgNumListMap.put("org_num_list", orgNumList);
        orgNumListMap.put("audit_date", "2019-11-01");
        Map<String, Object> resultMap = this.webUtilRequest("/rest/gateway/masterdata/returnsalesearch", orgNumListMap);
        if (MapUtil.isEmpty(resultMap)) {
            this.logger.error("resultMap is null");
        }
        if (!(returncode = (String)resultMap.get("returncode")).equals("0")) {
            return null;
        }
        Object data = resultMap.get("data");
        List jsonToList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson(data), Map.class);
        for (Map paramsMap : jsonToList) {
            OcRefundDomain ocRefundDomain = new OcRefundDomain();
            ocRefundDomain.setContractBillcode(String.valueOf(paramsMap.get("Auto_xh_num")));
            ocRefundDomain.setRefundNcode(String.valueOf(paramsMap.get("Auto_xt_num")));
            String tc_ti = String.valueOf(paramsMap.get("Tc_ti"));
            if (!tc_ti.equals("") || tc_ti.equals("null") || tc_ti == null) {
                double v = Double.parseDouble(tc_ti);
                BigDecimal bigDecimal = BigDecimal.valueOf(v);
                ocRefundDomain.setRefundMoney(bigDecimal);
            }
            ocRefundDomain.setMemberCode(String.valueOf(paramsMap.get("Org_num")));
            String creation__date = String.valueOf(paramsMap.get("Creation _date"));
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date refundDate = null;
            try {
                refundDate = sdf.parse(creation__date);
            }
            catch (ParseException e) {
                this.logger.error("data parse exception");
                e.printStackTrace();
            }
            ocRefundDomain.setRefundDate(refundDate);
            ocRefundDomain.setTenantCode("tenantCode");
            ocRefundDomain.setMemberCode(userinfoCode);
            ocRefundDomain.setContractRemark(String.valueOf(paramsMap.get("Reason_code")));
            HashMap<String, OcRefundDomain> refundMap = new HashMap<String, OcRefundDomain>();
            refundMap.put("ocRefundDomain", ocRefundDomain);
            this.logger.error("refunMap is " + refundMap);
            this.internalInvoke("oc.refund.saveRefund", refundMap);
        }
        return null;
    }

    private Integer checkStatus(String status) {
        if (status.equals("SUBM")) {
            return Constant.dmsState;
        }
        if (status.equals("CANC")) {
            return Constant.dmsState;
        }
        if (status.equals("HANG")) {
            return Constant.dmsState;
        }
        if (status.equals("LAYU")) {
            return Constant.dmsState;
        }
        if (status.equals("KEEP")) {
            return Constant.dmsState;
        }
        return 0;
    }

    public Map<String, Object> webUtilRequest(String requestUrl, Map<String, Object> sendhttpParam) {
        String finalUrl = "http://47.111.186.163:8080/eOrder" + requestUrl;
        try {
            String json = WebUtils.doPostByJson(finalUrl, sendhttpParam, 10000000, 10000000, null);
            Map jsonToMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(json, String.class, Object.class);
            return jsonToMap;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Map getTimeMap() {
        HashMap<String, String> sendhttpParam = new HashMap<String, String>();
        sendhttpParam.put("last_update_date", "2013-01-10 12:00:00");
        return sendhttpParam;
    }

    public static String doPostByJson(String url, List list) throws Exception {
        OkHttpClient client = new OkHttpClient().newBuilder().build();
        MediaType mediaType = MediaType.parse((String)"application/json");
        RequestBody body = RequestBody.create((MediaType)mediaType, (String)JsonUtil.buildNonDefaultBinder().toJson((Object)list));
        Request request = new Request.Builder().url(url).method("POST", body).addHeader("Content-Type", "application/json").build();
        Response response = client.newCall(request).execute();
        String StringTemp = response.body().string();
        return StringTemp;
    }
}

