/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.dms.service.impl;

import com.microsoft.azure.storage.CloudStorageAccount;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.table.CloudTable;
import com.microsoft.azure.storage.table.CloudTableClient;
import com.microsoft.azure.storage.table.TableEntity;
import com.microsoft.azure.storage.table.TableOperation;
import com.microsoft.azure.storage.table.TableResult;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.ext.channel.dms.domain.OcContractDomain;
import com.yqbsoft.laser.service.ext.channel.dms.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.ext.channel.dms.domain.TsIntegralDomain;
import com.yqbsoft.laser.service.ext.channel.dms.enums.ResultEnums;
import com.yqbsoft.laser.service.ext.channel.dms.service.TsService;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.List;

public class TsServiceImpl
extends BaseServiceImpl
implements TsService {
    private String SYS_CODE = "ervice.ext.channel.dms.TsServiceImpl";

    @Override
    public String saveNewData(OcContractDomain ocContractDomain) throws ApiException {
        this.logger.error(this.SYS_CODE + ".saveNewData.ocContractDomain", (Object)("ocContractDomain is" + ocContractDomain));
        String url = this.getUrl(ocContractDomain.getTenantCode(), "tsSave", "getTsConnectionUrl", null);
        String tableName = this.getUrl(ocContractDomain.getTenantCode(), "tableName", "getTsTableName", null);
        String brandName = this.getUrl(ocContractDomain.getTenantCode(), "brand", "getTsBrandName", null);
        String channel = this.getUrl(ocContractDomain.getTenantCode(), "channel", "getTsChannelName", null);
        if (StringUtils.isEmpty((String)url) | StringUtils.isEmpty((String)tableName) | StringUtils.isEmpty((String)brandName) | StringUtils.isEmpty((String)channel)) {
            this.logger.error(this.SYS_CODE + ".getUrl", (Object)("channel=" + channel + "tableName" + "=" + tableName + "brandName" + "=" + brandName + "url" + "=" + url));
            return ResultEnums.error.getCode();
        }
        CloudTable cloudTable = this.buildConnection(url, tableName);
        List<OcContractGoodsDomain> goodsList = ocContractDomain.getGoodsList();
        int i = 0;
        String dateString = DateUtil.getDateString((Date)ocContractDomain.getContractValidate(), (String)"yyyy-MM-dd HH:mm:ss");
        for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
            TsIntegralDomain tsIntegralDomain = this.buildSaveData(ocContractGoodsDomain, i, dateString, brandName, channel);
            TableOperation insertCustomer = TableOperation.insertOrReplace((TableEntity)tsIntegralDomain);
            try {
                TableResult execute = cloudTable.execute(insertCustomer);
                this.logger.error(this.SYS_CODE + ".execute", (Object)execute);
            }
            catch (StorageException e) {
                this.logger.error(this.SYS_CODE + ".StorageException", (Throwable)e);
                return ResultEnums.error.getCode();
            }
        }
        return ResultEnums.success.getCode();
    }

    public CloudTable buildConnection(String str, String tableName) {
        CloudStorageAccount storageAccount = null;
        CloudTable cloudTable = null;
        try {
            storageAccount = CloudStorageAccount.parse((String)str);
            CloudTableClient tableClient = storageAccount.createCloudTableClient();
            cloudTable = tableClient.getTableReference(tableName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cloudTable;
    }

    public TsIntegralDomain buildSaveData(OcContractGoodsDomain ocContractGoodsDomain, int i, String date, String brandName, String channel) {
        String RowKey = ocContractGoodsDomain.getContractBillcode() + "." + i + "-" + brandName;
        String partitionKey = "MINI_PROGRAM" + DateUtil.getDateStr((String)"yyyy-MM-dd");
        TsIntegralDomain tsIntegralDomain = new TsIntegralDomain();
        tsIntegralDomain.setPartitionKey(partitionKey);
        tsIntegralDomain.setRowKey(RowKey);
        tsIntegralDomain.setTransactionId(ocContractGoodsDomain.getContractBillcode());
        tsIntegralDomain.setLoyaltyId(ocContractGoodsDomain.getMemberBcode());
        tsIntegralDomain.setTransactionDateTime(date);
        tsIntegralDomain.setStoreCode(ocContractGoodsDomain.getMemberBcode());
        tsIntegralDomain.setProductCode(ocContractGoodsDomain.getSkuNo());
        tsIntegralDomain.setPurchaseQty(ocContractGoodsDomain.getGoodsNum().intValue());
        tsIntegralDomain.setRealAmount(String.valueOf(ocContractGoodsDomain.getContractGoodsMoney()));
        tsIntegralDomain.setRetailAmount(String.valueOf(ocContractGoodsDomain.getPricesetNprice()));
        tsIntegralDomain.setBrand(brandName);
        tsIntegralDomain.setChannel(channel);
        tsIntegralDomain.setTransactionType("010");
        tsIntegralDomain.setCreateDate("2020-09-23 10:01:55");
        tsIntegralDomain.setStatus("0");
        tsIntegralDomain.setLineItemNo(String.valueOf(i + 1));
        return tsIntegralDomain;
    }

    private String getUrl(String tenantCode, String flagSettingType, String flagSettingCode, String appmanageIcode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        String field = tenantCode.concat("-").concat(flagSettingType + appmanageIcode).concat("-").concat(flagSettingCode + appmanageIcode);
        String value = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
        this.logger.error(this.SYS_CODE + ".getUrl", (Object)(tenantCode + "=" + flagSettingType + appmanageIcode + "=" + flagSettingCode + "=" + value));
        return value;
    }
}

