/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.elm.store.service;

import com.yqbsoft.laser.service.ext.channel.discom.domain.DisChannel;
import com.yqbsoft.laser.service.ext.channel.discom.domain.UmUserinfo;
import com.yqbsoft.laser.service.ext.channel.discom.service.DisStoreBaseService;
import com.yqbsoft.laser.service.ext.channel.elm.ElmConstants;
import com.yqbsoft.laser.service.ext.channel.elm.domain.ElmResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.tool.util.WebUtils;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DisStoreServiceImpl
extends DisStoreBaseService {
    private String SYS_CODE = "elm.DisStoreServiceImpl";
    String ctype = "application/json;charset=utf-8";

    protected String getChannelCode() {
        return ElmConstants.channelCode;
    }

    public Map<String, Object> buildStoreUpdateParam(DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        UmUserinfo umUserinfo;
        if (MapUtil.isEmpty(sendParam) || MapUtil.isEmpty(configMap) || null == disChannel) {
            return null;
        }
        if (MapUtil.isEmpty(param)) {
            return null;
        }
        String memberCode = (String)param.get("memberCode");
        if (StringUtils.isBlank((String)memberCode)) {
            memberCode = disChannel.getMemberCode();
        }
        if (null == (umUserinfo = (UmUserinfo)param.get("umUserinfo"))) {
            return null;
        }
        sendParam.put("token", this.getToken(disChannel.getTenantCode(), disChannel.getChannelCode(), memberCode));
        HashMap<String, Object> metasmap = new HashMap<String, Object>();
        metasmap.put("app_key", configMap.get("key"));
        metasmap.put("timestamp", new Date().getTime() / 1000L);
        sendParam.put("metas", metasmap);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("addressText", umUserinfo.getCompanyAddress());
        properties.put("geo", umUserinfo.getUserinfoMap());
        properties.put("description", umUserinfo.getUserinfoRemark());
        properties.put("name", umUserinfo.getUserinfoCompname());
        properties.put("phone", umUserinfo.getUserinfoPhone());
        properties.put("openId", umUserinfo.getUserinfoCode());
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        params.put("shopId", Long.valueOf((String)sendParam.remove("shopId")));
        params.put("properties", properties);
        sendParam.put("params", params);
        return sendParam;
    }

    public Map<String, Object> buildStoreStartParam(DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        return this.buildStoreComParam(disChannel, sendParam, configMap, param);
    }

    public Map<String, Object> buildStoreEndParam(DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        return this.buildStoreComParam(disChannel, sendParam, configMap, param);
    }

    private Map<String, Object> buildStoreComParam(DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        if (MapUtil.isEmpty(sendParam) || MapUtil.isEmpty(configMap) || null == disChannel) {
            return null;
        }
        if (MapUtil.isEmpty(param)) {
            return null;
        }
        String memberCode = (String)param.get("memberCode");
        if (StringUtils.isBlank((String)memberCode)) {
            memberCode = disChannel.getMemberCode();
        }
        sendParam.put("token", this.getToken(disChannel.getTenantCode(), disChannel.getChannelCode(), memberCode));
        HashMap<String, Object> metasmap = new HashMap<String, Object>();
        metasmap.put("app_key", configMap.get("key"));
        metasmap.put("timestamp", new Date().getTime() / 1000L);
        sendParam.put("metas", metasmap);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("shopId", Long.valueOf((String)sendParam.remove("shopId")));
        properties.put("properties", (Map)JsonUtil.buildNormalBinder().getJsonToMap((String)sendParam.remove("properties"), String.class, Object.class));
        sendParam.put("params", properties);
        return sendParam;
    }

    public String sendStoreStartParam(DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        return this.sendStoreComParam(disChannel, sendhttpParam, configMap, param);
    }

    public String sendStoreEndParam(DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        return this.sendStoreComParam(disChannel, sendhttpParam, configMap, param);
    }

    public String sendStoreUpdateParam(DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        return this.sendStoreComParam(disChannel, sendhttpParam, configMap, param);
    }

    private String sendStoreComParam(DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        String json;
        if (null == disChannel || null == sendhttpParam || null == configMap) {
            return "ERROR";
        }
        String url = configMap.get(ElmConstants.serviceUrl);
        if (StringUtils.isBlank((String)url)) {
            this.logger.error(this.SYS_CODE + ".sendStoreEndParam.url", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        try {
            json = WebUtils.doPostJson((String)url, sendhttpParam, (int)30000, (int)30000, null);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".sendStoreEndParam.e", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()), (Throwable)e);
            return "ERROR";
        }
        if (StringUtils.isBlank((String)json)) {
            this.logger.error(this.SYS_CODE + ".sendStoreEndParam.json", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        ElmResult elmResult = this.make(json);
        if (null == elmResult) {
            return json;
        }
        if (null != elmResult.getError()) {
            return elmResult.getError().getMessage();
        }
        return "SUCCESS";
    }

    public UmUserinfo sendGetStore(DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        String json;
        if (null == disChannel || null == sendhttpParam || null == configMap) {
            return null;
        }
        String url = configMap.get(ElmConstants.serviceUrl);
        if (StringUtils.isBlank((String)url)) {
            this.logger.error(this.SYS_CODE + ".sendGetStore.url", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return null;
        }
        try {
            json = WebUtils.doPostJson((String)url, sendhttpParam, (int)30000, (int)30000, null);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".sendGetStore.e", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()), (Throwable)e);
            return null;
        }
        if (StringUtils.isBlank((String)json)) {
            this.logger.error(this.SYS_CODE + ".sendGetStore.json", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return null;
        }
        ElmResult elmResult = this.make(json);
        if (null == elmResult || MapUtil.isEmpty(elmResult.getResult())) {
            return null;
        }
        UmUserinfo umUserinfo = new UmUserinfo();
        umUserinfo.setCompanyAddress((String)elmResult.getResult().get("addressText"));
        umUserinfo.setUserinfoMap((String)elmResult.getResult().get("geo"));
        umUserinfo.setUserinfoRemark((String)elmResult.getResult().get("description"));
        umUserinfo.setUserinfoCompname((String)elmResult.getResult().get("name"));
        umUserinfo.setUserinfoPhone((String)elmResult.getResult().get("phone"));
        umUserinfo.setUserinfoCode((String)elmResult.getResult().get("openId"));
        umUserinfo.setDataState(Integer.valueOf(-1));
        if (Integer.valueOf((String)elmResult.getResult().get("isOpen")) == 1) {
            umUserinfo.setDataState(Integer.valueOf(0));
        }
        return umUserinfo;
    }

    private ElmResult make(String json) {
        if (StringUtils.isBlank((String)json)) {
            this.logger.error(this.SYS_CODE + ".make.json");
            return null;
        }
        ElmResult elmResult = (ElmResult)JsonUtil.buildNormalBinder().getJsonToObject(json, ElmResult.class);
        if (null == elmResult) {
            return null;
        }
        return elmResult;
    }

    public Map<String, Object> buildGetStoreParam(DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        return this.buildStoreComParam(disChannel, sendParam, configMap, param);
    }
}

